/* Generated by GIWS (version 2.0.0) with command:
giws -e -r -g -f ScilabObjects.giws.xml 
*/
/*

Copyright 2007-2008 INRIA
Copyright 2008-2011 DIGITEO
Copyright 2011-2012 Scilab Enterprises

Author : Sylvestre Ledru & others

This is generated code.

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

This software is governed by the CeCILL-B license under French law and
abiding by the rules of distribution of free software.  You can  use, 
modify and/ or redistribute the software under the terms of the CeCILL-B
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info". 

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability. 

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or 
data to be ensured and,  more generally, to use and operate it in the 
same conditions as regards security. 

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-B license and that you accept its terms.
*/


#ifndef __ORG_SCILAB_FORGE_JIMS_SCILABJAVAOBJECT__
#define __ORG_SCILAB_FORGE_JIMS_SCILABJAVAOBJECT__
#include <iostream>
#include <string>
#include <string.h>
#include <stdlib.h>
#include <jni.h>

#include "GiwsException.hxx"

        #if !defined(byte) | !defined(_MSC_VER) /* Defined anyway with Visual */
        #ifdef _MSC_VER
                typedef unsigned char byte;
        #else
                typedef signed char byte;
        #endif
        #else
                #pragma message("Byte has been redefined elsewhere. Some problems can happen")
        #endif


#ifndef GIWSEXPORT
# if defined(_MSC_VER) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define GIWSEXPORT
#   else
#     define GIWSEXPORT __declspec(dllexport)
#   endif
# else
#   if __GNUC__ >= 4
#     define GIWSEXPORT __attribute__ ((visibility ("default")))
#   else
#     define GIWSEXPORT
#   endif
# endif
#endif

namespace org_scilab_forge_jims {
class GIWSEXPORT ScilabJavaObject {

private:
JavaVM * jvm;

protected:
jmethodID jintinvokejintintjstringjava_lang_StringjintArray_intintID; // cache method id
jmethodID voidinitScilabJavaObjectID; // cache method id
jmethodID voidgarbageCollectID; // cache method id
jmethodID jstringgetRepresentationjintintID; // cache method id
jmethodID jbooleanisValidJavaObjectjintintID; // cache method id
jmethodID voidenableTracejstringjava_lang_StringID; // cache method id
jmethodID voiddisableTraceID; // cache method id
jmethodID voidsetFieldjintintjstringjava_lang_StringjintintID; // cache method id
jmethodID jintgetFieldjintintjstringjava_lang_StringID; // cache method id
jmethodID jintgetFieldTypejintintjstringjava_lang_StringID; // cache method id
jmethodID jintjavaCastjintintjstringjava_lang_StringID; // cache method id
jmethodID jintjavaCastjintintjintintID; // cache method id
jmethodID jstringgetClassNamejintintID; // cache method id
jmethodID jintgetArrayElementjintintjintArray_intintID; // cache method id
jmethodID voidsetArrayElementjintintjintArray_intintjintintID; // cache method id
jmethodID voidremoveScilabJavaObjectjintintID; // cache method id
jmethodID voidlimitDirectBufferjintintID; // cache method id
jmethodID jintisUnwrappablejintintID; // cache method id
jmethodID jintwrapDoublejdoubledoubleID; // cache method id
jmethodID jintwrapDoublejdoubleArray_doubledoubleID; // cache method id
jmethodID jintwrapDoublejobjectArray__doubledoubleID; // cache method id
jmethodID jintwrapIntjintintID; // cache method id
jmethodID jintwrapIntjintArray_intintID; // cache method id
jmethodID jintwrapIntjobjectArray__intintID; // cache method id
jmethodID jintwrapUIntjlonglongID; // cache method id
jmethodID jintwrapUIntjlongArray_longlongID; // cache method id
jmethodID jintwrapUIntjobjectArray__longlongID; // cache method id
jmethodID jintwrapBytejbytebyteID; // cache method id
jmethodID jintwrapBytejbyteArray_bytebyteID; // cache method id
jmethodID jintwrapBytejobjectArray__bytebyteID; // cache method id
jmethodID jintwrapUBytejshortshortID; // cache method id
jmethodID jintwrapUBytejshortArray_shortshortID; // cache method id
jmethodID jintwrapUBytejobjectArray__shortshortID; // cache method id
jmethodID jintwrapShortjshortshortID; // cache method id
jmethodID jintwrapShortjshortArray_shortshortID; // cache method id
jmethodID jintwrapShortjobjectArray__shortshortID; // cache method id
jmethodID jintwrapUShortjintintID; // cache method id
jmethodID jintwrapUShortjintArray_intintID; // cache method id
jmethodID jintwrapUShortjobjectArray__intintID; // cache method id
jmethodID jintwrapStringjstringjava_lang_StringID; // cache method id
jmethodID jintwrapStringjobjectArray_java_lang_Stringjava_lang_StringID; // cache method id
jclass stringArrayClass;
jmethodID jintwrapStringjobjectArray__java_lang_Stringjava_lang_StringID; // cache method id
jmethodID jintwrapBooleanjbooleanbooleanID; // cache method id
jmethodID jintwrapBooleanjbooleanArray_booleanbooleanID; // cache method id
jmethodID jintwrapBooleanjobjectArray__booleanbooleanID; // cache method id
jmethodID jintwrapCharjcharcharID; // cache method id
jmethodID jintwrapCharjcharArray_charcharID; // cache method id
jmethodID jintwrapCharjobjectArray__charcharID; // cache method id
jmethodID jintwrapFloatjfloatfloatID; // cache method id
jmethodID jintwrapFloatjfloatArray_floatfloatID; // cache method id
jmethodID jintwrapFloatjobjectArray__floatfloatID; // cache method id
jmethodID jintwrapLongjlonglongID; // cache method id
jmethodID jintwrapLongjlongArray_longlongID; // cache method id
jmethodID jintwrapLongjobjectArray__longlongID; // cache method id



jobject instance;
jclass instanceClass; // cache class

                       
// Caching (if any)


/**
* Get the environment matching to the current thread.
*/
virtual JNIEnv * getCurrentEnv();

public:
// Constructor
/**
* Create a wrapping of the object from a JNIEnv.
* It will call the default constructor
* @param JEnv_ the Java Env
*/
ScilabJavaObject(JavaVM * jvm_);

/**
* Create a wrapping of an already existing object from a JNIEnv.
* The object must have already been instantiated
* @param JEnv_ the Java Env
* @param JObj the object
*/
ScilabJavaObject(JavaVM * jvm_, jobject JObj);


/** 
* This is a fake constructor to avoid the constructor
* chaining when dealing with extended giws classes 
*/
#ifdef FAKEGIWSDATATYPE
ScilabJavaObject(fakeGiwsDataType::fakeGiwsDataType /* unused */) {}
#endif

// Destructor
~ScilabJavaObject();

// Generic method
// Synchronization methods
/**
* Enter monitor associated with the object.
* Equivalent of creating a "synchronized(obj)" scope in Java.
*/
void synchronize();

/**
* Exit monitor associated with the object.
* Equivalent of ending a "synchronized(obj)" scope.
*/
void endSynchronize();

// Methods
static int invoke(JavaVM * jvm_, int id, char const* methodName, int const* args, int argsSize);

static void initScilabJavaObject(JavaVM * jvm_);

static void garbageCollect(JavaVM * jvm_);

static char* getRepresentation(JavaVM * jvm_, int id);

static bool isValidJavaObject(JavaVM * jvm_, int id);

static void enableTrace(JavaVM * jvm_, char const* filename);

static void disableTrace(JavaVM * jvm_);

static void setField(JavaVM * jvm_, int id, char const* fieldName, int idarg);

static int getField(JavaVM * jvm_, int id, char const* fieldName);

static int getFieldType(JavaVM * jvm_, int id, char const* fieldName);

static int javaCast(JavaVM * jvm_, int id, char const* objName);

static int javaCast(JavaVM * jvm_, int id, int classId);

static char* getClassName(JavaVM * jvm_, int id);

static int getArrayElement(JavaVM * jvm_, int id, int const* index, int indexSize);

static void setArrayElement(JavaVM * jvm_, int id, int const* index, int indexSize, int idArg);

static void removeScilabJavaObject(JavaVM * jvm_, int id);

static void limitDirectBuffer(JavaVM * jvm_, int id);

static int isUnwrappable(JavaVM * jvm_, int id);

static int wrapDouble(JavaVM * jvm_, double x);

static int wrapDouble(JavaVM * jvm_, double const* x, int xSize);

static int wrapDouble(JavaVM * jvm_, double const* const* x, int xSize, int xSizeCol);

static int wrapInt(JavaVM * jvm_, int x);

static int wrapInt(JavaVM * jvm_, int const* x, int xSize);

static int wrapInt(JavaVM * jvm_, int const* const* x, int xSize, int xSizeCol);

static int wrapUInt(JavaVM * jvm_, long long x);

static int wrapUInt(JavaVM * jvm_, long long const* x, int xSize);

static int wrapUInt(JavaVM * jvm_, long long const* const* x, int xSize, int xSizeCol);

static int wrapByte(JavaVM * jvm_, byte x);

static int wrapByte(JavaVM * jvm_, byte const* x, int xSize);

static int wrapByte(JavaVM * jvm_, byte const* const* x, int xSize, int xSizeCol);

static int wrapUByte(JavaVM * jvm_, short x);

static int wrapUByte(JavaVM * jvm_, short const* x, int xSize);

static int wrapUByte(JavaVM * jvm_, short const* const* x, int xSize, int xSizeCol);

static int wrapShort(JavaVM * jvm_, short x);

static int wrapShort(JavaVM * jvm_, short const* x, int xSize);

static int wrapShort(JavaVM * jvm_, short const* const* x, int xSize, int xSizeCol);

static int wrapUShort(JavaVM * jvm_, int x);

static int wrapUShort(JavaVM * jvm_, int const* x, int xSize);

static int wrapUShort(JavaVM * jvm_, int const* const* x, int xSize, int xSizeCol);

static int wrapString(JavaVM * jvm_, char const* x);

static int wrapString(JavaVM * jvm_, char const* const* x, int xSize);

static int wrapString(JavaVM * jvm_, char const* const* const* x, int xSize, int xSizeCol);

static int wrapBoolean(JavaVM * jvm_, bool x);

static int wrapBoolean(JavaVM * jvm_, bool const* x, int xSize);

static int wrapBoolean(JavaVM * jvm_, bool const* const* x, int xSize, int xSizeCol);

static int wrapChar(JavaVM * jvm_, unsigned short x);

static int wrapChar(JavaVM * jvm_, unsigned short const* x, int xSize);

static int wrapChar(JavaVM * jvm_, unsigned short const* const* x, int xSize, int xSizeCol);

static int wrapFloat(JavaVM * jvm_, float x);

static int wrapFloat(JavaVM * jvm_, float const* x, int xSize);

static int wrapFloat(JavaVM * jvm_, float const* const* x, int xSize, int xSizeCol);

static int wrapLong(JavaVM * jvm_, long long x);

static int wrapLong(JavaVM * jvm_, long long const* x, int xSize);

static int wrapLong(JavaVM * jvm_, long long const* const* x, int xSize, int xSizeCol);


                        /**
                        * Get class name to use for static methods
                        * @return class name to use for static methods
                        */
                        
                static const std::string className()
                {
                return "org/scilab/forge/jims/ScilabJavaObject";
                }
                
};


}
#endif
