/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <Python.h>
#include "sg_preferences_dialog.h"
#include "sg.h"
#include "sg_project_autosave.h"
#include "sg_config.h"
#include "python/python_main.h"
#include "python/python_int.h"


static void label_pos_apply(GtkWidget *widget,sg_config_info *info);
static void label_pos_init(GtkWidget *widget,sg_config_info *info);

static void label_width_apply(GtkWidget *widget,sg_config_info *info);
static void label_width_init(GtkWidget *widget,sg_config_info *info);

static void autosave_apply(GtkWidget *widget,sg_config_info *info);
static void autosave_init(GtkWidget *widget,sg_config_info *info);

static void compress_apply(GtkWidget *widget,sg_config_info *info);
static void compress_init(GtkWidget *widget,sg_config_info *info);

static void autoscale_init(GtkWidget *widget,sg_config_info *info);
static void autoscale_apply(GtkWidget *widget,sg_config_info *info);

static void show_plot_toolbar_init(GtkWidget *widget,sg_config_info *info);
static void show_plot_toolbar_apply(GtkWidget *widget,sg_config_info *info);

static void show_plot_menubar_init(GtkWidget *widget,sg_config_info *info);
static void show_plot_menubar_apply(GtkWidget *widget,sg_config_info *info);


static gchar *label_pos[] = {"Right",
                             "Bottom",
                             NULL
};

sg_menu_info label_pos_info={label_pos,&label_pos_init,&label_pos_apply};
sg_bound_int_info label_width_info={30,120,&label_width_init,&label_width_apply},
                  autosave_info={0,1440,&autosave_init,&autosave_apply},
                  autoscale_info={0,50,&autoscale_init,&autoscale_apply},
                  show_plot_toolbar_info={0,1,&show_plot_toolbar_init,&show_plot_toolbar_apply},
                  show_plot_menubar_info={0,1,&show_plot_menubar_init,&show_plot_menubar_apply},
                  compression_info={0,9,&compress_init,&compress_apply};

sg_config_info gen_var_info[]={
        { DIALOG_SEP,NULL,NULL,NULL,NULL,"Preferences"},
        { NOTEBOOK_START,NULL,NULL,NULL,NULL,NULL},
        { PAGE_SEP,NULL,NULL,NULL,NULL,"Icon lists"},
        { FRAME_START,NULL,NULL,NULL,NULL,NULL},
        { DICT_MENU,"label_pos", "maingui",(gpointer)&label_pos_info,NULL,"Label position"},
        { DICT_INT_BOUND_SLIDER,"label_width", "maingui",(gpointer)&label_width_info,NULL,"Label width (pixels)"},
        { PAGE_SEP,NULL,NULL,NULL,NULL,"Files"},
        { FRAME_START,NULL,NULL,NULL,NULL,NULL},
        { DICT_INT_BOUND,"save_interval", "file",(gpointer)&autosave_info,NULL,"Autosave frequency in minutes\n(0=off)"},
        { DICT_INT_BOUND_SLIDER,"compress_level", "file",(gpointer)&compression_info,NULL,"Compression level\n(0=none, 1=low, .. , 9=high)"},
        { PAGE_SEP,NULL,NULL,NULL,NULL,"Plot window"},
        { FRAME_START,NULL,NULL,NULL,NULL,"Autoscale Spacing (percent)"},
        { DICT_INT_BOUND_SLIDER,"autoscale_left", "plotgui",(gpointer)&autoscale_info,NULL,"Left"},
        { DICT_INT_BOUND_SLIDER,"autoscale_right", "plotgui",(gpointer)&autoscale_info,NULL,"Right"},
        { DICT_INT_BOUND_SLIDER,"autoscale_top", "plotgui",(gpointer)&autoscale_info,NULL,"Top"},
        { DICT_INT_BOUND_SLIDER,"autoscale_bottom", "plotgui",(gpointer)&autoscale_info,NULL,"Bottom"},
        { FRAME_START,NULL,NULL,NULL,NULL,"Plot window appearance"},
        { DICT_BOOLEAN,"show_toolbar", "plotgui",(gpointer)&show_plot_toolbar_info,NULL,"Show left toolbar"},
        { DICT_BOOLEAN,"show_menubar", "plotgui",(gpointer)&show_plot_menubar_info,NULL,"Show top toolbar"},
        { NOTEBOOK_END,NULL,NULL,NULL,NULL,NULL},
        { END_CONFIG,NULL,NULL,NULL,NULL,NULL}
};


static
void label_pos_init(GtkWidget *widget,sg_config_info *info)
{
  gtk_list_select_item(GTK_LIST(GTK_COMBO(widget)->list),
                            sg_canvas_label_pos);

}

static
void label_pos_apply(GtkWidget *widget,sg_config_info *info)
{
  GtkWidget *child;
  gint mode;

  child = (GtkWidget *)GTK_LIST(GTK_COMBO(widget)->list)->selection->data;
  mode = gtk_list_child_position(GTK_LIST(GTK_COMBO(widget)->list),
                                 child);

  sg_config_set_value("label_pos", "maingui", PyInt_FromLong ((long) mode), TRUE);
  sg_config_exec_commit(sg_config_get_config("label_pos", "maingui"));

}

static
void label_width_init(GtkWidget *widget,sg_config_info *info)
{
  gtk_adjustment_set_value(GTK_RANGE(widget)->adjustment,
                            sg_canvas_label_width);
}

static
void label_width_apply(GtkWidget *widget,sg_config_info *info)
{
  gint space;

  space = GTK_RANGE(widget)->adjustment->value;

  sg_config_set_value("label_width", "maingui", PyInt_FromLong ((long) space), TRUE);
  sg_config_exec_commit(sg_config_get_config("label_width", "maingui"));

}

static
void autosave_init(GtkWidget *widget,sg_config_info *info)
{
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget),
                            sg_autosave_interval);
}

static
void autosave_apply(GtkWidget *widget,sg_config_info *info)
{
  gint minutes;

  minutes = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));

  sg_config_set_value("save_interval", "file", PyInt_FromLong ((long)minutes), TRUE);
  sg_config_exec_commit(sg_config_get_config("save_interval", "file"));
}

static
void compress_init(GtkWidget *widget,sg_config_info *info)
{
  gtk_adjustment_set_value(GTK_RANGE(widget)->adjustment,
    sg_compress_level);
}


static
void compress_apply(GtkWidget *widget,sg_config_info *info)
{
  gint level;

  level = GTK_RANGE(widget)->adjustment->value;
  
  sg_config_set_value("compress_level", "file", PyInt_FromLong ((long)level), TRUE);
  sg_config_exec_commit(sg_config_get_config("compress_level", "file"));
}

static
void autoscale_init(GtkWidget *widget,sg_config_info *info)
{
  if (!strcmp(info->config_name,"autoscale_left"))
    gtk_adjustment_set_value(GTK_RANGE(widget)->adjustment,
                            sg_autoscale_left);
  else if (!strcmp(info->config_name,"autoscale_right"))
    gtk_adjustment_set_value(GTK_RANGE(widget)->adjustment,
                            sg_autoscale_right);
  if (!strcmp(info->config_name,"autoscale_top"))
    gtk_adjustment_set_value(GTK_RANGE(widget)->adjustment,
                            sg_autoscale_top);
  else if (!strcmp(info->config_name,"autoscale_bottom"))
    gtk_adjustment_set_value(GTK_RANGE(widget)->adjustment,
                             sg_autoscale_bottom);

}


static
void autoscale_apply(GtkWidget *widget,sg_config_info *info)
{
  gint level;

  level = GTK_RANGE(widget)->adjustment->value;
  
  sg_config_set_value(info->config_name, info->config_group, PyInt_FromLong ((long)level), TRUE);
  sg_config_exec_commit(sg_config_get_config(info->config_name, info->config_group));
}

static
void show_plot_toolbar_init(GtkWidget *widget,sg_config_info *info)
{ 
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),sg_show_plot_toolbar);

}

static
void show_plot_toolbar_apply(GtkWidget *widget,sg_config_info *info)
{
  gint show;

  show = (gint)gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
  
  sg_config_set_value(info->config_name, info->config_group, PyInt_FromLong ((long)show), TRUE);
  show=(gint)PyInt_AsLong(sg_config_get_value(info->config_name, info->config_group));
  sg_config_exec_commit(sg_config_get_config(info->config_name, info->config_group));
}

static
void show_plot_menubar_init(GtkWidget *widget,sg_config_info *info)
{ 
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),sg_show_plot_menubar);

}

static
void show_plot_menubar_apply(GtkWidget *widget,sg_config_info *info)
{ gint show;

  show = (gint)gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
  sg_config_set_value(info->config_name, info->config_group, PyInt_FromLong ((long)show), TRUE);
  show=(gint)PyInt_AsLong(sg_config_get_value(info->config_name, info->config_group));
  sg_config_exec_commit(sg_config_get_config(info->config_name, info->config_group));
}


void general_config_dialog(GtkWidget *widget, gpointer data)
{
    sg_create_config_dialog(gen_var_info, &config_apply, &config_ok);
}

