from gtk import *
import sg

class SGwizard:
    """Constructs a wizard using a dictionary containing a key 'funcs' that holds \
    a list of the constructors for the various wizard pages, an optional key 'labels' \
    that holds a list of wizard page labels, and the key 'finish' to call when the user \
    presses the finish button"""
    params={}
    pagenum=0

    def __init__(self,params,title="Scigraphica wizard",modal=TRUE,\
                 tabs=FALSE,tab_pos=POS_TOP,with_labels=TRUE):
      if not params.has_key("funcs"):
        print params
        raise ValueError, 'The first parameter must be a dictionary containing the "funcs" key.'
      else:
        self.params=params

      self.page_widgets=[]
      for i in range(len(params["funcs"])):
        self.page_widgets.append(0)

      self.title=title
      self.tabs=tabs 
      self.main_window = GtkWindow()
      self.main_window.set_title(self.title)
      self.main_window.set_modal(FALSE)
      self.main_window.set_border_width(5)
      self.main_window.connect("destroy", self.main_window.destroy)
    
      main_table=GtkTable(1, 3, FALSE)
    
      self.main_window.add(main_table)
    
    # Notebook
      self.notebook=GtkNotebook()
      if not tabs:
        self.notebook.set_show_border(FALSE)
        
      try:
        l=self.params["labels"]
        if not len(l)==len(self.params["funcs"]):
          self.with_labels=FALSE
      except:
        self.with_labels=FALSE
      self.with_labels=with_labels
      self.notebook.set_show_tabs(tabs)
      main_table.attach(self.notebook,0,1,0,1)
      self.notebook.set_tab_pos(tab_pos)

      self.pagenum=0

      page=GtkVBox()
      if with_labels:
      	page_label=GtkLabel(self.params["labels"][self.pagenum])
      else:
      	page_label=GtkLabel("Start")

    # Main window
      main_table.attach(GtkHSeparator(),0,1,1,2,yoptions=0,ypadding=5)
      hbox=GtkHBox()
      main_table.attach(hbox,0,1,2,3,yoptions=0,ypadding=5)

      self.next_label=GtkLabel(label="Next >")
      if len(self.params["funcs"])==1:
        self.next_label.set_text("Close")
      self.next_button=GtkButton()
      self.next_button.add(self.next_label)
      self.next_button.connect("clicked",self.next_pressed)
      hbox.pack_end(self.next_button,fill=FALSE,expand=FALSE,padding=5)

      self.prev_button=GtkButton("< Back")
      self.prev_button.connect("clicked",self.prev_pressed)
      hbox.pack_end(self.prev_button,fill=FALSE,expand=FALSE,padding=5)
      self.prev_button.set_sensitive(FALSE)

      self.cancel=GtkButton("Cancel")
      self.cancel.connect("clicked",self.main_window.destroy)
      hbox.pack_end(self.cancel,fill=FALSE,padding=5)
     
      self.buttons={"next":self.next_button,
                    "prev":self.prev_button,
                    "cancel":self.cancel}
      self.notebook.append_page(page,page_label)
      apply(self.params["funcs"][self.pagenum],[self.params,page],self.buttons)
      self.page_widgets[self.pagenum]=page
      if not self.tabs and self.with_labels:
       self.main_window.set_title(self.title+": "+self.params["labels"][self.pagenum])
      else:
       self.main_window.set_title(self.title)
      page.show()

      
      self.main_window.show_all()
      if not sg:
        self.main_window.connect("destroy", mainquit)


    def prev_pressed(self,widget):
      self.pagenum=self.pagenum-1
      if self.pagenum>0:
          self.prev_button.set_sensitive(TRUE)
      else:
          self.prev_button.set_sensitive(FALSE)
      self.next_button.set_sensitive(TRUE)
      self.cancel.set_sensitive(TRUE)
      self.notebook.set_page(self.pagenum)
      if self.pagenum<len(self.params["funcs"])-1:
          self.next_label.set_text("Next >")
      if not self.tabs and self.with_labels:
        self.main_window.set_title(self.title+": "+self.params["labels"][self.pagenum])


    def next_pressed(self,widget):
      if self.pagenum>=len(self.params["funcs"]):
          apply(self.params["finish"],[self.params])
          self.main_window.destroy()
          return
      self.pagenum=self.pagenum+1
      if self.pagenum==len(self.params["funcs"]):
          apply(self.params["finish"],[self.params])
          self.main_window.destroy()
          return
      if self.pagenum==len(self.params["funcs"])-1:
          self.next_label.set_text("Finish")
      else:
          self.next_label.set_text("Next >")
      if self.page_widgets[self.pagenum]:
          self.page_widgets[self.pagenum].destroy()
          self.page_widgets[self.pagenum]=0

      self.prev_button.set_sensitive(TRUE)
      self.next_button.set_sensitive(TRUE)
      self.cancel.set_sensitive(TRUE)
      if callable(self.params["funcs"][self.pagenum]):
          page=GtkVBox()

      if self.with_labels:
      	page_label=GtkLabel(self.params["labels"][self.pagenum])
      else:
      	page_label=GtkLabel("Start")
      if not self.tabs and self.with_labels:
        self.main_window.set_title(self.title+": "+self.params["labels"][self.pagenum])

      self.notebook.insert_page(page,page_label,self.pagenum)
      page.show()
      self.notebook.set_page(self.pagenum)

      apply(self.params["funcs"][self.pagenum],[self.params,page],self.buttons)
      self.page_widgets[self.pagenum]=page
