/* gtkplotgnome - gnome-print driver
 * Copyright 1999-2001  Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GTK_PLOT_GNOME_H__
#define __GTK_PLOT_GNOME_H__

#ifdef WITH_GNOME_PRINT

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gnome.h>
#include <libgnomeprint/gnome-print.h>

#define GTK_PLOT_GNOME(obj)        GTK_CHECK_CAST (obj, gtk_plot_gnome_get_type (), GtkPlotGnome)
#define GTK_TYPE_PLOT_GNOME   (gtk_plot_gnome_get_type ())

#define GTK_PLOT_GNOME_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, gtk_plot_gnome_get_type(), GtkPlotGnomeClass)
#define GTK_IS_PLOT_GNOME(obj)     GTK_CHECK_TYPE (obj, gtk_plot_gnome_get_type ())


typedef struct _GtkPlotGnome GtkPlotGnome;
typedef struct _GtkPlotGnomeClass GtkPlotGnomeClass;

struct _GtkPlotGnome
{
   GtkPlotPC pc;

   GnomePrintContext *ctx;
 
   gint orientation;
   gint egnomeflag;

   gint units;
   gint page_size;
   gint width, height;

   gint page_width;
   gint page_height;

   gdouble scalex, scaley;

   gboolean gsaved;
};

struct _GtkPlotGnomeClass
{
   GtkPlotPCClass parent_class;
};

GtkType    gtk_plot_gnome_get_type                     (void);
GtkObject *gtk_plot_gnome_new                          (GnomePrinter *printer,
                                                        gint orientation,
                                                        gint page_size);

GtkObject *gtk_plot_gnome_new_with_size                (GnomePrinter *printer,
                                                        gint orientation,
                                                        gint units,
                                                        gdouble width,
                                                        gdouble height);

void 	   gtk_plot_gnome_construct                    (GtkPlotGnome *pc,
							GnomePrinter *printer,
                                                        gint orientation,
                                                        gint page_size);

void	   gtk_plot_gnome_construct_with_size          (GtkPlotGnome *pc,
							GnomePrinter *printer,
                                                        gint orientation,
                                                        gint units,
                                                        gdouble width,
                                                        gdouble height);

GtkObject *gtk_plot_gnome_preview_new                  (GnomeCanvas *canvas,
                                                        gint orientation,
                                                        gint page_size);

GtkObject *gtk_plot_gnome_preview_new_with_size        (GnomeCanvas *canvas,
                                                        gint orientation,
                                                        gint units,
                                                        gdouble width,
                                                        gdouble height);

void 	   gtk_plot_gnome_preview_construct            (GtkPlotGnome *pc,
							GnomeCanvas *canvas,
                                                        gint orientation,
                                                        gint page_size);

void	   gtk_plot_gnome_preview_with_size            (GtkPlotGnome *pc,
							GnomeCanvas *canvas,
                                                        gint orientation,
                                                        gint units,
                                                        gdouble width,
                                                        gdouble height);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* WITH_GNOME_PRINT */

#endif /* __GTK_PLOT_GNOME_H__ */

