module Schleuder
  class ManageKeysPlugin < Plugin
    def match(mail)
      mail.keywords.keys.include?('X-LIST-KEYS') || mail.keywords.keys.include?('X-ADD-KEY') || mail.keywords.keys.include?('X-DEL-KEY') || mail.keywords.keys.include?('X-SEND-KEY')
    end
    
    def process(mail)
      msg = ""
      k = mail.keywords.keys
      case 
      when k.include?('X-LIST-KEYS')
        Schleuder.log.debug 'LIST-KEYS requested'
        mail.crypt.list_keys.each do |k|
          msg << "#{k.to_s}\n"
        end
      when k.include?('X-ADD-KEY')
        Schleuder.log.debug 'ADD-KEY requested'
        res = mail.crypt.add_key(mail.body)
        res.imports.each do |i|
          msg << "#{mail.crypt.get_key(i.fpr).to_s}\n--> "
          if i.status == 1
            msg << "imported"
          else
            msg << "not imported"
          end
          msg << "\n\n"
        end
        msg << "\n\nImportResult.inspect:\n=> #{res.inspect}"
      when k.include?('X-DEL-KEY')
        # TODO: implement callback to sender with Hash to prevent replay attacks
        req = mail.keywords['X-DEL-KEY']
        key = mail.crypt.get_key(req)
        unless key
          msg << "#{req}\n\n--> No matching key present, nothing deleted."
        else
          msg << "#{key.to_s}\n--> "
          res = mail.crypt.delete_key(key)
          if res == true
            msg << "deleted"
          else
            msg << "not deleted\n\nException: #{res.to_s}"
          end
        end
        msg << "\n"
      when k.include?('X-SEND-KEY')
        Schleuder.log.debug 'SEND-KEY requested'
        req = mail.keywords['X-SEND-KEY']
        keyblock = mail.crypt.export(req)
        if keyblock.empty?
          msg << "#{req}\n\n--> No matching key present."
        else
          msg << "#{mail.crypt.get_key(req).to_s}\n\n#{keyblock}"
        end
        msg << "\n"
      end

      reply(mail, msg)
    end
  end
end

