(define (make-partitions n)
  (letrec
    ((iota
       (lambda (l h)
         (if (= l h)
             (list l)
             (cons l (iota (+ 1 l) h)))))
     (partition
       (lambda (n)
         (cond
           ((zero? n) '(()))
           ((= n 1) '((1)))
           (else (apply append
                        (map (lambda (x)
                               (map (lambda (p)
                                      (cons x p))
                                    (partition (- n x))))
                             (iota 1 n)))))))
     (filter-ascending
       (lambda (p)
         (cond ((null? (cdr p)) p)
           ((apply >= (car p))
             (cons (car p)
                   (filter-ascending (cdr p))))
           (else (filter-ascending (cdr p)))))))
    (reverse (filter-ascending (partition n)))))

(if (not (equal? (make-partitions 15)
                 '((15) (14 1) (13 2) (13 1 1) (12 3) (12 2 1) (12 1 1 1)
                   (11 4) (11 3 1) (11 2 2) (11 2 1 1) (11 1 1 1 1) (10 5)
                   (10 4 1) (10 3 2) (10 3 1 1) (10 2 2 1) (10 2 1 1 1)
                   (10 1 1 1 1 1) (9 6) (9 5 1) (9 4 2) (9 4 1 1) (9 3 3)
                   (9 3 2 1) (9 3 1 1 1) (9 2 2 2) (9 2 2 1 1) (9 2 1 1 1 1)
                   (9 1 1 1 1 1 1) (8 7) (8 6 1) (8 5 2) (8 5 1 1) (8 4 3)
                   (8 4 2 1) (8 4 1 1 1) (8 3 3 1) (8 3 2 2) (8 3 2 1 1)
                   (8 3 1 1 1 1) (8 2 2 2 1) (8 2 2 1 1 1) (8 2 1 1 1 1 1)
                   (8 1 1 1 1 1 1 1) (7 7 1) (7 6 2) (7 6 1 1) (7 5 3)
                   (7 5 2 1) (7 5 1 1 1) (7 4 4) (7 4 3 1) (7 4 2 2)
                   (7 4 2 1 1) (7 4 1 1 1 1) (7 3 3 2) (7 3 3 1 1)
                   (7 3 2 2 1) (7 3 2 1 1 1) (7 3 1 1 1 1 1) (7 2 2 2 2)
                   (7 2 2 2 1 1) (7 2 2 1 1 1 1) (7 2 1 1 1 1 1 1)
                   (7 1 1 1 1 1 1 1 1) (6 6 3) (6 6 2 1) (6 6 1 1 1)
                   (6 5 4) (6 5 3 1) (6 5 2 2) (6 5 2 1 1) (6 5 1 1 1 1)
                   (6 4 4 1) (6 4 3 2) (6 4 3 1 1) (6 4 2 2 1) (6 4 2 1 1 1)
                   (6 4 1 1 1 1 1) (6 3 3 3) (6 3 3 2 1) (6 3 3 1 1 1)
                   (6 3 2 2 2) (6 3 2 2 1 1) (6 3 2 1 1 1 1)
                   (6 3 1 1 1 1 1 1) (6 2 2 2 2 1) (6 2 2 2 1 1 1)
                   (6 2 2 1 1 1 1 1) (6 2 1 1 1 1 1 1 1) (6 1 1 1 1 1 1 1 1 1)
                   (5 5 5) (5 5 4 1) (5 5 3 2) (5 5 3 1 1) (5 5 2 2 1)
                   (5 5 2 1 1 1) (5 5 1 1 1 1 1) (5 4 4 2) (5 4 4 1 1)
                   (5 4 3 3) (5 4 3 2 1) (5 4 3 1 1 1) (5 4 2 2 2)
                   (5 4 2 2 1 1) (5 4 2 1 1 1 1) (5 4 1 1 1 1 1 1)
                   (5 3 3 3 1) (5 3 3 2 2) (5 3 3 2 1 1) (5 3 3 1 1 1 1)
                   (5 3 2 2 2 1) (5 3 2 2 1 1 1) (5 3 2 1 1 1 1 1)
                   (5 3 1 1 1 1 1 1 1) (5 2 2 2 2 2) (5 2 2 2 2 1 1)
                   (5 2 2 2 1 1 1 1) (5 2 2 1 1 1 1 1 1) (5 2 1 1 1 1 1 1 1 1)
                   (5 1 1 1 1 1 1 1 1 1 1) (4 4 4 3) (4 4 4 2 1) (4 4 4 1 1 1)
                   (4 4 3 3 1) (4 4 3 2 2) (4 4 3 2 1 1) (4 4 3 1 1 1 1)
                   (4 4 2 2 2 1) (4 4 2 2 1 1 1) (4 4 2 1 1 1 1 1)
                   (4 4 1 1 1 1 1 1 1) (4 3 3 3 2) (4 3 3 3 1 1) (4 3 3 2 2 1)
                   (4 3 3 2 1 1 1) (4 3 3 1 1 1 1 1) (4 3 2 2 2 2)
                   (4 3 2 2 2 1 1) (4 3 2 2 1 1 1 1) (4 3 2 1 1 1 1 1 1)
                   (4 3 1 1 1 1 1 1 1 1) (4 2 2 2 2 2 1) (4 2 2 2 2 1 1 1)
                   (4 2 2 2 1 1 1 1 1) (4 2 2 1 1 1 1 1 1 1)
                   (4 2 1 1 1 1 1 1 1 1 1) (4 1 1 1 1 1 1 1 1 1 1 1)
                   (3 3 3 3 3) (3 3 3 3 2 1) (3 3 3 3 1 1 1) (3 3 3 2 2 2)
                   (3 3 3 2 2 1 1) (3 3 3 2 1 1 1 1) (3 3 3 1 1 1 1 1 1)
                   (3 3 2 2 2 2 1) (3 3 2 2 2 1 1 1) (3 3 2 2 1 1 1 1 1)
                   (3 3 2 1 1 1 1 1 1 1) (3 3 1 1 1 1 1 1 1 1 1)
                   (3 2 2 2 2 2 2) (3 2 2 2 2 2 1 1) (3 2 2 2 2 1 1 1 1)
                   (3 2 2 2 1 1 1 1 1 1) (3 2 2 1 1 1 1 1 1 1 1)
                   (3 2 1 1 1 1 1 1 1 1 1 1) (3 1 1 1 1 1 1 1 1 1 1 1 1)
                   (2 2 2 2 2 2 2 1) (2 2 2 2 2 2 1 1 1) (2 2 2 2 2 1 1 1 1 1)
                   (2 2 2 2 1 1 1 1 1 1 1) (2 2 2 1 1 1 1 1 1 1 1 1)
                   (2 2 1 1 1 1 1 1 1 1 1 1 1) (2 1 1 1 1 1 1 1 1 1 1 1 1 1)
                   (1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))))
    (error "partitions of 15 failed"))

