#ifndef CUBE2SCANNER_H
#define CUBE2SCANNER_H

// Flex expects the signature of yylex to be defined in the macro YY_DECL, and
// the C++ parser expects it to be declared. We can factor both as follows.

#ifndef YY_DECL

#define	YY_DECL						\
    cubeparser::Cube2Parser::token_type				\
    cubeparser::Cube2Scanner::lex(				\
	cubeparser::Cube2Parser::semantic_type* yylval,		\
	cubeparser::Cube2Parser::location_type* yylloc		\
    )
#endif

#ifndef __FLEX_LEXER_H
//#define yyFlexLexer Cube2FlexLexer
#include "FlexLexer.h"
#undef yyFlexLexer
#endif

#include "Cube2Parser.h"

namespace cubeparser {


/** Scanner is a derived class to add some extra function to the scanner
 * class. Flex itself creates a class named yyFlexLexer, which is renamed using
 * macros to CubeparserFlexLexer. However we change the context of the generated
 * yylex() function to be contained within the Scanner class. This is required
 * because the yylex() defined in yyFlexLexer has no parameters. */
class Cube2Scanner : public yyFlexLexer
{
public:
    /** Create a new scanner object. The streams arg_yyin and arg_yyout default
     * to cin and cout, but that assignment is only made when initializing in
     * yylex(). */
    Cube2Scanner(std::istream* arg_yyin = 0,
	    std::ostream* arg_yyout = 0,
	    ParseContext* parseContext = NULL);

    /** Required for virtual functions */
    virtual ~Cube2Scanner();

    /** This is the main lexing function. It is generated by flex according to
     * the macro declaration YY_DECL above. The generated bison parser then
     * calls this virtual function to fetch new tokens. */
    virtual Cube2Parser::token_type lex(
	Cube2Parser::semantic_type* yylval,
	Cube2Parser::location_type* yylloc
	);

 private:

    ParseContext* parseContext;
};

} // namespace cubeparser

#endif // CUBE2SCANNER_H
