/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.dotnet.build;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.ant.dotnet.DotNetExecTask;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.DOMElementWriter;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.XMLFragment;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public abstract class AbstractBuildTask
extends Task {
    private File buildFile;
    private List targets = new ArrayList();
    private List properties = new ArrayList(1);
    private XMLFragment buildSnippet;
    private String vm;
    private boolean failOnError = true;
    private String errorProperty;

    protected AbstractBuildTask() {
    }

    public final void setBuildfile(File f) {
        this.buildFile = f;
    }

    public void addBuild(XMLFragment f) {
        if (this.buildSnippet != null) {
            throw new BuildException("You must not specify more than one build element");
        }
        this.buildSnippet = f;
    }

    public void setVm(String value) {
        this.vm = value;
    }

    public final void addTarget(Target t) {
        this.targets.add(t);
    }

    public final void addProperty(Property t) {
        this.properties.add(t);
    }

    public void setFailOnError(boolean b) {
        this.failOnError = b;
    }

    public void setErrorProperty(String name) {
        this.errorProperty = name;
    }

    protected abstract String getExecutable();

    protected abstract String[] getBuildfileArguments(File var1);

    protected abstract String[] getTargetArguments(List var1);

    protected abstract String[] getPropertyArguments(List var1);

    protected abstract Element makeTree(DocumentFragment var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        int i;
        if (this.buildFile != null && this.buildSnippet != null) {
            throw new BuildException("You must not specify the build file attribute and a nested build at the same time");
        }
        DotNetExecTask exec = DotNetExecTask.getTask(this, this.vm, this.getExecutable(), null);
        String[] args = this.getPropertyArguments(this.properties);
        for (i = 0; i < args.length; ++i) {
            exec.createArg().setValue(args[i]);
        }
        args = this.getTargetArguments(this.targets);
        for (i = 0; i < args.length; ++i) {
            exec.createArg().setValue(args[i]);
        }
        File generatedFile = null;
        if (this.buildSnippet != null) {
            try {
                generatedFile = this.getBuildFile();
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
            args = this.getBuildfileArguments(generatedFile);
        } else {
            args = this.getBuildfileArguments(this.buildFile);
        }
        for (int i2 = 0; i2 < args.length; ++i2) {
            exec.createArg().setValue(args[i2]);
        }
        exec.setFailonerror(this.failOnError);
        exec.internalSetErrorProperty(this.errorProperty);
        try {
            exec.execute();
        }
        finally {
            if (generatedFile != null) {
                generatedFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getBuildFile() throws IOException {
        File f = null;
        if (this.buildSnippet != null) {
            Element e = this.makeTree(this.buildSnippet.getFragment());
            f = FileUtils.getFileUtils().createTempFile("build", ".xml", null);
            f.deleteOnExit();
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(f);
                DOMElementWriter w = new DOMElementWriter(true, DOMElementWriter.XmlNamespacePolicy.ONLY_QUALIFY_ELEMENTS);
                w.write(e, (OutputStream)out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        return f;
    }

    public static class Property {
        private String name;
        private String value;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Target {
        private String name;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

