/*
 * Decompiled with CFR 0.152.
 */
package vizant;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import vizant.VizAttrStmt;
import vizant.VizPrinter;
import vizant.VizProject;
import vizant.VizProjectLoader;
import vizant.VizProjectLoaderImpl;
import vizant.VizSubgraph;
import vizant.VizWriter;

public class Vizant
extends Task {
    private File antfile;
    private File outfile;
    private VizProjectLoader loader;
    private VizPrinter printer;
    private VizWriter writer;

    public void init() {
        this.loader = this.getLoader();
        this.printer = this.getPrinter();
    }

    public void setAntfile(File file) throws BuildException {
        this.antfile = file;
        try {
            this.loader.setInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new BuildException((Throwable)fileNotFoundException);
        }
    }

    public void setOutfile(File file) {
        this.outfile = file;
    }

    public void setGraphid(String string) {
        this.printer.setGraphid(string);
    }

    public void setFrom(String string) {
        this.printer.setFrom(string);
    }

    public void setTo(String string) {
        this.printer.setTo(string);
    }

    public void setNocluster(boolean bl) {
        this.printer.setNocluster(bl);
    }

    public void setUniqueref(boolean bl) {
        this.loader.uniqueRef(bl);
    }

    public void setIgnoreant(boolean bl) {
        this.loader.ignoreAnt(bl);
    }

    public void setIgnoreantcall(boolean bl) {
        this.loader.ignoreAntcall(bl);
    }

    public void setIgnoredepends(boolean bl) {
        this.loader.ignoreDepends(bl);
    }

    public void addConfiguredAttrstmt(VizAttrStmt vizAttrStmt) throws BuildException {
        vizAttrStmt.checkConfiguration();
        this.printer.addAttributeStatement(vizAttrStmt);
    }

    public void addSubgraph(VizSubgraph vizSubgraph) {
        vizSubgraph.setPrinter(this.printer);
    }

    public void execute() throws BuildException {
        this.checkConfiguration();
        this.loadProjects();
        this.writeDotToOutfile();
    }

    protected VizPrinter getPrinter() {
        return new VizPrinter();
    }

    protected VizProjectLoader getLoader() {
        return new VizProjectLoaderImpl();
    }

    protected void checkConfiguration() throws BuildException {
        if (this.antfile == null) {
            throw new BuildException("antfile attribute is required");
        }
        if (this.outfile == null) {
            throw new BuildException("outfile attribute is required");
        }
    }

    protected void loadProjects() throws BuildException {
        Enumeration enumeration = this.loader.getProjects().elements();
        while (enumeration.hasMoreElements()) {
            this.printer.addProject((VizProject)enumeration.nextElement());
        }
    }

    protected void writeDotToOutfile() throws BuildException {
        VizFileWriter vizFileWriter = null;
        try {
            try {
                vizFileWriter = new VizFileWriter(this.outfile);
                this.print(vizFileWriter);
            }
            catch (IOException iOException) {
                throw new BuildException(iOException.toString());
            }
            Object var4_2 = null;
            if (vizFileWriter != null) {
                vizFileWriter.close();
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (vizFileWriter != null) {
                vizFileWriter.close();
            }
            throw throwable;
        }
    }

    protected void print(VizWriter vizWriter) {
        this.printer.setWriter(vizWriter);
        this.printer.print();
    }

    public class VizFileWriter
    implements VizWriter {
        private PrintWriter out = null;

        public VizFileWriter(File file) throws IOException {
            this.out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        }

        public void print(String string) {
            this.out.print(string);
        }

        public void println(String string) {
            this.out.println(string);
        }

        public void close() {
            if (this.out != null) {
                this.out.flush();
                this.out.close();
            }
        }
    }
}

