/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharsetDecoder;
import scala.Console$;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.tools.nsc.io.AbstractFile;
import scala.tools.nsc.io.PlainFile;
import scala.tools.nsc.io.SourceReader$;
import scala.tools.nsc.io.ZipArchive;

public class SourceReader
implements ScalaObject {
    private CharBuffer chars;
    private ByteBuffer bytes;
    private CharsetDecoder decoder;

    public SourceReader(CharsetDecoder charsetDecoder) {
        this.decoder = charsetDecoder;
        this.bytes = ByteBuffer.allocate(16384);
        this.chars = CharBuffer.allocate(16384);
    }

    private char[] terminate(CharBuffer charBuffer) {
        char[] cArray = new char[charBuffer.length()];
        charBuffer.get(cArray);
        this.chars_$eq(charBuffer);
        return cArray;
    }

    public char[] read(ReadableByteChannel readableByteChannel) {
        CharsetDecoder charsetDecoder = this.decoder.reset();
        ByteBuffer byteBuffer = this.bytes();
        byteBuffer.clear();
        CharBuffer charBuffer = this.chars();
        charBuffer.clear();
        boolean bl = false;
        while (!bl) {
            bl = readableByteChannel.read(byteBuffer) < 0;
            byteBuffer.flip();
            charBuffer = SourceReader$.MODULE$.decode(charsetDecoder, byteBuffer, charBuffer, bl);
        }
        return this.terminate(SourceReader$.MODULE$.flush(charsetDecoder, charBuffer));
    }

    public char[] read(AbstractFile abstractFile) {
        char[] cArray;
        AbstractFile abstractFile2 = abstractFile;
        if (!(abstractFile2 instanceof PlainFile)) {
            ZipArchive.FileEntry fileEntry;
            if (!(abstractFile2 instanceof ZipArchive.FileEntry)) {
                throw new IOException(abstractFile.toString() + " is neither plain file nor ZipArchive#FileEntry");
            }
            ZipArchive.FileEntry fileEntry2 = fileEntry = (ZipArchive.FileEntry)abstractFile2;
            ReadableByteChannel readableByteChannel = Channels.newChannel(fileEntry2.getArchive().getInputStream(fileEntry2.entry()));
            cArray = this.read(readableByteChannel);
        } else {
            cArray = this.read(((PlainFile)abstractFile2).file());
        }
        return cArray;
    }

    public char[] read(File file) {
        char[] cArray;
        FileChannel fileChannel = new FileInputStream(file).getChannel();
        try {
            cArray = this.read(fileChannel);
            fileChannel.close();
        }
        catch (Throwable throwable) {
            fileChannel.close();
            throw throwable;
        }
        catch (Exception exception) {
            this.reportEncodingError(file.toString());
            cArray = new char[]{};
            fileChannel.close();
        }
        return cArray;
    }

    public char[] read(String string) {
        return this.read(new File(string));
    }

    private void reportEncodingError(String string) {
        Console$.MODULE$.println("IO error while decoding " + string + " with " + this.decoder.charset());
        Console$.MODULE$.println("Please try specifying another one using the -encoding option");
    }

    private void chars_$eq(CharBuffer charBuffer) {
        this.chars = charBuffer;
    }

    private CharBuffer chars() {
        return this.chars;
    }

    private ByteBuffer bytes() {
        return this.bytes;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

