
// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Malolan Chetlur     
//          Umesh Kumar V. Rajasekaran

#include "IIRScram_ReportStatement.hh"
#include "IIR_Identifier.hh"
#include "IIR_Label.hh"
#include "IIR_AboveAttribute.hh"
#include "savant.hh"
#include "published_file.hh"

IIRScram_ReportStatement::~IIRScram_ReportStatement(){}

void 
IIRScram_ReportStatement::_publish_vhdl(ostream &_vhdl_out) {

  _publish_vhdl_stmt_label(_vhdl_out);

  _vhdl_out << "   report ";
  get_report_expression()->_publish_vhdl(_vhdl_out);

  if(get_severity_expression() != NULL) {
    _vhdl_out << "\n";
    _vhdl_out << "     severity ";
    get_severity_expression()->_publish_vhdl(_vhdl_out);
  }
}

void
IIRScram_ReportStatement::_publish_cc( published_file &_cc_out ) {
  _publish_cc_assertion_or_report_statement( _cc_out );
}

void
IIRScram_ReportStatement::_publish_cc_assertion_condition( published_file &_cc_out ) {
  _cc_out << "SAVANT_BOOLEAN_FALSE";
}

void
IIRScram_ReportStatement::_get_list_of_input_signals( set<IIR> *list ){
  if( get_report_expression() != NULL ){
    get_report_expression()->_get_list_of_input_signals(list);
  }
  if( get_severity_expression() != NULL ){
    get_severity_expression()->_get_list_of_input_signals(list);
  }
}

void 
IIRScram_ReportStatement::_type_check(){
  if( get_report_expression() != NULL ){
    _type_check_report_expression();
  }

  if( get_severity_expression() != NULL ){
    _type_check_severity_expression();
  }
}

IIR_Boolean
IIRScram_ReportStatement::_is_above_attribute_found() {
  IIR_Boolean retval = FALSE;
  retval = retval || get_report_expression()->_is_above_attribute_found();
  if(get_severity_expression() != NULL) {
    retval = retval || get_severity_expression()->_is_above_attribute_found();
  }
  return retval;
}

void
IIRScram_ReportStatement::
_build_above_attribute_set(set<IIR_AboveAttribute> *to_build) {
  get_report_expression()->_build_above_attribute_set(to_build);
  if(get_severity_expression() != NULL) {
    get_severity_expression()->_build_above_attribute_set(to_build);
  }
}

visitor_return_type *
IIRScram_ReportStatement::_accept_visitor( node_visitor *visitor, 
					   visitor_argument_type *arg ){
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_ReportStatement(this, arg);
}
