// Copyright (C) 1999-2014
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "colorscaletrue16.h"

ColorScaleTrueColor16::ColorScaleTrueColor16(int s, Visual* visual, int msb)
  : ColorScale(s), TrueColor16(visual)
{
  colors_ = new unsigned char[s*2];

  // we need to check to byteswap when we have cross platforms
  if ((!msb && lsb()) || (msb && !lsb())) {
    for (int i=0; i<s; i++) {
      unsigned short r = psColors_[i*3+2];
      unsigned short g = psColors_[i*3+1];
      unsigned short b = psColors_[i*3];
      unsigned short a = 0;
      a |= rs_>0 ? ((r & rm_) << rs_) : ((r & rm_) >> -rs_);
      a |= gs_>0 ? ((g & gm_) << gs_) : ((g & gm_) >> -gs_);
      a |= bs_>0 ? ((b & bm_) << bs_) : ((b & bm_) >> -bs_);

      memcpy(colors_+i*2, &a, 2);
    }
  }
  else {
    for (int i=0; i<s; i++) {
      unsigned short r = psColors_[i*3+2];
      unsigned short g = psColors_[i*3+1];
      unsigned short b = psColors_[i*3];
      unsigned short a = 0;
      a |= rs_>0 ? ((r & rm_) << rs_) : ((r & rm_) >> -rs_);
      a |= gs_>0 ? ((g & gm_) << gs_) : ((g & gm_) >> -gs_);
      a |= bs_>0 ? ((b & bm_) << bs_) : ((b & bm_) >> -bs_);

      unsigned char* rr = (unsigned char*)(&a);
      *(colors_+i*2) = *(rr+1);
      *(colors_+i*2+1) = *(rr);
    }
  }
}

ColorScaleTrueColor16::~ColorScaleTrueColor16()
{
  if (colors_)
    delete [] colors_;
}

LinearScaleTrueColor16::LinearScaleTrueColor16(int s, 
					       unsigned short* indexCells,
					       unsigned char* colorCells,
					       int count, 
					       Visual* visual, int msb)
  : LinearScale(s, indexCells, colorCells, count), 
    ColorScaleTrueColor16(s, visual, msb),
    ColorScale(s) {}

LogScaleTrueColor16::LogScaleTrueColor16(int s,
					 unsigned short* indexCells,
					 unsigned char* colorCells,
					 int count, double exp,
					 Visual* visual, int msb)
  : LogScale(s, indexCells, colorCells, count, exp), 
    ColorScaleTrueColor16(s, visual, msb),
    ColorScale(s) {}

PowScaleTrueColor16::PowScaleTrueColor16(int s,
					 unsigned short* indexCells,
					 unsigned char* colorCells,
					 int count, double exp,
					 Visual* visual, int msb)
  : PowScale(s, indexCells, colorCells, count, exp), 
    ColorScaleTrueColor16(s, visual, msb),
    ColorScale(s) {}

SqrtScaleTrueColor16::SqrtScaleTrueColor16(int s,
					   unsigned short* indexCells,
					   unsigned char* colorCells,
					   int count, 
					   Visual* visual, int msb)
  : SqrtScale(s, indexCells, colorCells, count), 
    ColorScaleTrueColor16(s, visual, msb),
    ColorScale(s) {}

SquaredScaleTrueColor16::SquaredScaleTrueColor16(int s,
						 unsigned short* indexCells,
						 unsigned char* colorCells,
						 int count, 
						 Visual* visual, int msb)
  : SquaredScale(s,indexCells,colorCells,count), 
    ColorScaleTrueColor16(s, visual, msb),
    ColorScale(s) {}

AsinhScaleTrueColor16::AsinhScaleTrueColor16(int s,
					     unsigned short* indexCells,
					     unsigned char* colorCells,
					     int count, 
					     Visual* visual, int msb)
  : AsinhScale(s,indexCells,colorCells,count), 
    ColorScaleTrueColor16(s, visual, msb),
    ColorScale(s) {}

SinhScaleTrueColor16::SinhScaleTrueColor16(int s,
					     unsigned short* indexCells,
					     unsigned char* colorCells,
					     int count, 
					     Visual* visual, int msb)
  : SinhScale(s,indexCells,colorCells,count), 
    ColorScaleTrueColor16(s, visual, msb),
    ColorScale(s) {}

IISScaleTrueColor16::IISScaleTrueColor16(unsigned short* indexCells,
					 unsigned char* colorCells,
					 int count, 
					 Visual* visual, int msb)
  : IISScale(indexCells, colorCells, count),
    ColorScaleTrueColor16(IISSIZE, visual, msb),
    ColorScale(IISSIZE) {}

HistEquScaleTrueColor16::HistEquScaleTrueColor16(int s, 
						 unsigned short* indexCells,
						 unsigned char* colorCells,
						 int count, 
						 double* hist, int histsize,
						 Visual* visual, int msb)
  : HistEquScale(s, indexCells, colorCells, count, hist, histsize), 
    ColorScaleTrueColor16(s, visual, msb),
    ColorScale(s) {}

