#  Copyright (C) 1999-2012
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc HelpDef {} {
    global help
    global ds9

    set help(refman) "$ds9(root)/doc/ref/index.html"
    set help(command) "$ds9(root)/doc/ref/command.html"
    set help(userman) "$ds9(root)/doc/user/index.html"
    set help(keyboard) "$ds9(root)/doc/ref/keyboard.html"
    set help(faq) "$ds9(root)/doc/faq.html"
    set help(new) "$ds9(root)/doc/new.html"
    set help(release) "$ds9(root)/doc/release/r7.0.html"
    set help(helpdesk) "$ds9(root)/doc/helpdesk.html"
    set help(story) "$ds9(root)/doc/story.html"
    set help(ack) "$ds9(root)/doc/acknowledgment.html"
    set help(home) "http://hea-www.harvard.edu/RD/ds9/"
    set help(vo) "$ds9(root)/doc/ref/vo.html"

    set help(about) "SAOImage DS9\nVersion $ds9(version)\n\nAuthors:\nWilliam Joye (SAO)\nEric Mandel (SAO)\nSteve Murray (SAO)\nJohn Roll (SAO)\n\nContributions:\nD.S. Berry (Starlink)\nL. Brown (HEASARC)\nMark Calabretta (ATNF)\nMike Fitzpatrick (NOAO)\nDoug Mink (SAO)\nDoug Tody (NOAO)\nP.T. Wallace (Starlink)\nR.F. Warren-Smith (Starlink)\nPeter Wilson (HEASARC)\n\nOther Contributors:\nMark Adler, Jean-loup Gailly,\nD. Richard Hip, G. Howlett,\nJan Nijtmans, John Ousterhout\n\nTranslations:\nHans-Jakob Grimm (SAO)\nAllan Hornstrup (DNSC)\nAlberto Martins (Universidade de Sao Paulo)\nManuel Perez Torres (SAO)\nMasahiro Tsujimoto (JAXA ISAS)\nElaine Fortin (SAO)\nAnne Lemiere(SAO)\nPetr Kubnek"

    set help(email) "If you encounter any problems or have suggestions with ds9, please contact us at: 

saord@cfa.harvard.edu
http://hea-www.harvard.edu/RD/ds9/

William Joye
Eric Mandel
Smithsonian Astrophysical Observatory
Garden St.
Cambridge, MA 02138 USA"

    set help(shortcuts) " DS9 version $ds9(version)\n\n\
          Key Stroke       Description\n\
          ----------       -----------\n\
          TAB              Goto next frame\n\
          DELETE           Deletes selected regions\n\
          R                Print Mouse Coordinates and Pixel value.\n\
          F                Toggles Infobox freeze\n\
          I                Set include property for region\n\
          E                Set exclude property for region\n\
          S                Set source property for region\n\
          B                Set background property for region\n\
          +                Goto next 3D Fits Slice\n\
          -                Goto previous 3D Fits Slice\n\
          Up Arrow         Move selected regions/cursor up one pixel.\n\
          Right Arrow      Move selected regions/cursor right one pixel.\n\
          Left Arrow       Move selected regions/cursor left one pixel.\n\
          Down Arrow       Move selected regions/cursor down one pixel.\n\
          Shift-Drag       Select all regions within the indicated region.\n\
          Control-Drag     Selected ANNULUS Regions, will create new radii.\n
"

}

proc HelpRef {} {
    global help
    HV hlpref [msgcat::mc {Reference Manual}] $help(refman)
}

proc HelpCommand {} {
    global help
    HV hlpcmd [msgcat::mc {Command}] $help(command)
}

proc HelpUser {} {
    global help
    HV hlpuser [msgcat::mc {User Manual}] $help(userman)
}

proc HelpKeyboard {} {
    global help
    HV hlpkeyboard [msgcat::mc {Keyboard Shortcuts}] $help(keyboard)
}

proc HelpFAQ {} {
    global help
    HV hlpfaq [msgcat::mc {FAQ}] $help(faq)
}

proc HelpNew {} {
    global help
    HV hlpnew [msgcat::mc {New Features}] $help(new)
}

proc HelpRelease {} {
    global help
    HV hlprelease [msgcat::mc {Release Notes}] $help(release)
}

proc HelpDesk {} {
    global help
    HV hlpdsk [msgcat::mc {Help Desk}] $help(helpdesk)
}

proc HelpStory {} {
    global help
    HV hlpstory [msgcat::mc {Story of SAOImage DS9}] $help(story)
}

proc HelpAck {} {
    global help
    HV hlpack [msgcat::mc {Acknowledgment}] $help(ack)
}

proc HelpHome {} {
    global help
    HV hlphome [msgcat::mc {DS9 Home Page}] $help(home)
}

proc HelpVO {} {
    global help
    HV hlvo [msgcat::mc {Virtual Observatory}] $help(vo)
}

proc ProcessSendAboutCmd {proc id param sock fn} {
    global help 
    ProcessSend $proc $id $sock $fn {.txt} "$help(about)\n"
}
