// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __polygon_h__
#define __polygon_h__

#include "marker.h"
#include "list.h"

class Polygon : public Marker {
private:
  List<Vertex> vertex;

  void render(Drawable, const Matrix&, RenderMode);
  void moveVertex(const Vector&, int);
  void recalcCenter();

public:
  Polygon(const Polygon&);
  Polygon(FrameBase* p, const Vector& ctr,
	  const Vector& b,
	  const char* clr, int wth, 
	  const char* fnt, const char* txt,
	  unsigned short prop, const char* cmt,
	  const List<Tag>& tg, const List<CallBack>& cb);
  Polygon(FrameBase* p, const List<Vertex>& v, 
	  const char* clr, int wth, 
	  const char* fnt, const char* txt,
	  unsigned short prop, const char* cmt,
	  const List<Tag>& tg, const List<CallBack>& cb);

  Marker* dup() {return new Polygon(*this);}
  void updateBBox();
  void updateCoords(const Matrix&);

  void edit(const Vector&, int);
  void rotate(const Vector&, int);
  void ps(int);
  int isIn(const Vector& v);
  int isPolygon() {return 1;}

  void createVertex(int, const Vector&);
  void deleteVertex(int);
  int getSegment(const Vector&);
  void reset(const Vector&);

  void list(ostream&, CoordSystem, SkyFrame, SkyFormat, int, int);
  void listCiao(ostream&, CoordSystem, int, int);
  void listSAOtng(ostream&, CoordSystem, SkyFrame, SkyFormat, int);
  void listSAOimage(ostream&, int);
  void listPros(ostream&, CoordSystem, SkyFrame, SkyFormat, int);
};

#endif
