// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "fitsimage.h"
#include "util.h"

#include "NaN.h"
#include "smooth.h"

int FitsImage::smooth()
{
  // radius
  int r = parent->smoothRadius_;

  // src
  float* src = new float[width_*height_];
  if (!src)
    return 0;

  float* ptr = src;
  for (int jj=0; jj<height_; jj++)
    for (int ii=0; ii<width_; ii++, ptr++)
      *ptr = fitsdata_->getValueDouble(jj*width_+ii);

  // dest
  float* dest = (float*)smooth_->data();

  // kernel
  // create kernel
  int rr = 2*r+1;
  float* kernel = new float[rr*rr];
  if (!kernel)
    return 0;
  memset(kernel, 0, rr*rr*sizeof(float));

  switch (parent->smoothFunction_) {
  case FrameBase::BOXCAR:
    boxcar(kernel,r);
    break;
  case FrameBase::TOPHAT:
    tophat(kernel,r);
    break;
  case FrameBase::GAUSSIAN:
    gaussian(kernel,r);
    break;
  }

  // convolve
  convolve(kernel,src,dest,width_,height_,r);
  
  // clean up
  delete kernel;
  delete src;

  return 1;
}
