#! /bin/sh

if [ "$2" = "val" ]; then
#    CMD="valgrind --leak-check=yes --show-reachable=yes ../ds9val"
    CMD="valgrind --leak-check=yes ../ds9val"
    XPA=ds9val
else
    CMD=../ds9
    XPA=ds9
fi

echo "Analysis Tests"
echo

echo "Starting DS9..."
if [ `xpaaccess $XPA` = no ]
then
    $CMD&
fi

i=1
while [ "$i" -le 30 ]
do
    sleep 2
    if [ `xpaaccess $XPA` = yes ]
    then
	break
    fi

    i=`expr $i + 1`
done

# load default
xpaset -p $XPA scale zscale
xpaset -p $XPA file img16.fits
xpaset -p $XPA regions file analysis.reg
xpaset -p $XPA analysis load analysis.ans

if [ "$1" = "plot" -o  -z "$1" ]; then
echo "Testing Text/Plot"
echo "This is a Test Text Message" | xpaset $XPA analysis text
cat xy.dat | xpaset $XPA analysis plot
cat xyexey.dat | xpaset $XPA analysis plot "{Plot Test}" X Y xyexey
cat stdin.xyey.dat | xpaset $XPA analysis plot stdin
xpaset -p $XPA raise
echo "PASSED"
fi

# Analysis
if [ "$1" = "analysis" -o  -z "$1" ]; then
echo "Testing Analysis File"
xpaget $XPA analysis > /dev/null
fi

# Main
if [ "$1" = "help" -o  -z "$1" ]; then
i=1
echo "$i Help"
xpaset -p $XPA analysis $i
fi

# Web
if [ "$1" = "web" -o  -z "$1" ]; then
i=`expr $i + 1`
echo "$i Web"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i web url"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i web file"
xpaset -p $XPA analysis $i
fi

# Basics
if [ "$1" = "basics" -o  -z "$1" ]; then
i=`expr $i + 1`
echo "Basic"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i escape macro"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i non macro"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$xpa"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$xpa_method"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$filename"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$filename(root)"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$xdim $ydim $bitpix"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$env"
xpaset -p $XPA analysis $i
fi

# Regions
if [ "$1" = "regions" -o  -z "$1" ]; then
i=`expr $i + 1`
echo "$i Regions"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$regions"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$regions wcs"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$include_regions_pixels"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$filename $regions"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$regions()"
xpaset -p $XPA analysis $i
fi

# Output
if [ "$1" = "output" -o  -z "$1" ]; then
i=`expr $i + 1`
echo "$i Output"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$null"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$text"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$text stderr"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$plot"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$plot(title,x,y,xyey)"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$plot(title,x,y,xyexey)"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$plot(title,x,y,4)"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$plot(title,x,y,5)"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$plot(stdin)"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$plot(stdin) text"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$plot(stdin) error"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$data"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$image"
xpaset -p $XPA analysis $i
fi

# Dialogs
if [ "$1" = "dialogs" -o  -z "$1" ]; then
i=`expr $i + 1`
echo "$i Dialog"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$message(message)"

i=`expr $i + 1`
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$message(ok,message)"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$entry(message)"
xpaset -p $XPA analysis $i
fi

# Params
if [ "$1" = "params" -o  -z "$1" ]; then
i=`expr $i + 1`
echo "$i Param"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$param"
xpaset -p $XPA analysis $i

i=`expr $i + 1`
echo "..$i \$param @file"
xpaset -p $XPA analysis $i
fi

echo "PASSED"

# Other
if [ "$1" = "other" -o  -z "$1" ]; then
xpaset -p $XPA analysis message {press 'x','y','z' to test interactive}
fi

#xpaset -p $XPA quit
echo "Done"
