#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc MarkerBaseDialog {frame id width height} {
    global marker
    global ds9

    set w ".marker$id"
    set mb ".mb$id"

    set t [$frame get marker $id type]
    switch -- [lindex $t 1] {
	point {
	    set type \
		"[string totitle [lindex $t 0]] [string totitle [lindex $t 1]]"
	    set which Point
	}
	{} {
	    set type [string totitle [lindex $t 0]]
	    set which $type
	}
    }

    # variables - some may already be initialized
    set marker($frame,$id,which) $which
    if {![info exists marker($frame,$id,system)]} {
	set marker($frame,$id,system) $marker(dialog,system)
    }
    set marker($frame,$id,clabel) $marker($frame,$id,system)
    if {![info exists marker($frame,$id,sky)]} {
	set marker($frame,$id,sky) $marker(dialog,sky)
    }
    if {![info exists marker($frame,$id,skyformat)]} {
	set marker($frame,$id,skyformat) $marker(dialog,skyformat)
    }

    # init
    MarkerBaseTextCB $frame $id
    MarkerBaseColorCB $frame $id
    MarkerBaseLineWidthCB $frame $id
    MarkerBasePropertyCB $frame $id
    MarkerBaseFontCB $frame $id
    ${which}CoordCB $frame $id

    # callbacks
    $frame marker $id callback delete MarkerBaseDeleteCB $frame
    $frame marker $id callback text MarkerBaseTextCB $frame
    $frame marker $id callback color MarkerBaseColorCB $frame
    $frame marker $id callback width MarkerBaseLineWidthCB $frame
    $frame marker $id callback property MarkerBasePropertyCB $frame
    $frame marker $id callback font MarkerBaseFontCB $frame

    # menus
    MarkerBaseMenu $frame $id
    MarkerBaseFileMenu $frame $id
    MarkerBaseColorMenu $frame $id
    MarkerBaseWidthMenu $frame $id
    MarkerBasePropertyMenu $frame $id
    MarkerBaseFontMenu $frame $id
    MarkerBaseCoordMenu $frame $id

    # window
    toplevel $w -colormap $ds9(main)
    wm title $w $type
    wm iconname $w $type
    wm group $w $ds9(top)
    wm protocol $w WM_DELETE_WINDOW "${which}Close $frame $id"
    $w configure -menu $mb
    wm minsize $w $width $height

    # dialog
    frame $w.basic -relief groove -borderwidth 2
    frame $w.basic.f
    frame $w.ref -relief groove -borderwidth 2
    frame $w.ref.f
    frame $w.buttons -relief groove -borderwidth 2

    pack $w.basic.f $w.ref.f -anchor w -padx 4 -pady 4
    pack $w.basic $w.ref -fill x 
    pack $w.buttons -side bottom -fill x -ipadx 4 -ipady 4

    # ID
    label $w.basic.f.idTitle -text "Id"
    label $w.basic.f.idValue -text "$id"

    # Text
    label $w.basic.f.textTitle -text "Text"
    entry $w.basic.f.textValue -textvariable marker($frame,$id,text) -width 40

    grid $w.basic.f.idTitle $w.basic.f.idValue -padx 4 -sticky w
    grid $w.basic.f.textTitle $w.basic.f.textValue -padx 4 -sticky w

    # Buttons
    button $w.buttons.apply -text Apply -command "${which}Apply $frame $id"
    button $w.buttons.close -text Close	-command "${which}Close $frame $id"
    pack $w.buttons.apply $w.buttons.close -side left -padx 10 -expand true

    bind $w <Return> "${which}Apply $frame $id"

    # some window managers need a hint
    raise $w
}

# actions

proc MarkerBaseClose {frame id} {
    $frame marker $id delete callback delete MarkerBaseDeleteCB
    $frame marker $id delete callback text MarkerBaseTextCB
    $frame marker $id delete callback color MarkerBaseColorCB
    $frame marker $id delete callback width MarkerBaseLineWidthCB
    $frame marker $id delete callback property MarkerBasePropertyCB
    $frame marker $id delete callback font MarkerBaseFontCB

    MarkerBaseDeleteCB $frame $id
}

proc MarkerBaseApply {frame id} {
    global marker

    $frame marker $id text \{$marker($frame,$id,text)\}
    UpdateMarkerMenu
}

proc MarkerBaseColor {frame id} {
    global marker

    $frame marker $id color $marker($frame,$id,color)
}

proc MarkerBaseLineWidth {frame id} {
    global marker

    $frame marker $id width $marker($frame,$id,linewidth)
}

proc MarkerBaseProperty {frame id prop} {
    global marker

    $frame marker $id property $prop $marker($frame,$id,$prop)
}

proc MarkerBaseFont {frame id} {
    global marker

    $frame marker $id font \
	\"$marker($frame,$id,font) $marker($frame,$id,font,size) \
	$marker($frame,$id,font,style)\"
}

# callbacks

proc MarkerBaseDeleteCB {frame id} {
    global marker

    set w ".marker$id"
    set mb ".mb$id"

    destroy $w
    destroy $mb

    # variables
    foreach m [array names marker] {
	set mm [split $m ,]
	if {[lindex $mm 0] == $frame && [lindex $mm 1] == $id} {
	    unset marker($m)
	}
    }
}

proc MarkerBaseTextCB {frame id} {
    global marker

    set marker($frame,$id,text) [$frame get marker $id text]
}

proc MarkerBaseColorCB {frame id} {
    global marker

    set marker($frame,$id,color) [$frame get marker $id color]
}

proc MarkerBaseLineWidthCB {frame id} {
    global marker

    set marker($frame,$id,linewidth) [$frame get marker $id width]
}

proc MarkerBasePropertyCB {frame id} {
    global marker

    set marker($frame,$id,edit) [$frame get marker $id property edit]
    set marker($frame,$id,move) [$frame get marker $id property move]
    set marker($frame,$id,rotate) [$frame get marker $id property rotate]
    set marker($frame,$id,delete) [$frame get marker $id property delete]
    set marker($frame,$id,fixed) [$frame get marker $id property fixed]
    set marker($frame,$id,include) [$frame get marker $id property include]
    set marker($frame,$id,source) [$frame get marker $id property source]
}

proc MarkerBaseFontCB {frame id} {
    global marker

    set f [$frame get marker $id font]

    set marker($frame,$id,font) [lindex $f 0]
    set marker($frame,$id,font,size) [lindex $f 1]
    set marker($frame,$id,font,style) [lindex $f 2]
}

proc MarkerBaseCoordCB {frame id} {
    global marker

    AdjustCoord $frame marker($frame,$id,system)

    set marker($frame,$id,clabel) $marker($frame,$id,system)
    switch -- $marker($frame,$id,system) {
	image -
	physical -
	amplifier -
	detector {}
	default {
	    if [$frame has wcs $marker($frame,$id,system)] {
		if [$frame has wcs equatorial $marker($frame,$id,system)] {
		    set marker($frame,$id,clabel) $marker($frame,$id,sky)
		} else {
		    set name [$frame get wcs name $marker($frame,$id,system)]
		    if {$name != ""} {
			set marker($frame,$id,clabel) $name
		    }
		}
	    }
	}
    }
}

proc MarkerBaseDistCB {frame id} {
    global marker

    AdjustDist $frame marker($frame,$id,dcoord)

    set marker($frame,$id,dlabel) $marker($frame,$id,dcoord)
    switch -- $marker($frame,$id,dcoord) {
	image -
	physical -
	amplifier -
	detector {}
	default {
	    if [$frame has wcs $marker($frame,$id,dcoord)] {
		if [$frame has wcs equatorial $marker($frame,$id,dcoord)] {
		    set marker($frame,$id,dlabel) $marker($frame,$id,dformat)
		} else {
		    set name [$frame get wcs name $marker($frame,$id,dcoord)]
		    if {$name != ""} {
			set marker($frame,$id,dlabel) $name
		    }
		}
	    }
	}
    }
}

# menus

proc MarkerBaseMenu {frame id} {
    global menu
    global marker

    set mb ".mb$id"

    menu $mb -tearoff 0 -selectcolor $menu(selectcolor)
    $mb add cascade -label File -menu $mb.file
    $mb add cascade -label Color -menu $mb.color
    $mb add cascade -label Width -menu $mb.width
    $mb add cascade -label Property -menu $mb.properties
    $mb add cascade -label Font -menu $mb.font
    $mb add cascade -label Coord -menu $mb.coord
}

proc MarkerBaseFileMenu {frame id} {
    global menu
    global marker

    set mb ".mb$id"
    set which $marker($frame,$id,which)

    menu $mb.file -tearoff 0 -selectcolor $menu(selectcolor)
    $mb.file add command -label Apply -command "${which}Apply $frame $id"
    $mb.file add separator
    $mb.file add command -label Close -command "${which}Close $frame $id"
}

proc MarkerBaseColorMenu {frame id} {
    global menu
    global marker

    set mb ".mb$id"

    menu $mb.color -tearoff 0 -selectcolor $menu(selectcolor)
    $mb.color add radiobutton -label "Black" \
	-variable marker($frame,$id,color) -value black \
	-command "MarkerBaseColor $frame $id"
    $mb.color add radiobutton -label "White" \
	-variable marker($frame,$id,color) -value white \
	-command "MarkerBaseColor $frame $id"
    $mb.color add radiobutton -label "Red" \
	-variable marker($frame,$id,color) -value red \
	-command "MarkerBaseColor $frame $id"
    $mb.color add radiobutton -label "Green" \
	-variable marker($frame,$id,color) -value green \
	-command "MarkerBaseColor $frame $id"
    $mb.color add radiobutton -label "Blue" \
	-variable marker($frame,$id,color) -value blue \
	-command "MarkerBaseColor $frame $id"
    $mb.color add radiobutton -label "Cyan" \
	-variable marker($frame,$id,color) -value cyan \
	-command "MarkerBaseColor $frame $id"
    $mb.color add radiobutton -label "Magenta" \
	-variable marker($frame,$id,color) -value magenta \
	-command "MarkerBaseColor $frame $id"
    $mb.color add radiobutton -label "Yellow" \
	-variable marker($frame,$id,color) -value yellow \
	-command "MarkerBaseColor $frame $id"
}

proc MarkerBaseWidthMenu {frame id} {
    global menu
    global marker

    set mb ".mb$id"

    menu $mb.width -tearoff 0 -selectcolor $menu(selectcolor)
    $mb.width add radiobutton -label "1" \
	-variable marker($frame,$id,linewidth) -value 1 \
	-command "MarkerBaseLineWidth $frame $id"
    $mb.width add radiobutton -label "2" \
	-variable marker($frame,$id,linewidth) -value 2 \
	-command "MarkerBaseLineWidth $frame $id"
    $mb.width add radiobutton -label "3" \
	-variable marker($frame,$id,linewidth) -value 3 \
	-command "MarkerBaseLineWidth $frame $id"
    $mb.width add radiobutton -label "4" \
	-variable marker($frame,$id,linewidth) -value 4 \
	-command "MarkerBaseLineWidth $frame $id"
}

proc MarkerBasePropertyMenu {frame id} {
    global menu
    global marker

    set mb ".mb$id"

    menu $mb.properties -tearoff 0 -selectcolor $menu(selectcolor)
    $mb.properties add checkbutton -label "Can Edit" \
	-variable marker($frame,$id,edit) \
	-command "MarkerBaseProperty $frame $id edit"
    $mb.properties add checkbutton -label "Can Move" \
	-variable marker($frame,$id,move) \
	-command "MarkerBaseProperty $frame $id move"
    $mb.properties add checkbutton -label "Can Rotate" \
	-variable marker($frame,$id,rotate) \
	-command "MarkerBaseProperty $frame $id rotate"
    $mb.properties add checkbutton -label "Can Delete" \
	-variable marker($frame,$id,delete) \
	-command "MarkerBaseProperty $frame $id delete"
    $mb.properties add checkbutton -label "Fixed in Size" \
	-variable marker($frame,$id,fixed) \
	-command "MarkerBaseProperty $frame $id fixed"
    $mb.properties add separator
    $mb.properties add radiobutton -label Include \
	-variable marker($frame,$id,include) -value 1 \
	-command "MarkerBaseProperty $frame $id include"
    $mb.properties add radiobutton -label Exclude \
	-variable marker($frame,$id,include) -value 0 \
	-command "MarkerBaseProperty $frame $id include"
    $mb.properties add separator
    $mb.properties add radiobutton -label Source \
	-variable marker($frame,$id,source) -value 1 \
	-command "MarkerBaseProperty $frame $id source"
    $mb.properties add radiobutton -label Background \
	-variable marker($frame,$id,source) -value 0 \
	-command "MarkerBaseProperty $frame $id source"
}

proc MarkerBaseFontMenu {frame id} {
    global menu
    global marker

    set mb ".mb$id"

    menu $mb.font -tearoff 0 -selectcolor $menu(selectcolor)
    $mb.font add radiobutton -label "Times" \
	-variable marker($frame,$id,font) -value times \
	-command "MarkerBaseFont $frame $id"
    $mb.font add radiobutton -label "Helvetica" \
	-variable marker($frame,$id,font) -value helvetica \
	-command "MarkerBaseFont $frame $id"
    $mb.font add radiobutton -label "Symbol" \
	-variable marker($frame,$id,font) -value symbol \
	-command "MarkerBaseFont $frame $id"
    $mb.font add radiobutton -label "Courier" \
	-variable marker($frame,$id,font) -value courier \
	-command "MarkerBaseFont $frame $id"
    $mb.font add separator
    $mb.font add radiobutton -label "9" \
	-variable marker($frame,$id,font,size) -value 9 \
	-command "MarkerBaseFont $frame $id"
    $mb.font add radiobutton -label "10" \
	-variable marker($frame,$id,font,size) -value 10 \
	-command "MarkerBaseFont $frame $id"
    $mb.font add radiobutton -label "12" \
	-variable marker($frame,$id,font,size) -value 12 \
	-command "MarkerBaseFont $frame $id"
    $mb.font add radiobutton -label "14" \
	-variable marker($frame,$id,font,size) -value 14 \
	-command "MarkerBaseFont $frame $id"
    $mb.font add radiobutton -label "18" \
	-variable marker($frame,$id,font,size) -value 18 \
	-command "MarkerBaseFont $frame $id"
    $mb.font add radiobutton -label "24" \
	-variable marker($frame,$id,font,size) -value 24 \
	-command "MarkerBaseFont $frame $id"
    $mb.font add radiobutton -label "30" \
	-variable marker($frame,$id,font,size) -value 30 \
	-command "MarkerBaseFont $frame $id"
    $mb.font add radiobutton -label "36" \
	-variable marker($frame,$id,font,size) -value 36 \
	-command "MarkerBaseFont $frame $id"
    $mb.font add separator
    $mb.font add radiobutton -label "Plain" \
	-variable marker($frame,$id,font,style) -value normal \
	-command "MarkerBaseFont $frame $id"
    $mb.font add radiobutton -label "Bold" \
	-variable marker($frame,$id,font,style) -value bold \
	-command "MarkerBaseFont $frame $id"
    $mb.font add radiobutton -label "Italic" \
	-variable marker($frame,$id,font,style) -value italic \
	-command "MarkerBaseFont $frame $id"
}

proc MarkerBaseCoordMenu {frame id} {
    global menu
    global marker
    global ds9

    set mb ".mb$id"
    set which $marker($frame,$id,which)
    set cb ${which}CoordCB

    menu $mb.coord -tearoff 0 -selectcolor $menu(selectcolor)
    $mb.coord add radiobutton -label "WCS" \
	-variable marker($frame,$id,system) -value wcs \
	-command "$cb $frame $id"
    $mb.coord add cascade -label "Multiple WCS" -menu $mb.coord.wcs
    $mb.coord add separator
    $mb.coord add radiobutton -label "Image" \
	-variable marker($frame,$id,system) -value image \
	-command "$cb $frame $id"
    $mb.coord add radiobutton -label "Physical" \
	-variable marker($frame,$id,system) -value physical \
	-command "$cb $frame $id"
    if {$ds9(amp,det)} {
	$mb.coord add radiobutton -label "Amplifier" \
	    -variable marker($frame,$id,system) -value amplifier \
	    -command "$cb $frame $id"
	$mb.coord add radiobutton -label "Detector" \
	    -variable marker($frame,$id,system) -value detector \
	    -command "$cb $frame $id"
    }
    $mb.coord add separator
    $mb.coord add radiobutton -label "Equatorial B1950" \
	-variable marker($frame,$id,sky) -value fk4 \
	-command "$cb $frame $id"
    $mb.coord add radiobutton -label "Equatorial J2000" \
	-variable marker($frame,$id,sky) -value fk5 \
	-command "$cb $frame $id"
    $mb.coord add radiobutton -label "ICRS" \
	-variable marker($frame,$id,sky) -value icrs \
	-command "$cb $frame $id"
    $mb.coord add radiobutton -label "Galactic" \
	-variable marker($frame,$id,sky) -value galactic \
	-command "$cb $frame $id"
    $mb.coord add radiobutton -label "Ecliptic" \
	-variable marker($frame,$id,sky) -value ecliptic \
	-command "$cb $frame $id"
    $mb.coord add separator
    $mb.coord add radiobutton -label "Degrees" \
	-variable marker($frame,$id,skyformat) -value degrees \
	-command "$cb $frame $id"
    $mb.coord add radiobutton -label "Sexagesimal" \
	-variable marker($frame,$id,skyformat) -value sexagesimal \
	-command "$cb $frame $id"

    menu $mb.coord.wcs -tearoff 0 -selectcolor $menu(selectcolor)
    foreach l {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	$mb.coord.wcs add radiobutton -label "WCS $l" \
	    -variable marker($frame,$id,system) -value "wcs$l" \
	    -command "$cb $frame $id"
    }

    UpdateCoordMenu $frame $mb.coord
}

proc MarkerBaseDistMenu {frame id name label cb coord format} {
    global menu
    global marker
    global ds9

    set mb ".mb$id"

    $mb add cascade -label $label -menu $mb.$name
    menu $mb.$name -tearoff 0 -selectcolor $menu(selectcolor)
    $mb.$name add radiobutton -label "WCS" \
	-variable marker($frame,$id,$coord) -value wcs \
	-command "$cb $frame $id"
    $mb.$name add cascade -label "Multiple WCS" -menu $mb.$name.wcs
    $mb.$name add separator
    $mb.$name add radiobutton -label "Image" \
	-variable marker($frame,$id,$coord) -value image \
	-command "$cb $frame $id"
    $mb.$name add radiobutton -label "Physical" \
	-variable marker($frame,$id,$coord) -value physical \
	-command "$cb $frame $id"
    if {$ds9(amp,det)} {
	$mb.$name add radiobutton -label "Amplifier" \
	    -variable marker($frame,$id,$coord) -value amplifier \
	    -command "$cb $frame $id"
	$mb.$name add radiobutton -label "Detector" \
	    -variable marker($frame,$id,$coord) -value detector \
	    -command "$cb $frame $id"
    }
    $mb.$name add separator

    $mb.$name add radiobutton -label "Degrees" \
	-variable marker($frame,$id,$format) -value degrees \
	-command "$cb $frame $id"
    $mb.$name add radiobutton -label "ArcMin" \
	-variable marker($frame,$id,$format) -value arcmin \
	-command "$cb $frame $id"
    $mb.$name add radiobutton -label "ArcSec" \
	-variable marker($frame,$id,$format) -value arcsec \
	-command "$cb $frame $id"

    menu $mb.$name.wcs -tearoff 0 -selectcolor $menu(selectcolor)
    foreach l {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	$mb.$name.wcs add radiobutton -label "WCS $l" \
	    -variable marker($frame,$id,$coord) -value "wcs$l" \
	    -command "$cb $frame $id"
    }

    UpdateDistMenu $frame $mb.$name 0 0
}


