#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc EllipseAnnulusDialog {frame id} {
    global marker

    set w ".marker$id"

    # see if we already have a header window visible
    if [winfo exist $w] {
	raise $w
	return
    }

    # base
    MarkerBaseAnnulusRectDialog $frame $id 275 150 radius Major Minor
}

# actions

proc EllipseAnnulusClose {frame id} {
    MarkerBaseAnnulusRectClose $frame $id
}

proc EllipseAnnulusApply {frame id} {
    MarkerBaseAnnulusRectApply $frame $id
}

proc EllipseAnnulusGenerate {frame id} {
    MarkerBaseAnnulusGenerateEllipse $frame $id
}

# callbacks

proc EllipseAnnulusCoordCB {frame id} {
    MarkerBaseAnnulusRectCoordCB $frame $id
}

proc EllipseAnnulusEditCB {frame id} {
    MarkerBaseAnnulusRectEditCB $frame $id
}

proc EllipseAnnulusDistCB {frame id} {
    MarkerBaseAnnulusRectDistCB $frame $id
}

proc EllipseAnnulusDefaultDialog {} {
    MarkerBaseAnnulusRectDefaultDialog ellipseannulus Radius Major Minor
}
