#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc EllipseDialog {frame id} {
    global marker

    set w ".marker$id"

    # see if we already have a header window visible
    if [winfo exist $w] {
	raise $w
	return
    }

    # base
    MarkerBaseRectDialog $frame $id 275 150 radius
}

# actions

proc EllipseClose {frame id} {
    MarkerBaseRectClose $frame $id
}

proc EllipseApply {frame id} {
    MarkerBaseRectApply $frame $id
}

# callbacks

proc EllipseCoordCB {frame id} {
    MarkerBaseRectCoordCB $frame $id
}

proc EllipseEditCB {frame id} {
    MarkerBaseRectEditCB $frame $id
}

proc EllipseDistCB {frame id} {
    MarkerBaseRectDistCB $frame $id
}

proc EllipseDefaultDialog {} {
    MarkerBaseRectDefaultDialog ellipse Radius
}
