// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __framergbtrue_h__
#define __framergbtrue_h__

#include "framergb.h"

class FrameRGBTrueColor : public FrameRGB {
 protected:
  int skipUpdate;

  XImage* colormapXM;      // rotate dest ximage
  Pixmap colormapPM;       // rotate pixmap
  GC colormapGCXOR;        // GC for interactive rotation
  long* colormapData[3];     // preextract data

  char bgTrueColor_[4];  // bg color encoded

 private:
  void fillRGBImageSingle(int, unsigned char*, char*, int, int, int, int,
			  double* (FitsImage::*)());
  void fillRGBImageMosaic(int, unsigned char*, char*, int, int, int, int, 
			  double* (FitsImage::*)());
  void fillRGBImageMosaicFast(int, unsigned char*, char*, int, int, int, int, 
			      double* (FitsImage::*)());

  void colormapBeginSingle(int,int,int);
  void colormapBeginMosaic(int,int,int);
  void colormapBeginMosaicFast(int,int,int);

  void psLevel1(PSColorSpace, int, int, float);
  void psLevel2(PSColorSpace, int, int, float);
  void psLevel2Head(PSColorSpace, int, int);

  void rotateMotion();

 protected:
  unsigned char* fillRGBImage(int, int, int, int, int, int, 
			      double* (FitsImage::*)());

  virtual void buildColormapXM(const unsigned char*) =0;
  virtual void encodeTrueColor(XColor*,char*) =0;

 public:
  FrameRGBTrueColor(Tcl_Interp*, Tk_Canvas, Tk_Item*);
  ~FrameRGBTrueColor();

  void colormapCmd(float, float, float, float, float, float, 
		   unsigned char*, int);

  void colormapBeginCmd();
  void colormapBeginCmd(const Vector&);
  void colormapMotionCmd(float, float, float, float, float, float,
			 unsigned char*, int);
  void colormapEndCmd(float, float, float, float, float, float,
		      unsigned char*, int);

  void bgColorCmd(const char*);
};

#endif
