 /* sane - Scanner Access Now Easy.
   Copyright (C) 2003 Johannes Hub (JohannesHub@foni.net)

   This file was initially copied from the hp3300 backend.
   This file is part of the SANE package.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   As a special exception, the authors of SANE give permission for
   additional uses of the libraries contained in this release of SANE.

   The exception is that, if you link a SANE library with other files
   to produce an exutable, this does not by itself cause the
   resulting executable to be covered by the GNU General Public
   License.  Your use of that executable is in no way restricted on
   account of linking the SANE library code into it.

   This exception does not, however, invalidate any other reasons why
   the executable file might be covered by the GNU General Public
   License.

   If you submit changes to SANE to the maintainers to be included in
   a subsequent release, you agree by submitting the changes that
   those changes may be distributed with this exception intact.

   If you write modifications of your own for SANE, it is your choice
   whether to permit this exception to apply to your modifications.
   If you do not wish that, delete this exception notice.
*/

/*
    Concept for a backend for scanners based on the RTS88xx chipset,
    such as HP3500C, 3530C, and HP ScanJet 3570C.
    Parts of this source were inspired by other backends.

    History:

    Version 0.17g 18.04.04 10.alpha, little fixes
    Version 0.17e 07.04.04 10.alpha, little fixes
    Version 0.17d 05.04.04 10.alpha, little fixes
    Version 0.17c 31.03.04 10.alpha, little fixes
    Version 0.17b 30.03.04 10.alpha, little fixes and libusb implemented
    Version 0.17a 22.03.04 10.alpha, little fixes
    Version 0.17  09.03.04 9. alpha, HP3500 included
*/

/*
    Core HP35x0c functions.
*/


#ifndef _HP_RTS_HP35x0C_H_
#define _HP_RTS_HP35x0C_H_

#include <unistd.h>

SANE_Byte	Hp35x0c_initial_regs[] =
{
	0xf5,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00,
	0xe1,0xfc,0xff,0xff,0x00,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x06,0x19,
	0xd0,0x7a,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xa0,0x37,0xff,0x0f,0x00,0x00,
	0x80,0x00,0x00,0x00,0x8c,0x76,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x20,0xbc,0x03,0x00,0x00,0x00,0x00,0x00,0x1d,0x1f,0x00,0x1f,0x00,0x00,0x00,0x00,
	0x5e,0xea,0x5f,0xea,0x00,0x80,0x64,0x00,0x00,0x00,0x00,0x00,0x84,0x04,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
	0x0f,0x02,0x4b,0x02,0x00,0xec,0x19,0xd8,0x2d,0x87,0x02,0xff,0x3f,0x78,0x60,0x00,
	0x1c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x0c,0x27,0x64,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x12,0x08,0x06,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x80,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xff,0xbf,0xff,0xff,0x00,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

SANE_Byte	Hp35x0c_rewind_regs[] =
{
	0xe5,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00,
	0x01,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xeb,0xed,0xe0,0x01,0x00,0x20,0x86,0x0b,
	0x02,0xa6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xa6,0xff,0x8f,0x00,0x00,
	0x20,0x00,0x00,0x00,0x8c,0x76,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x10,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x64,0x00,
	0x00,0x00,0x00,0x02,0x0e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x01,0x0f,0x18,0x31,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x80,0x00,0x10,0x0a,0x00,0x00,0x00,0x3a,0x0a,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x1f,0x4c,0x00,0x0c,0x1e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0xf8,0x2a,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xe0,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x30,0x00
};

struct Hp35x0c_tg_info__
{
	SANE_Word	tg_cph0p;
	SANE_Word	tg_crsp;
	SANE_Word	tg_cclpp;
	SANE_Word	tg_cdss1;
	SANE_Word	tg_cdsc1;
	SANE_Word	tg_cdss2;
	SANE_Word	tg_cdsc2;
} tg_info[] =
{
	/*	CPH0P		CRSP		CCLPP		CDSS1	CDSC1	CDSS2	CDSC2	*/
	{	0x01FFE0,	0x3c0000,	0x003000,	0xb,	0xd,	0x00,	0x01	},	/* NORMAL*/
	{	0x7ff800,	0xf00000,	0x01c000,	0xb,	0xc,	0x14,	0x15	}	/* DOUBLE*/
};

struct	Hp35x0c_resolution_parameters
{
	SANE_Int	resolution;
	SANE_Byte		reg_39_value;
	SANE_Byte		reg_c3_value;
	SANE_Byte		reg_c6_value;
	SANE_Byte		scan_frequency;
	SANE_Byte		cph0s;
	SANE_Byte		red_green_offset;
	SANE_Byte		green_blue_offset;
	SANE_Byte		intra_channel_offset;
	SANE_Byte		motor_movement_clock_multiplier;
	SANE_Byte		tg;
	SANE_Word		step_size;
};

static struct Hp35x0c_resolution_parameters Hp35x0c_resparms[] =
{
	/* My values - all work */
	/*res.,39, c3, c6, freq.chp,gre blu itr mm  tg  steps. */
	{	1200,	3,	6,	4,	2,	1,	22,	22,	4,	2,	0,	0x157b	},
	{	600,	3,	3,	1,	1,	0,	9,	10,	0,	2,	0,	0x157b	},
	{	400,	1,	1,	1,	1,	1,	6,	6,	1,	2,	0,	0x157b	},
	{	300,	3,	3,	3,	1,	0,	5,	4,	0,	2,	1,	0x157b	},
	{	200,	3,	1,	1,	1,	0,	3,	3,	0,	2,	1,	0x157b	},
	{	150,	3,	3,	3,	2,	0,	2,	2,	0,	2,	1,	0x157b	},
	{	100,	3,	1,	3,	1,	0,	1,	1,	0,	2,	1,	0x157b	},
	{	 75,	3,	3,	3,	4,	0,	1,	1,	0,	2,	1,	0x157b	},
	{	 50,	3,	1,	3,	2,	0,	0,	0,	0,	2,	1,	0x157b	},
	{	 25,	3,	1,	3,	4,	0,	0,	0,	0,	2,	1,	0x157b	},
	{	  0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0x157b	}
};

/*#define	RTS8801_GREYSCALE	0
#define	RTS8801_COLOUR		1
#define	RTS8801_BW		2*/

#define	REG_DESTINATION_POSITION 0x60

#define RTCMD_GETREG		0x80
#define	RTCMD_READSRAM		0x81

#define	RTCMD_SETREG		0x88
#define	RTCMD_WRITESRAM		0x89

#define	RTCMD_NVRAMCONTROL	0x8a

#define	RTCMD_BYTESAVAIL	0x90
#define	RTCMD_READBYTES		0x91

#define	RT_CHANNEL_ALL		0
#define	RT_CHANNEL_RED		1
#define	RT_CHANNEL_GREEN	2
#define	RT_CHANNEL_BLUE		3


static SANE_Int
Hp35x0c_set_value_msbfirst(	SANE_Byte	*regs,
			SANE_Int		firstreg,
			SANE_Int		totalregs,
			SANE_Word	value);

SANE_Int
Hp35x0c_queue_read_register( SANE_Int iHandle, SANE_Byte reg, SANE_Int bytes, SANE_Byte *data);

SANE_Int
Hp35x0c_read_register_immediate( SANE_Int iHandle, SANE_Int reg, SANE_Int bytes, SANE_Byte *data);

SANE_Int
Hp35x0c_set_register_immediate( SANE_Int iHandle, SANE_Int reg, SANE_Int bytes, SANE_Byte *data);

SANE_Int
Hp35x0c_send_command_immediate( SANE_Int iHandle, SANE_Int command,
				SANE_Byte	reg,
				SANE_Int	count,
				SANE_Int	bytes,
				SANE_Byte	*data,
				SANE_Int	readbytes,
				SANE_Byte	*readdata);

SANE_Int
Hp35x0c_write_sram( SANE_Int iHandle, SANE_Word	bytes, SANE_Byte	*data);

SANE_Int
Hp35x0c_read_sram( SANE_Int iHandle, SANE_Int	bytes, SANE_Byte *data);

SANE_Int
Hp35x0c_set_sram_page( SANE_Int iHandle, SANE_Byte	page);

SANE_Int
Hp35x0c_detect_sram( SANE_Int iHandle, SANE_Word *totalbytes, SANE_Byte *r93setting);

SANE_Int
Hp35x0c_is_rewound( SANE_Int iHandle );

SANE_Int
Hp35x0c_set_direction_forwards(SANE_Byte *regs);

SANE_Int
Hp35x0c_set_direction_rewind(SANE_Byte *regs);

SANE_Int
Hp35x0c_set_stop_when_rewound( SANE_Byte *regs, SANE_Int	stop);

SANE_Int
Hp35x0c_set_distances( SANE_Int iHandle,SANE_Int location1,
		   SANE_Int location2);

SANE_Int
Hp35x0c_set_powersave_mode(SANE_Int iHandle,SANE_Int enable);

SANE_Int
Hp35x0c_lamp_ready( SANE_Int iHandle );

SANE_Int
Hp35x0c_turn_off_lamp( SANE_Int iHandle );

SANE_Int
Hp35x0c_turn_on_lamp( SANE_Int iHandle );

SANE_Int
Hp35x0c_set_ccd_shift_clock_multiplier(	SANE_Byte	*regs,
					SANE_Word	value);

SANE_Int
Hp35x0c_set_ccd_sample_clock_multiplier(	SANE_Byte	*regs,
					SANE_Word	value);

SANE_Int
Hp35x0c_set_ccd_clock_reset_interval(	SANE_Byte	*regs,
					SANE_Word	value);

SANE_Int
Hp35x0c_set_ccd_clamp_clock_multiplier(	SANE_Byte	*regs,
					SANE_Word	value);

SANE_Int
Hp35x0c_set_movement_pattern(		SANE_Byte	*regs,
					SANE_Word	value);

SANE_Int
Hp35x0c_set_motor_movement_clock_multiplier(	SANE_Byte	*regs,
					SANE_Word	value);

SANE_Int
Hp35x0c_set_motor_type(			SANE_Byte	*regs,
					SANE_Word	value);

SANE_Int
Hp35x0c_set_basic_calibration(		SANE_Byte *regs,
					SANE_Int	redoffset1,
					SANE_Int	redoffset2,
					SANE_Int	redgain,
					SANE_Int	greenoffset1,
					SANE_Int	greenoffset2,
					SANE_Int	greengain,
					SANE_Int	blueoffset1,
					SANE_Int	blueoffset2,
					SANE_Int	bluegain);

SANE_Int
Hp35x0c_set_calibration_addresses(		SANE_Byte *regs,
					SANE_Word	redaddr,
					SANE_Word	blueaddr,
					SANE_Word	greenaddr);

SANE_Int
Hp35x0c_set_lamp_duty_cycle(			SANE_Byte *regs,
					SANE_Int	enable,
					SANE_Int	frequency,
					SANE_Int	offduty);

SANE_Int
Hp35x0c_set_data_feed_on(			SANE_Byte *regs);

SANE_Int
Hp35x0c_set_data_feed_off(			SANE_Byte *regs);

SANE_Int
Hp35x0c_enable_ccd(				SANE_Byte *regs,
					SANE_Int enable);

SANE_Int
Hp35x0c_set_cdss(				SANE_Byte *regs,
					SANE_Int	val1,
					SANE_Int	val2);

SANE_Int
Hp35x0c_set_cdsc(				SANE_Byte *regs,
					SANE_Int	val1,
					SANE_Int	val2);

SANE_Int
Hp35x0c_update_after_setting_cdss2(		SANE_Byte *regs);

SANE_Int
Hp35x0c_set_cph0s(				SANE_Byte *regs,
					SANE_Int	on);

SANE_Int
Hp35x0c_set_cvtr_lm(				SANE_Byte *regs,
					SANE_Int	val1,
					SANE_Int	val2,
					SANE_Int	val3);

SANE_Int
Hp35x0c_set_cvtr_mpt(			SANE_Byte *regs,
					SANE_Int	val1,
					SANE_Int	val2,
					SANE_Int	val3);

SANE_Int
Hp35x0c_set_cvtr_wparams(			SANE_Byte *regs,
					SANE_Word fpw,
					SANE_Word bpw,
					SANE_Word w);

SANE_Int
Hp35x0c_enable_movement(			SANE_Byte *regs,
					SANE_Int	enable);

SANE_Int
Hp35x0c_set_scan_frequency(			SANE_Byte *regs,
					SANE_Int	frequency);

SANE_Int
Hp35x0c_set_merge_channels(			SANE_Byte *regs,
					SANE_Int	on);

SANE_Int
Hp35x0c_set_channel(				SANE_Byte *regs,
					SANE_Int	channel);

SANE_Int
Hp35x0c_set_single_channel_scanning(		SANE_Byte *regs,
					SANE_Int	on);

SANE_Int
Hp35x0c_set_colour_mode(			SANE_Byte *regs,
					SANE_Int	on);

SANE_Int
Hp35x0c_set_horizontal_resolution(		SANE_Byte *regs,
					SANE_Int	resolution);

SANE_Int
Hp35x0c_set_last_sram_page(			SANE_Byte *regs,
					SANE_Int	pagenum);

SANE_Int
Hp35x0c_set_step_size(			SANE_Byte *regs,
					SANE_Int	stepsize);

SANE_Int
Hp35x0c_set_all_registers( SANE_Int iHandle, void const *regs_);

SANE_Int
Hp35x0c_adjust_misc_registers(SANE_Byte *regs);

static SANE_Int
Hp35x0c_nvram_enable_controller(SANE_Int iHandle,SANE_Int enable);

static SANE_Int
Hp35x0c_nvram_init_command(SANE_Int iHandle);

static SANE_Int
Hp35x0c_nvram_init_stdvars(SANE_Int iHandle,SANE_Int block,
			SANE_Int *addrbits,
			SANE_Byte *basereg);

static void
Hp35x0c_nvram_set_half_bit(	SANE_Byte *buffer,
			SANE_Int	value,
			SANE_Byte stdbits,
			SANE_Int	whichhalf);

static void
Hp35x0c_nvram_set_command_bit(SANE_Byte *buffer,
			 SANE_Int value,
			 SANE_Byte stdbits);

void
Hp35x0c_nvram_set_addressing_bits(	SANE_Byte *buffer,
				SANE_Int	location,
				SANE_Int	addressingbits,
				SANE_Byte stdbits);

SANE_Int
Hp35x0c_nvram_enable_write(SANE_Int iHandle,SANE_Int	addressingbits,
			SANE_Int	enable,
			SANE_Byte stdbits);

SANE_Int
Hp35x0c_nvram_write(SANE_Int iHandle,SANE_Int	block,
		SANE_Int	location,
		SANE_Char const *data,
		SANE_Int	bytes);

SANE_Int
Hp35x0c_nvram_read(SANE_Int iHandle,SANE_Int	block,
		SANE_Int	location,
		SANE_Byte	*data,
		SANE_Int	bytes);

SANE_Int  Hp35x0c_rewind(THWParams *pHWParams);

SANE_Bool Hp35x0c_init_scan(THWParams *pHWParams, TScanParams *pParams,
                    TDataPipe *pDataPipe);

SANE_Bool Hp35x0c_init_power_on(THWParams *pHWParams);

#endif /* NO _HP_RTS_HP35x0C_H_ */

