import Utils;

class samba_version(object):
    def __init__(self, version_dict, have_git=False):
        '''Determine the version number of samba

See VERSION for the format.  Entries on that file are 
also accepted as dictionary entries here
        '''

        self.MAJOR=None
        self.MINOR=None
        self.RELEASE=None
        self.REVISION=None
        self.TP_RELEASE=None
        self.ALPHA_RELEASE=None
        self.PRE_RELEASE=None
        self.RC_RELEASE=None
        self.IS_GIT_SNAPSHOT=True
        self.RELEASE_NICKNAME=None
        self.VENDOR_SUFFIX=None
        self.VENDOR_PATCH=None

        for a, b in version_dict.iteritems():
            if a.startswith("SAMBA_VERSION_"):
                setattr(self, a[14:], b)
            else:
                setattr(self, a, b)

        if self.IS_GIT_SNAPSHOT is "yes":
            self.IS_GIT_SNAPSHOT=True
        elif self.IS_GIT_SNAPSHOT is "no":
            self.IS_GIT_SNAPSHOT=False
                
 ##
 ## start with "3.0.22"
 ##
        self.MAJOR=int(self.MAJOR)
        self.MINOR=int(self.MINOR)
        self.RELEASE=int(self.RELEASE)

        SAMBA_VERSION_STRING = ("%u.%u.%u" % (self.MAJOR, self.MINOR, self.RELEASE))

##
## maybe add "3.0.22a" or "4.0.0tp11" or "4.0.0alpha1" or "3.0.22pre1" or "3.0.22rc1"
## We do not do pre or rc version on patch/letter releases
##
        if self.REVISION is not None:
            SAMBA_VERSION_STRING += self.REVISION
        if self.TP_RELEASE is not None:
            self.TP_RELEASE = int(self.TP_RELEASE)
            SAMBA_VERSION_STRING += ("tp%u" % self.TP_RELEASE)
        if self.ALPHA_RELEASE is not None:
            self.ALPHA_RELEASE = int(self.ALPHA_RELEASE)
            SAMBA_VERSION_STRING += ("alpha%u" % self.ALPHA_RELEASE)
        if self.PRE_RELEASE is not None:
            self.PRE_RELEASE = int(self.PRE_RELEASE)
            SAMBA_VERSION_STRING += ("pre%u" % self.PRE_RELEASE)
        if self.RC_RELEASE is not None:
            self.RC_RELEASE = int(self.RC_RELEASE)
            SAMBA_VERSION_STRING += ("rc%u" % self.RC_RELEASE)

        if self.IS_GIT_SNAPSHOT:
            #Get version from GIT
            if have_git:
                git = Utils.cmd_output('git show --pretty=format:"%h%n%ct%n%H%n%cd" --stat HEAD', silent=True)
            else:
                git = ''

            if git == '':
                SAMBA_VERSION_STRING += "-GIT-UNKNOWN"
            else:
                lines = git.splitlines();
                self.GIT_COMMIT_ABBREV = lines[0]
                self.GIT_COMMIT_TIME = lines[1]
                self.GIT_COMMIT_FULLREV = lines[2]
                self.GIT_COMMIT_DATE = lines[3]

                SAMBA_VERSION_STRING += ("-GIT-" + self.GIT_COMMIT_ABBREV)

        self.OFFICIAL_STRING=SAMBA_VERSION_STRING

        if self.VENDOR_SUFFIX is not None:
            SAMBA_VERSION_STRING += ("-" + self.VENDOR_SUFFIX)
            self.VENDOR_SUFFIX = self.VENDOR_SUFFIX

            if self.VENDOR_PATCH is not None:
                SAMBA_VERSION_STRING += ("-" + self.VENDOR_PATCH)
                self.VENDOR_PATCH = self.VENDOR_PATCH

        self.STRING = SAMBA_VERSION_STRING

        if self.RELEASE_NICKNAME is not None:
            self.STRING_WITH_NICKNAME += (" (" + self.RELEASE_NICKNAME + ")")
            self.RELEASE_NICKNAME = self.RELEASE_NICKNAME
        else:
            self.STRING_WITH_NICKNAME = self.STRING
    
    def __str__(self):
        string="/* Autogenerated by waf */\n"
        string+="#define SAMBA_VERSION_MAJOR %u\n" % self.MAJOR
        string+="#define SAMBA_VERSION_MINOR %u\n" % self.MINOR
        string+="#define SAMBA_VERSION_RELEASE %u\n" % self.RELEASE
        if self.REVISION is not None:
            string+="#define SAMBA_VERSION_REVISION %u\n" % self.REVISION

        if self.TP_RELEASE is not None:
            string+="#define SAMBA_VERSION_TP_RELEASE %u\n" % self.TP_RELEASE

        if self.ALPHA_RELEASE is not None:
            string+="#define SAMBA_VERSION_ALPHA_RELEASE %u\n" % self.ALPHA_RELEASE

        if self.PRE_RELEASE is not None:
            string+="#define SAMBA_VERSION_PRE_RELEASE %u\n" % self.PRE_RELEASE

        if self.RC_RELEASE is not None:
            string+="#define SAMBA_VERSION_RC_RELEASE %u\n" % self.RC_RELEASE

        try:
            string+="#define SAMBA_VERSION_GIT_COMMIT_ABBREV " + self.GIT_COMMIT_ABBREV + "\n"
            string+="#define SAMBA_VERSION_GIT_COMMIT_TIME " + self.GIT_COMMIT_TIME + "\n"
            string+="#define SAMBA_VERSION_GIT_COMMIT_FULLREV " + self.GIT_COMMIT_TIME + "\n"
            string+="#define SAMBA_VERSION_GIT_COMMIT_DATE " + self.GIT_COMMIT_DATA + "\n"
        except AttributeError:
            pass

        string+="#define SAMBA_VERSION_OFFICIAL_STRING \"" + self.OFFICIAL_STRING + "\"\n"

        if self.VENDOR_SUFFIX is not None:
            string+="#define SAMBA_VERSION_VENDOR_SUFFIX " + self.VENDOR_SUFFIX + "\n"
            if self.VENDOR_PATCH is not None:
                string+="#define SAMBA_VERSION_VENDOR_PATCH " + self.VENDOR_PATCH + "\n"

        if self.RELEASE_NICKNAME is not None:
            string+="#define SAMBA_VERSION_RELEASE_NICKNAME " + self.RELEASE_NICKNAME + "\n"

        # We need to put this #ifdef in to the headers so that vendors can override the version with a function
        string+='''
#ifdef SAMBA_VERSION_VENDOR_FUNCTION
#  define SAMBA_VERSION_STRING SAMBA_VERSION_VENDOR_FUNCTION
#else /* SAMBA_VERSION_VENDOR_FUNCTION */
#  define SAMBA_VERSION_STRING "''' + self.STRING_WITH_NICKNAME + '''"
#endif
'''
        string+="/* Version for mkrelease.sh: \nSAMBA_VERSION_STRING=" + self.STRING_WITH_NICKNAME + "\n */\n"

        return string


class samba_version_file(samba_version):
    def __init__(self, version_file, have_git=False):
        '''Parse the version information from a VERSION file'''
        f = open(version_file, 'r')
        version_dict = {}
        for line in f:
            try:
                line = line.strip()
                if line == '':
                    continue
                if line.startswith("#"):
                    continue
                split_line=line.split("=")
                if split_line[1] != "":
                    value = split_line[1].strip('"')
                    version_dict[split_line[0]] = value
            except:
                print "Failed to parse line %s from %s" % (line, version_file)
                raise
            
        super(samba_version_file, self).__init__(version_dict, have_git=have_git)
