#!/bin/bash

if [ -z "$SAMBA_GIT_URL" ]; then
	SAMBA_GIT_URL=git://git.samba.org/samba.git
fi

version=$( dpkg-parsechangelog -l`dirname $0`/changelog | sed -n 's/^Version: \(.*:\|\)//p' | sed 's/-[0-9.]\+ubuntu[0-9]\+$//' )
if [ -d "$SAMBA_GIT_URL/.bzr" ]; then
	bzr export samba4-upstream-$version "$SAMBA_GIT_URL"
else
	git clone "$SAMBA_GIT_URL" samba4-upstream-$version
fi

pushd "samba4-upstream-$version/source4"
./autogen-waf.sh 
./configure 
../buildtools/bin/waf dist 
tar xfz samba-4.*.tar.gz
rm samba-4*.tar.gz
mv samba-4* "samba4-$version"
../../`dirname $0`/dfsg-clean.sh "samba4-$version"
tar cz "samba4-$version" > ../../samba4_$version.orig.tar.gz
popd
rm -rf "samba4-upstream-$version"
