# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

__xdata__items__ = [
    "TestXInt",
    "",
    "TestXIntWithNoneDefaultValue",
    "",
    "TestXIntInto",
    "TestXIntIntoWithIntDefaultValue",
    "",
    "TestXMulTypesXIntIntoXNone",
    "",
    "TestXListXInt",
    "TestXListXIntWithNoneDefaultValue",
    "",
    "TestXListWithLenMultiple",
    "",
    "TestXListWithXStringXFloat",
    "TestXListWithXTuple",
    ]

from xdata import *

class TestXInt(XObject):
    __init__xattributes__ = [
        XAttribute("xint", xtype=XInt()),
        ]
    pass

class TestXIntWithNoneDefaultValue(XObject):
    __init__xattributes__ = [
        XAttribute("i", xtype=XInt(), default_value=None),
        ]
    pass

class TestXIntInto(XObject):
    __init__xattributes__ = [
        XAttribute("xint_into", xtype=XInt(into=[1, 2, 3])),
        ]
    pass

class TestXIntIntoWithIntDefaultValue(XObject):
    __init__xattributes__ = [
        XAttribute("xint_into", xtype=XInt(into=[1, 2, 3]), default_value=1),
        ]
    pass

class TestXMulTypesXIntIntoXNone(XObject):
    __init__xattributes__ = [
        XAttribute("a", xtype=XMulTypes(XNone(), XInt(into=[1, 2, 3]))),
        XAttribute("b", xtype=XInt(into=[1, 2, 3]), default_value=None),
        XAttribute("c", xtype=XMulTypes(XNone(), XInt(into=[1, 2, 3])), default_value=1),
        ]
    pass

class TestXListXInt(XObject):
    __init__xattributes__ = [
        XAttribute("xlist_xint", xtype=XList(sequence=XInt())),
        XAttribute("xlist_xint_no_unpack", xtype=XList(sequence=XInt(), unpack_in_browser=0)),
        ]
    pass

class TestXListXIntWithNoneDefaultValue(XObject):
    __init__xattributes__ = [
        XAttribute("xlist_xint", xtype=XList(sequence=XInt()), default_value=None),
        XAttribute("xlist_xint_no_unpack", xtype=XList(sequence=XInt(), unpack_in_browser=0), default_value=None),
        ]
    pass

class TestXListWithLenMultiple(XObject):
    __init__xattributes__ = [
        XAttribute("l", xtype=XList(sequence=(XInt(), XFloat(), XString()), len_multiple=1)),
        ]
    pass

class TestXListWithXStringXFloat(XObject):
    __init__xattributes__ = [
        XAttribute("l", xtype=XList(sequence=(XString(), XFloat(), ))),
        ]
    pass

class TestXListWithXTuple(XObject):
    __init__xattributes__ = [
        XAttribute("l", xtype=XList(sequence=XTuple(sequence=(XString(), XFloat(), )), )),
        XAttribute('b', xtype=XTuple(sequence=XMulTypes(XFloat(),XList(len=2,sequence=XFloat()))),default_value=None)
    ]
    pass
