# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

class TestCase(unittest.TestCase):
    def test(self):
        #
        from xsalome import XSalomeSession
        salome = XSalomeSession(modules=["MED","MEDFIELDCREATOR"],
                                logger=1,
                                study=1,
                                )
        #
        # Sorry, but I don't know how to use the MED component
        # in batch mode without opening a study !!!
        #
        study_name = "test"
        study = salome.study_manager.NewStudy(study_name)
        #
        med_gen = salome.lcc.FindOrLoadComponent("FactoryServer", "MED")
        self.failUnless(med_gen)
        from SALOME_MED import MED_Gen
        med_gen = med_gen._narrow(MED_Gen)
        self.failUnless(med_gen)
        #
        from os import getenv
        medfile  = getenv("MED_ROOT_DIR")
        medfile += "/share/salome/resources/med/pointe.med"
        #
        print medfile
        med = med_gen.readStructFile(medfile, study_name)
        mesh_names = med.getMeshNames()
        self.failUnlessEqual(mesh_names, ['maa1'])
        mesh = med.getMeshByName(mesh_names[0])
        #
        import medfieldcreator
        mfc = medfieldcreator.MedFieldCreator(mesh)
        mfc.run()
        field = mfc.getField()
        print field
        support = field.getSupport()
        print support
        mesh = support.getMesh()
        print mesh
        #
        xattr = medfieldcreator.MedFieldCreator.__init__xattributes__[0]
        xtype = xattr.xtype
        xtype(mesh)
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
