# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

from xdata import *

quantity_xattribute = XAttribute('quantity', xtype = XString())

class FloatAndQuantity(XObject):
    __init__xattributes__ = [
        XAttribute('value', xtype = XFloat()),
        quantity_xattribute,
        ]
    pass

xinstance_FloatAndQuantity = XInstance(FloatAndQuantity)

class XPhysicalValue(XFloat):
    
    __init__argslen__ = 1
    
    __init__xattributes__ = [
        quantity_xattribute,
        ] + XFloat.__init__xattributes__
    
    def getIdlType(self):
        return xinstance_FloatAndQuantity.getIdlType()

    def __call__(self, value):
        if not isinstance(value, FloatAndQuantity):
            value = XFloat.__call__(self, value)
            value = FloatAndQuantity(value, self.quantity)
            pass
        return value
    
    pass

length = XPhysicalValue("length")

class Point(XObject):
    __init__xattributes__ = [
        XAttribute('x', xtype = length),
        XAttribute('y', xtype = length),
        XAttribute('z', xtype = length, default_value = length(0)),
        ]
    pass

class Vector(XObject):
    __init__xattributes__ = [
        XAttribute("coords", xtype = XList(sequence = length)),
        ]
    pass

