# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xsalome import getXSalomeSession
salome = getXSalomeSession(modules=["STUDYTEST"])

compo = salome.lcc.FindOrLoadComponent("FactoryServerPy", "STUDYTEST")
from STUDYTEST_CORBA import STUDYTEST_Component
compo = compo._narrow(STUDYTEST_Component)

from batchmode_salome import myStudy
from batchmode_salome import myStudyManager

class TestCase(unittest.TestCase):
    
    def setUp(self):
        myBuilder = myStudy.NewBuilder()
        scompo = myStudy.FindComponent("STUDYTEST")
        if scompo:
            itr = myStudy.NewChildIterator(scompo)
            itr.InitEx(1)
            while itr.More():
                sobj = itr.Value()
                myBuilder.RemoveObjectWithChildren(sobj)
                itr.Next()
                pass
            pass
        return
    
    def testEmpty(self):
        obj = compo.newEmpty_no_superv()
        compo.PublishInStudy(myStudy, None, obj, "objbis")
        myStudyManager.SaveAs('./test.hdf', myStudy, 0)
        compo.PublishInStudy(myStudy, None, obj, "objbis")
        self.failUnlessEqual(myStudy.IsModified(), 0)
        return
    
    def testA(self):
        obj = compo.newA_no_superv(1, 2.3, "rrr")
        compo.PublishInStudy(myStudy, None, obj, "objbis")
        myStudyManager.SaveAs('./test.hdf', myStudy, 0)
        compo.PublishInStudy(myStudy, None, obj, "objbis")
        self.failUnlessEqual(myStudy.IsModified(), 0)
        return
    
    def tearDown(self):
        from os import system
        system('rm test.hdf > /dev/null 2>&1')
        return
    
    pass

if __name__ == '__main__':
    unittest.main()
    pass
