# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

#
# Non regression test :
# x = XAttribute("aa", xtype=XInstance(classes=['toto.titi']), default_value=None)
# should not raise at creation but at xtype interrogaction
#

import unittest

from xdata import *

class TestCase(unittest.TestCase):
    def test(self):
        x = XAttribute("aa", xtype=XInstance(classes=['R1R1R1.titi']), default_value=None)
        self.failUnlessEqual(x.xtype(None), None)
        self.failUnlessEqual(x.xtype("None"), None)
        self.failUnlessRaises(ImportError, x.xtype, 1.2)
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
