//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
//
//  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
//  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
//  VISU VISUGUI : GUI of VISU component
//  File   : VVTK_SizeBox.h
//  Author : Oleg UVAROV
//  Module : VISU
//
#ifndef VVTK_SIZEBOX_H
#define VVTK_SIZEBOX_H

#include "VVTK.h"

#include <QWidget>

class QLabel;
class QLineEdit;
class QPushButton;
class QCheckBox;
class QGroupBox;

class QtxDoubleSpinBox;
class QtxIntSpinBox;
class QtxColorButton;

class VVTK_EXPORT VVTK_SizeBox : public QWidget
{
  Q_OBJECT

public:
  enum { Results = 0, Geometry, Inside, Outside };

public:
  VVTK_SizeBox( QWidget* );
  ~VVTK_SizeBox() {}

public:
  int                      getType() const { return myType; }
  void                     setType( int );

  float                    getOutsideSize() const;
  void                     setOutsideSize( float );

  float                    getGeomSize() const;
  void                     setGeomSize( float );

  float                    getMinSize() const;
  void                     setMinSize( float );

  float                    getMaxSize() const;
  void                     setMaxSize( float );

  float                    getMagnification() const;
  void                     setMagnification( float );

  float                    getIncrement() const;
  void                     setIncrement( float );

  bool                     getUniform() const;
  void                     setUniform( bool );

  QColor                   getColor() const;
  void                     setColor( const QColor& );

  void                     enableSizeControls( bool enabled );

protected slots:
  void                     onToggleResults();
  void                     onToggleGeometry();
  void                     onToggleInside();
  void                     onToggleOutside();

  //void                     onColorButtonPressed();

private:
  int                      myType;

  QLabel*                  myOutsideSizeLabel;
  QtxIntSpinBox*           myOutsideSizeSpinBox;

  QLabel*                  myGeomSizeLabel;
  QtxIntSpinBox*           myGeomSizeSpinBox;

  QLabel*                  myMinSizeLabel;
  QtxIntSpinBox*           myMinSizeSpinBox;

  QLabel*                  myMaxSizeLabel;
  QtxIntSpinBox*           myMaxSizeSpinBox;

  QLabel*                  myMagnificationLabel;
  QtxIntSpinBox*           myMagnificationSpinBox;

  QLabel*                  myIncrementLabel;
  QtxDoubleSpinBox*        myIncrementSpinBox;

  QCheckBox*               myUniformCheckBox;  

  QGroupBox*               myColorGroup;
  QLabel*                  myColorLabel;
  QtxColorButton*          myColorButton;
};



#endif
