//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
//
//  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
//  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
#ifndef VVTK_MAINWINDOW_H
#define VVTK_MAINWINDOW_H

#ifdef WIN32
#pragma warning( disable:4251 )
#endif

#include "VVTK.h"
#include "SVTK_MainWindow.h"

class QSplitter;

class VISU_WidgetCtrl;
class VVTK_SegmentationCursorDlg;
class VISU_InsideCursorSettings;
class VISU_OutsideCursorSettings;
class VISU_PickingSettings;
class VVTK_InteractorStyle;
class VVTK_ControllerIncrement;
class VVTK_ControllerOnKeyDown;
class VVTK_PickingDlg;
class VVTK_MainWindow2;
class VVTK_Renderer1;
class VVTK_Renderer2;
class VVTK_Recorder;

//----------------------------------------------------------------------------
//! Customize SVTK_MainWindow to provide VVTK functionality
class VVTK_EXPORT VVTK_MainWindow: public SVTK_MainWindow
{
  Q_OBJECT;

public:
  //! Construct instance of the class
  VVTK_MainWindow(QWidget* theParent, 
		  const char* theName,
		  SUIT_ResourceMgr* theResourceMgr,
		  SUIT_ViewWindow* theViewWindow);

  //! Reimplement SVTK_MainWindow::Initialize
  virtual void Initialize(SVTK_RenderWindowInteractor* theInteractor);

  //! Destroy instance of the class
  virtual ~VVTK_MainWindow();

 public slots:

  virtual void onDumpView();

  virtual void action( const int );

  virtual void OnStartRecording();

  virtual void OnPlayRecording();

  virtual void OnPauseRecording();

  virtual void OnStopRecording();

 protected:
  virtual QtxActionToolMgr* toolMgr() const;

  vtkSmartPointer<VVTK_ControllerIncrement> myControllerIncrement;
  vtkSmartPointer<VVTK_ControllerOnKeyDown> myControllerOnKeyDown; 

  QToolBar* myRecordingToolBar;
  QtxAction* myStartAction;
  QtxAction* myPlayAction;
  QtxAction* myPauseAction;
  QtxAction* myStopAction;

  VVTK_Recorder *myRecorder;
  QtxActionToolMgr* myToolMgr;
};


//----------------------------------------------------------------------------
//! Extend VVTK_MainWindow to implement functionality for base view
class VVTK_EXPORT VVTK_MainWindow1: public VVTK_MainWindow
{
  Q_OBJECT;

public:
  //! Construct instance of the class
  VVTK_MainWindow1(QSplitter* theParent, 
		   const char* theName,
		   SUIT_ResourceMgr* theResourceMgr,
		   SUIT_ViewWindow* theViewWindow);

  //! Reimplement VVTK_MainWindow::Initialize
  virtual void Initialize(SVTK_RenderWindowInteractor* theInteractor,
			  VVTK_Renderer1* theRenderer);

  //! Destroy instance of the class
  virtual ~VVTK_MainWindow1();

  //! Create instance of the segmented VVTK_MainWindow
  /*!
    The two views (VVTK_MainWindow1 and VVTK_MainWindow2) should change its behaviour in the same time.
    So, it is necessary to synhronize them through sharing some common pointers.
  */
  VVTK_MainWindow2* CreateMainWindow2(QWidget* theParent, 
				      const char* theName,
				      SUIT_ResourceMgr* theResourceMgr,
				      SUIT_ViewWindow* theViewWindow);

  VISU_WidgetCtrl*  GetWidgetCtrl();

  void SetPlanesSegementation(bool theIsOn);

  void SetSphereSegementation(bool theIsOn);

  VISU_InsideCursorSettings* GetInsideCursorSettings();

  //! Get contained VISU_OutsideCursorSettings
  VISU_OutsideCursorSettings* GetOutsideCursorSettings();

  //! Get contained VISU_PickingSettings
  VISU_PickingSettings* GetPickingSettings();

 public slots:
  //! To activate/ deactivate the segementation cursor at run-time
  void OnSegmentationSwitch();//bool theIsSegmentationOn); 

  void OnSegmentationSwitch(QtxAction* theAction);//bool theIsSegmentationOn); 

   //! To change active selection mode at run-time
  virtual void OnSelectionModeSwitch(bool theIsSelectionOn); 

   //! To adjust to the current selection mode
  virtual void OnSelectionChanged(); 

 protected:
  VVTK_Renderer1* myRenderer; //!< Keeps extended version of SVTK_Renderer

  VVTK_MainWindow2* myMainWindow2; //!< Refer to segmented view

  QToolBar* myPtsToolBar; //!< Additional tool bar

  //! To implement show/hide segmented view on acttivate/ deactivate segementation cursor
  QSplitter* mySplitter; 

  QtxAction* myPickingAction; //!< Action for switch selection mode
  QtxAction* myPlaneSegmentationAction; //!< Action for switch segmentation mode to plane
  QtxAction* mySphereSegmentationAction; //!< Action for switch segmentation mode to sphere

  //! Keep reference to VVTK_SegmentationCursorDlg
  VVTK_SegmentationCursorDlg* mySegmentationCursorDlg; 
  VVTK_PickingDlg* myPickingDlg; //!< Keep reference to VVTK_PickingDlg
};


//----------------------------------------------------------------------------
//! Extend VVTK_MainWindow to implement functionality for segmented view
class VVTK_EXPORT VVTK_MainWindow2: public VVTK_MainWindow
{
  Q_OBJECT;

  friend class VVTK_MainWindow1;

  //! Construct instance of the class
  VVTK_MainWindow2(QWidget* theParent, 
		   const char* theName,
		   SUIT_ResourceMgr* theResourceMgr,
		   SUIT_ViewWindow* theViewWindow);
public:
  //! Destroy instance of the class
  virtual ~VVTK_MainWindow2();

  //! Reimplement SVTK_MainWindow::Initialize
  virtual void Initialize(SVTK_RenderWindowInteractor* theInteractor);

};


#ifdef WIN32
#pragma warning( default:4251 )
#endif

#endif
