//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
//
//  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
//  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
//  SALOME VTKViewer : build VTK viewer into Salome desktop
//  File   :
//  Author :
//  Module :
//  $Header$
//
#include "VVTK_ImageWriterMgr.h"
#include "VVTK_ImageWriter.h"

#include <vtkImageData.h>

#include <QSemaphore>

#include "utilities.h"

#include <limits>

#ifdef _DEBUG_
static int MYDEBUG = 0;
#else
static int MYDEBUG = 0;
#endif

//----------------------------------------------------------------------------
VVTK_ImageWriterMgr
::VVTK_ImageWriterMgr()
{
  int aMax = std::numeric_limits<int>::max() / 2;
  mySemaphore = new QSemaphore(aMax);
  mySemaphore->acquire( aMax );
  if(MYDEBUG) MESSAGE("VVTK_ImageWriterMgr::VVTK_ImageWriterMgr "<<
		//"- total = "<<mySemaphore->total()<<
		"; available = "<<mySemaphore->available() );
}


//----------------------------------------------------------------------------
VVTK_ImageWriterMgr
::~VVTK_ImageWriterMgr()
{
  Stop();
  delete mySemaphore;
}


//----------------------------------------------------------------------------
void
VVTK_ImageWriterMgr
::StartImageWriter(vtkImageData *theImageData,
		   const std::string& theName,
		   const int theProgressive,
		   const int theQuality)
{
  VVTK_ImageWriter *anImageWriter = 
    new VVTK_ImageWriter(mySemaphore,
			 theImageData,
			 theName,
			 theProgressive,
			 theQuality);
  myThreads.push_back(anImageWriter);

  anImageWriter->start();

}


//----------------------------------------------------------------------------
void
VVTK_ImageWriterMgr
::Stop()
{
  if(MYDEBUG) MESSAGE("VVTK_ImageWriterMgr::Stop "<<
		//"- total = "<<mySemaphore->total()<<
		"; available = "<<mySemaphore->available() );
  if(MYDEBUG) MESSAGE("VVTK_ImageWriterMgr::Stop - *mySemaphore += "<<myThreads.size() );
  mySemaphore->acquire( myThreads.size() );

  for(size_t anId = 0, anEnd = myThreads.size(); anId < anEnd; anId++){
    VVTK_ImageWriter* anImageWriter = myThreads[anId];
    anImageWriter->wait();
    delete anImageWriter;
  }
  myThreads.clear();
}
