//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
#ifndef __INTERPOLATION2D_HXX__
#define __INTERPOLATION2D_HXX__

#include "InterpolationPlanar.hxx"

namespace INTERP_KERNEL
{
  class Interpolation2D : public InterpolationPlanar<Interpolation2D>
  {
  public:
    Interpolation2D() { }
    Interpolation2D(const InterpolationOptions& io):InterpolationPlanar<Interpolation2D>(io) { }
  public:
    bool doRotate() const { return false; }
    double medianPlane() const { return 0.; }
    template<class MyMeshType, class MyMatrixRow>
    void performAdjustmentOfBB(PlanarIntersector<MyMeshType,MyMatrixRow>* intersector, std::vector<double>& bbox) const { }
  };
}

#endif
