/*
 * Copyright (C) 1993-2006 Robert & Jeremy Lain
 * See AUTHORS file for a full list of contributors.
 * 
 * $Id: sailwriter-hand.h,v 1.3 2006/01/25 21:54:02 jeremy_laine Exp $
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef SAILWRITER_HAND_H
#define SAILWRITER_HAND_H

#include "sail.h"
#include "sailwriter-txt.h"

/** This class allows you to write a developed sail by using
 *  the deviation of the edge from the straight line instead
 *  of using absolute coordinates to a TXT file.
 *
 *  @see CSailWriterHand
 */
class CSailWriterHand : public TxtWriterTempl<CSail>
{
public:
    CSailWriterHand(const CSail &sail);
    virtual void write(const QString &filename);
};


#endif
