/*
 * Copyright (C) 1993-2006 Robert & Jeremy Laine
 * See AUTHORS file for a full list of contributors.
 * 
 * $Id: rigdef.cpp,v 1.6 2006/01/25 21:54:00 jeremy_laine Exp $
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "rigdef.h"

/** The constructor.
 */
CRigDef::CRigDef()
{}


/** Produce the combined sail made up of all the panels
 */
CSail CRigDef::makeViewSail() const
{
    CSail output;

    for (unsigned int i = 0; i < rigsail.size(); i++)
        for (unsigned int j = 0; j < rigsail[i].nbpanels(); j++)
            output.panel.push_back(rigsail[i].panel[j] + rigsail[i].origin);

    return output;
}
