/*
 * Copyright (C) 1993-2004 Robert & Jeremy Lain
 * See AUTHORS file for a full list of contributors.
 * 
 * $Id: sailwriter-txt.h,v 1.3 2004/10/26 19:30:51 jeremy_laine Exp $
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef TXTWRITER_H
#define TXTWRITER_H

#include "filewriter.h"

/** This class allows you to write sailcut objects to
 *  a TXT file.
 *
 *  @see CSailTxtWriter
 */
template <class objtype>
class TxtWriterTempl : public CFileWriter
{
protected :
    /** the object to write */
    objtype _obj;

public:
    /** The constructor.
     *
     * @param obj the object to write
     * @param name the object's name
     */
    TxtWriterTempl(const objtype &obj, const QString &name)
            : CFileWriter(name,".txt","text files"), _obj(obj)
    {}
    ;

    /** The destructor.
     */
    virtual ~TxtWriterTempl()
    {}
    ;

    /** Write object to TXT format.
     *
     * @param filename the file to write to
     */
    virtual void write(const QString &filename)
    {
        cout << "TxtWriterTempl::write(" << filename << ")" << endl;
        ofstream myOut;
        myOut.open(filename,ios::out);
        if (!myOut.is_open())
            throw CException("TxtWriterTempl::write : unable to write to specified file");
        myOut << _name << endl;
        myOut << _obj;
        myOut.close();
    }
    ;
};


/** A class used to output a CSail to a TXT file. */
typedef TxtWriterTempl<CSail> CSailTxtWriter;

#endif
