/*
 * Copyright (C) 1993-2004 Robert & Jeremy Lain
 * See AUTHORS file for a full list of contributors.
 * 
 * $Id: saildisplabel.cpp,v 1.4 2004/10/26 19:30:50 jeremy_laine Exp $
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "saildisplabel.h"
#include "sailpainter.h"

/** Constructs a QLabel based view area.
 */
CSailDispLabel::CSailDispLabel( QWidget * parent )
        : QLabel( parent )
{
    // set the background to white
    QPalette pal;
    QColorGroup cg;
    cg.setColor( QColorGroup::Background, white );
    pal.setActive( cg );
    pal.setInactive( cg );
    setPalette( pal );
}


/** Clears the drawing area.
 */
void CSailDispLabel::clear()
{
    QPainter painter(this);
    QRect rect = painter.viewport();
    painter.eraseRect(rect);
}



/** Draws the panel labels on the display
 *  and adjusts the font size according to zoom .
 */
void CSailDispLabel::drawLabels()
{
    CSailPainter painter( this );
    QFont font;

    // set coordinate system to match the logical viewport
    painter.setWindow(lRect);

    // set the font size for labeling function of zoom
    font.setPixelSize(int(10 + sailDisp.panel[1].height() / (10*zoom)));
    //font.setPixelSize(100 + int( real(100) / zoom));

    painter.setPen(Qt::blue);
    painter.setFont(font);

    for ( unsigned int i = 0; i < sailDisp.nbpanels(); i++ )
        painter.draw(sailDisp.panel[i].label);
}


/** Forces a redraw of the view area.
 */
void CSailDispLabel::redraw()
{
    clear();
    paintEvent(NULL);
}


/** We received a mouse click.
 */
void CSailDispLabel::mousePressEvent ( QMouseEvent *event )
{
    if (event->button() == LeftButton)
    {
        setCenter(screenToLogical(event->pos().x(),event->pos().y()));
        redraw();
    }
}


/** We received a request to paint the drawing area.
 */
void CSailDispLabel::paintEvent( QPaintEvent * )
{
    CSailPainter painter( this );

    // set coordinate system to match the logical viewport
    painter.setWindow(lRect);

    // draw the sail
    painter.draw(sailDisp);
}


/** The draw area has been resized.
 */
void CSailDispLabel::resizeEvent( QResizeEvent * )
{
    QPainter painter(this);
    QRect vRect = painter.viewport();
    setVRect(vRect.width(), vRect.height());
    redraw();
}


/** We received a mouse wheel movement.
 */
void CSailDispLabel::wheelEvent( QWheelEvent *event)
{
    if (event->delta()>0)
        zoomIn();
    else
        zoomOut();
    redraw();
}
