/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : etc.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2003/02/05
 * ====================================================================
 */
#ifndef __ETC_H__
#define __ETC_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 :   (struct #define etc)
 * -------------------------------------------------------
 */
	struct ColorDat {
		long rgb;
		int red;
		int green;
		int blue;
	};



/* -------------------------------------------------------
 * 2 : ѿ (global)
 * -------------------------------------------------------
 */
#ifdef _ETC_
#define   GLOBAL
// 
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// ʬ̵
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL FILE *stream_log;


#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _ETC_



/* -------------------------------------------------------
 * 3 : ؿ (Function)
 * -------------------------------------------------------
 */
/* ʸ str  nܤˤ split_word ΰ֤֤ */
int split_word_point(char *str, char spilt_word, int n);
/* ʸ str  split_word Ĥ뤫֤ */
int split_word_num(char *str, char spilt_word);
/* ʸ str κ num ʸФʸ ret ֤ */
int strLeft(char *str, int num, char *ret);
/* ʸ str κ midܤ numʸФʸ ret ֤ */
int strMid(char *str, int mid, int num, char *ret);
/* ʸ str α num ʸФʸ ret ֤ */
int strRight(char *str, int num, char *ret);
/* ץåʸ (split_word) Ƕڤơǡ¤Ǥʸ (str) 
 * num ܤΥǡʸФʸ (ret) ֤ */
int LineDataSplit(char *str, char split_word, int num, char *ret);


/* String UTL */
void replace(char *text, char *key, char *rep);
char *search(char *text, char *key);
int ltrim(char *str, char *ret);


/* path string UTL */
/* եѥ̾ե̾ */
char *getFileName(char *lpszPath);
/* ե̾ĥҤ */
void cutExtName(char *lpszFileName);
/* ѥ̾ե̾ */
void cutFileName(char *lpszPath);
int GetAppPath(char *App_Path);


/* File UTL */
int LineRead(FILE *stream, char *ret);


/* color UTL */
int color_split(struct ColorDat *a);
long color_rgb(struct ColorDat *a);
long color_rb_change(long rgbcol);
int atoi16(char *str);
int hextoint(char *str);
int HexString(long data, char *hex);

int LogFileOpen(char *str);
int LogFileWrite(char *str);
int LogFileClose(void);

int OneShotLog(char *str);
int DeleteOneShotLog(void);

int GetConfigPath(char *path);
int Get_charset(void);
void home_of_user(char *home);
void name_of_user(char *user);

/* ʸΥѴ */
char *p_sag_iconv(char *from_str, char *from_code, char *to_code);
int sag_iconv(char *from_str, char *to_str, char *from_code, char *to_code);
char *conv_iconv(const char *from_str, const char *from_code, const char *to_code);
/* UTF-8 ΣʸΣХܤ飱ʸΥХȿ֤ */
int utf8_bite_num(char c);




#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __ETC_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : etc.h
 * ====================================================================
 */
