/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : MemoryLeak.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2002/12/27
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifndef __MEMORYLEAK_H__
#define __MEMORYLEAK_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 :   (struct #define etc)
 * -------------------------------------------------------
 */

//#if defined(MAX_PATH)
#define MAX_PATH	256
//#endif


/* xmalloc, xfree  malloc, free Ʊ褦˻Ȥ #define */
#if defined(DEBUG)
#define xmalloc(x)	_xmalloc((x), __LINE__, __FILE__)
#define xfree(x)	_xfree((x), __LINE__, __FILE__)
#define xdump()		_xdump()

#else
#define xmalloc(x)	malloc(x)
#define xfree(x)	free(x)
#define xdump()		

#endif


/* 򵭲뤿ι¤Τ */
typedef struct alloc_element {
	void *alloc_ptr;			// ݤ֥åؤݥ
	int alloc_line;				// xmalloc ƤӽФ
	char *alloc_file;			// ΥɤҤƤե̾
	struct alloc_element *next;	//  ALLOC_ELEMENT ؤΥݥ
} ALLOC_ELEMENT;




/* -------------------------------------------------------
 * 2 : ѿ (global)
 * -------------------------------------------------------
 */
#ifdef _MEMORYLEAK_
#define   GLOBAL
// 
#define   GLOBAL_VAL(v)  = (v)

	ALLOC_ELEMENT *_top = NULL;

#else
#define   GLOBAL	extern
// ʬ̵
#define   GLOBAL_VAL(v)  /* */

	extern ALLOC_ELEMENT *_top;

#endif




#undef	GLOBAL
#undef	GLOBAL_VAL
#undef _MEMORYLEAK_



/* -------------------------------------------------------
 * 3 : ؿ (Function)
 * -------------------------------------------------------
 */
void* _xmalloc(size_t size, int line, char *file);
void _xfree(void *p, int line, char *file);
void _xdump(void);
int MemoryDebugLogPath(char *output_path);
int DeleteMemoryDebugLog(void);
void CutFileName(char *lpszPath);
char *GetFileName(char *lpszPath);
int WhatKanji(unsigned char *str);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __MEMORYLEAK_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : MemoryLeak.h
 * ====================================================================
 */
