/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : MemoryLeak.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2002/12/27
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
//#include "etc.h"
#define _MEMORYLEAK_
#include "MemoryLeak.h"



void *_xmalloc(size_t size, int line, char *file)
{
	void *p;
	ALLOC_ELEMENT *ae;


	/* xmalloc(size) ǻꤵ줿Υ֥åݤ */
	p = malloc(size);
	if (p == NULL) {
		return NULL;
	}
	
	/* ALLOC_ELEMENT γ */
	ae = (ALLOC_ELEMENT *) malloc(sizeof(ALLOC_ELEMENT));
	if (ae == NULL) {
		free(p);
		return NULL;
	}
	
	ae->alloc_ptr = p;
	ae->alloc_line = line;
	ae->alloc_file = GetFileName(file);
//	ae->alloc_file = file;
	
	/* ꥹȹ¤ ALLOC_ELEMENT ɲ */
	if (_top == NULL) {
		ae->next = NULL;
		_top = ae;
	}
	else {
		ae->next = _top;
		_top = ae;
	}
	
	return p;
}



void _xfree(void *p, int line, char *file)
{
	ALLOC_ELEMENT *q;
	ALLOC_ELEMENT *r;
	char output_path[MAX_PATH];
	char str[256];
	FILE *stream;

	q = r = _top;
	while (q != NULL) {
		if (q->alloc_ptr == p) {
			if (q == _top) {
				_top = q->next;
			}
			else {
				r->next = q->next;
			}
			free(q);
			free(p);
			break;
		}
		r = q;
		q = q->next;
	}
	
	if (q == NULL) {
		MemoryDebugLogPath(output_path);
		/* ե򥪡ץ */ 
		if((stream = fopen(output_path, "a")) == NULL) {
			return;
		}
		sprintf(str, "%s(%d) : XFREE : illegal pointer(0x%x)\n", GetFileName(file), line, (int)p);
//		sprintf(str, "XFREE: %s(%d) : illegal pointer(0x%x)\n", file, line, p);
		fputs(str, stream);
		g_print(str);
		/* ե򥯥 */ 
		fclose(stream);
	}
}



void _xdump(void)
{
	ALLOC_ELEMENT *p = _top;
	ALLOC_ELEMENT *q;
	int count = 1;
	char output_path[MAX_PATH];
	char str[256];
	FILE *stream;


	MemoryDebugLogPath(output_path);
sprintf(output_path, "./MemoryDebugLog");
	/* ե򥪡ץ */ 
	if((stream = fopen(output_path, "a")) == NULL) {
		g_print("XDUMP : Not Open MemoryDebugLog [%s]\n", output_path);
		return;
	}


	g_print("XDUMP : Save [%s]\n", output_path);


	if (p == NULL) {
		sprintf(str, "XDUMP : all memory blocks deallcated\n");
		fputs(str, stream);
		g_print(str);
	}
	else {
		sprintf(str, "XDUMP : memory leaks detected [start]\n");
		fputs(str, stream);
		g_print(str);
		while (p != NULL) {
			sprintf(str, "%s(%d) : memory leak(0x%x) : memory leaks [%d]\n", 
				p->alloc_file, 
				p->alloc_line, 
				(int)p->alloc_ptr, 
				count++);
			fputs(str, stream);
			g_print(str);
			q = p->next;
			free(p);
			p = q;
		}
		sprintf(str, "XDUMP : memory leaks detected [end]\n");
		fputs(str, stream);
			g_print(str);
	}

	/* ե򥯥 */ 
	fclose(stream);
}





/* -------------------------------------------------------------------
 * ǥХåΥΥѥ롣
 * 
 * 
 */
int MemoryDebugLogPath(char *output_path)
{
	uid_t uid;
	struct passwd *pwd;

	uid = getuid();
	pwd = getpwuid(uid);
//	g_print ("user name = %s\n", pwd->pw_name);
//	g_print ("uid = %d\n", pwd->pw_uid);
//	g_print ("gid = %d\n", pwd->pw_gid);
//	g_print ("home directory = %s\n", pwd->pw_dir);
//	g_print ("shell = %s\n", pwd->pw_shell);
	sprintf(output_path, "%s/MemoryDebug", pwd->pw_dir);

	return 1;
}





/* -------------------------------------------------------------------
 * ǥХåΥõ
 * 
 * ץꥱ󳫻ϻΥõ
 */
int DeleteMemoryDebugLog(void)
{
	char path[MAX_PATH];

	MemoryDebugLogPath(path);
	unlink(path);

	return 1;
}





/* -------------------------------------------------------------------
 * ѥ̾ե̾
 *	
 * char *lpszPath	  ե̾ޤѥ̾ؤΥݥ
 * ʼ¹Ը塢ѥ̾ե̾ڤΥ
 *
 * ѥ̾Ƭʸ򸡺ơ:,\,/פΤ줫Ǹ˸줿Υݥ󥿤
 * '\0' 뤳Ȥǥե̾ޤ
 */
void CutFileName(char *lpszPath)
{
	char *lpszEnd = lpszPath;
	while(*lpszPath != '\0') {
		/* ХʸƬϥå */
		if ((WhatKanji((unsigned char *) lpszPath) & 2) == 2 ) {
			/* ʸ */
			lpszPath++;
		}
	}

	/* ѥ̾˥եޤޤʤä粿⤷ʤ */
	if(lpszEnd == lpszPath) {
		return;
	}
	/* ѥ̾ե̾ڤΥ */
	*lpszEnd = '\0';
	return;
}



/* -------------------------------------------------------------------
 * եѥ̾ե̾
 *	
 * char *lpszPath	  ե̾ޤѥ̾ؤΥݥ
 * char * ե̾ؤΥݥ
 * ե̾ޤޤʤȤ""ؤΥݥ
 * [\],[/],[:]Ĥʤä硢ե̾ȤߤʤƤΤޤ֤
 *	
 * ѥ̾Ƭʸ򸡺ơ:,\,/פΤ줫Ǹ˸õ
 * ʸӤȤϡоݤʸ2Хʸ1ХʸĴ٤ɬפޤ
 *	
 * "פ˰Ϥޤ줿,Ͽʤ
 */
char *GetFileName(char *lpszPath)
{
	char *lpszPtr = lpszPath;

	while(*lpszPtr != '\0') {
		/* ХʸƬϥå */
		if ((WhatKanji((unsigned char *) lpszPtr) & 2) == 2 ) {
			/* ʸ */
			lpszPtr++;
		}
		if (
				(WhatKanji((unsigned char *) lpszPtr) & 4) == 4 
				|| 
				(WhatKanji((unsigned char *) lpszPtr) & 8) == 8 
		) 
		{
			/* ʸ */
			lpszPtr++;
		}


		else {
			/* [\],[/],[:]򸫤Ĥ鸽+1Υݥ󥿤¸ */
			if((*lpszPtr == '\\') || (*lpszPtr == '/') || (*lpszPtr == ':')) {
				lpszPath=lpszPtr+1;
			}
		}
		/* ʸ */
		lpszPtr++;
	}
	return lpszPath;
}





/* -------------------------------------------------------------------
 * 
 */
int WhatKanji(unsigned char *str)
{
	int val = 0;
	unsigned char b1, b2, b3;

	b1 = *str++;
	b2 = *str++;
	b3 = *str;
	if (b1 == 0x1b) {
		if (b2 == '$' && b3 == 'B') return 16;
		if (b2 == '$' && b3 == '@') return 32;
		if (b2 == '(' && b3 == 'J') return 64;
		if (b2 == '(' && b3 == 'B') return 128;
		return 0;
	}
	if ( b1 >= 0xa0 && b1 <= 0xdf) val |= 1;
	if (
			(
				(b1 >= 0x81 && b1 <= 0x9f) 
				|| 
				(b1 >= 0xe0 && b1 <= 0xfc) 
			) 
			&& 
			(
				b2 >= 0x40 
				&& 
				b2 <= 0xfc 
				&& 
				b2 != 0x7f
			)
	)
		val |= 2;
	if (b1 == 0x8e && (b2 >= 0xa0 && b2 <= 0xdf)) val |= 4; 
	if ((b1 >= 0xa1 && b1 <= 0xfe) &&
		(b2 >= 0xa1 && b1 <= 0xfe)) val |= 8;

	return val;
}





#ifdef SAMPLE
main()
{
	int i;
	char *p;
	char *q;


	p = xmalloc(16);
	p = xmalloc(16);
	q = p;
	p = xmalloc(16);
	p = xmalloc(16);

	xfree(p+4);
	xfree(q);

	xdump();
}
#endif



/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : MemoryLeak.c
 * ====================================================================
 */
