/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : EnvSetDlg.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/03/01
 *    Last                 : 2003/03/01
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "intl.h"

#include "Trace.h"
#include "etc.h"
#define _ENVSETDLG_
#include "EnvSetDlg.h"



/* -------------------------------------------------------------------
 * CANCEL
 */
void envset_dlg_cancel_pushed(GtkWidget *widget, ENVSET_DLG *envset_dlg)
{
	envset_dlg->Value = 0;
	return;
}



/* -------------------------------------------------------------------
 * OK
 */
void envset_dlg_ok_pushed(GtkWidget *widget, ENVSET_DLG *envset_dlg)
{
	char str[256];
	int i;


	envset_dlg->Value = 1;

	/* ƥȥȥ꡼ʸ */
	/* User */
	strcpy(envset_dlg->user_name, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_user_name)));
	strcpy(envset_dlg->user_company, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_user_company)));

	/* Path */
	strcpy(envset_dlg->KeepCadPath, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_cad_path)));
	strcpy(envset_dlg->NcPath, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_nc_path)));
//	strcpy(envset_dlg->BrowserPath, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_browser_path)));

	/* Command */
	strcpy(envset_dlg->print_command, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_p_command)));
	strcpy(envset_dlg->editor_command, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_e_command)));
	strcpy(envset_dlg->browser_command, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_b_command)));

	/* System */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_system_Search)));
	envset_dlg->system_Search = atof(str);
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_system_Wait)));
	envset_dlg->system_Wait = atof(str);
//	strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_system_MaxLayer)));
//	envset_dlg->system_MaxLayer = atof(str);
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_system_Splits)));
	envset_dlg->system_Splits = atof(str);
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_system_ZoomMag)));
	envset_dlg->system_ZoomMag = atof(str);
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_system_ViewX)));
	envset_dlg->system_ViewX = atof(str);
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_system_FilletRC)));
	envset_dlg->system_FilletRC = atof(str);
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_system_Length)));
	envset_dlg->system_Length = atof(str);

	strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_system_WinMode)));
	envset_dlg->system_WinMode = atoi(str);
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_system_win_x_pos)));
	envset_dlg->system_win_x_pos = atoi(str);
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_system_win_y_pos)));
	envset_dlg->system_win_y_pos = atoi(str);
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_system_win_width)));
	envset_dlg->system_win_width = atoi(str);
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_system_win_height)));
	envset_dlg->system_win_height = atoi(str);


	/* Dimension */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_dimension_FontHeight)));
	envset_dlg->dimension_FontHeight = atof(str);

	strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_dimension_FontLetterSpace)));
	envset_dlg->dimension_FontLetterSpace = atof(str);

	strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_dimension_FontWordSpace)));
	envset_dlg->dimension_FontWordSpace = atof(str);

	strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_dimension_FontOverLineLength)));
	envset_dlg->dimension_FontOverLineLength = atof(str);

	strcpy(envset_dlg->dimension_Font1, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_dimension_Font1)));

	strcpy(envset_dlg->dimension_Font2, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_dimension_Font2)));

	strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_dimension_DimensionArrowLength)));
	envset_dlg->dimension_DimensionArrowLength = atof(str);

	strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_dimension_DimensionArrowAngle)));
	envset_dlg->dimension_DimensionArrowAngle = atof(str);

	strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_dimension_DimensionOverArrowLength)));
	envset_dlg->dimension_DimensionOverArrowLength = atof(str);

	strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_dimension_DimensionOverLength)));
	envset_dlg->dimension_DimensionOverLength = atof(str);

	strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_dimension_DimensionUnderLength)));
	envset_dlg->dimension_DimensionUnderLength = atof(str);


	/* SystemColor */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_system_color_BackColor)));
	envset_dlg->BackColor = atoi16(str);

	strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_system_color_SelectColor)));
	envset_dlg->SelectColor = atoi16(str);

	strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_system_color_DimensionColor)));
	envset_dlg->DimensionColor = atoi16(str);

	strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_system_color_CamColor)));
	envset_dlg->CamColor = atoi16(str);

	strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_system_color_PrinterRectColor)));
	envset_dlg->PrinterRectColor = atoi16(str);

	strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_system_color_FirstCenterLine)));
	envset_dlg->FirstCenterLine = atoi16(str);

	/* Color */
	for (i = 0 ; i < 25 ; i++) {
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_color_name[i])));
		envset_dlg->color_name[i] = atoi16(str);
	}

	/* Style */
	for (i = 0 ; i < 7 ; i++) {
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_style_max[i])));
		envset_dlg->style_max[i] = atoi(str);

		strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_style_min[i])));
		envset_dlg->style_min[i] = atoi(str);

		strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_style_DisplayWidth[i])));
		envset_dlg->style_DisplayWidth[i] = atoi(str);

		strcpy(str, gtk_entry_get_text(GTK_ENTRY(envset_dlg->entry_style_PrinterWidth[i])));
		envset_dlg->style_PrinterWidth[i] = atoi(str);
	}

	return;
}





/* -------------------------------------------------------------------
 * User Set Page Make
 */
GtkWidget *make_page_user(GtkWidget *notebook, ENVSET_DLG *envset_dlg)
{
#define USER_LABEL_WIDTH 120
#define USER_ENTRY_WIDTH 310
#define USER_WIDGET_HEIGHT 20

	GtkWidget *label;

	GtkWidget *tab_hbox_user;
		GtkWidget *vbox_label_user;
			GtkWidget *label_user_name;
			GtkWidget *label_user_company;
		GtkWidget *vbox_entry_user;
//			GtkWidget *entry_user_name;
//			GtkWidget *entry_user_company;

	/* User Set Page */
	label = gtk_label_new( _("User") );
	/* ѥå󥰥ܥå(tabvbox_user) */
	tab_hbox_user = gtk_hbox_new(0, 5);
	gtk_widget_show(tab_hbox_user);


		/* ٥ѤΣ֥ܥå */
		vbox_label_user = gtk_vbox_new(0, 0);
		gtk_box_pack_start((GtkBox *)GTK_BOX(tab_hbox_user), vbox_label_user, FALSE, TRUE, 5);
		gtk_widget_show(vbox_label_user);

			/* ̾ GTK_JUSTFY_LEFT, GTK_JUSTIFY_RIGHT, GTK_JUSTIFY_CENTER, GTK_JUSTIFY_FILL */
			label_user_name = gtk_label_new( _("Name") );
			/* ʿ󡢿ľü */
			gtk_misc_set_alignment(GTK_MISC(label_user_name), 0.0f, 1.0f);
			gtk_widget_set_usize (label_user_name, USER_LABEL_WIDTH, USER_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_user), label_user_name, FALSE, TRUE, 0);
			gtk_widget_show(label_user_name);

			/* ̾ */
			label_user_company = gtk_label_new( _("Company Name") );
			/* ʿ󡢿ľü */
			gtk_misc_set_alignment(GTK_MISC(label_user_company), 0.0f, 1.0f);
			gtk_widget_set_usize (label_user_company, USER_LABEL_WIDTH, USER_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_user), label_user_company, FALSE, TRUE, 0);
			gtk_widget_show(label_user_company);


		/* ȥꥤѤΣ֥ܥå */
		vbox_entry_user = gtk_vbox_new(0, 0);
		gtk_box_pack_start((GtkBox *)GTK_BOX(tab_hbox_user), vbox_entry_user, FALSE, TRUE, 5);
		gtk_widget_show(vbox_entry_user);

			/* user_name */
			envset_dlg->entry_user_name = gtk_entry_new();
			gtk_widget_set_usize (envset_dlg->entry_user_name, USER_ENTRY_WIDTH, USER_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_user), envset_dlg->entry_user_name, FALSE, TRUE, 0);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_user_name), envset_dlg->user_name);	/*  */
			gtk_widget_show(envset_dlg->entry_user_name);


			/* user_company */
			envset_dlg->entry_user_company = gtk_entry_new();
			gtk_widget_set_usize (envset_dlg->entry_user_company, USER_ENTRY_WIDTH, USER_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_user), envset_dlg->entry_user_company, FALSE, TRUE, 0);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_user_company), envset_dlg->user_company);	/*  */
			gtk_widget_show(envset_dlg->entry_user_company);


	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), tab_hbox_user, label);

	return tab_hbox_user;
}





/* -------------------------------------------------------------------
 * Path Set Page Make
 */
GtkWidget *make_page_path(GtkWidget *notebook, ENVSET_DLG *a)
{
#define PATH_LABEL_WIDTH 120
#define PATH_ENTRY_WIDTH 310
#define PATH_WIDGET_HEIGHT 20

	GtkWidget *label;

	GtkWidget *tab_hbox_path;
		GtkWidget *vbox_label_path;
			GtkWidget *label_cad_path;
			GtkWidget *label_nc_path;
//			GtkWidget *label_browser_path;
		GtkWidget *vbox_entry_path;
//			GtkWidget *entry_cad_path;
//			GtkWidget *entry_nc_path;
//			GtkWidget *entry_browser_path;

	/* User Set Page */
	label = gtk_label_new( _("Path") );
	/* ѥå󥰥ܥå(tabvbox_path) */
	tab_hbox_path = gtk_hbox_new(0, 5);
	gtk_widget_show(tab_hbox_path);


		/* ٥ѤΣ֥ܥå */
		vbox_label_path = gtk_vbox_new(0, 0);
		gtk_box_pack_start((GtkBox *)GTK_BOX(tab_hbox_path), vbox_label_path, FALSE, TRUE, 5);
		gtk_widget_show(vbox_label_path);

			/* label_cad_path */
			label_cad_path = gtk_label_new( _("CAD Data") );
			gtk_misc_set_alignment(GTK_MISC(label_cad_path), 0.0f, 1.0f);
			gtk_widget_set_usize (label_cad_path, PATH_LABEL_WIDTH, PATH_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_path), label_cad_path, FALSE, TRUE, 0);
			gtk_widget_show(label_cad_path);

			/* label_nc_path */
			label_nc_path = gtk_label_new( _("NC Data") );
			gtk_misc_set_alignment(GTK_MISC(label_nc_path), 0.0f, 1.0f);
			gtk_widget_set_usize (label_nc_path, PATH_LABEL_WIDTH, PATH_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_path), label_nc_path, FALSE, TRUE, 0);
			gtk_widget_show(label_nc_path);

			/* label_browser_path */
/*			label_browser_path = gtk_label_new( _("Browser") );
			gtk_misc_set_alignment(GTK_MISC(label_browser_path), 0.0f, 1.0f);
			gtk_widget_set_usize (label_browser_path, PATH_LABEL_WIDTH, PATH_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_path), label_browser_path, FALSE, TRUE, 0);
			gtk_widget_show(label_browser_path);
*/

		/* ȥꥤѤΣ֥ܥå */
		vbox_entry_path = gtk_vbox_new(0, 0);
		gtk_box_pack_start((GtkBox *)GTK_BOX(tab_hbox_path), vbox_entry_path, FALSE, TRUE, 5);
		gtk_widget_show(vbox_entry_path);

			/* entry_cad_path */
			a->entry_cad_path = gtk_entry_new();
			gtk_widget_set_usize (a->entry_cad_path, PATH_ENTRY_WIDTH, PATH_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_path), a->entry_cad_path, FALSE, TRUE, 0);
			gtk_entry_set_text(GTK_ENTRY(a->entry_cad_path), a->KeepCadPath);	/*  */
			gtk_widget_show(a->entry_cad_path);

			/* entry_nc_path */
			a->entry_nc_path = gtk_entry_new();
			gtk_widget_set_usize (a->entry_nc_path, PATH_ENTRY_WIDTH, PATH_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_path), a->entry_nc_path, FALSE, TRUE, 0);
			gtk_entry_set_text(GTK_ENTRY(a->entry_nc_path), a->NcPath);	/*  */
			gtk_widget_show(a->entry_nc_path);

			/* entry_browser_path */
//			a->entry_browser_path = gtk_entry_new();
//			gtk_widget_set_usize (a->entry_browser_path, PATH_ENTRY_WIDTH, PATH_WIDGET_HEIGHT);
//			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_path), a->entry_browser_path, FALSE, TRUE, 0);
//			gtk_entry_set_text(GTK_ENTRY(a->entry_browser_path), a->BrowserPath);	/*  */
//			gtk_widget_show(a->entry_browser_path);


	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), tab_hbox_path, label);

	return tab_hbox_path;
}




/* -------------------------------------------------------------------
 * Command Set Page Make
 */
GtkWidget *make_page_command(GtkWidget *notebook, ENVSET_DLG *a)
{
#define PATH_LABEL_WIDTH 120
#define PATH_ENTRY_WIDTH 310
#define PATH_WIDGET_HEIGHT 20

	GtkWidget *tab_label;

//#ifdef TEST
	GtkWidget *frame;
	GtkWidget *frame_vbox;
//#endif

	GtkWidget *tab_hbox_command;
		GtkWidget *vbox;
			GtkWidget *label;


	/* User Set Page */
	tab_label = gtk_label_new( _("Command") );
	/* ѥå󥰥ܥå(tab_hbox_command) */
	tab_hbox_command = gtk_hbox_new(0, 5);
	gtk_widget_show(tab_hbox_command);


		/* ٥ѤΣ֥ܥå */
		vbox = gtk_vbox_new(0, 5);
		gtk_box_pack_start((GtkBox *)GTK_BOX(tab_hbox_command), vbox, FALSE, FALSE, 5);
		gtk_widget_show(vbox);

//#ifdef TEST
			/* frame */
			frame = gtk_frame_new( _("Print") );
			gtk_frame_set_label_align (GTK_FRAME(frame), 0.02, 0);
//			gtk_widget_set_usize (frame, 430, 40);
			frame_vbox = gtk_vbox_new(0, 5);
			gtk_container_add(GTK_CONTAINER(frame), frame_vbox);

			/* label */
			label = gtk_label_new( _("Print command : ('%s' will be replaced with file name)") );
			gtk_misc_set_alignment(GTK_MISC(label), 0.0f, 1.0f);
//			gtk_widget_set_usize (label, PATH_LABEL_WIDTH, PATH_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(frame_vbox), label, FALSE, FALSE, 0);
			gtk_widget_show(label);

			/* entry_p_command */
			a->entry_p_command = gtk_entry_new();
//			gtk_widget_set_usize (a->entry_p_command, PATH_ENTRY_WIDTH, PATH_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(frame_vbox), a->entry_p_command, FALSE, FALSE, 0);
			gtk_entry_set_text(GTK_ENTRY(a->entry_p_command), a->print_command);	/*  */
			gtk_widget_show(a->entry_p_command);

			gtk_widget_show(frame_vbox);
			gtk_widget_show(frame);
			gtk_container_add(GTK_CONTAINER(vbox), frame);



			/* frame */
			frame = gtk_frame_new( _("Editor") );
			gtk_frame_set_label_align (GTK_FRAME(frame), 0.02, 0);
			frame_vbox = gtk_vbox_new(0, 5);
			gtk_container_add(GTK_CONTAINER(frame), frame_vbox);

			/* label */
			label = gtk_label_new( _("Editor start-up command : ('%s' will be replaced with file name)") );
			gtk_misc_set_alignment(GTK_MISC(label), 0.0f, 1.0f);
//			gtk_widget_set_usize (label, PATH_LABEL_WIDTH, PATH_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(frame_vbox), label, FALSE, TRUE, 0);
			gtk_widget_show(label);

			/* entry_e_command */
			a->entry_e_command = gtk_entry_new();
//			gtk_widget_set_usize (a->entry_e_command, PATH_ENTRY_WIDTH, PATH_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(frame_vbox), a->entry_e_command, FALSE, TRUE, 0);
			gtk_entry_set_text(GTK_ENTRY(a->entry_e_command), a->editor_command);	/*  */
			gtk_widget_show(a->entry_e_command);

			gtk_widget_show(frame_vbox);
			gtk_widget_show(frame);
			gtk_container_add(GTK_CONTAINER(vbox), frame);



			/* frame */
			frame = gtk_frame_new( _("Browser") );
			gtk_frame_set_label_align (GTK_FRAME(frame), 0.02, 0);
			frame_vbox = gtk_vbox_new(0, 5);
			gtk_container_add(GTK_CONTAINER(frame), frame_vbox);

			/* label */
			label = gtk_label_new( _("Browser start-up command : ('%s' will be replaced with file name)") );
			gtk_misc_set_alignment(GTK_MISC(label), 0.0f, 1.0f);
//			gtk_widget_set_usize (label, PATH_LABEL_WIDTH, PATH_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(frame_vbox), label, FALSE, TRUE, 0);
			gtk_widget_show(label);

			/* entry_b_command */
			a->entry_b_command = gtk_entry_new();
//			gtk_widget_set_usize (a->entry_b_command, PATH_ENTRY_WIDTH, PATH_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(frame_vbox), a->entry_b_command, FALSE, TRUE, 0);
			gtk_entry_set_text(GTK_ENTRY(a->entry_b_command), a->browser_command);	/*  */
			gtk_widget_show(a->entry_b_command);

			gtk_widget_show(frame_vbox);
			gtk_widget_show(frame);
			gtk_container_add(GTK_CONTAINER(vbox), frame);



//#endif
			
			
#ifdef TEST
			/* label */
			label = gtk_label_new( _("Print command : ('%s' will be replaced with file name)") );
			gtk_misc_set_alignment(GTK_MISC(label), 0.0f, 1.0f);
//			gtk_widget_set_usize (label, PATH_LABEL_WIDTH, PATH_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox), label, FALSE, TRUE, 0);
			gtk_widget_show(label);

			/* entry_p_command */
			a->entry_p_command = gtk_entry_new();
//			gtk_widget_set_usize (a->entry_p_command, PATH_ENTRY_WIDTH, PATH_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox), a->entry_p_command, FALSE, TRUE, 0);
			gtk_entry_set_text(GTK_ENTRY(a->entry_p_command), a->print_command);	/*  */
			gtk_widget_show(a->entry_p_command);


			/* label */
			label = gtk_label_new( _("Editor start-up command : ('%s' will be replaced with file name)") );
			gtk_misc_set_alignment(GTK_MISC(label), 0.0f, 1.0f);
//			gtk_widget_set_usize (label, PATH_LABEL_WIDTH, PATH_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox), label, FALSE, TRUE, 0);
			gtk_widget_show(label);

			/* entry_e_command */
			a->entry_e_command = gtk_entry_new();
//			gtk_widget_set_usize (a->entry_e_command, PATH_ENTRY_WIDTH, PATH_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox), a->entry_e_command, FALSE, TRUE, 0);
			gtk_entry_set_text(GTK_ENTRY(a->entry_e_command), a->editor_command);	/*  */
			gtk_widget_show(a->entry_e_command);


			/* label */
			label = gtk_label_new( _("Browser start-up command : ('%s' will be replaced with file name)") );
			gtk_misc_set_alignment(GTK_MISC(label), 0.0f, 1.0f);
//			gtk_widget_set_usize (label, PATH_LABEL_WIDTH, PATH_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox), label, FALSE, TRUE, 0);
			gtk_widget_show(label);

			/* entry_b_command */
			a->entry_b_command = gtk_entry_new();
//			gtk_widget_set_usize (a->entry_b_command, PATH_ENTRY_WIDTH, PATH_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox), a->entry_b_command, FALSE, TRUE, 0);
			gtk_entry_set_text(GTK_ENTRY(a->entry_b_command), a->browser_command);	/*  */
			gtk_widget_show(a->entry_b_command);
#endif


	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), tab_hbox_command, tab_label);

	return tab_hbox_command;
}




/* -------------------------------------------------------------------
 * System Set Page Make
 */
GtkWidget *make_page_system(GtkWidget *notebook, ENVSET_DLG *envset_dlg)
{
#define SYSTEM_LABEL_WIDTH 250
#define SYSTEM_ENTRY_WIDTH 180
#define SYSTEM_WIDGET_HEIGHT 20

	char str[256];
	GtkWidget *label;

	GtkWidget *tab_hbox_system;
		GtkWidget *vbox_label_system;
			GtkWidget *label_system_Search;
			GtkWidget *label_system_Wait;
//			GtkWidget *label_system_MaxLayer;
			GtkWidget *label_system_Splits;
			GtkWidget *label_system_ZoomMag;
			GtkWidget *label_system_ViewX;
			GtkWidget *label_system_FilletRC;
			GtkWidget *label_system_Length;
			GtkWidget *label_system_WinMode;
			GtkWidget *label_system_win_x_pos;
			GtkWidget *label_system_win_y_pos;
			GtkWidget *label_system_win_width;
			GtkWidget *label_system_win_height;
		GtkWidget *vbox_entry_system;
//			GtkWidget *entry_system_Search;
//			GtkWidget *entry_system_Wait;
//			GtkWidget *entry_system_MaxLayer;
//			GtkWidget *entry_system_Splits;
//			GtkWidget *entry_system_ZoomMag;
//			GtkWidget *entry_system_ViewX;
//			GtkWidget *entry_system_FilletRC;
//			GtkWidget *entry_system_Length;
//			GtkWidget *entry_system_WinMode;	/* 0:WM ˤޤ   1:   2:λ */
//			GtkWidget *entry_system_win_x_pos;
//			GtkWidget *entry_system_win_y_pos;
//			GtkWidget *entry_system_win_width;
//			GtkWidget *entry_system_win_height;



	/* System Set Page */
	label = gtk_label_new( _("System") );
	/* ѥå󥰥ܥå(tab_hbox_system) */
	tab_hbox_system = gtk_hbox_new(0, 5);
	gtk_widget_show(tab_hbox_system);


		/* ٥ѤΣ֥ܥå */
		vbox_label_system = gtk_vbox_new(0, 0);
		gtk_box_pack_start((GtkBox *)GTK_BOX(tab_hbox_system), vbox_label_system, FALSE, TRUE, 5);
		gtk_widget_show(vbox_label_system);

			/* ޷ǧΥ */
			label_system_Search = gtk_label_new( _("Diagram recognition distance") );
			gtk_misc_set_alignment(GTK_MISC(label_system_Search), 0.0f, 1.0f);
			gtk_widget_set_usize (label_system_Search, SYSTEM_LABEL_WIDTH, SYSTEM_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_system), label_system_Search, FALSE, TRUE, 0);
			gtk_widget_show(label_system_Search);

			/* ֥󥯻(ms) */
			label_system_Wait = gtk_label_new( _("Blink Time (ms)") );
			gtk_misc_set_alignment(GTK_MISC(label_system_Wait), 0.0f, 1.0f);
			gtk_widget_set_usize (label_system_Wait, SYSTEM_LABEL_WIDTH, SYSTEM_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_system), label_system_Wait, FALSE, TRUE, 0);
			gtk_widget_show(label_system_Wait);

			/* 쥤䡼(ǹ 255) */
//			label_system_MaxLayer = gtk_label_new( _("Number of the layers (max 255)") );
//			gtk_misc_set_alignment(GTK_MISC(label_system_MaxLayer), 0.0f, 1.0f);
//			gtk_widget_set_usize (label_system_MaxLayer, SYSTEM_LABEL_WIDTH, SYSTEM_WIDGET_HEIGHT);
//			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_system), label_system_MaxLayer, FALSE, TRUE, 0);
//			gtk_widget_show(label_system_MaxLayer);

			/* ʬ */
			label_system_Splits = gtk_label_new( _("Number of the scroll division") );
			gtk_misc_set_alignment(GTK_MISC(label_system_Splits), 0.0f, 1.0f);
			gtk_widget_set_usize (label_system_Splits, SYSTEM_LABEL_WIDTH, SYSTEM_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_system), label_system_Splits, FALSE, TRUE, 0);
			gtk_widget_show(label_system_Splits);

			/* ̾ */
			label_system_ZoomMag = gtk_label_new( _("Zoom coefficient") );
			gtk_misc_set_alignment(GTK_MISC(label_system_ZoomMag), 0.0f, 1.0f);
			gtk_widget_set_usize (label_system_ZoomMag, SYSTEM_LABEL_WIDTH, SYSTEM_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_system), label_system_ZoomMag, FALSE, TRUE, 0);
			gtk_widget_show(label_system_ZoomMag);

			/* ܤβ̲Ĺ */
			label_system_ViewX = gtk_label_new( _("Length at the screen side") );
			gtk_misc_set_alignment(GTK_MISC(label_system_ViewX), 0.0f, 1.0f);
			gtk_widget_set_usize (label_system_ViewX, SYSTEM_LABEL_WIDTH, SYSTEM_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_system), label_system_ViewX, FALSE, TRUE, 0);
			gtk_widget_show(label_system_ViewX);

			/* եåȤΣҤν */
			label_system_FilletRC = gtk_label_new( _("Default fillet radius") );
			gtk_misc_set_alignment(GTK_MISC(label_system_FilletRC), 0.0f, 1.0f);
			gtk_widget_set_usize (label_system_FilletRC, SYSTEM_LABEL_WIDTH, SYSTEM_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_system), label_system_FilletRC, FALSE, TRUE, 0);
			gtk_widget_show(label_system_FilletRC);

			/* Ĺν */
			label_system_Length = gtk_label_new( _("Default basic length") );
			gtk_misc_set_alignment(GTK_MISC(label_system_Length), 0.0f, 1.0f);
			gtk_widget_set_usize (label_system_Length, SYSTEM_LABEL_WIDTH, SYSTEM_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_system), label_system_Length, FALSE, TRUE, 0);
			gtk_widget_show(label_system_Length);

			/* ɥɽ⡼ */
			label_system_WinMode = gtk_label_new( _("Window mode") );
			gtk_misc_set_alignment(GTK_MISC(label_system_WinMode), 0.0f, 1.0f);
			gtk_widget_set_usize (label_system_WinMode, SYSTEM_LABEL_WIDTH, SYSTEM_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_system), label_system_WinMode, FALSE, TRUE, 0);
			gtk_widget_show(label_system_WinMode);

			/* ɥɽ֣ */
			label_system_win_x_pos = gtk_label_new( _("X Position of the window") );
			gtk_misc_set_alignment(GTK_MISC(label_system_win_x_pos), 0.0f, 1.0f);
			gtk_widget_set_usize (label_system_win_x_pos, SYSTEM_LABEL_WIDTH, SYSTEM_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_system), label_system_win_x_pos, FALSE, TRUE, 0);
			gtk_widget_show(label_system_win_x_pos);

			/* ɥɽ֣ */
			label_system_win_y_pos = gtk_label_new( _("Y Position of the window") );
			gtk_misc_set_alignment(GTK_MISC(label_system_win_y_pos), 0.0f, 1.0f);
			gtk_widget_set_usize (label_system_win_y_pos, SYSTEM_LABEL_WIDTH, SYSTEM_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_system), label_system_win_y_pos, FALSE, TRUE, 0);
			gtk_widget_show(label_system_win_y_pos);

			/* ɥ */
			label_system_win_width = gtk_label_new( _("Window width") );
			gtk_misc_set_alignment(GTK_MISC(label_system_win_width), 0.0f, 1.0f);
			gtk_widget_set_usize (label_system_win_width, SYSTEM_LABEL_WIDTH, SYSTEM_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_system), label_system_win_width, FALSE, TRUE, 0);
			gtk_widget_show(label_system_win_width);

			/* ɥι⤵ */
			label_system_win_height = gtk_label_new( _("Window height") );
			gtk_misc_set_alignment(GTK_MISC(label_system_win_height), 0.0f, 1.0f);
			gtk_widget_set_usize (label_system_win_height, SYSTEM_LABEL_WIDTH, SYSTEM_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_system), label_system_win_height, FALSE, TRUE, 0);
			gtk_widget_show(label_system_win_height);


		/* ȥꥤѤΣ֥ܥå */
		vbox_entry_system = gtk_vbox_new(0, 0);
		gtk_box_pack_start((GtkBox *)GTK_BOX(tab_hbox_system), vbox_entry_system, FALSE, TRUE, 5);
		gtk_widget_show(vbox_entry_system);

			/*  */
			envset_dlg->entry_system_Search = gtk_entry_new();
			gtk_widget_set_usize (envset_dlg->entry_system_Search, SYSTEM_ENTRY_WIDTH, SYSTEM_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_system), envset_dlg->entry_system_Search, FALSE, TRUE, 0);
			FloatOut_n(str, envset_dlg->system_Search, 6, 0);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_system_Search), str);	/*  */
			gtk_widget_show(envset_dlg->entry_system_Search);

			/*  */
			envset_dlg->entry_system_Wait = gtk_entry_new();
			gtk_widget_set_usize (envset_dlg->entry_system_Wait, SYSTEM_ENTRY_WIDTH, SYSTEM_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_system), envset_dlg->entry_system_Wait, FALSE, TRUE, 0);
			FloatOut_n(str, envset_dlg->system_Wait, 6, 0);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_system_Wait), str);	/*  */
			gtk_widget_show(envset_dlg->entry_system_Wait);

			/*  */
//			envset_dlg->entry_system_MaxLayer = gtk_entry_new();
//			gtk_widget_set_usize (envset_dlg->entry_system_MaxLayer, SYSTEM_ENTRY_WIDTH, SYSTEM_WIDGET_HEIGHT);
//			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_system), envset_dlg->entry_system_MaxLayer, FALSE, TRUE, 0);
//			FloatOut_n(str, envset_dlg->system_MaxLayer, 6, 0);
//			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_system_MaxLayer), str);	/*  */
//			gtk_widget_show(envset_dlg->entry_system_MaxLayer);

			/*  */
			envset_dlg->entry_system_Splits = gtk_entry_new();
			gtk_widget_set_usize (envset_dlg->entry_system_Splits, SYSTEM_ENTRY_WIDTH, SYSTEM_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_system), envset_dlg->entry_system_Splits, FALSE, TRUE, 0);
			FloatOut_n(str, envset_dlg->system_Splits, 6, 0);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_system_Splits), str);	/*  */
			gtk_widget_show(envset_dlg->entry_system_Splits);

			/*  */
			envset_dlg->entry_system_ZoomMag = gtk_entry_new();
			gtk_widget_set_usize (envset_dlg->entry_system_ZoomMag, SYSTEM_ENTRY_WIDTH, SYSTEM_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_system), envset_dlg->entry_system_ZoomMag, FALSE, TRUE, 0);
			FloatOut_n(str, envset_dlg->system_ZoomMag, 6, 0);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_system_ZoomMag), str);	/*  */
			gtk_widget_show(envset_dlg->entry_system_ZoomMag);

			/*  */
			envset_dlg->entry_system_ViewX = gtk_entry_new();
			gtk_widget_set_usize (envset_dlg->entry_system_ViewX, SYSTEM_ENTRY_WIDTH, SYSTEM_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_system), envset_dlg->entry_system_ViewX, FALSE, TRUE, 0);
			FloatOut_n(str, envset_dlg->system_ViewX, 6, 0);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_system_ViewX), str);	/*  */
			gtk_widget_show(envset_dlg->entry_system_ViewX);

			/*  */
			envset_dlg->entry_system_FilletRC = gtk_entry_new();
			gtk_widget_set_usize (envset_dlg->entry_system_FilletRC, SYSTEM_ENTRY_WIDTH, SYSTEM_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_system), envset_dlg->entry_system_FilletRC, FALSE, TRUE, 0);
			FloatOut_n(str, envset_dlg->system_FilletRC, 6, 0);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_system_FilletRC), str);	/*  */
			gtk_widget_show(envset_dlg->entry_system_FilletRC);

			/*  */
			envset_dlg->entry_system_Length = gtk_entry_new();
			gtk_widget_set_usize (envset_dlg->entry_system_Length, SYSTEM_ENTRY_WIDTH, SYSTEM_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_system), envset_dlg->entry_system_Length, FALSE, TRUE, 0);
			FloatOut_n(str, envset_dlg->system_Length, 6, 0);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_system_Length), str);	/*  */
			gtk_widget_show(envset_dlg->entry_system_Length);

			/* WinMode */
			envset_dlg->entry_system_WinMode = gtk_entry_new();
			gtk_widget_set_usize (envset_dlg->entry_system_WinMode, SYSTEM_ENTRY_WIDTH, SYSTEM_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_system), envset_dlg->entry_system_WinMode, FALSE, TRUE, 0);
			sprintf(str, "%d", envset_dlg->system_WinMode);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_system_WinMode), str);	/*  */
			gtk_widget_show(envset_dlg->entry_system_WinMode);

			/* win_x_pos */
			envset_dlg->entry_system_win_x_pos = gtk_entry_new();
			gtk_widget_set_usize (envset_dlg->entry_system_win_x_pos, SYSTEM_ENTRY_WIDTH, SYSTEM_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_system), envset_dlg->entry_system_win_x_pos, FALSE, TRUE, 0);
			sprintf(str, "%d", envset_dlg->system_win_x_pos);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_system_win_x_pos), str);	/*  */
			gtk_widget_show(envset_dlg->entry_system_win_x_pos);

			/* win_y_pos */
			envset_dlg->entry_system_win_y_pos = gtk_entry_new();
			gtk_widget_set_usize (envset_dlg->entry_system_win_y_pos, SYSTEM_ENTRY_WIDTH, SYSTEM_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_system), envset_dlg->entry_system_win_y_pos, FALSE, TRUE, 0);
			sprintf(str, "%d", envset_dlg->system_win_y_pos);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_system_win_y_pos), str);	/*  */
			gtk_widget_show(envset_dlg->entry_system_win_y_pos);

			/* win_width */
			envset_dlg->entry_system_win_width = gtk_entry_new();
			gtk_widget_set_usize (envset_dlg->entry_system_win_width, SYSTEM_ENTRY_WIDTH, SYSTEM_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_system), envset_dlg->entry_system_win_width, FALSE, TRUE, 0);
			sprintf(str, "%d", envset_dlg->system_win_width);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_system_win_width), str);	/*  */
			gtk_widget_show(envset_dlg->entry_system_win_width);

			/* win_height */
			envset_dlg->entry_system_win_height = gtk_entry_new();
			gtk_widget_set_usize (envset_dlg->entry_system_win_height, SYSTEM_ENTRY_WIDTH, SYSTEM_WIDGET_HEIGHT);
			gtk_box_pack_start(GTK_BOX(vbox_entry_system), envset_dlg->entry_system_win_height, FALSE, TRUE, 0);
			sprintf(str, "%d", envset_dlg->system_win_height);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_system_win_height), str);	/*  */
			gtk_widget_show(envset_dlg->entry_system_win_height);


	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), tab_hbox_system, label);

	return tab_hbox_system;
}





/* -------------------------------------------------------------------
 * Dimension Set Page Make
 */
GtkWidget *make_page_dimension(GtkWidget *notebook, ENVSET_DLG *envset_dlg)
{
#define DIMENSION_LABEL_WIDTH 250
#define DIMENSION_ENTRY_WIDTH 180
#define DIMENSION_WIDGET_HEIGHT 20

	char str[256];
	GtkWidget *label;

	GtkWidget *tab_hbox_dimension;
		GtkWidget *vbox_label_dimension;
			GtkWidget *label_dimension_FontHeight;
			GtkWidget *label_dimension_FontLetterSpace;
			GtkWidget *label_dimension_FontWordSpace;
			GtkWidget *label_dimension_FontOverLineLength;
			GtkWidget *label_dimension_Font1;
			GtkWidget *label_dimension_Font2;
			GtkWidget *label_dimension_DimensionArrowLength;
			GtkWidget *label_dimension_DimensionArrowAngle;
			GtkWidget *label_dimension_DimensionOverArrowLength;
			GtkWidget *label_dimension_DimensionOverLength;
			GtkWidget *label_dimension_DimensionUnderLength;
		GtkWidget *vbox_entry_dimension;
//			GtkWidget *entry_dimension_FontHeight;
//			GtkWidget *entry_dimension_FontLetterSpace;
//			GtkWidget *entry_dimension_FontWordSpace;
//			GtkWidget *entry_dimension_FontOverLineLength;
//			GtkWidget *entry_dimension_Font1;
//			GtkWidget *entry_dimension_Font2;
//			GtkWidget *entry_dimension_DimensionArrowLength;
//			GtkWidget *entry_dimension_DimensionArrowAngle;
//			GtkWidget *entry_dimension_DimensionOverArrowLength;
//			GtkWidget *entry_dimension_DimensionOverLength;
//			GtkWidget *entry_dimension_DimensionUnderLength;


	/* Dimension Set Page */
	label = gtk_label_new( _("Dimension") );
	/* ѥå󥰥ܥå(tabvbox_user) */
	tab_hbox_dimension = gtk_hbox_new(0, 5);
	gtk_widget_show(tab_hbox_dimension);





		/* ٥ѤΣ֥ܥå */
		vbox_label_dimension = gtk_vbox_new(0, 0);
		gtk_box_pack_start((GtkBox *)GTK_BOX(tab_hbox_dimension), vbox_label_dimension, FALSE, TRUE, 5);
		gtk_widget_show(vbox_label_dimension);

			label_dimension_FontHeight = gtk_label_new( _("Text height") );
			gtk_misc_set_alignment(GTK_MISC(label_dimension_FontHeight), 0.0f, 1.0f);
			gtk_widget_set_usize (label_dimension_FontHeight, DIMENSION_LABEL_WIDTH, DIMENSION_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_dimension), label_dimension_FontHeight, FALSE, TRUE, 0);
			gtk_widget_show(label_dimension_FontHeight);

			label_dimension_FontLetterSpace = gtk_label_new( _("Character space") );
			gtk_misc_set_alignment(GTK_MISC(label_dimension_FontLetterSpace), 0.0f, 1.0f);
			gtk_widget_set_usize (label_dimension_FontLetterSpace, DIMENSION_LABEL_WIDTH, DIMENSION_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_dimension), label_dimension_FontLetterSpace, FALSE, TRUE, 0);
			gtk_widget_show(label_dimension_FontLetterSpace);

			label_dimension_FontWordSpace = gtk_label_new( _("Word space") );
			gtk_misc_set_alignment(GTK_MISC(label_dimension_FontWordSpace), 0.0f, 1.0f);
			gtk_widget_set_usize (label_dimension_FontWordSpace, DIMENSION_LABEL_WIDTH, DIMENSION_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_dimension), label_dimension_FontWordSpace, FALSE, TRUE, 0);
			gtk_widget_show(label_dimension_FontWordSpace);

			label_dimension_FontOverLineLength = gtk_label_new( _("Space under character") );
			gtk_misc_set_alignment(GTK_MISC(label_dimension_FontOverLineLength), 0.0f, 1.0f);
			gtk_widget_set_usize (label_dimension_FontOverLineLength, DIMENSION_LABEL_WIDTH, DIMENSION_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_dimension), label_dimension_FontOverLineLength, FALSE, TRUE, 0);
			gtk_widget_show(label_dimension_FontOverLineLength);

			label_dimension_Font1 = gtk_label_new( _("Font 1") );
			gtk_misc_set_alignment(GTK_MISC(label_dimension_Font1), 0.0f, 1.0f);
			gtk_widget_set_usize (label_dimension_Font1, DIMENSION_LABEL_WIDTH, DIMENSION_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_dimension), label_dimension_Font1, FALSE, TRUE, 0);
			gtk_widget_show(label_dimension_Font1);

			label_dimension_Font2 = gtk_label_new( _("Font 2") );
			gtk_misc_set_alignment(GTK_MISC(label_dimension_Font2), 0.0f, 1.0f);
			gtk_widget_set_usize (label_dimension_Font2, DIMENSION_LABEL_WIDTH, DIMENSION_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_dimension), label_dimension_Font2, FALSE, TRUE, 0);
			gtk_widget_show(label_dimension_Font2);

			label_dimension_DimensionArrowLength = gtk_label_new( _("Arrow length") );
			gtk_misc_set_alignment(GTK_MISC(label_dimension_DimensionArrowLength), 0.0f, 1.0f);
			gtk_widget_set_usize (label_dimension_DimensionArrowLength, DIMENSION_LABEL_WIDTH, DIMENSION_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_dimension), label_dimension_DimensionArrowLength, FALSE, TRUE, 0);
			gtk_widget_show(label_dimension_DimensionArrowLength);

			label_dimension_DimensionArrowAngle = gtk_label_new( _("Arrow angle") );
			gtk_misc_set_alignment(GTK_MISC(label_dimension_DimensionArrowAngle), 0.0f, 1.0f);
			gtk_widget_set_usize (label_dimension_DimensionArrowAngle, DIMENSION_LABEL_WIDTH, DIMENSION_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_dimension), label_dimension_DimensionArrowAngle, FALSE, TRUE, 0);
			gtk_widget_show(label_dimension_DimensionArrowAngle);

			label_dimension_DimensionOverArrowLength = gtk_label_new( _("Length of the line of the opposite arrow") );
			gtk_misc_set_alignment(GTK_MISC(label_dimension_DimensionOverArrowLength), 0.0f, 1.0f);
			gtk_widget_set_usize (label_dimension_DimensionOverArrowLength, DIMENSION_LABEL_WIDTH, DIMENSION_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_dimension), label_dimension_DimensionOverArrowLength, FALSE, TRUE, 0);
			gtk_widget_show(label_dimension_DimensionOverArrowLength);

			label_dimension_DimensionOverLength = gtk_label_new( _("Over length") );
			gtk_misc_set_alignment(GTK_MISC(label_dimension_DimensionOverLength), 0.0f, 1.0f);
			gtk_widget_set_usize (label_dimension_DimensionOverLength, DIMENSION_LABEL_WIDTH, DIMENSION_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_dimension), label_dimension_DimensionOverLength, FALSE, TRUE, 0);
			gtk_widget_show(label_dimension_DimensionOverLength);

			label_dimension_DimensionUnderLength = gtk_label_new( _("Under length") );
			gtk_misc_set_alignment(GTK_MISC(label_dimension_DimensionUnderLength), 0.0f, 1.0f);
			gtk_widget_set_usize (label_dimension_DimensionUnderLength, DIMENSION_LABEL_WIDTH, DIMENSION_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_dimension), label_dimension_DimensionUnderLength, FALSE, TRUE, 0);
			gtk_widget_show(label_dimension_DimensionUnderLength);





		/* ȥꥤѤΣ֥ܥå */
		vbox_entry_dimension = gtk_vbox_new(0, 0);
		gtk_box_pack_start((GtkBox *)GTK_BOX(tab_hbox_dimension), vbox_entry_dimension, FALSE, TRUE, 5);
		gtk_widget_show(vbox_entry_dimension);

			/* FontHeight */
			envset_dlg->entry_dimension_FontHeight = gtk_entry_new();
			gtk_widget_set_usize (envset_dlg->entry_dimension_FontHeight, DIMENSION_ENTRY_WIDTH, DIMENSION_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_dimension), 
							   envset_dlg->entry_dimension_FontHeight, FALSE, TRUE, 0);
			FloatOut_n(str, envset_dlg->dimension_FontHeight, 6, 0);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_dimension_FontHeight), str);	/*  */
			gtk_widget_show(envset_dlg->entry_dimension_FontHeight);

			/* FontLetterSpace */
			envset_dlg->entry_dimension_FontLetterSpace = gtk_entry_new();
			gtk_widget_set_usize (envset_dlg->entry_dimension_FontLetterSpace, DIMENSION_ENTRY_WIDTH, DIMENSION_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_dimension), 
							   envset_dlg->entry_dimension_FontLetterSpace, FALSE, TRUE, 0);
			FloatOut_n(str, envset_dlg->dimension_FontLetterSpace, 6, 0);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_dimension_FontLetterSpace), str);	/*  */
			gtk_widget_show(envset_dlg->entry_dimension_FontLetterSpace);

			/* FontWordSpace */
			envset_dlg->entry_dimension_FontWordSpace = gtk_entry_new();
			gtk_widget_set_usize (envset_dlg->entry_dimension_FontWordSpace, DIMENSION_ENTRY_WIDTH, DIMENSION_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_dimension), 
							   envset_dlg->entry_dimension_FontWordSpace, FALSE, TRUE, 0);
			FloatOut_n(str, envset_dlg->dimension_FontWordSpace, 6, 0);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_dimension_FontWordSpace), str);	/*  */
			gtk_widget_show(envset_dlg->entry_dimension_FontWordSpace);

			/* FontOverLineLength */
			envset_dlg->entry_dimension_FontOverLineLength = gtk_entry_new();
			gtk_widget_set_usize (envset_dlg->entry_dimension_FontOverLineLength, DIMENSION_ENTRY_WIDTH, DIMENSION_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_dimension), 
							   envset_dlg->entry_dimension_FontOverLineLength, FALSE, TRUE, 0);
			FloatOut_n(str, envset_dlg->dimension_FontOverLineLength, 6, 0);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_dimension_FontOverLineLength), str);	/*  */
			gtk_widget_show(envset_dlg->entry_dimension_FontOverLineLength);

			/* Font1 */
			envset_dlg->entry_dimension_Font1 = gtk_entry_new();
			gtk_widget_set_usize (envset_dlg->entry_dimension_Font1, DIMENSION_ENTRY_WIDTH, DIMENSION_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_dimension), 
							   envset_dlg->entry_dimension_Font1, FALSE, TRUE, 0);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_dimension_Font1), 	/*  */
							   envset_dlg->dimension_Font1);
			gtk_widget_show(envset_dlg->entry_dimension_Font1);

			/* Font2 */
			envset_dlg->entry_dimension_Font2 = gtk_entry_new();
			gtk_widget_set_usize (envset_dlg->entry_dimension_Font2, DIMENSION_ENTRY_WIDTH, DIMENSION_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_dimension), 
							   envset_dlg->entry_dimension_Font2, FALSE, TRUE, 0);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_dimension_Font2), 	/*  */
							   envset_dlg->dimension_Font2);
			gtk_widget_show(envset_dlg->entry_dimension_Font2);

			/* DimensionArrowLength */
			envset_dlg->entry_dimension_DimensionArrowLength = gtk_entry_new();
			gtk_widget_set_usize (envset_dlg->entry_dimension_DimensionArrowLength, DIMENSION_ENTRY_WIDTH, DIMENSION_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_dimension), 
							   envset_dlg->entry_dimension_DimensionArrowLength, FALSE, TRUE, 0);
			FloatOut_n(str, envset_dlg->dimension_DimensionArrowLength, 6, 0);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_dimension_DimensionArrowLength), str);	/*  */
			gtk_widget_show(envset_dlg->entry_dimension_DimensionArrowLength);

			/* DimensionArrowAngle */
			envset_dlg->entry_dimension_DimensionArrowAngle = gtk_entry_new();
			gtk_widget_set_usize (envset_dlg->entry_dimension_DimensionArrowAngle, DIMENSION_ENTRY_WIDTH, DIMENSION_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_dimension), 
							   envset_dlg->entry_dimension_DimensionArrowAngle, FALSE, TRUE, 0);
			FloatOut_n(str, envset_dlg->dimension_DimensionArrowAngle, 6, 0);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_dimension_DimensionArrowAngle), str);	/*  */
			gtk_widget_show(envset_dlg->entry_dimension_DimensionArrowAngle);

			/* DimensionOverArrowLength */
			envset_dlg->entry_dimension_DimensionOverArrowLength = gtk_entry_new();
			gtk_widget_set_usize (envset_dlg->entry_dimension_DimensionOverArrowLength, DIMENSION_ENTRY_WIDTH, DIMENSION_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_dimension), 
							   envset_dlg->entry_dimension_DimensionOverArrowLength, FALSE, TRUE, 0);
			FloatOut_n(str, envset_dlg->dimension_DimensionOverArrowLength, 6, 0);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_dimension_DimensionOverArrowLength), str);	/*  */
			gtk_widget_show(envset_dlg->entry_dimension_DimensionOverArrowLength);

			/* DimensionOverLength */
			envset_dlg->entry_dimension_DimensionOverLength = gtk_entry_new();
			gtk_widget_set_usize (envset_dlg->entry_dimension_DimensionOverLength, DIMENSION_ENTRY_WIDTH, DIMENSION_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_dimension), 
							   envset_dlg->entry_dimension_DimensionOverLength, FALSE, TRUE, 0);
			FloatOut_n(str, envset_dlg->dimension_DimensionOverLength, 6, 0);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_dimension_DimensionOverLength), str);	/*  */
			gtk_widget_show(envset_dlg->entry_dimension_DimensionOverLength);

			/* DimensionUnderLength */
			envset_dlg->entry_dimension_DimensionUnderLength = gtk_entry_new();
			gtk_widget_set_usize (envset_dlg->entry_dimension_DimensionUnderLength, DIMENSION_ENTRY_WIDTH, DIMENSION_WIDGET_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_dimension), 
							   envset_dlg->entry_dimension_DimensionUnderLength, FALSE, TRUE, 0);
			FloatOut_n(str, envset_dlg->dimension_DimensionUnderLength, 6, 0);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_dimension_DimensionUnderLength), str);	/*  */
			gtk_widget_show(envset_dlg->entry_dimension_DimensionUnderLength);



	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), tab_hbox_dimension, label);

	return tab_hbox_dimension;
}





/* -------------------------------------------------------------------
 * System Color Set Page Make
 */
GtkWidget *make_page_system_color(GtkWidget *notebook, ENVSET_DLG *envset_dlg)
{
	char str[256];
	GtkWidget *label;

	GtkWidget *tab_hbox_system_color;
		GtkWidget *vbox_button_system_color;
			GtkWidget *button_system_color_BackColor;
			GtkWidget *button_system_color_SelectColor;
			GtkWidget *button_system_color_DimensionColor;
			GtkWidget *button_system_color_CamColor;
			GtkWidget *button_system_color_PrinterRectColor;
			GtkWidget *button_system_color_FirstCenterLine;

		GtkWidget *vbox_entry_system_color;
//			GtkWidget *entry_system_color_BackColor;
//			GtkWidget *entry_system_color_SelectColor;
//			GtkWidget *entry_system_color_DimensionColor;
//			GtkWidget *entry_system_color_CamColor;
//			GtkWidget *entry_system_color_PrinterRectColor;
//			GtkWidget *entry_system_color_FirstCenterLine;



	/* System Color Set Page */
	label = gtk_label_new( _("Syatem Color") );
	/* ѥå󥰥ܥå(tab_hbox_system_color) */
	tab_hbox_system_color = gtk_hbox_new(0, 5);
	gtk_widget_show(tab_hbox_system_color);


		/* ܥѤΥХå󥰥ܥå */
		vbox_button_system_color = gtk_vbox_new(0, 0);
		gtk_box_pack_start((GtkBox *)GTK_BOX(tab_hbox_system_color), vbox_button_system_color, FALSE, TRUE, 5);
		gtk_widget_show(vbox_button_system_color);

			/*  */
			button_system_color_BackColor = gtk_button_new_with_label( _("Background color") );
//			gtk_widget_set_usize (button_system_color_BackColor, 150, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_button_system_color), 
							   button_system_color_BackColor, FALSE, TRUE, 0);
			gtk_widget_show(button_system_color_BackColor);

			/*  */
			button_system_color_SelectColor = gtk_button_new_with_label( _("Select color") );
//			gtk_widget_set_usize (button_system_color_SelectColor, 150, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_button_system_color), 
							   button_system_color_SelectColor, FALSE, TRUE, 0);
			gtk_widget_show(button_system_color_SelectColor);

			/*  */
			button_system_color_DimensionColor = gtk_button_new_with_label( _("Dimension color") );
//			gtk_widget_set_usize (button_system_color_DimensionColor, 150, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_button_system_color), 
							   button_system_color_DimensionColor, FALSE, TRUE, 0);
			gtk_widget_show(button_system_color_DimensionColor);

			/*  */
			button_system_color_CamColor = gtk_button_new_with_label( _("CAM color") );
//			gtk_widget_set_usize (button_system_color_CamColor, 150, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_button_system_color), 
							   button_system_color_CamColor, FALSE, TRUE, 0);
			gtk_widget_show(button_system_color_CamColor);

			/*  */
			button_system_color_PrinterRectColor = gtk_button_new_with_label( _("Page border") );
//			gtk_widget_set_usize (button_system_color_PrinterRectColor, 150, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_button_system_color), 
							   button_system_color_PrinterRectColor, FALSE, TRUE, 0);
			gtk_widget_show(button_system_color_PrinterRectColor);

			/*  */
			button_system_color_FirstCenterLine = gtk_button_new_with_label( _("Axis color") );
//			gtk_widget_set_usize (button_system_color_FirstCenterLine, 150, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_button_system_color), 
							   button_system_color_FirstCenterLine, FALSE, TRUE, 0);
			gtk_widget_show(button_system_color_FirstCenterLine);


		/* ȥꥤѤΥХå󥰥ܥå */
		vbox_entry_system_color = gtk_vbox_new(0, 0);
		gtk_box_pack_start((GtkBox *)GTK_BOX(tab_hbox_system_color), vbox_entry_system_color, FALSE, TRUE, 5);
		gtk_widget_show(vbox_entry_system_color);

			/*  */
			envset_dlg->entry_system_color_BackColor = gtk_entry_new();
//			gtk_widget_set_usize (envset_dlg->entry_system_color_BackColor, 160, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_system_color), 
							   envset_dlg->entry_system_color_BackColor, FALSE, TRUE, 0);
			HexString(envset_dlg->BackColor, str);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_system_color_BackColor), str);	/*  */
			gtk_widget_show(envset_dlg->entry_system_color_BackColor);

			/*  */
			envset_dlg->entry_system_color_SelectColor = gtk_entry_new();
//			gtk_widget_set_usize (envset_dlg->entry_system_color_SelectColor, 160, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_system_color), 
							   envset_dlg->entry_system_color_SelectColor, FALSE, TRUE, 0);
			HexString(envset_dlg->SelectColor, str);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_system_color_SelectColor), str);	/*  */
			gtk_widget_show(envset_dlg->entry_system_color_SelectColor);

			/*  */
			envset_dlg->entry_system_color_DimensionColor = gtk_entry_new();
//			gtk_widget_set_usize (envset_dlg->entry_system_color_DimensionColor, 160, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_system_color), 
							   envset_dlg->entry_system_color_DimensionColor, FALSE, TRUE, 0);
			HexString(envset_dlg->DimensionColor, str);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_system_color_DimensionColor), str);	/*  */
			gtk_widget_show(envset_dlg->entry_system_color_DimensionColor);

			/*  */
			envset_dlg->entry_system_color_CamColor = gtk_entry_new();
//			gtk_widget_set_usize (envset_dlg->entry_system_color_CamColor, 160, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_system_color), 
							   envset_dlg->entry_system_color_CamColor, FALSE, TRUE, 0);
			HexString(envset_dlg->CamColor, str);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_system_color_CamColor), str);	/*  */
			gtk_widget_show(envset_dlg->entry_system_color_CamColor);

			/*  */
			envset_dlg->entry_system_color_PrinterRectColor = gtk_entry_new();
//			gtk_widget_set_usize (envset_dlg->entry_system_color_PrinterRectColor, 160, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_system_color), 
							   envset_dlg->entry_system_color_PrinterRectColor, FALSE, TRUE, 0);
			HexString(envset_dlg->PrinterRectColor, str);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_system_color_PrinterRectColor), str);	/*  */
			gtk_widget_show(envset_dlg->entry_system_color_PrinterRectColor);

			/*  */
			envset_dlg->entry_system_color_FirstCenterLine = gtk_entry_new();
//			gtk_widget_set_usize (envset_dlg->entry_system_color_FirstCenterLine, 160, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_system_color), 
							   envset_dlg->entry_system_color_FirstCenterLine, FALSE, TRUE, 0);
			HexString(envset_dlg->FirstCenterLine, str);
			gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_system_color_FirstCenterLine), str);	/*  */
			gtk_widget_show(envset_dlg->entry_system_color_FirstCenterLine);


	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), tab_hbox_system_color, label);

	return tab_hbox_system_color;
}





/* -------------------------------------------------------------------
 * Color Set Page Make
 */
GtkWidget *make_page_color(GtkWidget *notebook, ENVSET_DLG *envset_dlg)
{
	int i;
	char str[256];
	GtkWidget *label;

	GtkWidget *tab_hbox_color;
		GtkWidget *vbox_button_color1;
		GtkWidget *vbox_button_color2;
			GtkWidget *button_color_name[25];
		GtkWidget *vbox_entry_color1;
		GtkWidget *vbox_entry_color2;
//			GtkWidget *entry_color_name[25];



	/* Color Set Page */
	label = gtk_label_new( _("Color") );
	/* ѥå󥰥ܥå(tab_hbox_color) */
	tab_hbox_color = gtk_hbox_new(0, 5);
	gtk_widget_show(tab_hbox_color);


		vbox_button_color1 = gtk_vbox_new(0, 0);
		gtk_box_pack_start((GtkBox *)GTK_BOX(tab_hbox_color), vbox_button_color1, FALSE, TRUE, 5);
		gtk_widget_show(vbox_button_color1);

			for (i = 0 ; i < 15 ; i++) {
				if (i < 9) {
					sprintf(str, "Color-0%d", i+1);
				}
				else {
					sprintf(str, "Color-%d", i+1);
				}
				button_color_name[i] = gtk_button_new_with_label(str);
				gtk_widget_set_usize (button_color_name[i], 75, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_button_color1), 
								   button_color_name[i], FALSE, TRUE, 0);
				gtk_widget_show(button_color_name[i]);
			}

		vbox_entry_color1 = gtk_vbox_new(0, 0);
		gtk_box_pack_start((GtkBox *)GTK_BOX(tab_hbox_color), vbox_entry_color1, FALSE, TRUE, 5);
		gtk_widget_show(vbox_entry_color1);

			for (i = 0 ; i < 15 ; i++) {
				envset_dlg->entry_color_name[i] = gtk_entry_new();
				gtk_widget_set_usize (envset_dlg->entry_color_name[i], 80, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_color1), 
								   envset_dlg->entry_color_name[i], FALSE, TRUE, 0);
				HexString(envset_dlg->color_name[i], str);
				gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_color_name[i]), str);	/*  */
				gtk_widget_show(envset_dlg->entry_color_name[i]);
			}


		vbox_button_color2 = gtk_vbox_new(0, 0);
		gtk_box_pack_start((GtkBox *)GTK_BOX(tab_hbox_color), vbox_button_color2, FALSE, TRUE, 5);
		gtk_widget_show(vbox_button_color2);

			for (i = 15 ; i < 25 ; i++) {
				sprintf(str, "Color-%d", i+1);
				button_color_name[i] = gtk_button_new_with_label(str);
				gtk_widget_set_usize (button_color_name[i], 75, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_button_color2), 
								   button_color_name[i], FALSE, TRUE, 0);
				gtk_widget_show(button_color_name[i]);
			}


		vbox_entry_color2 = gtk_vbox_new(0, 0);
		gtk_box_pack_start((GtkBox *)GTK_BOX(tab_hbox_color), vbox_entry_color2, FALSE, TRUE, 5);
		gtk_widget_show(vbox_entry_color2);

			for (i = 15 ; i < 25 ; i++) {
				envset_dlg->entry_color_name[i] = gtk_entry_new();
				gtk_widget_set_usize (envset_dlg->entry_color_name[i], 80, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_color2), 
								   envset_dlg->entry_color_name[i], FALSE, TRUE, 0);
				HexString(envset_dlg->color_name[i], str);
				gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_color_name[i]), str);	/*  */
				gtk_widget_show(envset_dlg->entry_color_name[i]);
			}


	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), tab_hbox_color, label);

	return tab_hbox_color;
}





/* -------------------------------------------------------------------
 * Style Set Page Make
 */
GtkWidget *make_page_style(GtkWidget *notebook, ENVSET_DLG *envset_dlg)
{
	char str[256];
	int i;
	GtkWidget *label;

	GtkWidget *tab_hbox_style;
		GtkWidget *vbox_label_style;
			GtkWidget *label_style_label;
		GtkWidget *vbox_entry_style_max;
//			GtkWidget *entry_style_max[7];
		GtkWidget *vbox_entry_style_min;
//			GtkWidget *entry_style_min[7];
		GtkWidget *vbox_entry_style_DisplayWidth;
//			GtkWidget *entry_style_DisplayWidth[7];
		GtkWidget *vbox_entry_style_PrinterWidth;
//			GtkWidget *entry_style_PrinterWidth[7];

	/* Style Set Page */
	label = gtk_label_new( _("Line Style") );
	/* ѥå󥰥ܥå(tab_hbox_style) */
	tab_hbox_style = gtk_hbox_new(0, 5);
	gtk_widget_show(tab_hbox_style);


		vbox_label_style = gtk_vbox_new(0, 0);
		gtk_box_pack_start((GtkBox *)GTK_BOX(tab_hbox_style), vbox_label_style, FALSE, TRUE, 5);
		gtk_widget_show(vbox_label_style);

			label_style_label = gtk_label_new( _("Line Style") );
//			gtk_misc_set_alignment(GTK_MISC(label_style_label), 0.0f, 1.0f);
			gtk_widget_set_usize (label_style_label, 100, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_style), label_style_label, FALSE, TRUE, 0);
			gtk_widget_show(label_style_label);

			label_style_label = gtk_label_new( _("0 : Solid 1") );
			gtk_misc_set_alignment(GTK_MISC(label_style_label), 0.0f, 1.0f);
			gtk_widget_set_usize (label_style_label, 100, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_style), label_style_label, FALSE, TRUE, 0);
			gtk_widget_show(label_style_label);

			label_style_label = gtk_label_new( _("1 : Solid 2") );
			gtk_misc_set_alignment(GTK_MISC(label_style_label), 0.0f, 1.0f);
			gtk_widget_set_usize (label_style_label, 100, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_style), label_style_label, FALSE, TRUE, 0);
			gtk_widget_show(label_style_label);

			label_style_label = gtk_label_new( _("2 : DOT") );
			gtk_misc_set_alignment(GTK_MISC(label_style_label), 0.0f, 1.0f);
			gtk_widget_set_usize (label_style_label, 100, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_style), label_style_label, FALSE, TRUE, 0);
			gtk_widget_show(label_style_label);

			label_style_label = gtk_label_new( _("3 : DASHDOT") );
			gtk_misc_set_alignment(GTK_MISC(label_style_label), 0.0f, 1.0f);
			gtk_widget_set_usize (label_style_label, 100, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_style), label_style_label, FALSE, TRUE, 0);
			gtk_widget_show(label_style_label);

			label_style_label = gtk_label_new( _("4 : PHANTOM") );
			gtk_misc_set_alignment(GTK_MISC(label_style_label), 0.0f, 1.0f);
			gtk_widget_set_usize (label_style_label, 100, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_style), label_style_label, FALSE, TRUE, 0);
			gtk_widget_show(label_style_label);

			label_style_label = gtk_label_new( _("5 : Dimension") );
			gtk_misc_set_alignment(GTK_MISC(label_style_label), 0.0f, 1.0f);
			gtk_widget_set_usize (label_style_label, 100, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_style), label_style_label, FALSE, TRUE, 0);
			gtk_widget_show(label_style_label);

			label_style_label = gtk_label_new( _("6 : Font") );
			gtk_misc_set_alignment(GTK_MISC(label_style_label), 0.0f, 1.0f);
			gtk_widget_set_usize (label_style_label, 100, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_style), label_style_label, FALSE, TRUE, 0);
			gtk_widget_show(label_style_label);


		vbox_entry_style_max = gtk_vbox_new(0, 0);
		gtk_box_pack_start((GtkBox *)GTK_BOX(tab_hbox_style), vbox_entry_style_max, FALSE, TRUE, 5);
		gtk_widget_show(vbox_entry_style_max);

			label_style_label = gtk_label_new("Max");
			gtk_widget_set_usize (label_style_label, 70, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_style_max), label_style_label, FALSE, TRUE, 0);
			gtk_widget_show(label_style_label);

			for (i = 0 ; i < 7 ; i++) {
				envset_dlg->entry_style_max[i] = gtk_entry_new();
				gtk_widget_set_usize (envset_dlg->entry_style_max[i], 70, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_style_max), envset_dlg->entry_style_max[i], FALSE, TRUE, 0);
				sprintf(str, "%d", envset_dlg->style_max[i]);
				gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_style_max[i]), str);	/*  */
				gtk_widget_show(envset_dlg->entry_style_max[i]);
			}


		vbox_entry_style_min = gtk_vbox_new(0, 0);
		gtk_box_pack_start((GtkBox *)GTK_BOX(tab_hbox_style), vbox_entry_style_min, FALSE, TRUE, 5);
		gtk_widget_show(vbox_entry_style_min);

			label_style_label = gtk_label_new("Min");
			gtk_widget_set_usize (label_style_label, 70, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_style_min), label_style_label, FALSE, TRUE, 0);
			gtk_widget_show(label_style_label);

			for (i = 0 ; i < 7 ; i++) {
				envset_dlg->entry_style_min[i] = gtk_entry_new();
				gtk_widget_set_usize (envset_dlg->entry_style_min[i], 70, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_style_min), envset_dlg->entry_style_min[i], FALSE, TRUE, 0);
				sprintf(str, "%d", envset_dlg->style_min[i]);
				gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_style_min[i]), str);	/*  */
				gtk_widget_show(envset_dlg->entry_style_min[i]);
			}


		vbox_entry_style_DisplayWidth = gtk_vbox_new(0, 0);
		gtk_box_pack_start((GtkBox *)GTK_BOX(tab_hbox_style), vbox_entry_style_DisplayWidth, FALSE, TRUE, 5);
		gtk_widget_show(vbox_entry_style_DisplayWidth);

			label_style_label = gtk_label_new("DisplayWidth");
			gtk_widget_set_usize (label_style_label, 80, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_style_DisplayWidth), label_style_label, FALSE, TRUE, 0);
			gtk_widget_show(label_style_label);

			for (i = 0 ; i < 7 ; i++) {
				envset_dlg->entry_style_DisplayWidth[i] = gtk_entry_new();
				gtk_widget_set_usize (envset_dlg->entry_style_DisplayWidth[i], 80, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_style_DisplayWidth), 
								   envset_dlg->entry_style_DisplayWidth[i], FALSE, TRUE, 0);
				sprintf(str, "%d", envset_dlg->style_DisplayWidth[i]);
				gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_style_DisplayWidth[i]), str);	/*  */
				gtk_widget_show(envset_dlg->entry_style_DisplayWidth[i]);
			}


		vbox_entry_style_PrinterWidth = gtk_vbox_new(0, 0);
		gtk_box_pack_start((GtkBox *)GTK_BOX(tab_hbox_style), vbox_entry_style_PrinterWidth, FALSE, TRUE, 5);
		gtk_widget_show(vbox_entry_style_PrinterWidth);

			label_style_label = gtk_label_new("PrinterWidth");
			gtk_widget_set_usize (label_style_label, 80, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_style_PrinterWidth), label_style_label, FALSE, TRUE, 0);
			gtk_widget_show(label_style_label);

			for (i = 0 ; i < 7 ; i++) {
				envset_dlg->entry_style_PrinterWidth[i] = gtk_entry_new();
				gtk_widget_set_usize (envset_dlg->entry_style_PrinterWidth[i], 80, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_style_PrinterWidth), 
								   envset_dlg->entry_style_PrinterWidth[i], FALSE, TRUE, 0);
				sprintf(str, "%d", envset_dlg->style_PrinterWidth[i]);
				gtk_entry_set_text(GTK_ENTRY(envset_dlg->entry_style_PrinterWidth[i]), str);	/*  */
				gtk_widget_show(envset_dlg->entry_style_PrinterWidth[i]);
			}


	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), tab_hbox_style, label);

	return tab_hbox_style;
}





/* -------------------------------------------------------------------
 * Ķ (Environment Setting)
 * 
 */
gint EnvSetDialog(ENVSET_DLG *envset_dlg)
{
//	char str[256];

//	GtkWidget *dialog;
		GtkWidget *main_vbox;
			GtkWidget *notebook;

			GtkWidget *separator;
			GtkWidget *action_hbox;
				GtkWidget *cancel_buttun;
				GtkWidget *ok_buttun;


//g_print("EnvSetDlg.c : EnvSetDialog() : in");

	/* (envset_dlg->dialog) */
	envset_dlg->dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_position(GTK_WINDOW(envset_dlg->dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(envset_dlg->dialog), _("Environment Setting") );
//	gtk_signal_connect( GTK_OBJECT(envset_dlg->dialog), "key_press_event",
//						GTK_SIGNAL_FUNC(envset_dlg_key_press_event), envset_dlg);


		/* ˤޤѥå󥰥ܥå(main_vbox) */
		main_vbox = gtk_vbox_new(0, 5);
		gtk_container_add(GTK_CONTAINER(envset_dlg->dialog), main_vbox);
		gtk_container_border_width(GTK_CONTAINER(envset_dlg->dialog), 5);
		gtk_widget_show(main_vbox);





			/* NoteBook  */
			notebook = gtk_notebook_new();
			gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_TOP);
			gtk_container_add(GTK_CONTAINER(main_vbox), notebook);
			gtk_widget_show(notebook);


				/* User Page Make */
				make_page_user(notebook, envset_dlg);

				/* Path Set Page Make */
				make_page_path(notebook, envset_dlg);

				/* Command Set Page Make */
				make_page_command(notebook, envset_dlg);

				/* System Page Make */
				make_page_system(notebook, envset_dlg);

				/* Dimension Page Make */
				make_page_dimension(notebook, envset_dlg);

				/* System Color Page Make */
				make_page_system_color(notebook, envset_dlg);

				/* Color Page Make */
				make_page_color(notebook, envset_dlg);

				/* Style Page Make */
				make_page_style(notebook, envset_dlg);

			gtk_widget_show(notebook);





		/* ѥ졼(separator) */
		separator = gtk_hseparator_new();
		gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
		gtk_widget_show(separator);



		/* ѥå󥰥ܥå(action_hbox) */
		action_hbox = gtk_hbox_new(FALSE, 2);
		gtk_box_pack_start( GTK_BOX(main_vbox), action_hbox, TRUE, TRUE, 0);
		gtk_widget_show(action_hbox);

			/* -----------------------------------------------------
			 * ѥå󥰥ܥå(action_hbox) 
			 * ܥ(cancel_buttun & ok_buttun) 
			 * Ǽ
			 */
			/* CANCELܥ */
			cancel_buttun = gtk_button_new_with_label("CANCEL");
			gtk_widget_set_usize (cancel_buttun, 80, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), cancel_buttun, TRUE, TRUE, 2);
			gtk_signal_connect( GTK_OBJECT(cancel_buttun), "clicked", GTK_SIGNAL_FUNC(envset_dlg_cancel_pushed), envset_dlg);
			gtk_signal_connect( GTK_OBJECT(cancel_buttun), "clicked", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
			gtk_widget_show(cancel_buttun);

			/* OKܥ */
			ok_buttun = gtk_button_new_with_label("OK");
			gtk_widget_set_usize (ok_buttun, 80, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), ok_buttun, TRUE, TRUE, 2);
			gtk_signal_connect(GTK_OBJECT(ok_buttun), "clicked", GTK_SIGNAL_FUNC(envset_dlg_ok_pushed), envset_dlg);
			gtk_signal_connect(GTK_OBJECT(ok_buttun), "clicked", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
		//	  GTK_WIDGET_SET_FLAGS(ok_buttun, GTK_CAN_DEFAULT);
		//	  gtk_widget_grab_default(ok_buttun);
			gtk_widget_show(ok_buttun);



	/* ̤ɽ */
	gtk_window_set_modal(GTK_WINDOW(envset_dlg->dialog), TRUE);
	/* ᥤ󥦥ɥǤʤ褦 */
	gtk_window_set_transient_for(GTK_WINDOW(envset_dlg->dialog), GTK_WINDOW(envset_dlg->parent));


	/* Ļ֤ */
	gtk_widget_show(envset_dlg->dialog);
	/* ᥤ󥤥٥ȥ롼 */
	gtk_main();
	gtk_widget_destroy(envset_dlg->dialog);
	return 0; 
}





/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : EnvSetDlg.c
 * ====================================================================
 */
