/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : CulcInputDlg.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/03/09
 *    Last                 : 2003/03/09
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
//#include <math.h>

#include "Trace.h"
#include "StringCulc.h"
#define _CULCINPUTDLG_
#include "CulcInputDlg.h"


/*  ե entry  */
void def_focus(CULCINPUT_DLG *culcinput_dlg)
{
	gtk_window_set_focus(GTK_WINDOW(culcinput_dlg->dialog), culcinput_dlg->entry);
}



/* -------------------------------------------------------------------
 * [=] Button Pushed
 */
void button_pushed_eq(GtkWidget *widget, CULCINPUT_DLG *culcinput_dlg)
{
	char str[256];
	double d_value;

	/* ƥȥȥ꡼ʸ */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(culcinput_dlg->entry)));
	/* η׻򤷤֤ */
	d_value = StringCulc(str);
	FloatOut_n(str, d_value, 6, 0);
	/*  */
	gtk_entry_set_text(GTK_ENTRY(culcinput_dlg->entry), str);
	def_focus(culcinput_dlg);
}



/* -------------------------------------------------------------------
 * [0] Button Pushed
 */
void button_pushed_0(GtkWidget *widget, CULCINPUT_DLG *culcinput_dlg)
{
	char str[256];

	/* ƥȥȥ꡼ʸ */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(culcinput_dlg->entry)));
	strcat(str, "0");
	/*  */
	gtk_entry_set_text(GTK_ENTRY(culcinput_dlg->entry), str);
	def_focus(culcinput_dlg);
}



/* -------------------------------------------------------------------
 * [1] Button Pushed
 */
void button_pushed_1(GtkWidget *widget, CULCINPUT_DLG *culcinput_dlg)
{
	char str[256];

	/* ƥȥȥ꡼ʸ */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(culcinput_dlg->entry)));
	strcat(str, "1");
	/*  */
	gtk_entry_set_text(GTK_ENTRY(culcinput_dlg->entry), str);
	def_focus(culcinput_dlg);
}



/* -------------------------------------------------------------------
 * [2] Button Pushed
 */
void button_pushed_2(GtkWidget *widget, CULCINPUT_DLG *culcinput_dlg)
{
	char str[256];

	/* ƥȥȥ꡼ʸ */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(culcinput_dlg->entry)));
	strcat(str, "2");
	/*  */
	gtk_entry_set_text(GTK_ENTRY(culcinput_dlg->entry), str);
	def_focus(culcinput_dlg);
}



/* -------------------------------------------------------------------
 * [3] Button Pushed
 */
void button_pushed_3(GtkWidget *widget, CULCINPUT_DLG *culcinput_dlg)
{
	char str[256];

	/* ƥȥȥ꡼ʸ */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(culcinput_dlg->entry)));
	strcat(str, "3");
	/*  */
	gtk_entry_set_text(GTK_ENTRY(culcinput_dlg->entry), str);
	def_focus(culcinput_dlg);
}



/* -------------------------------------------------------------------
 * [4] Button Pushed
 */
void button_pushed_4(GtkWidget *widget, CULCINPUT_DLG *culcinput_dlg)
{
	char str[256];

	/* ƥȥȥ꡼ʸ */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(culcinput_dlg->entry)));
	strcat(str, "4");
	/*  */
	gtk_entry_set_text(GTK_ENTRY(culcinput_dlg->entry), str);
	def_focus(culcinput_dlg);
}



/* -------------------------------------------------------------------
 * [5] Button Pushed
 */
void button_pushed_5(GtkWidget *widget, CULCINPUT_DLG *culcinput_dlg)
{
	char str[256];

	/* ƥȥȥ꡼ʸ */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(culcinput_dlg->entry)));
	strcat(str, "5");
	/*  */
	gtk_entry_set_text(GTK_ENTRY(culcinput_dlg->entry), str);
	def_focus(culcinput_dlg);
}



/* -------------------------------------------------------------------
 * [6] Button Pushed
 */
void button_pushed_6(GtkWidget *widget, CULCINPUT_DLG *culcinput_dlg)
{
	char str[256];

	/* ƥȥȥ꡼ʸ */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(culcinput_dlg->entry)));
	strcat(str, "6");
	/*  */
	gtk_entry_set_text(GTK_ENTRY(culcinput_dlg->entry), str);
	def_focus(culcinput_dlg);
}



/* -------------------------------------------------------------------
 * [7] Button Pushed
 */
void button_pushed_7(GtkWidget *widget, CULCINPUT_DLG *culcinput_dlg)
{
	char str[256];

	/* ƥȥȥ꡼ʸ */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(culcinput_dlg->entry)));
	strcat(str, "7");
	/*  */
	gtk_entry_set_text(GTK_ENTRY(culcinput_dlg->entry), str);
	def_focus(culcinput_dlg);
}



/* -------------------------------------------------------------------
 * [8] Button Pushed
 */
void button_pushed_8(GtkWidget *widget, CULCINPUT_DLG *culcinput_dlg)
{
	char str[256];

	/* ƥȥȥ꡼ʸ */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(culcinput_dlg->entry)));
	strcat(str, "8");
	/*  */
	gtk_entry_set_text(GTK_ENTRY(culcinput_dlg->entry), str);
	def_focus(culcinput_dlg);
}



/* -------------------------------------------------------------------
 * [9] Button Pushed
 */
void button_pushed_9(GtkWidget *widget, CULCINPUT_DLG *culcinput_dlg)
{
	char str[256];

	/* ƥȥȥ꡼ʸ */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(culcinput_dlg->entry)));
	strcat(str, "9");
	/*  */
	gtk_entry_set_text(GTK_ENTRY(culcinput_dlg->entry), str);
	def_focus(culcinput_dlg);
}

/* -------------------------------------------------------------------
 * [.] Button Pushed
 */
void button_pushed_pt(GtkWidget *widget, CULCINPUT_DLG *culcinput_dlg)
{
	char str[256];

	/* ƥȥȥ꡼ʸ */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(culcinput_dlg->entry)));
	strcat(str, ".");
	/*  */
	gtk_entry_set_text(GTK_ENTRY(culcinput_dlg->entry), str);
	def_focus(culcinput_dlg);
}





/* -------------------------------------------------------------------
 * [C] Button Pushed
 */
void button_pushed_C(GtkWidget *widget, CULCINPUT_DLG *culcinput_dlg)
{
	char str[256];

	str[0] = '\0';
	/*  */
	gtk_entry_set_text(GTK_ENTRY(culcinput_dlg->entry), str);
	def_focus(culcinput_dlg);
}

/* -------------------------------------------------------------------
 * [+] Button Pushed
 */
void button_pushed_addition(GtkWidget *widget, CULCINPUT_DLG *culcinput_dlg)
{
	char str[256];

	/* ƥȥȥ꡼ʸ */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(culcinput_dlg->entry)));
	strcat(str, "+");
	/*  */
	gtk_entry_set_text(GTK_ENTRY(culcinput_dlg->entry), str);
	def_focus(culcinput_dlg);
}

/* -------------------------------------------------------------------
 * [-] Button Pushed
 */
void button_pushed_subtraction(GtkWidget *widget, CULCINPUT_DLG *culcinput_dlg)
{
	char str[256];

	/* ƥȥȥ꡼ʸ */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(culcinput_dlg->entry)));
	strcat(str, "-");
	/*  */
	gtk_entry_set_text(GTK_ENTRY(culcinput_dlg->entry), str);
	def_focus(culcinput_dlg);
}

/* -------------------------------------------------------------------
 * [*] Button Pushed
 */
void button_pushed_multiplication(GtkWidget *widget, CULCINPUT_DLG *culcinput_dlg)
{
	char str[256];

	/* ƥȥȥ꡼ʸ */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(culcinput_dlg->entry)));
	strcat(str, "*");
	/*  */
	gtk_entry_set_text(GTK_ENTRY(culcinput_dlg->entry), str);
	def_focus(culcinput_dlg);
}

/* -------------------------------------------------------------------
 * [/] Button Pushed
 */
void button_pushed_division(GtkWidget *widget, CULCINPUT_DLG *culcinput_dlg)
{
	char str[256];

	/* ƥȥȥ꡼ʸ */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(culcinput_dlg->entry)));
	strcat(str, "/");
	/*  */
	gtk_entry_set_text(GTK_ENTRY(culcinput_dlg->entry), str);
	def_focus(culcinput_dlg);
}

/* -------------------------------------------------------------------
 * [(] Button Pushed
 */
void button_pushed_open_brackets(GtkWidget *widget, CULCINPUT_DLG *culcinput_dlg)
{
	char str[256];

	/* ƥȥȥ꡼ʸ */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(culcinput_dlg->entry)));
	strcat(str, "(");
	/*  */
	gtk_entry_set_text(GTK_ENTRY(culcinput_dlg->entry), str);
	def_focus(culcinput_dlg);
}

/* -------------------------------------------------------------------
 * [)] Button Pushed
 */
void button_pushed_closed_brackets(GtkWidget *widget, CULCINPUT_DLG *culcinput_dlg)
{
	char str[256];

	/* ƥȥȥ꡼ʸ */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(culcinput_dlg->entry)));
	strcat(str, ")");
	/*  */
	gtk_entry_set_text(GTK_ENTRY(culcinput_dlg->entry), str);
	def_focus(culcinput_dlg);
}



/* -------------------------------------------------------------------
 * CANCEL
 */
void culcinput_dlg_cancel_pushed(GtkWidget *widget, CULCINPUT_DLG *culcinput_dlg)
{
	culcinput_dlg->value = 0;
	culcinput_dlg->anser = 0;
	strcpy(culcinput_dlg->default_str, "");
}



/* -------------------------------------------------------------------
 * OK
 */
void culcinput_dlg_ok_pushed(GtkWidget *widget, CULCINPUT_DLG *culcinput_dlg)
{
	/* ƥȥȥ꡼ʸ */
	strcpy(culcinput_dlg->default_str, gtk_entry_get_text(GTK_ENTRY(culcinput_dlg->entry)));

	/* η׻򤷤֤ */
	culcinput_dlg->anser = StringCulc(culcinput_dlg->default_str);

	FloatOut_n(culcinput_dlg->default_str, culcinput_dlg->anser, 6, 0);

	strcpy(def_str, culcinput_dlg->default_str);
	culcinput_dlg->value = 1;
}



/* -------------------------------------------------------------------
 * 줿٥
 * key_press_event
 */
static gint culcinput_dlg_key_press_event(GtkWidget *widget, GdkEventKey *event, CULCINPUT_DLG *culcinput_dlg)
{
//	g_print("sagcad.c : culcinput_dlg_key_press_event  state:%d  keyval:0x%x  length:%d  string:%s\n", 
//			event->state, event->keyval, event->length, event->string);

	if (event->keyval == 0xff0d || event->keyval == 0xff8d) {		/* Enter */
		culcinput_dlg_ok_pushed(widget, culcinput_dlg);
		gtk_main_quit();
	}

	return TRUE; 
}



/* -------------------------------------------------------------------
 * ǡϥ
 * 
 */
gint CulcInputDialog(CULCINPUT_DLG *culcinput_dlg)
{
//	char str[256];

//	GtkWidget *dialog;
		GtkWidget *main_vbox;
			GtkWidget *vbox;
				GtkWidget *msg1_label;
				GtkWidget *msg2_label;
//				GtkWidget *entryl;

//			GtkWidget *separator;

			GtkWidget *table;
				GtkWidget *button_0;
				GtkWidget *button_1;
				GtkWidget *button_2;
				GtkWidget *button_3;
				GtkWidget *button_4;
				GtkWidget *button_5;
				GtkWidget *button_6;
				GtkWidget *button_7;
				GtkWidget *button_8;
				GtkWidget *button_9;
				GtkWidget *button_point;
				GtkWidget *button_addition;
				GtkWidget *button_subtraction;
				GtkWidget *button_multiplication;
				GtkWidget *button_division;
				GtkWidget *button_clear;

				GtkWidget *button_open_brackets;
				GtkWidget *button_closed_brackets;
				GtkWidget *button_equal;

			GtkWidget *separator;
			GtkWidget *action_hbox;
				GtkWidget *cancel_buttun;
				GtkWidget *ok_buttun;


	/* (culcinput_dlg->dialog) */
	culcinput_dlg->dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_position(GTK_WINDOW(culcinput_dlg->dialog), GTK_WIN_POS_MOUSE/*GTK_WIN_POS_CENTER*/);
	gtk_window_set_title(GTK_WINDOW(culcinput_dlg->dialog), culcinput_dlg->title);
	gtk_signal_connect( GTK_OBJECT(culcinput_dlg->dialog), "key_press_event",
						GTK_SIGNAL_FUNC(culcinput_dlg_key_press_event), culcinput_dlg);



		/* ˤޤѥå󥰥ܥå(main_vbox) */
		main_vbox = gtk_vbox_new(0, 5);
		gtk_container_add(GTK_CONTAINER(culcinput_dlg->dialog), main_vbox);
		gtk_container_border_width(GTK_CONTAINER(culcinput_dlg->dialog), 5);
		gtk_widget_show(main_vbox);



			/* -----------------------------------------------------
			 * ѥå󥰥ܥå(main_vbox) 
			 * ѥå󥰥ܥå(vbox & table & action_hbox) 
			 * Ǽ
			 */
			/* ѥå󥰥ܥå(hbox) */
			vbox = gtk_vbox_new(FALSE, 2);
			gtk_box_pack_start( (GtkBox *)GTK_BOX(main_vbox), 
								vbox, TRUE, TRUE, 0);
			gtk_widget_show(vbox);


				/* ٥(msg1_label)κ */
				if (culcinput_dlg->msg1[0] != '\0') {
					msg1_label = gtk_label_new(culcinput_dlg->msg1);
//					gtk_widget_set_usize (msg1_label, 100, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(vbox), msg1_label, TRUE, TRUE, 0);
					gtk_widget_show(msg1_label);
				}

				/* ٥(msg2_label)κ */
				if (culcinput_dlg->msg2[0] != '\0') {
					msg2_label = gtk_label_new(culcinput_dlg->msg2);
//					gtk_widget_set_usize (msg2_label, 100, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(vbox), msg2_label, TRUE, TRUE, 0);
					gtk_widget_show(msg2_label);
				}

				/* ƥȥȥ꡼(culcinput_dlg->entry) */
				culcinput_dlg->entry = gtk_entry_new();
//				gtk_widget_set_usize (culcinput_dlg->entry, 150, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(vbox), culcinput_dlg->entry, TRUE, TRUE, 1);
				/*  */
				if (strlen(culcinput_dlg->default_str) == 0) {
					strcpy(culcinput_dlg->default_str, def_str);
					//g_print("default == Before String\n");
				}
//				else {
//					g_print("default != New String\n");
//				}
				gtk_entry_set_text(GTK_ENTRY(culcinput_dlg->entry), culcinput_dlg->default_str);
				//gtk_signal_connect (GTK_OBJECT(entry), "activate", GTK_SIGNAL_FUNC(entry_callback), NULL);
				gtk_widget_show(culcinput_dlg->entry);



			/* ѥ졼(separator) */
			separator = gtk_hseparator_new();
			gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
			gtk_widget_show(separator);



			/* ơ֥ѥå(table) */
			table = gtk_table_new(4, 5, FALSE);
			gtk_box_pack_start( GTK_BOX(main_vbox), table, TRUE, TRUE, 0);
			gtk_widget_show(table);


				/* button_0 */
				button_0 = gtk_button_new_with_label("0");
				gtk_table_attach_defaults(GTK_TABLE(table), button_0, 0, 2, 3, 4);
				gtk_signal_connect(GTK_OBJECT(button_0), 
								   "clicked", 
								   GTK_SIGNAL_FUNC(button_pushed_0), 
								   culcinput_dlg);
				gtk_widget_show(button_0);

				/* button_1 */
				button_1 = gtk_button_new_with_label("1");
				gtk_table_attach_defaults(GTK_TABLE(table), button_1, 0, 1, 2, 3);
				gtk_signal_connect(GTK_OBJECT(button_1), 
								   "clicked", 
								   GTK_SIGNAL_FUNC(button_pushed_1), 
								   culcinput_dlg);
				gtk_widget_show(button_1);

				/* button_2 */
				button_2 = gtk_button_new_with_label("2");
				gtk_table_attach_defaults(GTK_TABLE(table), button_2, 1, 2, 2, 3);
				gtk_signal_connect(GTK_OBJECT(button_2), 
								   "clicked", 
								   GTK_SIGNAL_FUNC(button_pushed_2), 
								   culcinput_dlg);
				gtk_widget_show(button_2);

				/* button_3 */
				button_3 = gtk_button_new_with_label("3");
				gtk_table_attach_defaults(GTK_TABLE(table), button_3, 2, 3, 2, 3);
				gtk_signal_connect(GTK_OBJECT(button_3), 
								   "clicked", 
								   GTK_SIGNAL_FUNC(button_pushed_3), 
								   culcinput_dlg);
				gtk_widget_show(button_3);

				/* button_4 */
				button_4 = gtk_button_new_with_label("4");
				gtk_table_attach_defaults(GTK_TABLE(table), button_4, 0, 1, 1, 2);
				gtk_signal_connect(GTK_OBJECT(button_4), 
								   "clicked", 
								   GTK_SIGNAL_FUNC(button_pushed_4), 
								   culcinput_dlg);
				gtk_widget_show(button_4);

				/* button_5 */
				button_5 = gtk_button_new_with_label("5");
				gtk_table_attach_defaults(GTK_TABLE(table), button_5, 1, 2, 1, 2);
				gtk_signal_connect(GTK_OBJECT(button_5), 
								   "clicked", 
								   GTK_SIGNAL_FUNC(button_pushed_5), 
								   culcinput_dlg);
				gtk_widget_show(button_5);

				/* button_6 */
				button_6 = gtk_button_new_with_label("6");
				gtk_table_attach_defaults(GTK_TABLE(table), button_6, 2, 3, 1, 2);
				gtk_signal_connect(GTK_OBJECT(button_6), 
								   "clicked", 
								   GTK_SIGNAL_FUNC(button_pushed_6), 
								   culcinput_dlg);
				gtk_widget_show(button_6);

				/* button_7 */
				button_7 = gtk_button_new_with_label("7");
				gtk_table_attach_defaults(GTK_TABLE(table), button_7, 0, 1, 0, 1);
				gtk_signal_connect(GTK_OBJECT(button_7), 
								   "clicked", 
								   GTK_SIGNAL_FUNC(button_pushed_7), 
								   culcinput_dlg);
				gtk_widget_show(button_7);

				/* button_8 */
				button_8 = gtk_button_new_with_label("8");
				gtk_table_attach_defaults(GTK_TABLE(table), button_8, 1, 2, 0, 1);
				gtk_signal_connect(GTK_OBJECT(button_8), 
								   "clicked", 
								   GTK_SIGNAL_FUNC(button_pushed_8), 
								   culcinput_dlg);
				gtk_widget_show(button_8);

				/* button_9 */
				button_9 = gtk_button_new_with_label("9");
				gtk_table_attach_defaults(GTK_TABLE(table), button_9, 2, 3, 0, 1);
				gtk_signal_connect(GTK_OBJECT(button_9), 
								   "clicked", 
								   GTK_SIGNAL_FUNC(button_pushed_9), 
								   culcinput_dlg);
				gtk_widget_show(button_9);


				/* button_point */
				button_point = gtk_button_new_with_label(".");
				gtk_table_attach_defaults(GTK_TABLE(table), button_point, 2, 3, 3, 4);
				gtk_signal_connect(GTK_OBJECT(button_point), 
								   "clicked", 
								   GTK_SIGNAL_FUNC(button_pushed_pt), 
								   culcinput_dlg);
				gtk_widget_show(button_point);

				/* + */
				button_addition = gtk_button_new_with_label("+");
				gtk_table_attach_defaults(GTK_TABLE(table), button_addition, 3, 4, 3, 4);
				gtk_signal_connect(GTK_OBJECT(button_addition), 
								   "clicked", 
								   GTK_SIGNAL_FUNC(button_pushed_addition), 
								   culcinput_dlg);
				gtk_widget_show(button_addition);

				/* - */
				button_subtraction = gtk_button_new_with_label("-");
				gtk_table_attach_defaults(GTK_TABLE(table), button_subtraction, 3, 4, 2, 3);
				gtk_signal_connect(GTK_OBJECT(button_subtraction), 
								   "clicked", 
								   GTK_SIGNAL_FUNC(button_pushed_subtraction), 
								   culcinput_dlg);
				gtk_widget_show(button_subtraction);

				/* * */
				button_multiplication = gtk_button_new_with_label("X");
				gtk_table_attach_defaults(GTK_TABLE(table), button_multiplication, 3, 4, 1, 2);
				gtk_signal_connect(GTK_OBJECT(button_multiplication), 
								   "clicked", 
								   GTK_SIGNAL_FUNC(button_pushed_multiplication), 
								   culcinput_dlg);
				gtk_widget_show(button_multiplication);

				/* / */
				button_division = gtk_button_new_with_label("/");
				gtk_table_attach_defaults(GTK_TABLE(table), button_division, 3, 4, 0, 1);
				gtk_signal_connect(GTK_OBJECT(button_division), 
								   "clicked", 
								   GTK_SIGNAL_FUNC(button_pushed_division), 
								   culcinput_dlg);
				gtk_widget_show(button_division);

				/* button_clear */
				button_clear = gtk_button_new_with_label("C");
				gtk_table_attach_defaults(GTK_TABLE(table), button_clear, 4, 5, 2, 3);
				gtk_signal_connect(GTK_OBJECT(button_clear), 
								   "clicked", 
								   GTK_SIGNAL_FUNC(button_pushed_C), 
								   culcinput_dlg);
				gtk_widget_show(button_clear);


				/* button_open_brackets */
				button_open_brackets = gtk_button_new_with_label("(");
				gtk_table_attach_defaults(GTK_TABLE(table), button_open_brackets, 4, 5, 0, 1);
				gtk_signal_connect(GTK_OBJECT(button_open_brackets), 
								   "clicked", 
								   GTK_SIGNAL_FUNC(button_pushed_open_brackets), 
								   culcinput_dlg);
				gtk_widget_show(button_open_brackets);

				/* button_closed_brackets */
				button_closed_brackets = gtk_button_new_with_label(")");
				gtk_table_attach_defaults(GTK_TABLE(table), button_closed_brackets, 4, 5, 1, 2);
				gtk_signal_connect(GTK_OBJECT(button_closed_brackets), 
								   "clicked", 
								   GTK_SIGNAL_FUNC(button_pushed_closed_brackets), 
								   culcinput_dlg);
				gtk_widget_show(button_closed_brackets);

				/* button_equal */
				button_equal = gtk_button_new_with_label("=");
				gtk_table_attach_defaults(GTK_TABLE(table), button_equal, 4, 5, 3, 4);
				gtk_signal_connect(GTK_OBJECT(button_equal), 
								   "clicked", 
								   GTK_SIGNAL_FUNC(button_pushed_eq), 
								   culcinput_dlg);
				gtk_widget_show(button_equal);



		/* ѥ졼(separator) */
		separator = gtk_hseparator_new();
		gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
		gtk_widget_show(separator);



		/* ѥå󥰥ܥå(action_hbox) */
		action_hbox = gtk_hbox_new(FALSE, 2);
		gtk_box_pack_start( GTK_BOX(main_vbox), action_hbox, TRUE, TRUE, 0);
		gtk_widget_show(action_hbox);

			/* -----------------------------------------------------
			 * ѥå󥰥ܥå(action_hbox) 
			 * ܥ(cancel_buttun & ok_buttun) 
			 * Ǽ
			 */
			/* CANCELܥ */
			cancel_buttun = gtk_button_new_with_label("CANCEL");
//			gtk_widget_set_usize (cancel_buttun, 80, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), cancel_buttun, TRUE, TRUE, 2);
			gtk_signal_connect( GTK_OBJECT(cancel_buttun), "clicked", GTK_SIGNAL_FUNC(culcinput_dlg_cancel_pushed), culcinput_dlg);
			gtk_signal_connect( GTK_OBJECT(cancel_buttun), "clicked", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
			gtk_widget_show(cancel_buttun);

			/* OKܥ */
			ok_buttun = gtk_button_new_with_label("OK");
//			gtk_widget_set_usize (ok_buttun, 80, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), ok_buttun, TRUE, TRUE, 2);
			gtk_signal_connect(GTK_OBJECT(ok_buttun), "clicked", GTK_SIGNAL_FUNC(culcinput_dlg_ok_pushed), culcinput_dlg);
			gtk_signal_connect(GTK_OBJECT(ok_buttun), "clicked", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
		//	  GTK_WIDGET_SET_FLAGS(ok_buttun, GTK_CAN_DEFAULT);
		//	  gtk_widget_grab_default(ok_buttun);
			gtk_widget_show(ok_buttun);





	/*  ե entry  */
	gtk_window_set_focus(GTK_WINDOW(culcinput_dlg->dialog), culcinput_dlg->entry);
	gtk_entry_select_region( GTK_ENTRY(culcinput_dlg->entry), 0, 
							 GTK_ENTRY(culcinput_dlg->entry)->text_length);


	/* ̤ɽ */
	gtk_window_set_modal(GTK_WINDOW(culcinput_dlg->dialog), TRUE);
	/* ᥤ󥦥ɥǤʤ褦 */
	gtk_window_set_transient_for(GTK_WINDOW(culcinput_dlg->dialog), GTK_WINDOW(culcinput_dlg->parent));


	/* Ļ֤ */
	gtk_widget_show(culcinput_dlg->dialog);
	/* ᥤ󥤥٥ȥ롼 */
	gtk_main();
	gtk_widget_destroy(culcinput_dlg->dialog);
	return 0; 
}





/* -------------------------------------------------------------------
 * ǡϥ
 * 
 */
gint CulcInputBox(GtkWidget *widget, char *title, char *msg1, char *msg2, char *default_str)
{
	CULCINPUT_DLG a;
//	int Ret;


	a.value = 0;
	strcpy(a.title, title);
	strcpy(a.msg1, msg1);
	strcpy(a.msg2, msg2);
	strcpy(a.default_str, default_str);
	a.push_str = 0;
	a.anser = 0;
	a.entry = NULL;
	a.parent = widget;
	a.dialog = NULL;

	CulcInputDialog(&a);
	if (a.value == 0) {
		return -1;
	}
	strcpy(default_str, a.default_str);

	return 1;
}





/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : CulcInputDlg.c
 * ====================================================================
 */
