/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : CopyFunc.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *	  Begin 			   : 2001/03/14
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifndef __COPYFUNC_H__
#define __COPYFUNC_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 :   (struct #define etc)
 * -------------------------------------------------------
 */



/* -------------------------------------------------------
 * 2 : ѿ (global)
 * -------------------------------------------------------
 */
#ifdef _COPYFUNC_
#define   GLOBAL
// 
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// ʬ̵
#define   GLOBAL_VAL(v)  /* */
#endif




#undef	GLOBAL
#undef	GLOBAL_VAL
#undef _COPYFUNC_



/* -------------------------------------------------------
 * 3 : ؿ (Function)
 * -------------------------------------------------------
 */
/* CAD DATA a  ٥ȥ(x,y) ʿ԰ư޷Ѵ֤ */
int Parallel(SELECT *select, double x, double y);
/* CAD DATA a  (x,y) 濴 Angle ٲžư޷Ѵ֤ */
int Rotation(SELECT *select, double x, double y, double Angle);
/* CAD DATA a  ľ(sx,sy)-(ex,ey) 濴 оΰư޷Ѵ֤ */
int Mirror(SELECT *select, double sx, double sy, double ex, double ey);
/* CAD DATA a  (x,y) 濴 k ܤ޷Ѵ֤ */
int Scaling(SELECT *select, double x, double y, double k);


/* 쥯ȿ޷ ԥå(x,y),  Repeat ǰưޤʣ̤
 * (Repeat=1 ư	Repeat>1 ʣ)
 */
int CopyPara(double x, double y, int Repeat);

/* 쥯ȿ޷ (x,y),  Angle,  Repeat ǰưޤʣ̤
 * (Repeat=1 ư	Repeat>1 ʣ)
 */
int CopyRoll(double x, double y, double angle, int Repeat);

/* 쥯ȿ޷ ľ(sx,sy)-(ex,ey) 򼴤 оΰưޤʣ̤
 * (Repeat=1 ư	Repeat=2 ʣ)
 */
int CopyMirr(double sx, double sy, double ex, double ey, int Repeat);

/* 쥯ȿ޷  (x,y) 濴 k ܤ޷Ѵ
 * (ο޷򤤤)
 */
int CopyScaling(double x, double y, double k, int Frag);

/* 쥯ȿ޷ 
 * X Υԥå x, Y Υԥå y, X β RepeatX, Yβ RepeatY
 * ʣ̤
 */
int CopyKousi(double x, double y, int RepeatX, int RepeatY);

int AssistLineCopy(DIMENSION *copy_dimension, DIMENSION *org_dimension);

int ScalingXY(SELECT *select, double x, double y, double kx, double ky);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __COPYFUNC_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : CopyFunc.h
 * ====================================================================
 */
