/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : EllipseSetDlg.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/04/19
 *    Last                 : 2007/11/08
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "intl.h"
#include "culcfunc.h"

#define _ELLIPSESETDLG_
#include "EllipseSetDlg.h"




/* -------------------------------------------------------------------
 * CANCEL
 */
void ellipse_set_dlg_cancel_pushed(GtkWidget *widget, ELLIPSE_SET_DLG *ellipse_set_dlg)
{
	ellipse_set_dlg->value = 0;
}



/* -------------------------------------------------------------------
 * OK
 */
void ellipse_set_dlg_ok_pushed(GtkWidget *widget, ELLIPSE_SET_DLG *ellipse_set_dlg)
{
	char str[256];


	/* テキストエントリーから文字列を取得 */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(ellipse_set_dlg->cx_entry)));
	ellipse_set_dlg->cx = atof(str);

	strcpy(str, gtk_entry_get_text(GTK_ENTRY(ellipse_set_dlg->cy_entry)));
	ellipse_set_dlg->cy = atof(str);

	strcpy(str, gtk_entry_get_text(GTK_ENTRY(ellipse_set_dlg->long_r_entry)));
	ellipse_set_dlg->long_r = atof(str);

	strcpy(str, gtk_entry_get_text(GTK_ENTRY(ellipse_set_dlg->k_entry)));
	ellipse_set_dlg->k = atof(str);

	strcpy(str, gtk_entry_get_text(GTK_ENTRY(ellipse_set_dlg->angle_entry)));
	ellipse_set_dlg->angle = atof(str);

	strcpy(str, gtk_entry_get_text(GTK_ENTRY(ellipse_set_dlg->sa_entry)));
	ellipse_set_dlg->sa = atof(str);

	strcpy(str, gtk_entry_get_text(GTK_ENTRY(ellipse_set_dlg->ea_entry)));
	ellipse_set_dlg->ea = atof(str);

	ellipse_set_dlg->value = 1;
}



/* -------------------------------------------------------------------
 * キーが押されたイベント
 * key_press_event
 */
static gint ellipse_set_dlg_key_press_event(GtkWidget *widget, GdkEventKey *event, ELLIPSE_SET_DLG *ellipse_set_dlg)
{
//	g_print("sagcad.c : ellipse_set_dlg_key_press_event  state:%d  keyval:0x%x  length:%d  string:%s\n", 
//			event->state, event->keyval, event->length, event->string);


	if (event->keyval == 0xff0d || event->keyval == 0xff8d) {		/* Enter */
		ellipse_set_dlg_ok_pushed(widget, ellipse_set_dlg);
		gtk_main_quit();
	}
	return TRUE; 
}





/* -------------------------------------------------------------------
 * コピー【移動/複写】設定
 * 
 */
gint EllipseSetDialog(ELLIPSE_SET_DLG *ellipse_set_dlg)
{
	char str[256];

//	GtkWidget *dialog;
	GtkWidget *main_vbox;
		GtkWidget *hbox;
			GtkWidget *label_vbox;
				GtkWidget *cx_label;
				GtkWidget *cy_label;
				GtkWidget *long_r_label;
				GtkWidget *k_label;
				GtkWidget *angle_label;
				GtkWidget *sa_label;
				GtkWidget *ea_label;

			GtkWidget *entry_vbox;
//				GtkWidget *cx_entry;
//				GtkWidget *cy_entry;
//				GtkWidget *long_r_entry;
//				GtkWidget *k_entry;
//				GtkWidget *angle_entry;
//				GtkWidget *sa_entry;
//				GtkWidget *ea_entry;

		GtkWidget *separator;
		GtkWidget *action_hbox;
			GtkWidget *cancel_buttun;
			GtkWidget *ok_buttun;


	/* ダイアログ(ellipse_set_dlg->dialog)生成 */
	ellipse_set_dlg->dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_position(GTK_WINDOW(ellipse_set_dlg->dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(ellipse_set_dlg->dialog), _("Ellipse Data Input") );
	g_signal_connect( G_OBJECT(ellipse_set_dlg->dialog), "key_press_event",
						G_CALLBACK(ellipse_set_dlg_key_press_event), ellipse_set_dlg);



	/* ダイアログの中にまず、パッキングボックス(main_vbox)を作成 */
	main_vbox = gtk_vbox_new(0, 5);
	gtk_container_add(GTK_CONTAINER(ellipse_set_dlg->dialog), main_vbox);
	gtk_container_set_border_width(GTK_CONTAINER(ellipse_set_dlg->dialog), 5);
	gtk_widget_show(main_vbox);



		/* パッキングボックス(hbox)を作成 */
		hbox = gtk_hbox_new(FALSE, 2);
		gtk_box_pack_start( GTK_BOX(main_vbox), hbox, TRUE, TRUE, 0);
		gtk_widget_show(hbox);

			/* パッキングボックス(label_vbox)を作成 */
			label_vbox = gtk_vbox_new(FALSE, 2);
			gtk_box_pack_start( GTK_BOX(hbox), label_vbox, TRUE, TRUE, 0);
			gtk_widget_show(label_vbox);

				/* ラベル (cx_label) の作成 */
				cx_label = gtk_label_new( _("Center X") );
//				gtk_widget_set_size_request(cx_label, 80, 20);
				gtk_box_pack_start(GTK_BOX(label_vbox), cx_label, TRUE, TRUE, 0);
				gtk_widget_show(cx_label);

				/* ラベル (cy_label) の作成 */
				cy_label = gtk_label_new( _("Center Y") );
//				gtk_widget_set_size_request(cy_label, 80, 20);
				gtk_box_pack_start(GTK_BOX(label_vbox), cy_label, TRUE, TRUE, 0);
				gtk_widget_show(cy_label);

				/* ラベル (long_r_label) の作成 */
				long_r_label = gtk_label_new( _("Long axis length") );
//				gtk_widget_set_size_request(long_r_label, 80, 20);
				gtk_box_pack_start(GTK_BOX(label_vbox), long_r_label, TRUE, TRUE, 0);
				gtk_widget_show(long_r_label);

				/* ラベル (k_label) の作成 */
				k_label = gtk_label_new( _("Short axis percentage") );
//				gtk_widget_set_size_request(k_label, 80, 20);
				gtk_box_pack_start(GTK_BOX(label_vbox), k_label, TRUE, TRUE, 0);
				gtk_widget_show(k_label);

				/* ラベル (angle_label) の作成 */
				angle_label = gtk_label_new( _("Inclination") );
//				gtk_widget_set_size_request(angle_label, 80, 20);
				gtk_box_pack_start(GTK_BOX(label_vbox), angle_label, TRUE, TRUE, 0);
				gtk_widget_show(angle_label);

				/* ラベル (sa_label) の作成 */
				sa_label = gtk_label_new( _("Start Angle") );
//				gtk_widget_set_size_request(sa_label, 80, 20);
				gtk_box_pack_start(GTK_BOX(label_vbox), sa_label, TRUE, TRUE, 0);
				gtk_widget_show(sa_label);

				/* ラベル (ea_label) の作成 */
				ea_label = gtk_label_new( _("End Angle") );
//				gtk_widget_set_size_request(ea_label, 80, 20);
				gtk_box_pack_start(GTK_BOX(label_vbox), ea_label, TRUE, TRUE, 0);
				gtk_widget_show(ea_label);



			/* パッキングボックス(entry_vbox)を作成 */
			entry_vbox = gtk_vbox_new(FALSE, 2);
			gtk_box_pack_start( GTK_BOX(hbox), entry_vbox, TRUE, TRUE, 0);
			gtk_widget_show(entry_vbox);

				/* エントリー (cx_entry) を作成 */
				ellipse_set_dlg->cx_entry = gtk_entry_new();
//				gtk_widget_set_size_request(ellipse_set_dlg->cx_entry, 150, 20);
				gtk_box_pack_start(GTK_BOX(entry_vbox), ellipse_set_dlg->cx_entry, TRUE, TRUE, 1);
				/* 初期値設定 */
				FloatOut_n(str, ellipse_set_dlg->cx, 6, 0);
				gtk_entry_set_text(GTK_ENTRY(ellipse_set_dlg->cx_entry), str);
				gtk_widget_show(ellipse_set_dlg->cx_entry);

				/* エントリー (cy_entry) を作成 */
				ellipse_set_dlg->cy_entry = gtk_entry_new();
//				gtk_widget_set_size_request(ellipse_set_dlg->cy_entry, 150, 20);
				gtk_box_pack_start(GTK_BOX(entry_vbox), ellipse_set_dlg->cy_entry, TRUE, TRUE, 1);
				/* 初期値設定 */
				FloatOut_n(str, ellipse_set_dlg->cy, 6, 0);
				gtk_entry_set_text(GTK_ENTRY(ellipse_set_dlg->cy_entry), str);
				gtk_widget_show(ellipse_set_dlg->cy_entry);

				/* エントリー (long_r_entry) を作成 */
				ellipse_set_dlg->long_r_entry = gtk_entry_new();
//				gtk_widget_set_size_request(ellipse_set_dlg->long_r_entry, 150, 20);
				gtk_box_pack_start(GTK_BOX(entry_vbox), ellipse_set_dlg->long_r_entry, TRUE, TRUE, 1);
				/* 初期値設定 */
				FloatOut_n(str, ellipse_set_dlg->long_r, 6, 0);
				gtk_entry_set_text(GTK_ENTRY(ellipse_set_dlg->long_r_entry), str);
				gtk_widget_show(ellipse_set_dlg->long_r_entry);

				/* エントリー (k_entry) を作成 */
				ellipse_set_dlg->k_entry = gtk_entry_new();
//				gtk_widget_set_size_request(ellipse_set_dlg->k_entry, 150, 20);
				gtk_box_pack_start(GTK_BOX(entry_vbox), ellipse_set_dlg->k_entry, TRUE, TRUE, 1);
				/* 初期値設定 */
				FloatOut_n(str, ellipse_set_dlg->k, 6, 0);
				gtk_entry_set_text(GTK_ENTRY(ellipse_set_dlg->k_entry), str);
				gtk_widget_show(ellipse_set_dlg->k_entry);

				/* エントリー (angle_entry) を作成 */
				ellipse_set_dlg->angle_entry = gtk_entry_new();
//				gtk_widget_set_size_request(ellipse_set_dlg->angle_entry, 150, 20);
				gtk_box_pack_start(GTK_BOX(entry_vbox), ellipse_set_dlg->angle_entry, TRUE, TRUE, 1);
				/* 初期値設定 */
				FloatOut_n(str, ellipse_set_dlg->angle, 6, 0);
				gtk_entry_set_text(GTK_ENTRY(ellipse_set_dlg->angle_entry), str);
				gtk_widget_show(ellipse_set_dlg->angle_entry);

				/* エントリー (sa_entry) を作成 */
				ellipse_set_dlg->sa_entry = gtk_entry_new();
//				gtk_widget_set_size_request(ellipse_set_dlg->sa_entry, 150, 20);
				gtk_box_pack_start(GTK_BOX(entry_vbox), ellipse_set_dlg->sa_entry, TRUE, TRUE, 1);
				/* 初期値設定 */
				FloatOut_n(str, ellipse_set_dlg->sa, 6, 0);
				gtk_entry_set_text(GTK_ENTRY(ellipse_set_dlg->sa_entry), str);
				gtk_widget_show(ellipse_set_dlg->sa_entry);

				/* エントリー (ea_entry) を作成 */
				ellipse_set_dlg->ea_entry = gtk_entry_new();
//				gtk_widget_set_size_request(ellipse_set_dlg->ea_entry, 150, 20);
				gtk_box_pack_start(GTK_BOX(entry_vbox), ellipse_set_dlg->ea_entry, TRUE, TRUE, 1);
				/* 初期値設定 */
				FloatOut_n(str, ellipse_set_dlg->ea, 6, 0);
				gtk_entry_set_text(GTK_ENTRY(ellipse_set_dlg->ea_entry), str);
				gtk_widget_show(ellipse_set_dlg->ea_entry);



		/* セパレーター(separator) */
		separator = gtk_hseparator_new();
		gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
		gtk_widget_show(separator);



		/* パッキングボックス (hbox) を作成 */
		action_hbox = gtk_hbox_new(FALSE, 2);
		gtk_box_pack_start( GTK_BOX(main_vbox), action_hbox, TRUE, TRUE, 0);
		gtk_widget_show(action_hbox);

			/* CANCELボタンの生成 */
			cancel_buttun = gtk_button_new_with_label("CANCEL");
//			gtk_widget_set_size_request(cancel_buttun, 80, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), cancel_buttun, TRUE, TRUE, 2);
			g_signal_connect(G_OBJECT(cancel_buttun), 
							   "clicked", G_CALLBACK(ellipse_set_dlg_cancel_pushed), ellipse_set_dlg);
			g_signal_connect(G_OBJECT(cancel_buttun), 
							   "clicked", G_CALLBACK(gtk_main_quit), NULL);
			gtk_widget_show(cancel_buttun);


			/* OKボタンの生成 */
			ok_buttun = gtk_button_new_with_label("OK");
//			gtk_widget_set_size_request(ok_buttun, 80, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), ok_buttun, TRUE, TRUE, 2);
			g_signal_connect(G_OBJECT(ok_buttun), 
							   "clicked", G_CALLBACK(ellipse_set_dlg_ok_pushed), ellipse_set_dlg);
			g_signal_connect(G_OBJECT(ok_buttun), 
							   "clicked", G_CALLBACK(gtk_main_quit), NULL);
		//	  GTK_WIDGET_SET_FLAGS(ok_buttun, GTK_CAN_DEFAULT);
		//	  gtk_widget_grab_default(ok_buttun);
			gtk_widget_show(ok_buttun);





	/* ダイアログを最前面に表示する */
	gtk_window_set_modal(GTK_WINDOW(ellipse_set_dlg->dialog), TRUE);
	/* メインウィンドウを操作できないように設定 */
	gtk_window_set_transient_for(GTK_WINDOW(ellipse_set_dlg->dialog), GTK_WINDOW(ellipse_set_dlg->parent));


	/* ダイアログを可視状態へ */
	gtk_widget_show(ellipse_set_dlg->dialog);
	/* メインイベントループ */
	gtk_main();
	gtk_widget_destroy(ellipse_set_dlg->dialog);
	return 0; 
}





/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : EllipseSetDlg.c
 * ====================================================================
 */
