#!/bin/bash
# bbou@ac-toulouse.fr
# 14/07/2009 
# conf/unconfig-pam_winbind.sh 

### I N C L U D E
. ./_include.sh

### P A R A M S
if [ "$1" == "-f" ];then
	MYDIR="$2"
	shift
	shift
else
	MYDIR="${PAMDIR}"
fi
MYSERVICES="$1"
MYMODES="$2"
#echo "dir=${MYDIR}"
#echo "services=${MYSERVICES}"
#echo "modes=${MYMODES}"

### M O D I F I E D   F I L E S ...
# those specified by ${MYDIR}/${MYSERVICES}

### ... W I T H   A C C E S S
INST_UID=root
INST_GID=root
INST_PAM_MOD=644

### S T A R T
echo "+uninstall pam_winbind"
case ${DISTRIBUTION} in
	Debian|Ubuntu)
		echo "remove winbind profile for pam-auth-update"
		rm /usr/share/pam-configs/winbind
		;;
	*)
		echo "fall back to common pam files update"

		# C L E A N U P   P A M   H O O K
		j=1
		for i in ${MYSERVICES}; do

			# read mode
			mode=`echo ${MYMODES} | gawk '{split($0,a);print a[nth]}' "nth=${j}"`
			j=$((j+1))	
	
			# handle file
			echo "remove pam_winbind references in ${MYDIR}/${i}"

			# check
			if [ ! -f ${MYDIR}/${i} ]; then
				echo "cannot clean up ${MYDIR}/${i} (does not exist)"	
				continue
			fi

			# remove
			awk -f pam_parse.awk "remove_pamwinbind=1" "output_${mode}=1" ${MYDIR}/${i} > ${TMPDIR}/${i}
			#cat ${TMPDIR}/${i}

			# install
			echo "install modified ${i} to ${MYDIR}"
			${INSTALL} -o ${INST_UID} -g ${INST_GID} -m ${INST_PAM_MOD} ${TMPDIR}/${i} ${MYDIR} > /dev/null

			# cleanup temporary
			rm ${TMPDIR}/${i}
		done
		;;
esac
