/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file OptionsFile.h
    \author Romain BONDUE
    \date 03/08/2006 */
#ifndef __OPTIONSFILE_H__
#define __OPTIONSFILE_H__

#include <stdexcept>
#include <ostream>

#include "XMLParser.h"
#include "Exceptions.h"



namespace nsUserData
{
    class COptionsFile : public CXMLParser
    {
      public :
        COptionsFile (bool DisplayTrayIcon, bool StartMinimized,
                      unsigned LeaveRootDelay) throw();
        ~COptionsFile () throw();
        void Record () throw (nsErrors::CException);
            /* If the file doesn't exist, it's not considered as an error.
               Nothing is done. */
        void Extract () throw (nsErrors::CException);
        bool DisplayTrayIcon () const throw();
        void DisplayTrayIcon (bool) throw();
        bool StartMinimized () const throw();
        void StartMinimized (bool) throw();
        unsigned LeaveRootDelay () const throw();
        void LeaveRootDelay (unsigned) throw();


      protected :
            // For extracting :
        void Text (const char*, const std::string&)
                                                throw (nsErrors::CException);
            // For recording : (*not* virtual)
        void RecordFields (std::ostream&) throw (std::ios_base::failure);


      private :
        bool m_DisplayTrayIcon;
        bool m_StartMinimized;
        unsigned m_LeaveRootDelay;

    }; // COptionsFile

} // namespace nsUserData

#include "private/OptionsFile.hxx"

#endif // __OPTIONSFILE_H__
