#[macro_use]
extern crate criterion;
extern crate pem;

use criterion::Criterion;

const SAMPLE: &'static str = "-----BEGIN RSA PRIVATE KEY-----\r
MIIBPQIBAAJBAOsfi5AGYhdRs/x6q5H7kScxA0Kzzqe6WI6gf6+tc6IvKQJo5rQc\r
dWWSQ0nRGt2hOPDO+35NKhQEjBQxPh/v7n0CAwEAAQJBAOGaBAyuw0ICyENy5NsO\r
2gkT00AWTSzM9Zns0HedY31yEabkuFvrMCHjscEF7u3Y6PB7An3IzooBHchsFDei\r
AAECIQD/JahddzR5K3A6rzTidmAf1PBtqi7296EnWv8WvpfAAQIhAOvowIXZI4Un\r
DXjgZ9ekuUjZN+GUQRAVlkEEohGLVy59AiEA90VtqDdQuWWpvJX0cM08V10tLXrT\r
TTGsEtITid1ogAECIQDAaFl90ZgS5cMrL3wCeatVKzVUmuJmB/VAmlLFFGzK0QIh\r
ANJGc7AFk4fyFD/OezhwGHbWmo/S+bfeAiIh2Ss2FxKJ\r
-----END RSA PRIVATE KEY-----\r
\r
-----BEGIN RSA PUBLIC KEY-----\r
MIIBOgIBAAJBAMIeCnn9G/7g2Z6J+qHOE2XCLLuPoh5NHTO2Fm+PbzBvafBo0oYo\r
QVVy7frzxmOqx6iIZBxTyfAQqBPO3Br59BMCAwEAAQJAX+PjHPuxdqiwF6blTkS0\r
RFI1MrnzRbCmOkM6tgVO0cd6r5Z4bDGLusH9yjI9iI84gPRjK0AzymXFmBGuREHI\r
sQIhAPKf4pp+Prvutgq2ayygleZChBr1DC4XnnufBNtaswyvAiEAzNGVKgNvzuhk\r
ijoUXIDruJQEGFGvZTsi1D2RehXiT90CIQC4HOQUYKCydB7oWi1SHDokFW2yFyo6\r
/+lf3fgNjPI6OQIgUPmTFXciXxT1msh3gFLf3qt2Kv8wbr9Ad9SXjULVpGkCIB+g\r
RzHX0lkJl9Stshd/7Gbt65/QYq+v+xvAeT0CoyIg\r
-----END RSA PUBLIC KEY-----\r
";


fn pem_parse() {
  pem::parse(SAMPLE).unwrap();
}

fn pem_parse_many() {
    pem::parse_many(SAMPLE);
}

fn pem_encode(pem: &pem::Pem) {
    pem::encode(pem);
}

fn pem_encode_many(pems: &std::vec::Vec<pem::Pem>) {
    pem::encode_many(pems);
}

fn criterion_benchmark(c: &mut Criterion) {
    // Parse
    c.bench_function("pem::parse", |b| b.iter(|| pem_parse()));  
    c.bench_function("pem::parse_many", |b| b.iter(|| pem_parse_many()));
  
    // Encode
    let pem = pem::Pem { tag: String::from("RSA PRIVATE KEY"), contents: vec!(48, 130, 1, 61, 2, 1, 0, 2, 65, 0, 235, 31, 139, 144, 6, 98, 23, 81, 179, 252, 122, 171, 145, 251, 145, 39, 49, 3, 66, 179, 206, 167, 186, 88, 142, 160, 127, 175, 173, 115, 162, 47, 41, 2, 104, 230, 180, 28, 117, 101, 146, 67, 73, 209, 26, 221, 161, 56, 240, 206, 251, 126, 77, 42, 20, 4, 140, 20, 49, 62, 31, 239, 238, 125, 2, 3, 1, 0, 1, 2, 65, 0, 225, 154, 4, 12, 174, 195, 66, 2, 200, 67, 114, 228, 219, 14, 218, 9, 19, 211, 64, 22, 77, 44, 204, 245, 153, 236, 208, 119, 157, 99, 125, 114, 17, 166, 228, 184, 91, 235, 48, 33, 227, 177, 193, 5, 238, 237, 216, 232, 240, 123, 2, 125, 200, 206, 138, 1, 29, 200, 108, 20, 55, 162, 0, 1, 2, 33, 0, 255, 37, 168, 93, 119, 52, 121, 43, 112, 58, 175, 52, 226, 118, 96, 31, 212, 240, 109, 170, 46, 246, 247, 161, 39, 90, 255, 22, 190, 151, 192, 1, 2, 33, 0, 235, 232, 192, 133, 217, 35, 133, 39, 13, 120, 224, 103, 215, 164, 185, 72, 217, 55, 225, 148, 65, 16, 21, 150, 65, 4, 162, 17, 139, 87, 46, 125, 2, 33, 0, 247, 69, 109, 168, 55, 80, 185, 101, 169, 188, 149, 244, 112, 205, 60, 87, 93, 45, 45, 122, 211, 77, 49, 172, 18, 210, 19, 137, 221, 104, 128, 1, 2, 33, 0, 192, 104, 89, 125, 209, 152, 18, 229, 195, 43, 47, 124, 2, 121, 171, 85, 43, 53, 84, 154, 226, 102, 7, 245, 64, 154, 82, 197, 20, 108, 202, 209, 2, 33, 0, 210, 70, 115, 176, 5, 147, 135, 242, 20, 63, 206, 123, 56, 112, 24, 118, 214, 154, 143, 210, 249, 183, 222, 2, 34, 33, 217, 43, 54, 23, 18, 137) };
    c.bench_function("pem::encode", move |b| b.iter(|| pem_encode(&pem)));

    let pems = vec!(pem::Pem { tag: String::from("RSA PRIVATE KEY"), contents: vec!(48, 130, 1, 61, 2, 1, 0, 2, 65, 0, 235, 31, 139, 144, 6, 98, 23, 81, 179, 252, 122, 171, 145, 251, 145, 39, 49, 3, 66, 179, 206, 167, 186, 88, 142, 160, 127, 175, 173, 115, 162, 47, 41, 2, 104, 230, 180, 28, 117, 101, 146, 67, 73, 209, 26, 221, 161, 56, 240, 206, 251, 126, 77, 42, 20, 4, 140, 20, 49, 62, 31, 239, 238, 125, 2, 3, 1, 0, 1, 2, 65, 0, 225, 154, 4, 12, 174, 195, 66, 2, 200, 67, 114, 228, 219, 14, 218, 9, 19, 211, 64, 22, 77, 44, 204, 245, 153, 236, 208, 119, 157, 99, 125, 114, 17, 166, 228, 184, 91, 235, 48, 33, 227, 177, 193, 5, 238, 237, 216, 232, 240, 123, 2, 125, 200, 206, 138, 1, 29, 200, 108, 20, 55, 162, 0, 1, 2, 33, 0, 255, 37, 168, 93, 119, 52, 121, 43, 112, 58, 175, 52, 226, 118, 96, 31, 212, 240, 109, 170, 46, 246, 247, 161, 39, 90, 255, 22, 190, 151, 192, 1, 2, 33, 0, 235, 232, 192, 133, 217, 35, 133, 39, 13, 120, 224, 103, 215, 164, 185, 72, 217, 55, 225, 148, 65, 16, 21, 150, 65, 4, 162, 17, 139, 87, 46, 125, 2, 33, 0, 247, 69, 109, 168, 55, 80, 185, 101, 169, 188, 149, 244, 112, 205, 60, 87, 93, 45, 45, 122, 211, 77, 49, 172, 18, 210, 19, 137, 221, 104, 128, 1, 2, 33, 0, 192, 104, 89, 125, 209, 152, 18, 229, 195, 43, 47, 124, 2, 121, 171, 85, 43, 53, 84, 154, 226, 102, 7, 245, 64, 154, 82, 197, 20, 108, 202, 209, 2, 33, 0, 210, 70, 115, 176, 5, 147, 135, 242, 20, 63, 206, 123, 56, 112, 24, 118, 214, 154, 143, 210, 249, 183, 222, 2, 34, 33, 217, 43, 54, 23, 18, 137) }, pem::Pem { tag: String::from("RSA PUBLIC KEY"), contents: vec!(48, 130, 1, 58, 2, 1, 0, 2, 65, 0, 194, 30, 10, 121, 253, 27, 254, 224, 217, 158, 137, 250, 161, 206, 19, 101, 194, 44, 187, 143, 162, 30, 77, 29, 51, 182, 22, 111, 143, 111, 48, 111, 105, 240, 104, 210, 134, 40, 65, 85, 114, 237, 250, 243, 198, 99, 170, 199, 168, 136, 100, 28, 83, 201, 240, 16, 168, 19, 206, 220, 26, 249, 244, 19, 2, 3, 1, 0, 1, 2, 64, 95, 227, 227, 28, 251, 177, 118, 168, 176, 23, 166, 229, 78, 68, 180, 68, 82, 53, 50, 185, 243, 69, 176, 166, 58, 67, 58, 182, 5, 78, 209, 199, 122, 175, 150, 120, 108, 49, 139, 186, 193, 253, 202, 50, 61, 136, 143, 56, 128, 244, 99, 43, 64, 51, 202, 101, 197, 152, 17, 174, 68, 65, 200, 177, 2, 33, 0, 242, 159, 226, 154, 126, 62, 187, 238, 182, 10, 182, 107, 44, 160, 149, 230, 66, 132, 26, 245, 12, 46, 23, 158, 123, 159, 4, 219, 90, 179, 12, 175, 2, 33, 0, 204, 209, 149, 42, 3, 111, 206, 232, 100, 138, 58, 20, 92, 128, 235, 184, 148, 4, 24, 81, 175, 101, 59, 34, 212, 61, 145, 122, 21, 226, 79, 221, 2, 33, 0, 184, 28, 228, 20, 96, 160, 178, 116, 30, 232, 90, 45, 82, 28, 58, 36, 21, 109, 178, 23, 42, 58, 255, 233, 95, 221, 248, 13, 140, 242, 58, 57, 2, 32, 80, 249, 147, 21, 119, 34, 95, 20, 245, 154, 200, 119, 128, 82, 223, 222, 171, 118, 42, 255, 48, 110, 191, 64, 119, 212, 151, 141, 66, 213, 164, 105, 2, 32, 31, 160, 71, 49, 215, 210, 89, 9, 151, 212, 173, 178, 23, 127, 236, 102, 237, 235, 159, 208, 98, 175, 175, 251, 27, 192, 121, 61, 2, 163, 34, 32) });
    c.bench_function("pem::encode_many", move |b| b.iter(|| pem_encode_many(&pems)));
}

criterion_group!(benches, criterion_benchmark);
criterion_main!(benches);