// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use AccelFlags;
use AccelGroup;
use Align;
use Allocation;
use Buildable;
use Clipboard;
use DirectionType;
use DragResult;
use Orientation;
use Requisition;
use SelectionData;
use Settings;
use SizeRequestMode;
use StateFlags;
use StyleContext;
use TargetList;
use TextDirection;
use Tooltip;
use WidgetHelpType;
use WidgetPath;
use Window;
use cairo;
use cairo_ffi;
use ffi;
use gdk;
use gdk_ffi;
use gdk_pixbuf;
use gio;
use glib;
use glib::StaticType;
use glib::Value;
use glib::object::Downcast;
use glib::object::IsA;
use glib::signal::SignalHandlerId;
use glib::signal::connect;
use glib::translate::*;
use glib_ffi;
use gobject_ffi;
use libc;
use pango;
use signal::Inhibit;
use std::boxed::Box as Box_;
use std::mem;
use std::mem::transmute;
use std::ptr;

glib_wrapper! {
    pub struct Widget(Object<ffi::GtkWidget, ffi::GtkWidgetClass>): Buildable;

    match fn {
        get_type => || ffi::gtk_widget_get_type(),
    }
}

impl Widget {
    //pub fn new(type_: glib::types::Type, first_property_name: &str, : /*Unknown conversion*//*Unimplemented*/Fundamental: VarArgs) -> Widget {
    //    unsafe { TODO: call ffi::gtk_widget_new() }
    //}

    pub fn get_default_direction() -> TextDirection {
        assert_initialized_main_thread!();
        unsafe {
            from_glib(ffi::gtk_widget_get_default_direction())
        }
    }

    #[cfg_attr(feature = "v3_10", deprecated)]
    pub fn pop_composite_child() {
        assert_initialized_main_thread!();
        unsafe {
            ffi::gtk_widget_pop_composite_child();
        }
    }

    #[cfg_attr(feature = "v3_10", deprecated)]
    pub fn push_composite_child() {
        assert_initialized_main_thread!();
        unsafe {
            ffi::gtk_widget_push_composite_child();
        }
    }

    pub fn set_default_direction(dir: TextDirection) {
        assert_initialized_main_thread!();
        unsafe {
            ffi::gtk_widget_set_default_direction(dir.to_glib());
        }
    }
}

pub trait WidgetExt {
    fn activate(&self) -> bool;

    fn add_accelerator(&self, accel_signal: &str, accel_group: &AccelGroup, accel_key: u32, accel_mods: gdk::ModifierType, accel_flags: AccelFlags);

    fn add_device_events<P: IsA<gdk::Device>>(&self, device: &P, events: gdk::EventMask);

    fn add_events(&self, events: i32);

    fn add_mnemonic_label<P: IsA<Widget>>(&self, label: &P);

    //#[cfg(any(feature = "v3_8", feature = "dox"))]
    //fn add_tick_callback(&self, callback: /*Unknown conversion*//*Unimplemented*/TickCallback, notify: /*Unknown conversion*//*Unimplemented*/DestroyNotify) -> u32;

    fn can_activate_accel(&self, signal_id: u32) -> bool;

    fn child_focus(&self, direction: DirectionType) -> bool;

    fn child_notify(&self, child_property: &str);

    fn compute_expand(&self, orientation: Orientation) -> bool;

    fn create_pango_context(&self) -> Option<pango::Context>;

    fn create_pango_layout<'a, P: Into<Option<&'a str>>>(&self, text: P) -> Option<pango::Layout>;

    fn destroy(&self);

    //fn destroyed<P: IsA<Widget>>(&self, widget_pointer: &P);

    fn device_is_shadowed<P: IsA<gdk::Device>>(&self, device: &P) -> bool;

    #[cfg_attr(feature = "v3_10", deprecated)]
    fn drag_begin<'a, P: Into<Option<&'a gdk::Event>>>(&self, targets: &TargetList, actions: gdk::DragAction, button: i32, event: P) -> Option<gdk::DragContext>;

    #[cfg(any(feature = "v3_10", feature = "dox"))]
    fn drag_begin_with_coordinates<'a, P: Into<Option<&'a gdk::Event>>>(&self, targets: &TargetList, actions: gdk::DragAction, button: i32, event: P, x: i32, y: i32) -> Option<gdk::DragContext>;

    fn drag_check_threshold(&self, start_x: i32, start_y: i32, current_x: i32, current_y: i32) -> bool;

    fn drag_dest_add_image_targets(&self);

    fn drag_dest_add_text_targets(&self);

    fn drag_dest_add_uri_targets(&self);

    fn drag_dest_find_target<'a, P: Into<Option<&'a TargetList>>>(&self, context: &gdk::DragContext, target_list: P) -> Option<gdk::Atom>;

    fn drag_dest_get_target_list(&self) -> Option<TargetList>;

    fn drag_dest_get_track_motion(&self) -> bool;

    #[cfg_attr(feature = "v3_22", deprecated)]
    fn drag_dest_set_proxy(&self, proxy_window: &gdk::Window, protocol: gdk::DragProtocol, use_coordinates: bool);

    fn drag_dest_set_target_list<'a, P: Into<Option<&'a TargetList>>>(&self, target_list: P);

    fn drag_dest_set_track_motion(&self, track_motion: bool);

    fn drag_dest_unset(&self);

    fn drag_get_data(&self, context: &gdk::DragContext, target: &gdk::Atom, time_: u32);

    fn drag_highlight(&self);

    fn drag_source_add_image_targets(&self);

    fn drag_source_add_text_targets(&self);

    fn drag_source_add_uri_targets(&self);

    fn drag_source_get_target_list(&self) -> Option<TargetList>;

    fn drag_source_set_icon_gicon<P: IsA<gio::Icon>>(&self, icon: &P);

    fn drag_source_set_icon_name(&self, icon_name: &str);

    fn drag_source_set_icon_pixbuf(&self, pixbuf: &gdk_pixbuf::Pixbuf);

    #[cfg_attr(feature = "v3_10", deprecated)]
    fn drag_source_set_icon_stock(&self, stock_id: &str);

    fn drag_source_set_target_list<'a, P: Into<Option<&'a TargetList>>>(&self, target_list: P);

    fn drag_source_unset(&self);

    fn drag_unhighlight(&self);

    fn draw(&self, cr: &cairo::Context);

    fn error_bell(&self);

    fn event(&self, event: &gdk::Event) -> bool;

    fn freeze_child_notify(&self);

    //fn get_accessible(&self) -> /*Ignored*/Option<atk::Object>;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_action_group(&self, prefix: &str) -> Option<gio::ActionGroup>;

    #[cfg(any(feature = "v3_10", feature = "dox"))]
    fn get_allocated_baseline(&self) -> i32;

    fn get_allocated_height(&self) -> i32;

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    fn get_allocated_size(&self) -> (Allocation, i32);

    fn get_allocated_width(&self) -> i32;

    fn get_allocation(&self) -> Allocation;

    fn get_ancestor(&self, widget_type: glib::types::Type) -> Option<Widget>;

    fn get_app_paintable(&self) -> bool;

    fn get_can_default(&self) -> bool;

    fn get_can_focus(&self) -> bool;

    fn get_child_visible(&self) -> bool;

    #[cfg(any(feature = "v3_14", feature = "dox"))]
    fn get_clip(&self) -> Allocation;

    fn get_clipboard(&self, selection: &gdk::Atom) -> Clipboard;

    #[cfg_attr(feature = "v3_10", deprecated)]
    fn get_composite_name(&self) -> Option<String>;

    fn get_device_enabled<P: IsA<gdk::Device>>(&self, device: &P) -> bool;

    fn get_device_events<P: IsA<gdk::Device>>(&self, device: &P) -> gdk::EventMask;

    fn get_direction(&self) -> TextDirection;

    fn get_display(&self) -> Option<gdk::Display>;

    fn get_double_buffered(&self) -> bool;

    fn get_events(&self) -> i32;

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    fn get_focus_on_click(&self) -> bool;

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn get_font_map(&self) -> Option<pango::FontMap>;

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn get_font_options(&self) -> Option<cairo::FontOptions>;

    #[cfg(any(feature = "v3_8", feature = "dox"))]
    fn get_frame_clock(&self) -> Option<gdk::FrameClock>;

    fn get_halign(&self) -> Align;

    fn get_has_tooltip(&self) -> bool;

    fn get_has_window(&self) -> bool;

    fn get_hexpand(&self) -> bool;

    fn get_hexpand_set(&self) -> bool;

    fn get_mapped(&self) -> bool;

    fn get_margin_bottom(&self) -> i32;

    #[cfg(any(feature = "v3_12", feature = "dox"))]
    fn get_margin_end(&self) -> i32;

    #[cfg_attr(feature = "v3_12", deprecated)]
    fn get_margin_left(&self) -> i32;

    #[cfg_attr(feature = "v3_12", deprecated)]
    fn get_margin_right(&self) -> i32;

    #[cfg(any(feature = "v3_12", feature = "dox"))]
    fn get_margin_start(&self) -> i32;

    fn get_margin_top(&self) -> i32;

    fn get_modifier_mask(&self, intent: gdk::ModifierIntent) -> gdk::ModifierType;

    fn get_name(&self) -> Option<String>;

    fn get_no_show_all(&self) -> bool;

    #[cfg(any(feature = "v3_8", feature = "dox"))]
    fn get_opacity(&self) -> f64;

    fn get_pango_context(&self) -> Option<pango::Context>;

    fn get_parent(&self) -> Option<Widget>;

    fn get_parent_window(&self) -> Option<gdk::Window>;

    fn get_path(&self) -> WidgetPath;

    fn get_preferred_height(&self) -> (i32, i32);

    #[cfg(any(feature = "v3_10", feature = "dox"))]
    fn get_preferred_height_and_baseline_for_width(&self, width: i32) -> (i32, i32, i32, i32);

    fn get_preferred_height_for_width(&self, width: i32) -> (i32, i32);

    fn get_preferred_size(&self) -> (Requisition, Requisition);

    fn get_preferred_width(&self) -> (i32, i32);

    fn get_preferred_width_for_height(&self, height: i32) -> (i32, i32);

    fn get_realized(&self) -> bool;

    fn get_receives_default(&self) -> bool;

    fn get_request_mode(&self) -> SizeRequestMode;

    #[cfg_attr(feature = "v3_12", deprecated)]
    fn get_root_window(&self) -> Option<gdk::Window>;

    #[cfg(any(feature = "v3_10", feature = "dox"))]
    fn get_scale_factor(&self) -> i32;

    fn get_screen(&self) -> Option<gdk::Screen>;

    fn get_sensitive(&self) -> bool;

    fn get_settings(&self) -> Option<Settings>;

    fn get_size_request(&self) -> (i32, i32);

    fn get_state_flags(&self) -> StateFlags;

    fn get_style_context(&self) -> Option<StyleContext>;

    fn get_support_multidevice(&self) -> bool;

    fn get_template_child(&self, widget_type: glib::types::Type, name: &str) -> Option<glib::Object>;

    fn get_tooltip_markup(&self) -> Option<String>;

    fn get_tooltip_text(&self) -> Option<String>;

    fn get_tooltip_window(&self) -> Option<Window>;

    fn get_toplevel(&self) -> Option<Widget>;

    fn get_valign(&self) -> Align;

    #[cfg(any(feature = "v3_10", feature = "dox"))]
    fn get_valign_with_baseline(&self) -> Align;

    fn get_vexpand(&self) -> bool;

    fn get_vexpand_set(&self) -> bool;

    fn get_visible(&self) -> bool;

    fn get_visual(&self) -> Option<gdk::Visual>;

    fn get_window(&self) -> Option<gdk::Window>;

    fn grab_add(&self);

    fn grab_default(&self);

    fn grab_focus(&self);

    fn grab_remove(&self);

    fn has_default(&self) -> bool;

    fn has_focus(&self) -> bool;

    fn has_grab(&self) -> bool;

    fn has_screen(&self) -> bool;

    fn has_visible_focus(&self) -> bool;

    fn hide(&self);

    fn hide_on_delete(&self) -> bool;

    fn in_destruction(&self) -> bool;

    #[cfg(any(feature = "v3_10", feature = "dox"))]
    fn init_template(&self);

    fn input_shape_combine_region<'a, P: Into<Option<&'a cairo::Region>>>(&self, region: P);

    #[cfg(any(feature = "v3_6", feature = "dox"))]
    fn insert_action_group<'a, P: IsA<gio::ActionGroup> + 'a, Q: Into<Option<&'a P>>>(&self, name: &str, group: Q);

    fn is_ancestor<P: IsA<Widget>>(&self, ancestor: &P) -> bool;

    #[cfg_attr(feature = "v3_22", deprecated)]
    fn is_composited(&self) -> bool;

    fn is_drawable(&self) -> bool;

    fn is_focus(&self) -> bool;

    fn is_sensitive(&self) -> bool;

    fn is_toplevel(&self) -> bool;

    #[cfg(any(feature = "v3_8", feature = "dox"))]
    fn is_visible(&self) -> bool;

    fn keynav_failed(&self, direction: DirectionType) -> bool;

    fn list_accel_closures(&self) -> Vec<glib::Closure>;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn list_action_prefixes(&self) -> Vec<String>;

    fn list_mnemonic_labels(&self) -> Vec<Widget>;

    fn map(&self);

    fn mnemonic_activate(&self, group_cycling: bool) -> bool;

    #[cfg_attr(feature = "v3_16", deprecated)]
    fn override_background_color<'a, P: Into<Option<&'a gdk::RGBA>>>(&self, state: StateFlags, color: P);

    #[cfg_attr(feature = "v3_16", deprecated)]
    fn override_color<'a, P: Into<Option<&'a gdk::RGBA>>>(&self, state: StateFlags, color: P);

    #[cfg_attr(feature = "v3_16", deprecated)]
    fn override_cursor<'a, 'b, P: Into<Option<&'a gdk::RGBA>>, Q: Into<Option<&'b gdk::RGBA>>>(&self, cursor: P, secondary_cursor: Q);

    #[cfg_attr(feature = "v3_16", deprecated)]
    fn override_font<'a, P: Into<Option<&'a pango::FontDescription>>>(&self, font_desc: P);

    #[cfg_attr(feature = "v3_16", deprecated)]
    fn override_symbolic_color<'a, P: Into<Option<&'a gdk::RGBA>>>(&self, name: &str, color: P);

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    fn queue_allocate(&self);

    fn queue_compute_expand(&self);

    fn queue_draw(&self);

    fn queue_draw_area(&self, x: i32, y: i32, width: i32, height: i32);

    fn queue_draw_region(&self, region: &cairo::Region);

    fn queue_resize(&self);

    fn queue_resize_no_redraw(&self);

    fn realize(&self);

    #[cfg_attr(feature = "v3_14", deprecated)]
    fn region_intersect(&self, region: &cairo::Region) -> Option<cairo::Region>;

    #[cfg(any(feature = "v3_8", feature = "dox"))]
    fn register_window(&self, window: &gdk::Window);

    fn remove_accelerator(&self, accel_group: &AccelGroup, accel_key: u32, accel_mods: gdk::ModifierType) -> bool;

    fn remove_mnemonic_label<P: IsA<Widget>>(&self, label: &P);

    #[cfg(any(feature = "v3_8", feature = "dox"))]
    fn remove_tick_callback(&self, id: u32);

    #[cfg_attr(feature = "v3_10", deprecated)]
    fn render_icon_pixbuf(&self, stock_id: &str, size: i32) -> Option<gdk_pixbuf::Pixbuf>;

    #[cfg_attr(feature = "v3_14", deprecated)]
    fn reparent<P: IsA<Widget>>(&self, new_parent: &P);

    fn reset_style(&self);

    #[cfg_attr(feature = "v3_22", deprecated)]
    fn send_expose(&self, event: &gdk::Event) -> i32;

    fn send_focus_change(&self, event: &gdk::Event) -> bool;

    fn set_accel_path<'a, 'b, P: Into<Option<&'a str>>, Q: Into<Option<&'b AccelGroup>>>(&self, accel_path: P, accel_group: Q);

    fn set_allocation(&self, allocation: &Allocation);

    fn set_app_paintable(&self, app_paintable: bool);

    fn set_can_default(&self, can_default: bool);

    fn set_can_focus(&self, can_focus: bool);

    fn set_child_visible(&self, is_visible: bool);

    #[cfg(any(feature = "v3_14", feature = "dox"))]
    fn set_clip(&self, clip: &Allocation);

    #[cfg_attr(feature = "v3_10", deprecated)]
    fn set_composite_name(&self, name: &str);

    fn set_device_enabled<P: IsA<gdk::Device>>(&self, device: &P, enabled: bool);

    fn set_device_events<P: IsA<gdk::Device>>(&self, device: &P, events: gdk::EventMask);

    fn set_direction(&self, dir: TextDirection);

    #[cfg_attr(feature = "v3_14", deprecated)]
    fn set_double_buffered(&self, double_buffered: bool);

    fn set_events(&self, events: i32);

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    fn set_focus_on_click(&self, focus_on_click: bool);

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn set_font_map<'a, P: Into<Option<&'a pango::FontMap>>>(&self, font_map: P);

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn set_font_options<'a, P: Into<Option<&'a cairo::FontOptions>>>(&self, options: P);

    fn set_halign(&self, align: Align);

    fn set_has_tooltip(&self, has_tooltip: bool);

    fn set_has_window(&self, has_window: bool);

    fn set_hexpand(&self, expand: bool);

    fn set_hexpand_set(&self, set: bool);

    fn set_mapped(&self, mapped: bool);

    fn set_margin_bottom(&self, margin: i32);

    #[cfg(any(feature = "v3_12", feature = "dox"))]
    fn set_margin_end(&self, margin: i32);

    #[cfg_attr(feature = "v3_12", deprecated)]
    fn set_margin_left(&self, margin: i32);

    #[cfg_attr(feature = "v3_12", deprecated)]
    fn set_margin_right(&self, margin: i32);

    #[cfg(any(feature = "v3_12", feature = "dox"))]
    fn set_margin_start(&self, margin: i32);

    fn set_margin_top(&self, margin: i32);

    fn set_name(&self, name: &str);

    fn set_no_show_all(&self, no_show_all: bool);

    #[cfg(any(feature = "v3_8", feature = "dox"))]
    fn set_opacity(&self, opacity: f64);

    fn set_parent<P: IsA<Widget>>(&self, parent: &P);

    fn set_parent_window(&self, parent_window: &gdk::Window);

    fn set_realized(&self, realized: bool);

    fn set_receives_default(&self, receives_default: bool);

    fn set_redraw_on_allocate(&self, redraw_on_allocate: bool);

    fn set_sensitive(&self, sensitive: bool);

    fn set_size_request(&self, width: i32, height: i32);

    fn set_state_flags(&self, flags: StateFlags, clear: bool);

    fn set_support_multidevice(&self, support_multidevice: bool);

    fn set_tooltip_markup<'a, P: Into<Option<&'a str>>>(&self, markup: P);

    fn set_tooltip_text<'a, P: Into<Option<&'a str>>>(&self, text: P);

    fn set_tooltip_window<'a, P: IsA<Window> + 'a, Q: Into<Option<&'a P>>>(&self, custom_window: Q);

    fn set_valign(&self, align: Align);

    fn set_vexpand(&self, expand: bool);

    fn set_vexpand_set(&self, set: bool);

    fn set_visible(&self, visible: bool);

    fn set_visual<'a, P: Into<Option<&'a gdk::Visual>>>(&self, visual: P);

    fn set_window(&self, window: &gdk::Window);

    fn shape_combine_region<'a, P: Into<Option<&'a cairo::Region>>>(&self, region: P);

    fn show(&self);

    fn show_all(&self);

    fn show_now(&self);

    fn size_allocate(&self, allocation: &mut Allocation);

    #[cfg(any(feature = "v3_10", feature = "dox"))]
    fn size_allocate_with_baseline(&self, allocation: &mut Allocation, baseline: i32);

    //fn style_get(&self, first_property_name: &str, : /*Unknown conversion*//*Unimplemented*/Fundamental: VarArgs);

    //fn style_get_valist(&self, first_property_name: &str, var_args: /*Unknown conversion*//*Unimplemented*/Unsupported);

    fn thaw_child_notify(&self);

    fn translate_coordinates<P: IsA<Widget>>(&self, dest_widget: &P, src_x: i32, src_y: i32) -> Option<(i32, i32)>;

    fn trigger_tooltip_query(&self);

    fn unmap(&self);

    fn unparent(&self);

    fn unrealize(&self);

    #[cfg(any(feature = "v3_8", feature = "dox"))]
    fn unregister_window(&self, window: &gdk::Window);

    fn unset_state_flags(&self, flags: StateFlags);

    fn get_property_composite_child(&self) -> bool;

    fn get_property_expand(&self) -> bool;

    fn set_property_expand(&self, expand: bool);

    fn get_property_has_default(&self) -> bool;

    fn set_property_has_default(&self, has_default: bool);

    fn get_property_has_focus(&self) -> bool;

    fn set_property_has_focus(&self, has_focus: bool);

    fn get_property_height_request(&self) -> i32;

    fn set_property_height_request(&self, height_request: i32);

    fn get_property_is_focus(&self) -> bool;

    fn set_property_is_focus(&self, is_focus: bool);

    fn get_property_margin(&self) -> i32;

    fn set_property_margin(&self, margin: i32);

    fn get_property_width_request(&self) -> i32;

    fn set_property_width_request(&self, width_request: i32);

    fn connect_accel_closures_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_button_press_event<F: Fn(&Self, &gdk::EventButton) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_button_release_event<F: Fn(&Self, &gdk::EventButton) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_can_activate_accel<F: Fn(&Self, u32) -> bool + 'static>(&self, f: F) -> SignalHandlerId;

    //fn connect_child_notify<Unsupported or ignored types>(&self, f: F) -> SignalHandlerId;

    #[cfg_attr(feature = "v3_22", deprecated)]
    fn connect_composited_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg_attr(feature = "v3_22", deprecated)]
    fn emit_composited_changed(&self);

    fn connect_configure_event<F: Fn(&Self, &gdk::EventConfigure) -> bool + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_damage_event<F: Fn(&Self, &gdk::EventExpose) -> bool + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_delete_event<F: Fn(&Self, &gdk::Event) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_destroy<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_destroy_event<F: Fn(&Self, &gdk::Event) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_direction_changed<F: Fn(&Self, TextDirection) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_drag_begin<F: Fn(&Self, &gdk::DragContext) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_drag_data_delete<F: Fn(&Self, &gdk::DragContext) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_drag_data_get<F: Fn(&Self, &gdk::DragContext, &SelectionData, u32, u32) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_drag_data_received<F: Fn(&Self, &gdk::DragContext, i32, i32, &SelectionData, u32, u32) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_drag_drop<F: Fn(&Self, &gdk::DragContext, i32, i32, u32) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_drag_end<F: Fn(&Self, &gdk::DragContext) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_drag_failed<F: Fn(&Self, &gdk::DragContext, DragResult) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_drag_leave<F: Fn(&Self, &gdk::DragContext, u32) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_drag_motion<F: Fn(&Self, &gdk::DragContext, i32, i32, u32) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_draw<F: Fn(&Self, &cairo::Context) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_enter_notify_event<F: Fn(&Self, &gdk::EventCrossing) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_event<F: Fn(&Self, &gdk::Event) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_event_after<F: Fn(&Self, &gdk::Event) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_focus<F: Fn(&Self, DirectionType) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_focus_in_event<F: Fn(&Self, &gdk::EventFocus) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_focus_out_event<F: Fn(&Self, &gdk::EventFocus) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_grab_broken_event<F: Fn(&Self, &gdk::EventGrabBroken) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_grab_focus<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_grab_focus(&self);

    fn connect_grab_notify<F: Fn(&Self, bool) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_hide<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_hierarchy_changed<F: Fn(&Self, &Option<Widget>) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_key_press_event<F: Fn(&Self, &gdk::EventKey) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_key_release_event<F: Fn(&Self, &gdk::EventKey) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_keynav_failed<F: Fn(&Self, DirectionType) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_leave_notify_event<F: Fn(&Self, &gdk::EventCrossing) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_map<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_mnemonic_activate<F: Fn(&Self, bool) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_motion_notify_event<F: Fn(&Self, &gdk::EventMotion) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_move_focus<F: Fn(&Self, DirectionType) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_move_focus(&self, direction: DirectionType);

    fn connect_parent_set<F: Fn(&Self, &Option<Widget>) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_popup_menu<F: Fn(&Self) -> bool + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_popup_menu(&self) -> bool;

    fn connect_property_notify_event<F: Fn(&Self, &gdk::EventProperty) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_proximity_in_event<F: Fn(&Self, &gdk::EventProximity) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_proximity_out_event<F: Fn(&Self, &gdk::EventProximity) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_query_tooltip<F: Fn(&Self, i32, i32, bool, &Tooltip) -> bool + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_realize<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_screen_changed<F: Fn(&Self, &Option<gdk::Screen>) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_scroll_event<F: Fn(&Self, &gdk::EventScroll) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_selection_clear_event<F: Fn(&Self, &gdk::EventSelection) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_selection_get<F: Fn(&Self, &SelectionData, u32, u32) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_selection_notify_event<F: Fn(&Self, &gdk::EventSelection) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_selection_received<F: Fn(&Self, &SelectionData, u32) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_selection_request_event<F: Fn(&Self, &gdk::EventSelection) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_show<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_show_help<F: Fn(&Self, WidgetHelpType) -> bool + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_show_help(&self, help_type: WidgetHelpType) -> bool;

    fn connect_size_allocate<F: Fn(&Self, &Allocation) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_state_flags_changed<F: Fn(&Self, StateFlags) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_style_updated<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_touch_event<F: Fn(&Self, &gdk::Event) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_unmap<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_unrealize<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg_attr(feature = "v3_12", deprecated)]
    fn connect_visibility_notify_event<F: Fn(&Self, &gdk::EventVisibility) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_window_state_event<F: Fn(&Self, &gdk::EventWindowState) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_app_paintable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_can_default_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_can_focus_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_composite_child_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg_attr(feature = "v3_14", deprecated)]
    fn connect_property_double_buffered_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_events_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_expand_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    fn connect_property_focus_on_click_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_halign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_has_default_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_has_focus_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_has_tooltip_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_height_request_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_hexpand_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_hexpand_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_is_focus_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_margin_bottom_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v3_12", feature = "dox"))]
    fn connect_property_margin_end_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg_attr(feature = "v3_12", deprecated)]
    fn connect_property_margin_left_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg_attr(feature = "v3_12", deprecated)]
    fn connect_property_margin_right_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v3_12", feature = "dox"))]
    fn connect_property_margin_start_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_margin_top_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_no_show_all_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v3_8", feature = "dox"))]
    fn connect_property_opacity_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_parent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_receives_default_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v3_10", feature = "dox"))]
    fn connect_property_scale_factor_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_sensitive_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_tooltip_markup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_tooltip_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_valign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_vexpand_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_vexpand_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_width_request_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_window_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Widget> + IsA<glib::object::Object> + glib::object::ObjectExt> WidgetExt for O {
    fn activate(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_activate(self.to_glib_none().0))
        }
    }

    fn add_accelerator(&self, accel_signal: &str, accel_group: &AccelGroup, accel_key: u32, accel_mods: gdk::ModifierType, accel_flags: AccelFlags) {
        unsafe {
            ffi::gtk_widget_add_accelerator(self.to_glib_none().0, accel_signal.to_glib_none().0, accel_group.to_glib_none().0, accel_key, accel_mods.to_glib(), accel_flags.to_glib());
        }
    }

    fn add_device_events<P: IsA<gdk::Device>>(&self, device: &P, events: gdk::EventMask) {
        unsafe {
            ffi::gtk_widget_add_device_events(self.to_glib_none().0, device.to_glib_none().0, events.to_glib());
        }
    }

    fn add_events(&self, events: i32) {
        unsafe {
            ffi::gtk_widget_add_events(self.to_glib_none().0, events);
        }
    }

    fn add_mnemonic_label<P: IsA<Widget>>(&self, label: &P) {
        unsafe {
            ffi::gtk_widget_add_mnemonic_label(self.to_glib_none().0, label.to_glib_none().0);
        }
    }

    //#[cfg(any(feature = "v3_8", feature = "dox"))]
    //fn add_tick_callback(&self, callback: /*Unknown conversion*//*Unimplemented*/TickCallback, notify: /*Unknown conversion*//*Unimplemented*/DestroyNotify) -> u32 {
    //    unsafe { TODO: call ffi::gtk_widget_add_tick_callback() }
    //}

    fn can_activate_accel(&self, signal_id: u32) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_can_activate_accel(self.to_glib_none().0, signal_id))
        }
    }

    fn child_focus(&self, direction: DirectionType) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_child_focus(self.to_glib_none().0, direction.to_glib()))
        }
    }

    fn child_notify(&self, child_property: &str) {
        unsafe {
            ffi::gtk_widget_child_notify(self.to_glib_none().0, child_property.to_glib_none().0);
        }
    }

    fn compute_expand(&self, orientation: Orientation) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_compute_expand(self.to_glib_none().0, orientation.to_glib()))
        }
    }

    fn create_pango_context(&self) -> Option<pango::Context> {
        unsafe {
            from_glib_full(ffi::gtk_widget_create_pango_context(self.to_glib_none().0))
        }
    }

    fn create_pango_layout<'a, P: Into<Option<&'a str>>>(&self, text: P) -> Option<pango::Layout> {
        let text = text.into();
        let text = text.to_glib_none();
        unsafe {
            from_glib_full(ffi::gtk_widget_create_pango_layout(self.to_glib_none().0, text.0))
        }
    }

    fn destroy(&self) {
        unsafe {
            ffi::gtk_widget_destroy(self.to_glib_none().0);
        }
    }

    //fn destroyed<P: IsA<Widget>>(&self, widget_pointer: &P) {
    //    unsafe { TODO: call ffi::gtk_widget_destroyed() }
    //}

    fn device_is_shadowed<P: IsA<gdk::Device>>(&self, device: &P) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_device_is_shadowed(self.to_glib_none().0, device.to_glib_none().0))
        }
    }

    fn drag_begin<'a, P: Into<Option<&'a gdk::Event>>>(&self, targets: &TargetList, actions: gdk::DragAction, button: i32, event: P) -> Option<gdk::DragContext> {
        let event = event.into();
        unsafe {
            from_glib_none(ffi::gtk_drag_begin(self.to_glib_none().0, targets.to_glib_none().0, actions.to_glib(), button, mut_override(event.to_glib_none().0)))
        }
    }

    #[cfg(any(feature = "v3_10", feature = "dox"))]
    fn drag_begin_with_coordinates<'a, P: Into<Option<&'a gdk::Event>>>(&self, targets: &TargetList, actions: gdk::DragAction, button: i32, event: P, x: i32, y: i32) -> Option<gdk::DragContext> {
        let event = event.into();
        unsafe {
            from_glib_none(ffi::gtk_drag_begin_with_coordinates(self.to_glib_none().0, targets.to_glib_none().0, actions.to_glib(), button, mut_override(event.to_glib_none().0), x, y))
        }
    }

    fn drag_check_threshold(&self, start_x: i32, start_y: i32, current_x: i32, current_y: i32) -> bool {
        unsafe {
            from_glib(ffi::gtk_drag_check_threshold(self.to_glib_none().0, start_x, start_y, current_x, current_y))
        }
    }

    fn drag_dest_add_image_targets(&self) {
        unsafe {
            ffi::gtk_drag_dest_add_image_targets(self.to_glib_none().0);
        }
    }

    fn drag_dest_add_text_targets(&self) {
        unsafe {
            ffi::gtk_drag_dest_add_text_targets(self.to_glib_none().0);
        }
    }

    fn drag_dest_add_uri_targets(&self) {
        unsafe {
            ffi::gtk_drag_dest_add_uri_targets(self.to_glib_none().0);
        }
    }

    fn drag_dest_find_target<'a, P: Into<Option<&'a TargetList>>>(&self, context: &gdk::DragContext, target_list: P) -> Option<gdk::Atom> {
        let target_list = target_list.into();
        let target_list = target_list.to_glib_none();
        unsafe {
            from_glib_none(ffi::gtk_drag_dest_find_target(self.to_glib_none().0, context.to_glib_none().0, target_list.0))
        }
    }

    fn drag_dest_get_target_list(&self) -> Option<TargetList> {
        unsafe {
            from_glib_none(ffi::gtk_drag_dest_get_target_list(self.to_glib_none().0))
        }
    }

    fn drag_dest_get_track_motion(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_drag_dest_get_track_motion(self.to_glib_none().0))
        }
    }

    fn drag_dest_set_proxy(&self, proxy_window: &gdk::Window, protocol: gdk::DragProtocol, use_coordinates: bool) {
        unsafe {
            ffi::gtk_drag_dest_set_proxy(self.to_glib_none().0, proxy_window.to_glib_none().0, protocol.to_glib(), use_coordinates.to_glib());
        }
    }

    fn drag_dest_set_target_list<'a, P: Into<Option<&'a TargetList>>>(&self, target_list: P) {
        let target_list = target_list.into();
        let target_list = target_list.to_glib_none();
        unsafe {
            ffi::gtk_drag_dest_set_target_list(self.to_glib_none().0, target_list.0);
        }
    }

    fn drag_dest_set_track_motion(&self, track_motion: bool) {
        unsafe {
            ffi::gtk_drag_dest_set_track_motion(self.to_glib_none().0, track_motion.to_glib());
        }
    }

    fn drag_dest_unset(&self) {
        unsafe {
            ffi::gtk_drag_dest_unset(self.to_glib_none().0);
        }
    }

    fn drag_get_data(&self, context: &gdk::DragContext, target: &gdk::Atom, time_: u32) {
        unsafe {
            ffi::gtk_drag_get_data(self.to_glib_none().0, context.to_glib_none().0, target.to_glib_none().0, time_);
        }
    }

    fn drag_highlight(&self) {
        unsafe {
            ffi::gtk_drag_highlight(self.to_glib_none().0);
        }
    }

    fn drag_source_add_image_targets(&self) {
        unsafe {
            ffi::gtk_drag_source_add_image_targets(self.to_glib_none().0);
        }
    }

    fn drag_source_add_text_targets(&self) {
        unsafe {
            ffi::gtk_drag_source_add_text_targets(self.to_glib_none().0);
        }
    }

    fn drag_source_add_uri_targets(&self) {
        unsafe {
            ffi::gtk_drag_source_add_uri_targets(self.to_glib_none().0);
        }
    }

    fn drag_source_get_target_list(&self) -> Option<TargetList> {
        unsafe {
            from_glib_none(ffi::gtk_drag_source_get_target_list(self.to_glib_none().0))
        }
    }

    fn drag_source_set_icon_gicon<P: IsA<gio::Icon>>(&self, icon: &P) {
        unsafe {
            ffi::gtk_drag_source_set_icon_gicon(self.to_glib_none().0, icon.to_glib_none().0);
        }
    }

    fn drag_source_set_icon_name(&self, icon_name: &str) {
        unsafe {
            ffi::gtk_drag_source_set_icon_name(self.to_glib_none().0, icon_name.to_glib_none().0);
        }
    }

    fn drag_source_set_icon_pixbuf(&self, pixbuf: &gdk_pixbuf::Pixbuf) {
        unsafe {
            ffi::gtk_drag_source_set_icon_pixbuf(self.to_glib_none().0, pixbuf.to_glib_none().0);
        }
    }

    fn drag_source_set_icon_stock(&self, stock_id: &str) {
        unsafe {
            ffi::gtk_drag_source_set_icon_stock(self.to_glib_none().0, stock_id.to_glib_none().0);
        }
    }

    fn drag_source_set_target_list<'a, P: Into<Option<&'a TargetList>>>(&self, target_list: P) {
        let target_list = target_list.into();
        let target_list = target_list.to_glib_none();
        unsafe {
            ffi::gtk_drag_source_set_target_list(self.to_glib_none().0, target_list.0);
        }
    }

    fn drag_source_unset(&self) {
        unsafe {
            ffi::gtk_drag_source_unset(self.to_glib_none().0);
        }
    }

    fn drag_unhighlight(&self) {
        unsafe {
            ffi::gtk_drag_unhighlight(self.to_glib_none().0);
        }
    }

    fn draw(&self, cr: &cairo::Context) {
        unsafe {
            ffi::gtk_widget_draw(self.to_glib_none().0, mut_override(cr.to_glib_none().0));
        }
    }

    fn error_bell(&self) {
        unsafe {
            ffi::gtk_widget_error_bell(self.to_glib_none().0);
        }
    }

    fn event(&self, event: &gdk::Event) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_event(self.to_glib_none().0, mut_override(event.to_glib_none().0)))
        }
    }

    fn freeze_child_notify(&self) {
        unsafe {
            ffi::gtk_widget_freeze_child_notify(self.to_glib_none().0);
        }
    }

    //fn get_accessible(&self) -> /*Ignored*/Option<atk::Object> {
    //    unsafe { TODO: call ffi::gtk_widget_get_accessible() }
    //}

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_action_group(&self, prefix: &str) -> Option<gio::ActionGroup> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_action_group(self.to_glib_none().0, prefix.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v3_10", feature = "dox"))]
    fn get_allocated_baseline(&self) -> i32 {
        unsafe {
            ffi::gtk_widget_get_allocated_baseline(self.to_glib_none().0)
        }
    }

    fn get_allocated_height(&self) -> i32 {
        unsafe {
            ffi::gtk_widget_get_allocated_height(self.to_glib_none().0)
        }
    }

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    fn get_allocated_size(&self) -> (Allocation, i32) {
        unsafe {
            let mut allocation = Allocation::uninitialized();
            let mut baseline = mem::uninitialized();
            ffi::gtk_widget_get_allocated_size(self.to_glib_none().0, allocation.to_glib_none_mut().0, &mut baseline);
            (allocation, baseline)
        }
    }

    fn get_allocated_width(&self) -> i32 {
        unsafe {
            ffi::gtk_widget_get_allocated_width(self.to_glib_none().0)
        }
    }

    fn get_allocation(&self) -> Allocation {
        unsafe {
            let mut allocation = Allocation::uninitialized();
            ffi::gtk_widget_get_allocation(self.to_glib_none().0, allocation.to_glib_none_mut().0);
            allocation
        }
    }

    fn get_ancestor(&self, widget_type: glib::types::Type) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_ancestor(self.to_glib_none().0, widget_type.to_glib()))
        }
    }

    fn get_app_paintable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_app_paintable(self.to_glib_none().0))
        }
    }

    fn get_can_default(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_can_default(self.to_glib_none().0))
        }
    }

    fn get_can_focus(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_can_focus(self.to_glib_none().0))
        }
    }

    fn get_child_visible(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_child_visible(self.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v3_14", feature = "dox"))]
    fn get_clip(&self) -> Allocation {
        unsafe {
            let mut clip = Allocation::uninitialized();
            ffi::gtk_widget_get_clip(self.to_glib_none().0, clip.to_glib_none_mut().0);
            clip
        }
    }

    fn get_clipboard(&self, selection: &gdk::Atom) -> Clipboard {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_clipboard(self.to_glib_none().0, selection.to_glib_none().0))
        }
    }

    fn get_composite_name(&self) -> Option<String> {
        unsafe {
            from_glib_full(ffi::gtk_widget_get_composite_name(self.to_glib_none().0))
        }
    }

    fn get_device_enabled<P: IsA<gdk::Device>>(&self, device: &P) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_device_enabled(self.to_glib_none().0, device.to_glib_none().0))
        }
    }

    fn get_device_events<P: IsA<gdk::Device>>(&self, device: &P) -> gdk::EventMask {
        unsafe {
            from_glib(ffi::gtk_widget_get_device_events(self.to_glib_none().0, device.to_glib_none().0))
        }
    }

    fn get_direction(&self) -> TextDirection {
        unsafe {
            from_glib(ffi::gtk_widget_get_direction(self.to_glib_none().0))
        }
    }

    fn get_display(&self) -> Option<gdk::Display> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_display(self.to_glib_none().0))
        }
    }

    fn get_double_buffered(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_double_buffered(self.to_glib_none().0))
        }
    }

    fn get_events(&self) -> i32 {
        unsafe {
            ffi::gtk_widget_get_events(self.to_glib_none().0)
        }
    }

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    fn get_focus_on_click(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_focus_on_click(self.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn get_font_map(&self) -> Option<pango::FontMap> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_font_map(self.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn get_font_options(&self) -> Option<cairo::FontOptions> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_font_options(self.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v3_8", feature = "dox"))]
    fn get_frame_clock(&self) -> Option<gdk::FrameClock> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_frame_clock(self.to_glib_none().0))
        }
    }

    fn get_halign(&self) -> Align {
        unsafe {
            from_glib(ffi::gtk_widget_get_halign(self.to_glib_none().0))
        }
    }

    fn get_has_tooltip(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_has_tooltip(self.to_glib_none().0))
        }
    }

    fn get_has_window(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_has_window(self.to_glib_none().0))
        }
    }

    fn get_hexpand(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_hexpand(self.to_glib_none().0))
        }
    }

    fn get_hexpand_set(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_hexpand_set(self.to_glib_none().0))
        }
    }

    fn get_mapped(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_mapped(self.to_glib_none().0))
        }
    }

    fn get_margin_bottom(&self) -> i32 {
        unsafe {
            ffi::gtk_widget_get_margin_bottom(self.to_glib_none().0)
        }
    }

    #[cfg(any(feature = "v3_12", feature = "dox"))]
    fn get_margin_end(&self) -> i32 {
        unsafe {
            ffi::gtk_widget_get_margin_end(self.to_glib_none().0)
        }
    }

    fn get_margin_left(&self) -> i32 {
        unsafe {
            ffi::gtk_widget_get_margin_left(self.to_glib_none().0)
        }
    }

    fn get_margin_right(&self) -> i32 {
        unsafe {
            ffi::gtk_widget_get_margin_right(self.to_glib_none().0)
        }
    }

    #[cfg(any(feature = "v3_12", feature = "dox"))]
    fn get_margin_start(&self) -> i32 {
        unsafe {
            ffi::gtk_widget_get_margin_start(self.to_glib_none().0)
        }
    }

    fn get_margin_top(&self) -> i32 {
        unsafe {
            ffi::gtk_widget_get_margin_top(self.to_glib_none().0)
        }
    }

    fn get_modifier_mask(&self, intent: gdk::ModifierIntent) -> gdk::ModifierType {
        unsafe {
            from_glib(ffi::gtk_widget_get_modifier_mask(self.to_glib_none().0, intent.to_glib()))
        }
    }

    fn get_name(&self) -> Option<String> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_name(self.to_glib_none().0))
        }
    }

    fn get_no_show_all(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_no_show_all(self.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v3_8", feature = "dox"))]
    fn get_opacity(&self) -> f64 {
        unsafe {
            ffi::gtk_widget_get_opacity(self.to_glib_none().0)
        }
    }

    fn get_pango_context(&self) -> Option<pango::Context> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_pango_context(self.to_glib_none().0))
        }
    }

    fn get_parent(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_parent(self.to_glib_none().0))
        }
    }

    fn get_parent_window(&self) -> Option<gdk::Window> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_parent_window(self.to_glib_none().0))
        }
    }

    fn get_path(&self) -> WidgetPath {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_path(self.to_glib_none().0))
        }
    }

    fn get_preferred_height(&self) -> (i32, i32) {
        unsafe {
            let mut minimum_height = mem::uninitialized();
            let mut natural_height = mem::uninitialized();
            ffi::gtk_widget_get_preferred_height(self.to_glib_none().0, &mut minimum_height, &mut natural_height);
            (minimum_height, natural_height)
        }
    }

    #[cfg(any(feature = "v3_10", feature = "dox"))]
    fn get_preferred_height_and_baseline_for_width(&self, width: i32) -> (i32, i32, i32, i32) {
        unsafe {
            let mut minimum_height = mem::uninitialized();
            let mut natural_height = mem::uninitialized();
            let mut minimum_baseline = mem::uninitialized();
            let mut natural_baseline = mem::uninitialized();
            ffi::gtk_widget_get_preferred_height_and_baseline_for_width(self.to_glib_none().0, width, &mut minimum_height, &mut natural_height, &mut minimum_baseline, &mut natural_baseline);
            (minimum_height, natural_height, minimum_baseline, natural_baseline)
        }
    }

    fn get_preferred_height_for_width(&self, width: i32) -> (i32, i32) {
        unsafe {
            let mut minimum_height = mem::uninitialized();
            let mut natural_height = mem::uninitialized();
            ffi::gtk_widget_get_preferred_height_for_width(self.to_glib_none().0, width, &mut minimum_height, &mut natural_height);
            (minimum_height, natural_height)
        }
    }

    fn get_preferred_size(&self) -> (Requisition, Requisition) {
        unsafe {
            let mut minimum_size = Requisition::uninitialized();
            let mut natural_size = Requisition::uninitialized();
            ffi::gtk_widget_get_preferred_size(self.to_glib_none().0, minimum_size.to_glib_none_mut().0, natural_size.to_glib_none_mut().0);
            (minimum_size, natural_size)
        }
    }

    fn get_preferred_width(&self) -> (i32, i32) {
        unsafe {
            let mut minimum_width = mem::uninitialized();
            let mut natural_width = mem::uninitialized();
            ffi::gtk_widget_get_preferred_width(self.to_glib_none().0, &mut minimum_width, &mut natural_width);
            (minimum_width, natural_width)
        }
    }

    fn get_preferred_width_for_height(&self, height: i32) -> (i32, i32) {
        unsafe {
            let mut minimum_width = mem::uninitialized();
            let mut natural_width = mem::uninitialized();
            ffi::gtk_widget_get_preferred_width_for_height(self.to_glib_none().0, height, &mut minimum_width, &mut natural_width);
            (minimum_width, natural_width)
        }
    }

    fn get_realized(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_realized(self.to_glib_none().0))
        }
    }

    fn get_receives_default(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_receives_default(self.to_glib_none().0))
        }
    }

    fn get_request_mode(&self) -> SizeRequestMode {
        unsafe {
            from_glib(ffi::gtk_widget_get_request_mode(self.to_glib_none().0))
        }
    }

    fn get_root_window(&self) -> Option<gdk::Window> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_root_window(self.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v3_10", feature = "dox"))]
    fn get_scale_factor(&self) -> i32 {
        unsafe {
            ffi::gtk_widget_get_scale_factor(self.to_glib_none().0)
        }
    }

    fn get_screen(&self) -> Option<gdk::Screen> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_screen(self.to_glib_none().0))
        }
    }

    fn get_sensitive(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_sensitive(self.to_glib_none().0))
        }
    }

    fn get_settings(&self) -> Option<Settings> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_settings(self.to_glib_none().0))
        }
    }

    fn get_size_request(&self) -> (i32, i32) {
        unsafe {
            let mut width = mem::uninitialized();
            let mut height = mem::uninitialized();
            ffi::gtk_widget_get_size_request(self.to_glib_none().0, &mut width, &mut height);
            (width, height)
        }
    }

    fn get_state_flags(&self) -> StateFlags {
        unsafe {
            from_glib(ffi::gtk_widget_get_state_flags(self.to_glib_none().0))
        }
    }

    fn get_style_context(&self) -> Option<StyleContext> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_style_context(self.to_glib_none().0))
        }
    }

    fn get_support_multidevice(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_support_multidevice(self.to_glib_none().0))
        }
    }

    fn get_template_child(&self, widget_type: glib::types::Type, name: &str) -> Option<glib::Object> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_template_child(self.to_glib_none().0, widget_type.to_glib(), name.to_glib_none().0))
        }
    }

    fn get_tooltip_markup(&self) -> Option<String> {
        unsafe {
            from_glib_full(ffi::gtk_widget_get_tooltip_markup(self.to_glib_none().0))
        }
    }

    fn get_tooltip_text(&self) -> Option<String> {
        unsafe {
            from_glib_full(ffi::gtk_widget_get_tooltip_text(self.to_glib_none().0))
        }
    }

    fn get_tooltip_window(&self) -> Option<Window> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_tooltip_window(self.to_glib_none().0))
        }
    }

    fn get_toplevel(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_toplevel(self.to_glib_none().0))
        }
    }

    fn get_valign(&self) -> Align {
        unsafe {
            from_glib(ffi::gtk_widget_get_valign(self.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v3_10", feature = "dox"))]
    fn get_valign_with_baseline(&self) -> Align {
        unsafe {
            from_glib(ffi::gtk_widget_get_valign_with_baseline(self.to_glib_none().0))
        }
    }

    fn get_vexpand(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_vexpand(self.to_glib_none().0))
        }
    }

    fn get_vexpand_set(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_vexpand_set(self.to_glib_none().0))
        }
    }

    fn get_visible(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_visible(self.to_glib_none().0))
        }
    }

    fn get_visual(&self) -> Option<gdk::Visual> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_visual(self.to_glib_none().0))
        }
    }

    fn get_window(&self) -> Option<gdk::Window> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_window(self.to_glib_none().0))
        }
    }

    fn grab_add(&self) {
        unsafe {
            ffi::gtk_grab_add(self.to_glib_none().0);
        }
    }

    fn grab_default(&self) {
        unsafe {
            ffi::gtk_widget_grab_default(self.to_glib_none().0);
        }
    }

    fn grab_focus(&self) {
        unsafe {
            ffi::gtk_widget_grab_focus(self.to_glib_none().0);
        }
    }

    fn grab_remove(&self) {
        unsafe {
            ffi::gtk_grab_remove(self.to_glib_none().0);
        }
    }

    fn has_default(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_has_default(self.to_glib_none().0))
        }
    }

    fn has_focus(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_has_focus(self.to_glib_none().0))
        }
    }

    fn has_grab(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_has_grab(self.to_glib_none().0))
        }
    }

    fn has_screen(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_has_screen(self.to_glib_none().0))
        }
    }

    fn has_visible_focus(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_has_visible_focus(self.to_glib_none().0))
        }
    }

    fn hide(&self) {
        unsafe {
            ffi::gtk_widget_hide(self.to_glib_none().0);
        }
    }

    fn hide_on_delete(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_hide_on_delete(self.to_glib_none().0))
        }
    }

    fn in_destruction(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_in_destruction(self.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v3_10", feature = "dox"))]
    fn init_template(&self) {
        unsafe {
            ffi::gtk_widget_init_template(self.to_glib_none().0);
        }
    }

    fn input_shape_combine_region<'a, P: Into<Option<&'a cairo::Region>>>(&self, region: P) {
        let region = region.into();
        unsafe {
            ffi::gtk_widget_input_shape_combine_region(self.to_glib_none().0, mut_override(region.to_glib_none().0));
        }
    }

    #[cfg(any(feature = "v3_6", feature = "dox"))]
    fn insert_action_group<'a, P: IsA<gio::ActionGroup> + 'a, Q: Into<Option<&'a P>>>(&self, name: &str, group: Q) {
        let group = group.into();
        let group = group.to_glib_none();
        unsafe {
            ffi::gtk_widget_insert_action_group(self.to_glib_none().0, name.to_glib_none().0, group.0);
        }
    }

    fn is_ancestor<P: IsA<Widget>>(&self, ancestor: &P) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_is_ancestor(self.to_glib_none().0, ancestor.to_glib_none().0))
        }
    }

    fn is_composited(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_is_composited(self.to_glib_none().0))
        }
    }

    fn is_drawable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_is_drawable(self.to_glib_none().0))
        }
    }

    fn is_focus(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_is_focus(self.to_glib_none().0))
        }
    }

    fn is_sensitive(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_is_sensitive(self.to_glib_none().0))
        }
    }

    fn is_toplevel(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_is_toplevel(self.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v3_8", feature = "dox"))]
    fn is_visible(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_is_visible(self.to_glib_none().0))
        }
    }

    fn keynav_failed(&self, direction: DirectionType) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_keynav_failed(self.to_glib_none().0, direction.to_glib()))
        }
    }

    fn list_accel_closures(&self) -> Vec<glib::Closure> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::gtk_widget_list_accel_closures(self.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn list_action_prefixes(&self) -> Vec<String> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::gtk_widget_list_action_prefixes(self.to_glib_none().0))
        }
    }

    fn list_mnemonic_labels(&self) -> Vec<Widget> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::gtk_widget_list_mnemonic_labels(self.to_glib_none().0))
        }
    }

    fn map(&self) {
        unsafe {
            ffi::gtk_widget_map(self.to_glib_none().0);
        }
    }

    fn mnemonic_activate(&self, group_cycling: bool) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_mnemonic_activate(self.to_glib_none().0, group_cycling.to_glib()))
        }
    }

    fn override_background_color<'a, P: Into<Option<&'a gdk::RGBA>>>(&self, state: StateFlags, color: P) {
        let color = color.into();
        let color = color.to_glib_none();
        unsafe {
            ffi::gtk_widget_override_background_color(self.to_glib_none().0, state.to_glib(), color.0);
        }
    }

    fn override_color<'a, P: Into<Option<&'a gdk::RGBA>>>(&self, state: StateFlags, color: P) {
        let color = color.into();
        let color = color.to_glib_none();
        unsafe {
            ffi::gtk_widget_override_color(self.to_glib_none().0, state.to_glib(), color.0);
        }
    }

    fn override_cursor<'a, 'b, P: Into<Option<&'a gdk::RGBA>>, Q: Into<Option<&'b gdk::RGBA>>>(&self, cursor: P, secondary_cursor: Q) {
        let cursor = cursor.into();
        let cursor = cursor.to_glib_none();
        let secondary_cursor = secondary_cursor.into();
        let secondary_cursor = secondary_cursor.to_glib_none();
        unsafe {
            ffi::gtk_widget_override_cursor(self.to_glib_none().0, cursor.0, secondary_cursor.0);
        }
    }

    fn override_font<'a, P: Into<Option<&'a pango::FontDescription>>>(&self, font_desc: P) {
        let font_desc = font_desc.into();
        let font_desc = font_desc.to_glib_none();
        unsafe {
            ffi::gtk_widget_override_font(self.to_glib_none().0, font_desc.0);
        }
    }

    fn override_symbolic_color<'a, P: Into<Option<&'a gdk::RGBA>>>(&self, name: &str, color: P) {
        let color = color.into();
        let color = color.to_glib_none();
        unsafe {
            ffi::gtk_widget_override_symbolic_color(self.to_glib_none().0, name.to_glib_none().0, color.0);
        }
    }

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    fn queue_allocate(&self) {
        unsafe {
            ffi::gtk_widget_queue_allocate(self.to_glib_none().0);
        }
    }

    fn queue_compute_expand(&self) {
        unsafe {
            ffi::gtk_widget_queue_compute_expand(self.to_glib_none().0);
        }
    }

    fn queue_draw(&self) {
        unsafe {
            ffi::gtk_widget_queue_draw(self.to_glib_none().0);
        }
    }

    fn queue_draw_area(&self, x: i32, y: i32, width: i32, height: i32) {
        unsafe {
            ffi::gtk_widget_queue_draw_area(self.to_glib_none().0, x, y, width, height);
        }
    }

    fn queue_draw_region(&self, region: &cairo::Region) {
        unsafe {
            ffi::gtk_widget_queue_draw_region(self.to_glib_none().0, region.to_glib_none().0);
        }
    }

    fn queue_resize(&self) {
        unsafe {
            ffi::gtk_widget_queue_resize(self.to_glib_none().0);
        }
    }

    fn queue_resize_no_redraw(&self) {
        unsafe {
            ffi::gtk_widget_queue_resize_no_redraw(self.to_glib_none().0);
        }
    }

    fn realize(&self) {
        unsafe {
            ffi::gtk_widget_realize(self.to_glib_none().0);
        }
    }

    fn region_intersect(&self, region: &cairo::Region) -> Option<cairo::Region> {
        unsafe {
            from_glib_full(ffi::gtk_widget_region_intersect(self.to_glib_none().0, region.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v3_8", feature = "dox"))]
    fn register_window(&self, window: &gdk::Window) {
        unsafe {
            ffi::gtk_widget_register_window(self.to_glib_none().0, window.to_glib_none().0);
        }
    }

    fn remove_accelerator(&self, accel_group: &AccelGroup, accel_key: u32, accel_mods: gdk::ModifierType) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_remove_accelerator(self.to_glib_none().0, accel_group.to_glib_none().0, accel_key, accel_mods.to_glib()))
        }
    }

    fn remove_mnemonic_label<P: IsA<Widget>>(&self, label: &P) {
        unsafe {
            ffi::gtk_widget_remove_mnemonic_label(self.to_glib_none().0, label.to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v3_8", feature = "dox"))]
    fn remove_tick_callback(&self, id: u32) {
        unsafe {
            ffi::gtk_widget_remove_tick_callback(self.to_glib_none().0, id);
        }
    }

    fn render_icon_pixbuf(&self, stock_id: &str, size: i32) -> Option<gdk_pixbuf::Pixbuf> {
        unsafe {
            from_glib_full(ffi::gtk_widget_render_icon_pixbuf(self.to_glib_none().0, stock_id.to_glib_none().0, size))
        }
    }

    fn reparent<P: IsA<Widget>>(&self, new_parent: &P) {
        unsafe {
            ffi::gtk_widget_reparent(self.to_glib_none().0, new_parent.to_glib_none().0);
        }
    }

    fn reset_style(&self) {
        unsafe {
            ffi::gtk_widget_reset_style(self.to_glib_none().0);
        }
    }

    fn send_expose(&self, event: &gdk::Event) -> i32 {
        unsafe {
            ffi::gtk_widget_send_expose(self.to_glib_none().0, mut_override(event.to_glib_none().0))
        }
    }

    fn send_focus_change(&self, event: &gdk::Event) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_send_focus_change(self.to_glib_none().0, mut_override(event.to_glib_none().0)))
        }
    }

    fn set_accel_path<'a, 'b, P: Into<Option<&'a str>>, Q: Into<Option<&'b AccelGroup>>>(&self, accel_path: P, accel_group: Q) {
        let accel_path = accel_path.into();
        let accel_path = accel_path.to_glib_none();
        let accel_group = accel_group.into();
        let accel_group = accel_group.to_glib_none();
        unsafe {
            ffi::gtk_widget_set_accel_path(self.to_glib_none().0, accel_path.0, accel_group.0);
        }
    }

    fn set_allocation(&self, allocation: &Allocation) {
        unsafe {
            ffi::gtk_widget_set_allocation(self.to_glib_none().0, allocation.to_glib_none().0);
        }
    }

    fn set_app_paintable(&self, app_paintable: bool) {
        unsafe {
            ffi::gtk_widget_set_app_paintable(self.to_glib_none().0, app_paintable.to_glib());
        }
    }

    fn set_can_default(&self, can_default: bool) {
        unsafe {
            ffi::gtk_widget_set_can_default(self.to_glib_none().0, can_default.to_glib());
        }
    }

    fn set_can_focus(&self, can_focus: bool) {
        unsafe {
            ffi::gtk_widget_set_can_focus(self.to_glib_none().0, can_focus.to_glib());
        }
    }

    fn set_child_visible(&self, is_visible: bool) {
        unsafe {
            ffi::gtk_widget_set_child_visible(self.to_glib_none().0, is_visible.to_glib());
        }
    }

    #[cfg(any(feature = "v3_14", feature = "dox"))]
    fn set_clip(&self, clip: &Allocation) {
        unsafe {
            ffi::gtk_widget_set_clip(self.to_glib_none().0, clip.to_glib_none().0);
        }
    }

    fn set_composite_name(&self, name: &str) {
        unsafe {
            ffi::gtk_widget_set_composite_name(self.to_glib_none().0, name.to_glib_none().0);
        }
    }

    fn set_device_enabled<P: IsA<gdk::Device>>(&self, device: &P, enabled: bool) {
        unsafe {
            ffi::gtk_widget_set_device_enabled(self.to_glib_none().0, device.to_glib_none().0, enabled.to_glib());
        }
    }

    fn set_device_events<P: IsA<gdk::Device>>(&self, device: &P, events: gdk::EventMask) {
        unsafe {
            ffi::gtk_widget_set_device_events(self.to_glib_none().0, device.to_glib_none().0, events.to_glib());
        }
    }

    fn set_direction(&self, dir: TextDirection) {
        unsafe {
            ffi::gtk_widget_set_direction(self.to_glib_none().0, dir.to_glib());
        }
    }

    fn set_double_buffered(&self, double_buffered: bool) {
        unsafe {
            ffi::gtk_widget_set_double_buffered(self.to_glib_none().0, double_buffered.to_glib());
        }
    }

    fn set_events(&self, events: i32) {
        unsafe {
            ffi::gtk_widget_set_events(self.to_glib_none().0, events);
        }
    }

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    fn set_focus_on_click(&self, focus_on_click: bool) {
        unsafe {
            ffi::gtk_widget_set_focus_on_click(self.to_glib_none().0, focus_on_click.to_glib());
        }
    }

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn set_font_map<'a, P: Into<Option<&'a pango::FontMap>>>(&self, font_map: P) {
        let font_map = font_map.into();
        let font_map = font_map.to_glib_none();
        unsafe {
            ffi::gtk_widget_set_font_map(self.to_glib_none().0, font_map.0);
        }
    }

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn set_font_options<'a, P: Into<Option<&'a cairo::FontOptions>>>(&self, options: P) {
        let options = options.into();
        let options = options.to_glib_none();
        unsafe {
            ffi::gtk_widget_set_font_options(self.to_glib_none().0, options.0);
        }
    }

    fn set_halign(&self, align: Align) {
        unsafe {
            ffi::gtk_widget_set_halign(self.to_glib_none().0, align.to_glib());
        }
    }

    fn set_has_tooltip(&self, has_tooltip: bool) {
        unsafe {
            ffi::gtk_widget_set_has_tooltip(self.to_glib_none().0, has_tooltip.to_glib());
        }
    }

    fn set_has_window(&self, has_window: bool) {
        unsafe {
            ffi::gtk_widget_set_has_window(self.to_glib_none().0, has_window.to_glib());
        }
    }

    fn set_hexpand(&self, expand: bool) {
        unsafe {
            ffi::gtk_widget_set_hexpand(self.to_glib_none().0, expand.to_glib());
        }
    }

    fn set_hexpand_set(&self, set: bool) {
        unsafe {
            ffi::gtk_widget_set_hexpand_set(self.to_glib_none().0, set.to_glib());
        }
    }

    fn set_mapped(&self, mapped: bool) {
        unsafe {
            ffi::gtk_widget_set_mapped(self.to_glib_none().0, mapped.to_glib());
        }
    }

    fn set_margin_bottom(&self, margin: i32) {
        unsafe {
            ffi::gtk_widget_set_margin_bottom(self.to_glib_none().0, margin);
        }
    }

    #[cfg(any(feature = "v3_12", feature = "dox"))]
    fn set_margin_end(&self, margin: i32) {
        unsafe {
            ffi::gtk_widget_set_margin_end(self.to_glib_none().0, margin);
        }
    }

    fn set_margin_left(&self, margin: i32) {
        unsafe {
            ffi::gtk_widget_set_margin_left(self.to_glib_none().0, margin);
        }
    }

    fn set_margin_right(&self, margin: i32) {
        unsafe {
            ffi::gtk_widget_set_margin_right(self.to_glib_none().0, margin);
        }
    }

    #[cfg(any(feature = "v3_12", feature = "dox"))]
    fn set_margin_start(&self, margin: i32) {
        unsafe {
            ffi::gtk_widget_set_margin_start(self.to_glib_none().0, margin);
        }
    }

    fn set_margin_top(&self, margin: i32) {
        unsafe {
            ffi::gtk_widget_set_margin_top(self.to_glib_none().0, margin);
        }
    }

    fn set_name(&self, name: &str) {
        unsafe {
            ffi::gtk_widget_set_name(self.to_glib_none().0, name.to_glib_none().0);
        }
    }

    fn set_no_show_all(&self, no_show_all: bool) {
        unsafe {
            ffi::gtk_widget_set_no_show_all(self.to_glib_none().0, no_show_all.to_glib());
        }
    }

    #[cfg(any(feature = "v3_8", feature = "dox"))]
    fn set_opacity(&self, opacity: f64) {
        unsafe {
            ffi::gtk_widget_set_opacity(self.to_glib_none().0, opacity);
        }
    }

    fn set_parent<P: IsA<Widget>>(&self, parent: &P) {
        unsafe {
            ffi::gtk_widget_set_parent(self.to_glib_none().0, parent.to_glib_none().0);
        }
    }

    fn set_parent_window(&self, parent_window: &gdk::Window) {
        unsafe {
            ffi::gtk_widget_set_parent_window(self.to_glib_none().0, parent_window.to_glib_none().0);
        }
    }

    fn set_realized(&self, realized: bool) {
        unsafe {
            ffi::gtk_widget_set_realized(self.to_glib_none().0, realized.to_glib());
        }
    }

    fn set_receives_default(&self, receives_default: bool) {
        unsafe {
            ffi::gtk_widget_set_receives_default(self.to_glib_none().0, receives_default.to_glib());
        }
    }

    fn set_redraw_on_allocate(&self, redraw_on_allocate: bool) {
        unsafe {
            ffi::gtk_widget_set_redraw_on_allocate(self.to_glib_none().0, redraw_on_allocate.to_glib());
        }
    }

    fn set_sensitive(&self, sensitive: bool) {
        unsafe {
            ffi::gtk_widget_set_sensitive(self.to_glib_none().0, sensitive.to_glib());
        }
    }

    fn set_size_request(&self, width: i32, height: i32) {
        unsafe {
            ffi::gtk_widget_set_size_request(self.to_glib_none().0, width, height);
        }
    }

    fn set_state_flags(&self, flags: StateFlags, clear: bool) {
        unsafe {
            ffi::gtk_widget_set_state_flags(self.to_glib_none().0, flags.to_glib(), clear.to_glib());
        }
    }

    fn set_support_multidevice(&self, support_multidevice: bool) {
        unsafe {
            ffi::gtk_widget_set_support_multidevice(self.to_glib_none().0, support_multidevice.to_glib());
        }
    }

    fn set_tooltip_markup<'a, P: Into<Option<&'a str>>>(&self, markup: P) {
        let markup = markup.into();
        let markup = markup.to_glib_none();
        unsafe {
            ffi::gtk_widget_set_tooltip_markup(self.to_glib_none().0, markup.0);
        }
    }

    fn set_tooltip_text<'a, P: Into<Option<&'a str>>>(&self, text: P) {
        let text = text.into();
        let text = text.to_glib_none();
        unsafe {
            ffi::gtk_widget_set_tooltip_text(self.to_glib_none().0, text.0);
        }
    }

    fn set_tooltip_window<'a, P: IsA<Window> + 'a, Q: Into<Option<&'a P>>>(&self, custom_window: Q) {
        let custom_window = custom_window.into();
        let custom_window = custom_window.to_glib_none();
        unsafe {
            ffi::gtk_widget_set_tooltip_window(self.to_glib_none().0, custom_window.0);
        }
    }

    fn set_valign(&self, align: Align) {
        unsafe {
            ffi::gtk_widget_set_valign(self.to_glib_none().0, align.to_glib());
        }
    }

    fn set_vexpand(&self, expand: bool) {
        unsafe {
            ffi::gtk_widget_set_vexpand(self.to_glib_none().0, expand.to_glib());
        }
    }

    fn set_vexpand_set(&self, set: bool) {
        unsafe {
            ffi::gtk_widget_set_vexpand_set(self.to_glib_none().0, set.to_glib());
        }
    }

    fn set_visible(&self, visible: bool) {
        unsafe {
            ffi::gtk_widget_set_visible(self.to_glib_none().0, visible.to_glib());
        }
    }

    fn set_visual<'a, P: Into<Option<&'a gdk::Visual>>>(&self, visual: P) {
        let visual = visual.into();
        let visual = visual.to_glib_none();
        unsafe {
            ffi::gtk_widget_set_visual(self.to_glib_none().0, visual.0);
        }
    }

    fn set_window(&self, window: &gdk::Window) {
        unsafe {
            ffi::gtk_widget_set_window(self.to_glib_none().0, window.to_glib_full());
        }
    }

    fn shape_combine_region<'a, P: Into<Option<&'a cairo::Region>>>(&self, region: P) {
        let region = region.into();
        unsafe {
            ffi::gtk_widget_shape_combine_region(self.to_glib_none().0, mut_override(region.to_glib_none().0));
        }
    }

    fn show(&self) {
        unsafe {
            ffi::gtk_widget_show(self.to_glib_none().0);
        }
    }

    fn show_all(&self) {
        unsafe {
            ffi::gtk_widget_show_all(self.to_glib_none().0);
        }
    }

    fn show_now(&self) {
        unsafe {
            ffi::gtk_widget_show_now(self.to_glib_none().0);
        }
    }

    fn size_allocate(&self, allocation: &mut Allocation) {
        unsafe {
            ffi::gtk_widget_size_allocate(self.to_glib_none().0, allocation.to_glib_none_mut().0);
        }
    }

    #[cfg(any(feature = "v3_10", feature = "dox"))]
    fn size_allocate_with_baseline(&self, allocation: &mut Allocation, baseline: i32) {
        unsafe {
            ffi::gtk_widget_size_allocate_with_baseline(self.to_glib_none().0, allocation.to_glib_none_mut().0, baseline);
        }
    }

    //fn style_get(&self, first_property_name: &str, : /*Unknown conversion*//*Unimplemented*/Fundamental: VarArgs) {
    //    unsafe { TODO: call ffi::gtk_widget_style_get() }
    //}

    //fn style_get_valist(&self, first_property_name: &str, var_args: /*Unknown conversion*//*Unimplemented*/Unsupported) {
    //    unsafe { TODO: call ffi::gtk_widget_style_get_valist() }
    //}

    fn thaw_child_notify(&self) {
        unsafe {
            ffi::gtk_widget_thaw_child_notify(self.to_glib_none().0);
        }
    }

    fn translate_coordinates<P: IsA<Widget>>(&self, dest_widget: &P, src_x: i32, src_y: i32) -> Option<(i32, i32)> {
        unsafe {
            let mut dest_x = mem::uninitialized();
            let mut dest_y = mem::uninitialized();
            let ret = from_glib(ffi::gtk_widget_translate_coordinates(self.to_glib_none().0, dest_widget.to_glib_none().0, src_x, src_y, &mut dest_x, &mut dest_y));
            if ret { Some((dest_x, dest_y)) } else { None }
        }
    }

    fn trigger_tooltip_query(&self) {
        unsafe {
            ffi::gtk_widget_trigger_tooltip_query(self.to_glib_none().0);
        }
    }

    fn unmap(&self) {
        unsafe {
            ffi::gtk_widget_unmap(self.to_glib_none().0);
        }
    }

    fn unparent(&self) {
        unsafe {
            ffi::gtk_widget_unparent(self.to_glib_none().0);
        }
    }

    fn unrealize(&self) {
        unsafe {
            ffi::gtk_widget_unrealize(self.to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v3_8", feature = "dox"))]
    fn unregister_window(&self, window: &gdk::Window) {
        unsafe {
            ffi::gtk_widget_unregister_window(self.to_glib_none().0, window.to_glib_none().0);
        }
    }

    fn unset_state_flags(&self, flags: StateFlags) {
        unsafe {
            ffi::gtk_widget_unset_state_flags(self.to_glib_none().0, flags.to_glib());
        }
    }

    fn get_property_composite_child(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "composite-child".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn get_property_expand(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "expand".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_expand(&self, expand: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "expand".to_glib_none().0, Value::from(&expand).to_glib_none().0);
        }
    }

    fn get_property_has_default(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "has-default".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_has_default(&self, has_default: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "has-default".to_glib_none().0, Value::from(&has_default).to_glib_none().0);
        }
    }

    fn get_property_has_focus(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "has-focus".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_has_focus(&self, has_focus: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "has-focus".to_glib_none().0, Value::from(&has_focus).to_glib_none().0);
        }
    }

    fn get_property_height_request(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "height-request".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_height_request(&self, height_request: i32) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "height-request".to_glib_none().0, Value::from(&height_request).to_glib_none().0);
        }
    }

    fn get_property_is_focus(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "is-focus".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_is_focus(&self, is_focus: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "is-focus".to_glib_none().0, Value::from(&is_focus).to_glib_none().0);
        }
    }

    fn get_property_margin(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "margin".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_margin(&self, margin: i32) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "margin".to_glib_none().0, Value::from(&margin).to_glib_none().0);
        }
    }

    fn get_property_width_request(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "width-request".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_width_request(&self, width_request: i32) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "width-request".to_glib_none().0, Value::from(&width_request).to_glib_none().0);
        }
    }

    fn connect_accel_closures_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "accel-closures-changed",
                transmute(accel_closures_changed_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_button_press_event<F: Fn(&Self, &gdk::EventButton) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::EventButton) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "button-press-event",
                transmute(button_press_event_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_button_release_event<F: Fn(&Self, &gdk::EventButton) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::EventButton) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "button-release-event",
                transmute(button_release_event_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_can_activate_accel<F: Fn(&Self, u32) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, u32) -> bool + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "can-activate-accel",
                transmute(can_activate_accel_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    //fn connect_child_notify<Unsupported or ignored types>(&self, f: F) -> SignalHandlerId {
    //    Ignored child_property: GObject.ParamSpec
    //}

    fn connect_composited_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "composited-changed",
                transmute(composited_changed_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn emit_composited_changed(&self) {
        let _ = self.emit("composited-changed", &[]).unwrap();
    }

    fn connect_configure_event<F: Fn(&Self, &gdk::EventConfigure) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::EventConfigure) -> bool + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "configure-event",
                transmute(configure_event_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_damage_event<F: Fn(&Self, &gdk::EventExpose) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::EventExpose) -> bool + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "damage-event",
                transmute(damage_event_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_delete_event<F: Fn(&Self, &gdk::Event) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::Event) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "delete-event",
                transmute(delete_event_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_destroy<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "destroy",
                transmute(destroy_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_destroy_event<F: Fn(&Self, &gdk::Event) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::Event) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "destroy-event",
                transmute(destroy_event_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_direction_changed<F: Fn(&Self, TextDirection) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, TextDirection) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "direction-changed",
                transmute(direction_changed_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_drag_begin<F: Fn(&Self, &gdk::DragContext) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::DragContext) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "drag-begin",
                transmute(drag_begin_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_drag_data_delete<F: Fn(&Self, &gdk::DragContext) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::DragContext) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "drag-data-delete",
                transmute(drag_data_delete_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_drag_data_get<F: Fn(&Self, &gdk::DragContext, &SelectionData, u32, u32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::DragContext, &SelectionData, u32, u32) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "drag-data-get",
                transmute(drag_data_get_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_drag_data_received<F: Fn(&Self, &gdk::DragContext, i32, i32, &SelectionData, u32, u32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::DragContext, i32, i32, &SelectionData, u32, u32) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "drag-data-received",
                transmute(drag_data_received_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_drag_drop<F: Fn(&Self, &gdk::DragContext, i32, i32, u32) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::DragContext, i32, i32, u32) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "drag-drop",
                transmute(drag_drop_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_drag_end<F: Fn(&Self, &gdk::DragContext) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::DragContext) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "drag-end",
                transmute(drag_end_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_drag_failed<F: Fn(&Self, &gdk::DragContext, DragResult) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::DragContext, DragResult) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "drag-failed",
                transmute(drag_failed_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_drag_leave<F: Fn(&Self, &gdk::DragContext, u32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::DragContext, u32) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "drag-leave",
                transmute(drag_leave_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_drag_motion<F: Fn(&Self, &gdk::DragContext, i32, i32, u32) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::DragContext, i32, i32, u32) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "drag-motion",
                transmute(drag_motion_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_draw<F: Fn(&Self, &cairo::Context) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &cairo::Context) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "draw",
                transmute(draw_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_enter_notify_event<F: Fn(&Self, &gdk::EventCrossing) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::EventCrossing) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "enter-notify-event",
                transmute(enter_notify_event_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_event<F: Fn(&Self, &gdk::Event) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::Event) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "event",
                transmute(event_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_event_after<F: Fn(&Self, &gdk::Event) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::Event) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "event-after",
                transmute(event_after_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_focus<F: Fn(&Self, DirectionType) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, DirectionType) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "focus",
                transmute(focus_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_focus_in_event<F: Fn(&Self, &gdk::EventFocus) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::EventFocus) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "focus-in-event",
                transmute(focus_in_event_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_focus_out_event<F: Fn(&Self, &gdk::EventFocus) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::EventFocus) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "focus-out-event",
                transmute(focus_out_event_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_grab_broken_event<F: Fn(&Self, &gdk::EventGrabBroken) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::EventGrabBroken) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "grab-broken-event",
                transmute(grab_broken_event_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_grab_focus<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "grab-focus",
                transmute(grab_focus_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn emit_grab_focus(&self) {
        let _ = self.emit("grab-focus", &[]).unwrap();
    }

    fn connect_grab_notify<F: Fn(&Self, bool) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, bool) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "grab-notify",
                transmute(grab_notify_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_hide<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "hide",
                transmute(hide_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_hierarchy_changed<F: Fn(&Self, &Option<Widget>) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &Option<Widget>) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "hierarchy-changed",
                transmute(hierarchy_changed_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_key_press_event<F: Fn(&Self, &gdk::EventKey) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::EventKey) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "key-press-event",
                transmute(key_press_event_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_key_release_event<F: Fn(&Self, &gdk::EventKey) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::EventKey) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "key-release-event",
                transmute(key_release_event_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_keynav_failed<F: Fn(&Self, DirectionType) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, DirectionType) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "keynav-failed",
                transmute(keynav_failed_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_leave_notify_event<F: Fn(&Self, &gdk::EventCrossing) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::EventCrossing) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "leave-notify-event",
                transmute(leave_notify_event_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_map<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "map",
                transmute(map_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_mnemonic_activate<F: Fn(&Self, bool) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, bool) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "mnemonic-activate",
                transmute(mnemonic_activate_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_motion_notify_event<F: Fn(&Self, &gdk::EventMotion) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::EventMotion) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "motion-notify-event",
                transmute(motion_notify_event_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_move_focus<F: Fn(&Self, DirectionType) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, DirectionType) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "move-focus",
                transmute(move_focus_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn emit_move_focus(&self, direction: DirectionType) {
        let _ = self.emit("move-focus", &[&direction]).unwrap();
    }

    fn connect_parent_set<F: Fn(&Self, &Option<Widget>) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &Option<Widget>) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "parent-set",
                transmute(parent_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_popup_menu<F: Fn(&Self) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) -> bool + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "popup-menu",
                transmute(popup_menu_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn emit_popup_menu(&self) -> bool {
        let res = self.emit("popup-menu", &[]).unwrap();
        res.unwrap().get().unwrap()
    }

    fn connect_property_notify_event<F: Fn(&Self, &gdk::EventProperty) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::EventProperty) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "property-notify-event",
                transmute(property_notify_event_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_proximity_in_event<F: Fn(&Self, &gdk::EventProximity) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::EventProximity) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "proximity-in-event",
                transmute(proximity_in_event_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_proximity_out_event<F: Fn(&Self, &gdk::EventProximity) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::EventProximity) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "proximity-out-event",
                transmute(proximity_out_event_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_query_tooltip<F: Fn(&Self, i32, i32, bool, &Tooltip) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, i32, i32, bool, &Tooltip) -> bool + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "query-tooltip",
                transmute(query_tooltip_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_realize<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "realize",
                transmute(realize_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_screen_changed<F: Fn(&Self, &Option<gdk::Screen>) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &Option<gdk::Screen>) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "screen-changed",
                transmute(screen_changed_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_scroll_event<F: Fn(&Self, &gdk::EventScroll) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::EventScroll) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "scroll-event",
                transmute(scroll_event_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_selection_clear_event<F: Fn(&Self, &gdk::EventSelection) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::EventSelection) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "selection-clear-event",
                transmute(selection_clear_event_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_selection_get<F: Fn(&Self, &SelectionData, u32, u32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &SelectionData, u32, u32) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "selection-get",
                transmute(selection_get_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_selection_notify_event<F: Fn(&Self, &gdk::EventSelection) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::EventSelection) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "selection-notify-event",
                transmute(selection_notify_event_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_selection_received<F: Fn(&Self, &SelectionData, u32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &SelectionData, u32) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "selection-received",
                transmute(selection_received_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_selection_request_event<F: Fn(&Self, &gdk::EventSelection) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::EventSelection) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "selection-request-event",
                transmute(selection_request_event_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_show<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "show",
                transmute(show_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_show_help<F: Fn(&Self, WidgetHelpType) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, WidgetHelpType) -> bool + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "show-help",
                transmute(show_help_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn emit_show_help(&self, help_type: WidgetHelpType) -> bool {
        let res = self.emit("show-help", &[&help_type]).unwrap();
        res.unwrap().get().unwrap()
    }

    fn connect_size_allocate<F: Fn(&Self, &Allocation) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &Allocation) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "size-allocate",
                transmute(size_allocate_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_state_flags_changed<F: Fn(&Self, StateFlags) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, StateFlags) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "state-flags-changed",
                transmute(state_flags_changed_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_style_updated<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "style-updated",
                transmute(style_updated_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_touch_event<F: Fn(&Self, &gdk::Event) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::Event) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "touch-event",
                transmute(touch_event_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_unmap<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "unmap",
                transmute(unmap_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_unrealize<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "unrealize",
                transmute(unrealize_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_visibility_notify_event<F: Fn(&Self, &gdk::EventVisibility) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::EventVisibility) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "visibility-notify-event",
                transmute(visibility_notify_event_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_window_state_event<F: Fn(&Self, &gdk::EventWindowState) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &gdk::EventWindowState) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "window-state-event",
                transmute(window_state_event_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_app_paintable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::app-paintable",
                transmute(notify_app_paintable_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_can_default_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::can-default",
                transmute(notify_can_default_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_can_focus_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::can-focus",
                transmute(notify_can_focus_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_composite_child_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::composite-child",
                transmute(notify_composite_child_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_double_buffered_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::double-buffered",
                transmute(notify_double_buffered_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_events_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::events",
                transmute(notify_events_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_expand_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::expand",
                transmute(notify_expand_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    fn connect_property_focus_on_click_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::focus-on-click",
                transmute(notify_focus_on_click_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_halign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::halign",
                transmute(notify_halign_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_has_default_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::has-default",
                transmute(notify_has_default_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_has_focus_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::has-focus",
                transmute(notify_has_focus_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_has_tooltip_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::has-tooltip",
                transmute(notify_has_tooltip_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_height_request_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::height-request",
                transmute(notify_height_request_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_hexpand_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::hexpand",
                transmute(notify_hexpand_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_hexpand_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::hexpand-set",
                transmute(notify_hexpand_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_is_focus_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::is-focus",
                transmute(notify_is_focus_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::margin",
                transmute(notify_margin_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_margin_bottom_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::margin-bottom",
                transmute(notify_margin_bottom_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    #[cfg(any(feature = "v3_12", feature = "dox"))]
    fn connect_property_margin_end_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::margin-end",
                transmute(notify_margin_end_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_margin_left_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::margin-left",
                transmute(notify_margin_left_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_margin_right_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::margin-right",
                transmute(notify_margin_right_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    #[cfg(any(feature = "v3_12", feature = "dox"))]
    fn connect_property_margin_start_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::margin-start",
                transmute(notify_margin_start_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_margin_top_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::margin-top",
                transmute(notify_margin_top_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::name",
                transmute(notify_name_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_no_show_all_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::no-show-all",
                transmute(notify_no_show_all_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    #[cfg(any(feature = "v3_8", feature = "dox"))]
    fn connect_property_opacity_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::opacity",
                transmute(notify_opacity_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_parent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::parent",
                transmute(notify_parent_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_receives_default_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::receives-default",
                transmute(notify_receives_default_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    #[cfg(any(feature = "v3_10", feature = "dox"))]
    fn connect_property_scale_factor_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::scale-factor",
                transmute(notify_scale_factor_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_sensitive_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::sensitive",
                transmute(notify_sensitive_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_tooltip_markup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::tooltip-markup",
                transmute(notify_tooltip_markup_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_tooltip_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::tooltip-text",
                transmute(notify_tooltip_text_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_valign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::valign",
                transmute(notify_valign_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_vexpand_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::vexpand",
                transmute(notify_vexpand_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_vexpand_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::vexpand-set",
                transmute(notify_vexpand_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::visible",
                transmute(notify_visible_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_width_request_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::width-request",
                transmute(notify_width_request_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_window_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::window",
                transmute(notify_window_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }
}

unsafe extern "C" fn accel_closures_changed_trampoline<P>(this: *mut ffi::GtkWidget, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn button_press_event_trampoline<P>(this: *mut ffi::GtkWidget, event: *mut gdk_ffi::GdkEventButton, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::EventButton) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(event)).to_glib()
}

unsafe extern "C" fn button_release_event_trampoline<P>(this: *mut ffi::GtkWidget, event: *mut gdk_ffi::GdkEventButton, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::EventButton) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(event)).to_glib()
}

unsafe extern "C" fn can_activate_accel_trampoline<P>(this: *mut ffi::GtkWidget, signal_id: libc::c_uint, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, u32) -> bool + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), signal_id).to_glib()
}

unsafe extern "C" fn composited_changed_trampoline<P>(this: *mut ffi::GtkWidget, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn configure_event_trampoline<P>(this: *mut ffi::GtkWidget, event: *mut gdk_ffi::GdkEventConfigure, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::EventConfigure) -> bool + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(event)).to_glib()
}

unsafe extern "C" fn damage_event_trampoline<P>(this: *mut ffi::GtkWidget, event: *mut gdk_ffi::GdkEventExpose, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::EventExpose) -> bool + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(event)).to_glib()
}

unsafe extern "C" fn delete_event_trampoline<P>(this: *mut ffi::GtkWidget, event: *mut gdk_ffi::GdkEvent, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::Event) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_none(event)).to_glib()
}

unsafe extern "C" fn destroy_trampoline<P>(this: *mut ffi::GtkWidget, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn destroy_event_trampoline<P>(this: *mut ffi::GtkWidget, event: *mut gdk_ffi::GdkEvent, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::Event) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_none(event)).to_glib()
}

unsafe extern "C" fn direction_changed_trampoline<P>(this: *mut ffi::GtkWidget, previous_direction: ffi::GtkTextDirection, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P, TextDirection) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), from_glib(previous_direction))
}

unsafe extern "C" fn drag_begin_trampoline<P>(this: *mut ffi::GtkWidget, context: *mut gdk_ffi::GdkDragContext, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::DragContext) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(context))
}

unsafe extern "C" fn drag_data_delete_trampoline<P>(this: *mut ffi::GtkWidget, context: *mut gdk_ffi::GdkDragContext, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::DragContext) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(context))
}

unsafe extern "C" fn drag_data_get_trampoline<P>(this: *mut ffi::GtkWidget, context: *mut gdk_ffi::GdkDragContext, data: *mut ffi::GtkSelectionData, info: libc::c_uint, time: libc::c_uint, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::DragContext, &SelectionData, u32, u32) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(context), &from_glib_borrow(data), info, time)
}

unsafe extern "C" fn drag_data_received_trampoline<P>(this: *mut ffi::GtkWidget, context: *mut gdk_ffi::GdkDragContext, x: libc::c_int, y: libc::c_int, data: *mut ffi::GtkSelectionData, info: libc::c_uint, time: libc::c_uint, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::DragContext, i32, i32, &SelectionData, u32, u32) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(context), x, y, &from_glib_borrow(data), info, time)
}

unsafe extern "C" fn drag_drop_trampoline<P>(this: *mut ffi::GtkWidget, context: *mut gdk_ffi::GdkDragContext, x: libc::c_int, y: libc::c_int, time: libc::c_uint, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::DragContext, i32, i32, u32) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(context), x, y, time).to_glib()
}

unsafe extern "C" fn drag_end_trampoline<P>(this: *mut ffi::GtkWidget, context: *mut gdk_ffi::GdkDragContext, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::DragContext) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(context))
}

unsafe extern "C" fn drag_failed_trampoline<P>(this: *mut ffi::GtkWidget, context: *mut gdk_ffi::GdkDragContext, result: ffi::GtkDragResult, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::DragContext, DragResult) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(context), from_glib(result)).to_glib()
}

unsafe extern "C" fn drag_leave_trampoline<P>(this: *mut ffi::GtkWidget, context: *mut gdk_ffi::GdkDragContext, time: libc::c_uint, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::DragContext, u32) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(context), time)
}

unsafe extern "C" fn drag_motion_trampoline<P>(this: *mut ffi::GtkWidget, context: *mut gdk_ffi::GdkDragContext, x: libc::c_int, y: libc::c_int, time: libc::c_uint, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::DragContext, i32, i32, u32) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(context), x, y, time).to_glib()
}

unsafe extern "C" fn draw_trampoline<P>(this: *mut ffi::GtkWidget, cr: *mut cairo_ffi::cairo_t, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &cairo::Context) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(cr)).to_glib()
}

unsafe extern "C" fn enter_notify_event_trampoline<P>(this: *mut ffi::GtkWidget, event: *mut gdk_ffi::GdkEventCrossing, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::EventCrossing) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(event)).to_glib()
}

unsafe extern "C" fn event_trampoline<P>(this: *mut ffi::GtkWidget, event: *mut gdk_ffi::GdkEvent, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::Event) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_none(event)).to_glib()
}

unsafe extern "C" fn event_after_trampoline<P>(this: *mut ffi::GtkWidget, event: *mut gdk_ffi::GdkEvent, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::Event) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_none(event))
}

unsafe extern "C" fn focus_trampoline<P>(this: *mut ffi::GtkWidget, direction: ffi::GtkDirectionType, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, DirectionType) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), from_glib(direction)).to_glib()
}

unsafe extern "C" fn focus_in_event_trampoline<P>(this: *mut ffi::GtkWidget, event: *mut gdk_ffi::GdkEventFocus, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::EventFocus) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(event)).to_glib()
}

unsafe extern "C" fn focus_out_event_trampoline<P>(this: *mut ffi::GtkWidget, event: *mut gdk_ffi::GdkEventFocus, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::EventFocus) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(event)).to_glib()
}

unsafe extern "C" fn grab_broken_event_trampoline<P>(this: *mut ffi::GtkWidget, event: *mut gdk_ffi::GdkEventGrabBroken, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::EventGrabBroken) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(event)).to_glib()
}

unsafe extern "C" fn grab_focus_trampoline<P>(this: *mut ffi::GtkWidget, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn grab_notify_trampoline<P>(this: *mut ffi::GtkWidget, was_grabbed: glib_ffi::gboolean, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P, bool) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), from_glib(was_grabbed))
}

unsafe extern "C" fn hide_trampoline<P>(this: *mut ffi::GtkWidget, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn hierarchy_changed_trampoline<P>(this: *mut ffi::GtkWidget, previous_toplevel: *mut ffi::GtkWidget, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P, &Option<Widget>) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(previous_toplevel))
}

unsafe extern "C" fn key_press_event_trampoline<P>(this: *mut ffi::GtkWidget, event: *mut gdk_ffi::GdkEventKey, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::EventKey) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(event)).to_glib()
}

unsafe extern "C" fn key_release_event_trampoline<P>(this: *mut ffi::GtkWidget, event: *mut gdk_ffi::GdkEventKey, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::EventKey) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(event)).to_glib()
}

unsafe extern "C" fn keynav_failed_trampoline<P>(this: *mut ffi::GtkWidget, direction: ffi::GtkDirectionType, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, DirectionType) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), from_glib(direction)).to_glib()
}

unsafe extern "C" fn leave_notify_event_trampoline<P>(this: *mut ffi::GtkWidget, event: *mut gdk_ffi::GdkEventCrossing, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::EventCrossing) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(event)).to_glib()
}

unsafe extern "C" fn map_trampoline<P>(this: *mut ffi::GtkWidget, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn mnemonic_activate_trampoline<P>(this: *mut ffi::GtkWidget, group_cycling: glib_ffi::gboolean, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, bool) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), from_glib(group_cycling)).to_glib()
}

unsafe extern "C" fn motion_notify_event_trampoline<P>(this: *mut ffi::GtkWidget, event: *mut gdk_ffi::GdkEventMotion, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::EventMotion) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(event)).to_glib()
}

unsafe extern "C" fn move_focus_trampoline<P>(this: *mut ffi::GtkWidget, direction: ffi::GtkDirectionType, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P, DirectionType) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), from_glib(direction))
}

unsafe extern "C" fn parent_set_trampoline<P>(this: *mut ffi::GtkWidget, old_parent: *mut ffi::GtkWidget, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P, &Option<Widget>) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(old_parent))
}

unsafe extern "C" fn popup_menu_trampoline<P>(this: *mut ffi::GtkWidget, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P) -> bool + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked()).to_glib()
}

unsafe extern "C" fn property_notify_event_trampoline<P>(this: *mut ffi::GtkWidget, event: *mut gdk_ffi::GdkEventProperty, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::EventProperty) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(event)).to_glib()
}

unsafe extern "C" fn proximity_in_event_trampoline<P>(this: *mut ffi::GtkWidget, event: *mut gdk_ffi::GdkEventProximity, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::EventProximity) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(event)).to_glib()
}

unsafe extern "C" fn proximity_out_event_trampoline<P>(this: *mut ffi::GtkWidget, event: *mut gdk_ffi::GdkEventProximity, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::EventProximity) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(event)).to_glib()
}

unsafe extern "C" fn query_tooltip_trampoline<P>(this: *mut ffi::GtkWidget, x: libc::c_int, y: libc::c_int, keyboard_mode: glib_ffi::gboolean, tooltip: *mut ffi::GtkTooltip, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, i32, i32, bool, &Tooltip) -> bool + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), x, y, from_glib(keyboard_mode), &from_glib_borrow(tooltip)).to_glib()
}

unsafe extern "C" fn realize_trampoline<P>(this: *mut ffi::GtkWidget, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn screen_changed_trampoline<P>(this: *mut ffi::GtkWidget, previous_screen: *mut gdk_ffi::GdkScreen, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P, &Option<gdk::Screen>) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(previous_screen))
}

unsafe extern "C" fn scroll_event_trampoline<P>(this: *mut ffi::GtkWidget, event: *mut gdk_ffi::GdkEventScroll, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::EventScroll) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(event)).to_glib()
}

unsafe extern "C" fn selection_clear_event_trampoline<P>(this: *mut ffi::GtkWidget, event: *mut gdk_ffi::GdkEventSelection, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::EventSelection) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(event)).to_glib()
}

unsafe extern "C" fn selection_get_trampoline<P>(this: *mut ffi::GtkWidget, data: *mut ffi::GtkSelectionData, info: libc::c_uint, time: libc::c_uint, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P, &SelectionData, u32, u32) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(data), info, time)
}

unsafe extern "C" fn selection_notify_event_trampoline<P>(this: *mut ffi::GtkWidget, event: *mut gdk_ffi::GdkEventSelection, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::EventSelection) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(event)).to_glib()
}

unsafe extern "C" fn selection_received_trampoline<P>(this: *mut ffi::GtkWidget, data: *mut ffi::GtkSelectionData, time: libc::c_uint, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P, &SelectionData, u32) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(data), time)
}

unsafe extern "C" fn selection_request_event_trampoline<P>(this: *mut ffi::GtkWidget, event: *mut gdk_ffi::GdkEventSelection, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::EventSelection) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(event)).to_glib()
}

unsafe extern "C" fn show_trampoline<P>(this: *mut ffi::GtkWidget, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn show_help_trampoline<P>(this: *mut ffi::GtkWidget, help_type: ffi::GtkWidgetHelpType, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, WidgetHelpType) -> bool + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), from_glib(help_type)).to_glib()
}

unsafe extern "C" fn size_allocate_trampoline<P>(this: *mut ffi::GtkWidget, allocation: *mut ffi::GtkAllocation, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P, &Allocation) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_none(allocation))
}

unsafe extern "C" fn state_flags_changed_trampoline<P>(this: *mut ffi::GtkWidget, flags: ffi::GtkStateFlags, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P, StateFlags) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), from_glib(flags))
}

unsafe extern "C" fn style_updated_trampoline<P>(this: *mut ffi::GtkWidget, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn touch_event_trampoline<P>(this: *mut ffi::GtkWidget, object: *mut gdk_ffi::GdkEvent, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::Event) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_none(object)).to_glib()
}

unsafe extern "C" fn unmap_trampoline<P>(this: *mut ffi::GtkWidget, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn unrealize_trampoline<P>(this: *mut ffi::GtkWidget, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn visibility_notify_event_trampoline<P>(this: *mut ffi::GtkWidget, event: *mut gdk_ffi::GdkEventVisibility, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::EventVisibility) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(event)).to_glib()
}

unsafe extern "C" fn window_state_event_trampoline<P>(this: *mut ffi::GtkWidget, event: *mut gdk_ffi::GdkEventWindowState, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Widget> {
    let f: &&(Fn(&P, &gdk::EventWindowState) -> Inhibit + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(event)).to_glib()
}

unsafe extern "C" fn notify_app_paintable_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_can_default_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_can_focus_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_composite_child_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_double_buffered_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_events_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_expand_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
unsafe extern "C" fn notify_focus_on_click_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_halign_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_has_default_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_has_focus_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_has_tooltip_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_height_request_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_hexpand_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_hexpand_set_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_is_focus_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_margin_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_margin_bottom_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

#[cfg(any(feature = "v3_12", feature = "dox"))]
unsafe extern "C" fn notify_margin_end_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_margin_left_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_margin_right_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

#[cfg(any(feature = "v3_12", feature = "dox"))]
unsafe extern "C" fn notify_margin_start_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_margin_top_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_name_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_no_show_all_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

#[cfg(any(feature = "v3_8", feature = "dox"))]
unsafe extern "C" fn notify_opacity_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_parent_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_receives_default_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

#[cfg(any(feature = "v3_10", feature = "dox"))]
unsafe extern "C" fn notify_scale_factor_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_sensitive_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_tooltip_markup_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_tooltip_text_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_valign_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_vexpand_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_vexpand_set_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_visible_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_width_request_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_window_trampoline<P>(this: *mut ffi::GtkWidget, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Widget> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Widget::from_glib_borrow(this).downcast_unchecked())
}
