// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use Buildable;
use CellRenderer;
use Container;
use Entry;
use MovementStep;
use Scrollable;
use Tooltip;
use TreeIter;
use TreeModel;
use TreePath;
use TreeSelection;
use TreeViewColumn;
use TreeViewDropPosition;
use TreeViewGridLines;
use Widget;
use cairo;
use ffi;
use gdk;
use glib;
use glib::StaticType;
use glib::Value;
use glib::object::Downcast;
use glib::object::IsA;
use glib::signal::SignalHandlerId;
use glib::signal::connect;
use glib::translate::*;
use glib_ffi;
use gobject_ffi;
use libc;
use signal::Inhibit;
use std::boxed::Box as Box_;
use std::mem;
use std::mem::transmute;
use std::ptr;

glib_wrapper! {
    pub struct TreeView(Object<ffi::GtkTreeView, ffi::GtkTreeViewClass>): Container, Widget, Buildable, Scrollable;

    match fn {
        get_type => || ffi::gtk_tree_view_get_type(),
    }
}

impl TreeView {
    pub fn new() -> TreeView {
        assert_initialized_main_thread!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_tree_view_new()).downcast_unchecked()
        }
    }

    pub fn new_with_model<P: IsA<TreeModel>>(model: &P) -> TreeView {
        skip_assert_initialized!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_tree_view_new_with_model(model.to_glib_none().0)).downcast_unchecked()
        }
    }
}

impl Default for TreeView {
    fn default() -> Self {
        Self::new()
    }
}

pub trait TreeViewExt {
    fn append_column(&self, column: &TreeViewColumn) -> i32;

    fn collapse_all(&self);

    fn collapse_row(&self, path: &TreePath) -> bool;

    fn columns_autosize(&self);

    fn convert_bin_window_to_tree_coords(&self, bx: i32, by: i32) -> (i32, i32);

    fn convert_bin_window_to_widget_coords(&self, bx: i32, by: i32) -> (i32, i32);

    fn convert_tree_to_bin_window_coords(&self, tx: i32, ty: i32) -> (i32, i32);

    fn convert_tree_to_widget_coords(&self, tx: i32, ty: i32) -> (i32, i32);

    fn convert_widget_to_bin_window_coords(&self, wx: i32, wy: i32) -> (i32, i32);

    fn convert_widget_to_tree_coords(&self, wx: i32, wy: i32) -> (i32, i32);

    fn create_row_drag_icon(&self, path: &TreePath) -> Option<cairo::Surface>;

    fn expand_all(&self);

    fn expand_row(&self, path: &TreePath, open_all: bool) -> bool;

    fn expand_to_path(&self, path: &TreePath);

    #[cfg(any(feature = "v3_8", feature = "dox"))]
    fn get_activate_on_single_click(&self) -> bool;

    fn get_background_area<'a, 'b, P: Into<Option<&'a TreePath>>, Q: Into<Option<&'b TreeViewColumn>>>(&self, path: P, column: Q) -> gdk::Rectangle;

    fn get_bin_window(&self) -> Option<gdk::Window>;

    fn get_cell_area<'a, 'b, P: Into<Option<&'a TreePath>>, Q: Into<Option<&'b TreeViewColumn>>>(&self, path: P, column: Q) -> gdk::Rectangle;

    fn get_column(&self, n: i32) -> Option<TreeViewColumn>;

    fn get_columns(&self) -> Vec<TreeViewColumn>;

    fn get_cursor(&self) -> (Option<TreePath>, Option<TreeViewColumn>);

    fn get_dest_row_at_pos(&self, drag_x: i32, drag_y: i32) -> Option<(Option<TreePath>, TreeViewDropPosition)>;

    fn get_drag_dest_row(&self) -> (Option<TreePath>, TreeViewDropPosition);

    fn get_enable_search(&self) -> bool;

    fn get_enable_tree_lines(&self) -> bool;

    fn get_expander_column(&self) -> Option<TreeViewColumn>;

    fn get_fixed_height_mode(&self) -> bool;

    fn get_grid_lines(&self) -> TreeViewGridLines;

    fn get_headers_clickable(&self) -> bool;

    fn get_headers_visible(&self) -> bool;

    fn get_hover_expand(&self) -> bool;

    fn get_hover_selection(&self) -> bool;

    fn get_level_indentation(&self) -> i32;

    fn get_model(&self) -> Option<TreeModel>;

    fn get_n_columns(&self) -> u32;

    fn get_path_at_pos(&self, x: i32, y: i32) -> Option<(Option<TreePath>, Option<TreeViewColumn>, i32, i32)>;

    fn get_reorderable(&self) -> bool;

    //fn get_row_separator_func(&self) -> /*Unknown conversion*//*Unimplemented*/TreeViewRowSeparatorFunc;

    fn get_rubber_banding(&self) -> bool;

    #[cfg_attr(feature = "v3_14", deprecated)]
    fn get_rules_hint(&self) -> bool;

    fn get_search_column(&self) -> i32;

    fn get_search_entry(&self) -> Option<Entry>;

    //fn get_search_equal_func(&self) -> /*Unknown conversion*//*Unimplemented*/TreeViewSearchEqualFunc;

    //fn get_search_position_func(&self) -> /*Unknown conversion*//*Unimplemented*/TreeViewSearchPositionFunc;

    fn get_selection(&self) -> TreeSelection;

    fn get_show_expanders(&self) -> bool;

    fn get_tooltip_column(&self) -> i32;

    fn get_tooltip_context(&self, x: &mut i32, y: &mut i32, keyboard_tip: bool) -> Option<(Option<TreeModel>, TreePath, TreeIter)>;

    fn get_visible_range(&self) -> Option<(TreePath, TreePath)>;

    fn get_visible_rect(&self) -> gdk::Rectangle;

    fn insert_column(&self, column: &TreeViewColumn, position: i32) -> i32;

    //fn insert_column_with_attributes<P: IsA<CellRenderer>>(&self, position: i32, title: &str, cell: &P, : /*Unknown conversion*//*Unimplemented*/Fundamental: VarArgs) -> i32;

    //fn insert_column_with_data_func<P: IsA<CellRenderer>, Q: Into<Option</*Unimplemented*/Fundamental: Pointer>>>(&self, position: i32, title: &str, cell: &P, func: /*Unknown conversion*//*Unimplemented*/TreeCellDataFunc, data: Q, dnotify: /*Unknown conversion*//*Unimplemented*/DestroyNotify) -> i32;

    fn is_blank_at_pos(&self, x: i32, y: i32) -> Option<(Option<TreePath>, Option<TreeViewColumn>, i32, i32)>;

    fn is_rubber_banding_active(&self) -> bool;

    //fn map_expanded_rows<P: Into<Option</*Unimplemented*/Fundamental: Pointer>>>(&self, func: /*Unknown conversion*//*Unimplemented*/TreeViewMappingFunc, data: P);

    fn move_column_after<'a, P: Into<Option<&'a TreeViewColumn>>>(&self, column: &TreeViewColumn, base_column: P);

    fn remove_column(&self, column: &TreeViewColumn) -> i32;

    fn row_activated(&self, path: &TreePath, column: &TreeViewColumn);

    fn row_expanded(&self, path: &TreePath) -> bool;

    fn scroll_to_cell<'a, 'b, P: Into<Option<&'a TreePath>>, Q: Into<Option<&'b TreeViewColumn>>>(&self, path: P, column: Q, use_align: bool, row_align: f32, col_align: f32);

    fn scroll_to_point(&self, tree_x: i32, tree_y: i32);

    #[cfg(any(feature = "v3_8", feature = "dox"))]
    fn set_activate_on_single_click(&self, single: bool);

    //fn set_column_drag_function<'a, 'b, P: Into<Option<&'a /*Unimplemented*/TreeViewColumnDropFunc>>, Q: Into<Option<&'b /*Ignored*/glib::DestroyNotify>>>(&self, func: P, destroy: Q);

    fn set_cursor<'a, P: Into<Option<&'a TreeViewColumn>>>(&self, path: &TreePath, focus_column: P, start_editing: bool);

    fn set_cursor_on_cell<'a, 'b, P: Into<Option<&'a TreeViewColumn>>, Q: IsA<CellRenderer> + 'b, R: Into<Option<&'b Q>>>(&self, path: &TreePath, focus_column: P, focus_cell: R, start_editing: bool);

    fn set_drag_dest_row<'a, P: Into<Option<&'a TreePath>>>(&self, path: P, pos: TreeViewDropPosition);

    fn set_enable_search(&self, enable_search: bool);

    fn set_enable_tree_lines(&self, enabled: bool);

    fn set_expander_column(&self, column: &TreeViewColumn);

    fn set_fixed_height_mode(&self, enable: bool);

    fn set_grid_lines(&self, grid_lines: TreeViewGridLines);

    fn set_headers_clickable(&self, setting: bool);

    fn set_headers_visible(&self, headers_visible: bool);

    fn set_hover_expand(&self, expand: bool);

    fn set_hover_selection(&self, hover: bool);

    fn set_level_indentation(&self, indentation: i32);

    fn set_model<'a, P: IsA<TreeModel> + 'a, Q: Into<Option<&'a P>>>(&self, model: Q);

    fn set_reorderable(&self, reorderable: bool);

    //fn set_row_separator_func<'a, 'b, P: Into<Option<&'a /*Unimplemented*/TreeViewRowSeparatorFunc>>, Q: Into<Option</*Unimplemented*/Fundamental: Pointer>>, R: Into<Option<&'b /*Ignored*/glib::DestroyNotify>>>(&self, func: P, data: Q, destroy: R);

    fn set_rubber_banding(&self, enable: bool);

    #[cfg_attr(feature = "v3_14", deprecated)]
    fn set_rules_hint(&self, setting: bool);

    fn set_search_column(&self, column: i32);

    fn set_search_entry<'a, P: IsA<Entry> + 'a, Q: Into<Option<&'a P>>>(&self, entry: Q);

    //fn set_search_equal_func<'a, P: Into<Option</*Unimplemented*/Fundamental: Pointer>>, Q: Into<Option<&'a /*Ignored*/glib::DestroyNotify>>>(&self, search_equal_func: /*Unknown conversion*//*Unimplemented*/TreeViewSearchEqualFunc, search_user_data: P, search_destroy: Q);

    //fn set_search_position_func<'a, 'b, P: Into<Option<&'a /*Unimplemented*/TreeViewSearchPositionFunc>>, Q: Into<Option</*Unimplemented*/Fundamental: Pointer>>, R: Into<Option<&'b /*Ignored*/glib::DestroyNotify>>>(&self, func: P, data: Q, destroy: R);

    fn set_show_expanders(&self, enabled: bool);

    fn set_tooltip_cell<'a, 'b, 'c, P: Into<Option<&'a TreePath>>, Q: Into<Option<&'b TreeViewColumn>>, R: IsA<CellRenderer> + 'c, S: Into<Option<&'c R>>>(&self, tooltip: &Tooltip, path: P, column: Q, cell: S);

    fn set_tooltip_column(&self, column: i32);

    fn set_tooltip_row(&self, tooltip: &Tooltip, path: &TreePath);

    fn unset_rows_drag_dest(&self);

    fn unset_rows_drag_source(&self);

    fn get_property_enable_grid_lines(&self) -> TreeViewGridLines;

    fn set_property_enable_grid_lines(&self, enable_grid_lines: TreeViewGridLines);

    fn set_property_ubuntu_almost_fixed_height_mode(&self, ubuntu_almost_fixed_height_mode: bool);

    fn connect_columns_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_cursor_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_expand_collapse_cursor_row<F: Fn(&Self, bool, bool, bool) -> bool + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_expand_collapse_cursor_row(&self, object: bool, p0: bool, p1: bool) -> bool;

    fn connect_move_cursor<F: Fn(&Self, MovementStep, i32) -> bool + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_move_cursor(&self, step: MovementStep, direction: i32) -> bool;

    fn connect_row_activated<F: Fn(&Self, &TreePath, &TreeViewColumn) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_row_activated(&self, path: &TreePath, column: &TreeViewColumn);

    fn connect_row_collapsed<F: Fn(&Self, &TreeIter, &TreePath) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_row_expanded<F: Fn(&Self, &TreeIter, &TreePath) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_select_all<F: Fn(&Self) -> bool + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_select_all(&self) -> bool;

    fn connect_select_cursor_parent<F: Fn(&Self) -> bool + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_select_cursor_parent(&self) -> bool;

    fn connect_select_cursor_row<F: Fn(&Self, bool) -> bool + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_select_cursor_row(&self, object: bool) -> bool;

    fn connect_start_interactive_search<F: Fn(&Self) -> bool + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_start_interactive_search(&self) -> bool;

    fn connect_test_collapse_row<F: Fn(&Self, &TreeIter, &TreePath) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_test_expand_row<F: Fn(&Self, &TreeIter, &TreePath) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_toggle_cursor_row<F: Fn(&Self) -> bool + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_toggle_cursor_row(&self) -> bool;

    fn connect_unselect_all<F: Fn(&Self) -> bool + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_unselect_all(&self) -> bool;

    #[cfg(any(feature = "v3_8", feature = "dox"))]
    fn connect_property_activate_on_single_click_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_enable_grid_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_enable_search_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_enable_tree_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_expander_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_fixed_height_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_headers_clickable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_headers_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_hover_expand_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_hover_selection_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_level_indentation_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_model_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_reorderable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_rubber_banding_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg_attr(feature = "v3_14", deprecated)]
    fn connect_property_rules_hint_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_search_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_show_expanders_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_tooltip_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_ubuntu_almost_fixed_height_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<TreeView> + IsA<glib::object::Object> + glib::object::ObjectExt> TreeViewExt for O {
    fn append_column(&self, column: &TreeViewColumn) -> i32 {
        unsafe {
            ffi::gtk_tree_view_append_column(self.to_glib_none().0, column.to_glib_none().0)
        }
    }

    fn collapse_all(&self) {
        unsafe {
            ffi::gtk_tree_view_collapse_all(self.to_glib_none().0);
        }
    }

    fn collapse_row(&self, path: &TreePath) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_collapse_row(self.to_glib_none().0, mut_override(path.to_glib_none().0)))
        }
    }

    fn columns_autosize(&self) {
        unsafe {
            ffi::gtk_tree_view_columns_autosize(self.to_glib_none().0);
        }
    }

    fn convert_bin_window_to_tree_coords(&self, bx: i32, by: i32) -> (i32, i32) {
        unsafe {
            let mut tx = mem::uninitialized();
            let mut ty = mem::uninitialized();
            ffi::gtk_tree_view_convert_bin_window_to_tree_coords(self.to_glib_none().0, bx, by, &mut tx, &mut ty);
            (tx, ty)
        }
    }

    fn convert_bin_window_to_widget_coords(&self, bx: i32, by: i32) -> (i32, i32) {
        unsafe {
            let mut wx = mem::uninitialized();
            let mut wy = mem::uninitialized();
            ffi::gtk_tree_view_convert_bin_window_to_widget_coords(self.to_glib_none().0, bx, by, &mut wx, &mut wy);
            (wx, wy)
        }
    }

    fn convert_tree_to_bin_window_coords(&self, tx: i32, ty: i32) -> (i32, i32) {
        unsafe {
            let mut bx = mem::uninitialized();
            let mut by = mem::uninitialized();
            ffi::gtk_tree_view_convert_tree_to_bin_window_coords(self.to_glib_none().0, tx, ty, &mut bx, &mut by);
            (bx, by)
        }
    }

    fn convert_tree_to_widget_coords(&self, tx: i32, ty: i32) -> (i32, i32) {
        unsafe {
            let mut wx = mem::uninitialized();
            let mut wy = mem::uninitialized();
            ffi::gtk_tree_view_convert_tree_to_widget_coords(self.to_glib_none().0, tx, ty, &mut wx, &mut wy);
            (wx, wy)
        }
    }

    fn convert_widget_to_bin_window_coords(&self, wx: i32, wy: i32) -> (i32, i32) {
        unsafe {
            let mut bx = mem::uninitialized();
            let mut by = mem::uninitialized();
            ffi::gtk_tree_view_convert_widget_to_bin_window_coords(self.to_glib_none().0, wx, wy, &mut bx, &mut by);
            (bx, by)
        }
    }

    fn convert_widget_to_tree_coords(&self, wx: i32, wy: i32) -> (i32, i32) {
        unsafe {
            let mut tx = mem::uninitialized();
            let mut ty = mem::uninitialized();
            ffi::gtk_tree_view_convert_widget_to_tree_coords(self.to_glib_none().0, wx, wy, &mut tx, &mut ty);
            (tx, ty)
        }
    }

    fn create_row_drag_icon(&self, path: &TreePath) -> Option<cairo::Surface> {
        unsafe {
            from_glib_full(ffi::gtk_tree_view_create_row_drag_icon(self.to_glib_none().0, mut_override(path.to_glib_none().0)))
        }
    }

    fn expand_all(&self) {
        unsafe {
            ffi::gtk_tree_view_expand_all(self.to_glib_none().0);
        }
    }

    fn expand_row(&self, path: &TreePath, open_all: bool) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_expand_row(self.to_glib_none().0, mut_override(path.to_glib_none().0), open_all.to_glib()))
        }
    }

    fn expand_to_path(&self, path: &TreePath) {
        unsafe {
            ffi::gtk_tree_view_expand_to_path(self.to_glib_none().0, mut_override(path.to_glib_none().0));
        }
    }

    #[cfg(any(feature = "v3_8", feature = "dox"))]
    fn get_activate_on_single_click(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_activate_on_single_click(self.to_glib_none().0))
        }
    }

    fn get_background_area<'a, 'b, P: Into<Option<&'a TreePath>>, Q: Into<Option<&'b TreeViewColumn>>>(&self, path: P, column: Q) -> gdk::Rectangle {
        let path = path.into();
        let column = column.into();
        let column = column.to_glib_none();
        unsafe {
            let mut rect = gdk::Rectangle::uninitialized();
            ffi::gtk_tree_view_get_background_area(self.to_glib_none().0, mut_override(path.to_glib_none().0), column.0, rect.to_glib_none_mut().0);
            rect
        }
    }

    fn get_bin_window(&self) -> Option<gdk::Window> {
        unsafe {
            from_glib_none(ffi::gtk_tree_view_get_bin_window(self.to_glib_none().0))
        }
    }

    fn get_cell_area<'a, 'b, P: Into<Option<&'a TreePath>>, Q: Into<Option<&'b TreeViewColumn>>>(&self, path: P, column: Q) -> gdk::Rectangle {
        let path = path.into();
        let column = column.into();
        let column = column.to_glib_none();
        unsafe {
            let mut rect = gdk::Rectangle::uninitialized();
            ffi::gtk_tree_view_get_cell_area(self.to_glib_none().0, mut_override(path.to_glib_none().0), column.0, rect.to_glib_none_mut().0);
            rect
        }
    }

    fn get_column(&self, n: i32) -> Option<TreeViewColumn> {
        unsafe {
            from_glib_none(ffi::gtk_tree_view_get_column(self.to_glib_none().0, n))
        }
    }

    fn get_columns(&self) -> Vec<TreeViewColumn> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::gtk_tree_view_get_columns(self.to_glib_none().0))
        }
    }

    fn get_cursor(&self) -> (Option<TreePath>, Option<TreeViewColumn>) {
        unsafe {
            let mut path = ptr::null_mut();
            let mut focus_column = ptr::null_mut();
            ffi::gtk_tree_view_get_cursor(self.to_glib_none().0, &mut path, &mut focus_column);
            (from_glib_full(path), from_glib_none(focus_column))
        }
    }

    fn get_dest_row_at_pos(&self, drag_x: i32, drag_y: i32) -> Option<(Option<TreePath>, TreeViewDropPosition)> {
        unsafe {
            let mut path = ptr::null_mut();
            let mut pos = mem::uninitialized();
            let ret = from_glib(ffi::gtk_tree_view_get_dest_row_at_pos(self.to_glib_none().0, drag_x, drag_y, &mut path, &mut pos));
            if ret { Some((from_glib_full(path), from_glib(pos))) } else { None }
        }
    }

    fn get_drag_dest_row(&self) -> (Option<TreePath>, TreeViewDropPosition) {
        unsafe {
            let mut path = ptr::null_mut();
            let mut pos = mem::uninitialized();
            ffi::gtk_tree_view_get_drag_dest_row(self.to_glib_none().0, &mut path, &mut pos);
            (from_glib_full(path), from_glib(pos))
        }
    }

    fn get_enable_search(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_enable_search(self.to_glib_none().0))
        }
    }

    fn get_enable_tree_lines(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_enable_tree_lines(self.to_glib_none().0))
        }
    }

    fn get_expander_column(&self) -> Option<TreeViewColumn> {
        unsafe {
            from_glib_none(ffi::gtk_tree_view_get_expander_column(self.to_glib_none().0))
        }
    }

    fn get_fixed_height_mode(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_fixed_height_mode(self.to_glib_none().0))
        }
    }

    fn get_grid_lines(&self) -> TreeViewGridLines {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_grid_lines(self.to_glib_none().0))
        }
    }

    fn get_headers_clickable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_headers_clickable(self.to_glib_none().0))
        }
    }

    fn get_headers_visible(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_headers_visible(self.to_glib_none().0))
        }
    }

    fn get_hover_expand(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_hover_expand(self.to_glib_none().0))
        }
    }

    fn get_hover_selection(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_hover_selection(self.to_glib_none().0))
        }
    }

    fn get_level_indentation(&self) -> i32 {
        unsafe {
            ffi::gtk_tree_view_get_level_indentation(self.to_glib_none().0)
        }
    }

    fn get_model(&self) -> Option<TreeModel> {
        unsafe {
            from_glib_none(ffi::gtk_tree_view_get_model(self.to_glib_none().0))
        }
    }

    fn get_n_columns(&self) -> u32 {
        unsafe {
            ffi::gtk_tree_view_get_n_columns(self.to_glib_none().0)
        }
    }

    fn get_path_at_pos(&self, x: i32, y: i32) -> Option<(Option<TreePath>, Option<TreeViewColumn>, i32, i32)> {
        unsafe {
            let mut path = ptr::null_mut();
            let mut column = ptr::null_mut();
            let mut cell_x = mem::uninitialized();
            let mut cell_y = mem::uninitialized();
            let ret = from_glib(ffi::gtk_tree_view_get_path_at_pos(self.to_glib_none().0, x, y, &mut path, &mut column, &mut cell_x, &mut cell_y));
            if ret { Some((from_glib_full(path), from_glib_none(column), cell_x, cell_y)) } else { None }
        }
    }

    fn get_reorderable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_reorderable(self.to_glib_none().0))
        }
    }

    //fn get_row_separator_func(&self) -> /*Unknown conversion*//*Unimplemented*/TreeViewRowSeparatorFunc {
    //    unsafe { TODO: call ffi::gtk_tree_view_get_row_separator_func() }
    //}

    fn get_rubber_banding(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_rubber_banding(self.to_glib_none().0))
        }
    }

    fn get_rules_hint(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_rules_hint(self.to_glib_none().0))
        }
    }

    fn get_search_column(&self) -> i32 {
        unsafe {
            ffi::gtk_tree_view_get_search_column(self.to_glib_none().0)
        }
    }

    fn get_search_entry(&self) -> Option<Entry> {
        unsafe {
            from_glib_none(ffi::gtk_tree_view_get_search_entry(self.to_glib_none().0))
        }
    }

    //fn get_search_equal_func(&self) -> /*Unknown conversion*//*Unimplemented*/TreeViewSearchEqualFunc {
    //    unsafe { TODO: call ffi::gtk_tree_view_get_search_equal_func() }
    //}

    //fn get_search_position_func(&self) -> /*Unknown conversion*//*Unimplemented*/TreeViewSearchPositionFunc {
    //    unsafe { TODO: call ffi::gtk_tree_view_get_search_position_func() }
    //}

    fn get_selection(&self) -> TreeSelection {
        unsafe {
            from_glib_none(ffi::gtk_tree_view_get_selection(self.to_glib_none().0))
        }
    }

    fn get_show_expanders(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_show_expanders(self.to_glib_none().0))
        }
    }

    fn get_tooltip_column(&self) -> i32 {
        unsafe {
            ffi::gtk_tree_view_get_tooltip_column(self.to_glib_none().0)
        }
    }

    fn get_tooltip_context(&self, x: &mut i32, y: &mut i32, keyboard_tip: bool) -> Option<(Option<TreeModel>, TreePath, TreeIter)> {
        unsafe {
            let mut model = ptr::null_mut();
            let mut path = ptr::null_mut();
            let mut iter = TreeIter::uninitialized();
            let ret = from_glib(ffi::gtk_tree_view_get_tooltip_context(self.to_glib_none().0, x, y, keyboard_tip.to_glib(), &mut model, &mut path, iter.to_glib_none_mut().0));
            if ret { Some((from_glib_none(model), from_glib_full(path), iter)) } else { None }
        }
    }

    fn get_visible_range(&self) -> Option<(TreePath, TreePath)> {
        unsafe {
            let mut start_path = ptr::null_mut();
            let mut end_path = ptr::null_mut();
            let ret = from_glib(ffi::gtk_tree_view_get_visible_range(self.to_glib_none().0, &mut start_path, &mut end_path));
            if ret { Some((from_glib_full(start_path), from_glib_full(end_path))) } else { None }
        }
    }

    fn get_visible_rect(&self) -> gdk::Rectangle {
        unsafe {
            let mut visible_rect = gdk::Rectangle::uninitialized();
            ffi::gtk_tree_view_get_visible_rect(self.to_glib_none().0, visible_rect.to_glib_none_mut().0);
            visible_rect
        }
    }

    fn insert_column(&self, column: &TreeViewColumn, position: i32) -> i32 {
        unsafe {
            ffi::gtk_tree_view_insert_column(self.to_glib_none().0, column.to_glib_none().0, position)
        }
    }

    //fn insert_column_with_attributes<P: IsA<CellRenderer>>(&self, position: i32, title: &str, cell: &P, : /*Unknown conversion*//*Unimplemented*/Fundamental: VarArgs) -> i32 {
    //    unsafe { TODO: call ffi::gtk_tree_view_insert_column_with_attributes() }
    //}

    //fn insert_column_with_data_func<P: IsA<CellRenderer>, Q: Into<Option</*Unimplemented*/Fundamental: Pointer>>>(&self, position: i32, title: &str, cell: &P, func: /*Unknown conversion*//*Unimplemented*/TreeCellDataFunc, data: Q, dnotify: /*Unknown conversion*//*Unimplemented*/DestroyNotify) -> i32 {
    //    unsafe { TODO: call ffi::gtk_tree_view_insert_column_with_data_func() }
    //}

    fn is_blank_at_pos(&self, x: i32, y: i32) -> Option<(Option<TreePath>, Option<TreeViewColumn>, i32, i32)> {
        unsafe {
            let mut path = ptr::null_mut();
            let mut column = ptr::null_mut();
            let mut cell_x = mem::uninitialized();
            let mut cell_y = mem::uninitialized();
            let ret = from_glib(ffi::gtk_tree_view_is_blank_at_pos(self.to_glib_none().0, x, y, &mut path, &mut column, &mut cell_x, &mut cell_y));
            if ret { Some((from_glib_full(path), from_glib_none(column), cell_x, cell_y)) } else { None }
        }
    }

    fn is_rubber_banding_active(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_is_rubber_banding_active(self.to_glib_none().0))
        }
    }

    //fn map_expanded_rows<P: Into<Option</*Unimplemented*/Fundamental: Pointer>>>(&self, func: /*Unknown conversion*//*Unimplemented*/TreeViewMappingFunc, data: P) {
    //    unsafe { TODO: call ffi::gtk_tree_view_map_expanded_rows() }
    //}

    fn move_column_after<'a, P: Into<Option<&'a TreeViewColumn>>>(&self, column: &TreeViewColumn, base_column: P) {
        let base_column = base_column.into();
        let base_column = base_column.to_glib_none();
        unsafe {
            ffi::gtk_tree_view_move_column_after(self.to_glib_none().0, column.to_glib_none().0, base_column.0);
        }
    }

    fn remove_column(&self, column: &TreeViewColumn) -> i32 {
        unsafe {
            ffi::gtk_tree_view_remove_column(self.to_glib_none().0, column.to_glib_none().0)
        }
    }

    fn row_activated(&self, path: &TreePath, column: &TreeViewColumn) {
        unsafe {
            ffi::gtk_tree_view_row_activated(self.to_glib_none().0, mut_override(path.to_glib_none().0), column.to_glib_none().0);
        }
    }

    fn row_expanded(&self, path: &TreePath) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_row_expanded(self.to_glib_none().0, mut_override(path.to_glib_none().0)))
        }
    }

    fn scroll_to_cell<'a, 'b, P: Into<Option<&'a TreePath>>, Q: Into<Option<&'b TreeViewColumn>>>(&self, path: P, column: Q, use_align: bool, row_align: f32, col_align: f32) {
        let path = path.into();
        let column = column.into();
        let column = column.to_glib_none();
        unsafe {
            ffi::gtk_tree_view_scroll_to_cell(self.to_glib_none().0, mut_override(path.to_glib_none().0), column.0, use_align.to_glib(), row_align, col_align);
        }
    }

    fn scroll_to_point(&self, tree_x: i32, tree_y: i32) {
        unsafe {
            ffi::gtk_tree_view_scroll_to_point(self.to_glib_none().0, tree_x, tree_y);
        }
    }

    #[cfg(any(feature = "v3_8", feature = "dox"))]
    fn set_activate_on_single_click(&self, single: bool) {
        unsafe {
            ffi::gtk_tree_view_set_activate_on_single_click(self.to_glib_none().0, single.to_glib());
        }
    }

    //fn set_column_drag_function<'a, 'b, P: Into<Option<&'a /*Unimplemented*/TreeViewColumnDropFunc>>, Q: Into<Option<&'b /*Ignored*/glib::DestroyNotify>>>(&self, func: P, destroy: Q) {
    //    unsafe { TODO: call ffi::gtk_tree_view_set_column_drag_function() }
    //}

    fn set_cursor<'a, P: Into<Option<&'a TreeViewColumn>>>(&self, path: &TreePath, focus_column: P, start_editing: bool) {
        let focus_column = focus_column.into();
        let focus_column = focus_column.to_glib_none();
        unsafe {
            ffi::gtk_tree_view_set_cursor(self.to_glib_none().0, mut_override(path.to_glib_none().0), focus_column.0, start_editing.to_glib());
        }
    }

    fn set_cursor_on_cell<'a, 'b, P: Into<Option<&'a TreeViewColumn>>, Q: IsA<CellRenderer> + 'b, R: Into<Option<&'b Q>>>(&self, path: &TreePath, focus_column: P, focus_cell: R, start_editing: bool) {
        let focus_column = focus_column.into();
        let focus_column = focus_column.to_glib_none();
        let focus_cell = focus_cell.into();
        let focus_cell = focus_cell.to_glib_none();
        unsafe {
            ffi::gtk_tree_view_set_cursor_on_cell(self.to_glib_none().0, mut_override(path.to_glib_none().0), focus_column.0, focus_cell.0, start_editing.to_glib());
        }
    }

    fn set_drag_dest_row<'a, P: Into<Option<&'a TreePath>>>(&self, path: P, pos: TreeViewDropPosition) {
        let path = path.into();
        unsafe {
            ffi::gtk_tree_view_set_drag_dest_row(self.to_glib_none().0, mut_override(path.to_glib_none().0), pos.to_glib());
        }
    }

    fn set_enable_search(&self, enable_search: bool) {
        unsafe {
            ffi::gtk_tree_view_set_enable_search(self.to_glib_none().0, enable_search.to_glib());
        }
    }

    fn set_enable_tree_lines(&self, enabled: bool) {
        unsafe {
            ffi::gtk_tree_view_set_enable_tree_lines(self.to_glib_none().0, enabled.to_glib());
        }
    }

    fn set_expander_column(&self, column: &TreeViewColumn) {
        unsafe {
            ffi::gtk_tree_view_set_expander_column(self.to_glib_none().0, column.to_glib_none().0);
        }
    }

    fn set_fixed_height_mode(&self, enable: bool) {
        unsafe {
            ffi::gtk_tree_view_set_fixed_height_mode(self.to_glib_none().0, enable.to_glib());
        }
    }

    fn set_grid_lines(&self, grid_lines: TreeViewGridLines) {
        unsafe {
            ffi::gtk_tree_view_set_grid_lines(self.to_glib_none().0, grid_lines.to_glib());
        }
    }

    fn set_headers_clickable(&self, setting: bool) {
        unsafe {
            ffi::gtk_tree_view_set_headers_clickable(self.to_glib_none().0, setting.to_glib());
        }
    }

    fn set_headers_visible(&self, headers_visible: bool) {
        unsafe {
            ffi::gtk_tree_view_set_headers_visible(self.to_glib_none().0, headers_visible.to_glib());
        }
    }

    fn set_hover_expand(&self, expand: bool) {
        unsafe {
            ffi::gtk_tree_view_set_hover_expand(self.to_glib_none().0, expand.to_glib());
        }
    }

    fn set_hover_selection(&self, hover: bool) {
        unsafe {
            ffi::gtk_tree_view_set_hover_selection(self.to_glib_none().0, hover.to_glib());
        }
    }

    fn set_level_indentation(&self, indentation: i32) {
        unsafe {
            ffi::gtk_tree_view_set_level_indentation(self.to_glib_none().0, indentation);
        }
    }

    fn set_model<'a, P: IsA<TreeModel> + 'a, Q: Into<Option<&'a P>>>(&self, model: Q) {
        let model = model.into();
        let model = model.to_glib_none();
        unsafe {
            ffi::gtk_tree_view_set_model(self.to_glib_none().0, model.0);
        }
    }

    fn set_reorderable(&self, reorderable: bool) {
        unsafe {
            ffi::gtk_tree_view_set_reorderable(self.to_glib_none().0, reorderable.to_glib());
        }
    }

    //fn set_row_separator_func<'a, 'b, P: Into<Option<&'a /*Unimplemented*/TreeViewRowSeparatorFunc>>, Q: Into<Option</*Unimplemented*/Fundamental: Pointer>>, R: Into<Option<&'b /*Ignored*/glib::DestroyNotify>>>(&self, func: P, data: Q, destroy: R) {
    //    unsafe { TODO: call ffi::gtk_tree_view_set_row_separator_func() }
    //}

    fn set_rubber_banding(&self, enable: bool) {
        unsafe {
            ffi::gtk_tree_view_set_rubber_banding(self.to_glib_none().0, enable.to_glib());
        }
    }

    fn set_rules_hint(&self, setting: bool) {
        unsafe {
            ffi::gtk_tree_view_set_rules_hint(self.to_glib_none().0, setting.to_glib());
        }
    }

    fn set_search_column(&self, column: i32) {
        unsafe {
            ffi::gtk_tree_view_set_search_column(self.to_glib_none().0, column);
        }
    }

    fn set_search_entry<'a, P: IsA<Entry> + 'a, Q: Into<Option<&'a P>>>(&self, entry: Q) {
        let entry = entry.into();
        let entry = entry.to_glib_none();
        unsafe {
            ffi::gtk_tree_view_set_search_entry(self.to_glib_none().0, entry.0);
        }
    }

    //fn set_search_equal_func<'a, P: Into<Option</*Unimplemented*/Fundamental: Pointer>>, Q: Into<Option<&'a /*Ignored*/glib::DestroyNotify>>>(&self, search_equal_func: /*Unknown conversion*//*Unimplemented*/TreeViewSearchEqualFunc, search_user_data: P, search_destroy: Q) {
    //    unsafe { TODO: call ffi::gtk_tree_view_set_search_equal_func() }
    //}

    //fn set_search_position_func<'a, 'b, P: Into<Option<&'a /*Unimplemented*/TreeViewSearchPositionFunc>>, Q: Into<Option</*Unimplemented*/Fundamental: Pointer>>, R: Into<Option<&'b /*Ignored*/glib::DestroyNotify>>>(&self, func: P, data: Q, destroy: R) {
    //    unsafe { TODO: call ffi::gtk_tree_view_set_search_position_func() }
    //}

    fn set_show_expanders(&self, enabled: bool) {
        unsafe {
            ffi::gtk_tree_view_set_show_expanders(self.to_glib_none().0, enabled.to_glib());
        }
    }

    fn set_tooltip_cell<'a, 'b, 'c, P: Into<Option<&'a TreePath>>, Q: Into<Option<&'b TreeViewColumn>>, R: IsA<CellRenderer> + 'c, S: Into<Option<&'c R>>>(&self, tooltip: &Tooltip, path: P, column: Q, cell: S) {
        let path = path.into();
        let column = column.into();
        let column = column.to_glib_none();
        let cell = cell.into();
        let cell = cell.to_glib_none();
        unsafe {
            ffi::gtk_tree_view_set_tooltip_cell(self.to_glib_none().0, tooltip.to_glib_none().0, mut_override(path.to_glib_none().0), column.0, cell.0);
        }
    }

    fn set_tooltip_column(&self, column: i32) {
        unsafe {
            ffi::gtk_tree_view_set_tooltip_column(self.to_glib_none().0, column);
        }
    }

    fn set_tooltip_row(&self, tooltip: &Tooltip, path: &TreePath) {
        unsafe {
            ffi::gtk_tree_view_set_tooltip_row(self.to_glib_none().0, tooltip.to_glib_none().0, mut_override(path.to_glib_none().0));
        }
    }

    fn unset_rows_drag_dest(&self) {
        unsafe {
            ffi::gtk_tree_view_unset_rows_drag_dest(self.to_glib_none().0);
        }
    }

    fn unset_rows_drag_source(&self) {
        unsafe {
            ffi::gtk_tree_view_unset_rows_drag_source(self.to_glib_none().0);
        }
    }

    fn get_property_enable_grid_lines(&self) -> TreeViewGridLines {
        unsafe {
            let mut value = Value::from_type(<TreeViewGridLines as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "enable-grid-lines".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_enable_grid_lines(&self, enable_grid_lines: TreeViewGridLines) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "enable-grid-lines".to_glib_none().0, Value::from(&enable_grid_lines).to_glib_none().0);
        }
    }

    fn set_property_ubuntu_almost_fixed_height_mode(&self, ubuntu_almost_fixed_height_mode: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "ubuntu-almost-fixed-height-mode".to_glib_none().0, Value::from(&ubuntu_almost_fixed_height_mode).to_glib_none().0);
        }
    }

    fn connect_columns_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "columns-changed",
                transmute(columns_changed_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_cursor_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "cursor-changed",
                transmute(cursor_changed_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_expand_collapse_cursor_row<F: Fn(&Self, bool, bool, bool) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, bool, bool, bool) -> bool + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "expand-collapse-cursor-row",
                transmute(expand_collapse_cursor_row_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn emit_expand_collapse_cursor_row(&self, object: bool, p0: bool, p1: bool) -> bool {
        let res = self.emit("expand-collapse-cursor-row", &[&object, &p0, &p1]).unwrap();
        res.unwrap().get().unwrap()
    }

    fn connect_move_cursor<F: Fn(&Self, MovementStep, i32) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, MovementStep, i32) -> bool + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "move-cursor",
                transmute(move_cursor_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn emit_move_cursor(&self, step: MovementStep, direction: i32) -> bool {
        let res = self.emit("move-cursor", &[&step, &direction]).unwrap();
        res.unwrap().get().unwrap()
    }

    fn connect_row_activated<F: Fn(&Self, &TreePath, &TreeViewColumn) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &TreePath, &TreeViewColumn) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "row-activated",
                transmute(row_activated_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn emit_row_activated(&self, path: &TreePath, column: &TreeViewColumn) {
        let _ = self.emit("row-activated", &[&path, &column]).unwrap();
    }

    fn connect_row_collapsed<F: Fn(&Self, &TreeIter, &TreePath) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &TreeIter, &TreePath) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "row-collapsed",
                transmute(row_collapsed_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_row_expanded<F: Fn(&Self, &TreeIter, &TreePath) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &TreeIter, &TreePath) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "row-expanded",
                transmute(row_expanded_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_select_all<F: Fn(&Self) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) -> bool + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "select-all",
                transmute(select_all_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn emit_select_all(&self) -> bool {
        let res = self.emit("select-all", &[]).unwrap();
        res.unwrap().get().unwrap()
    }

    fn connect_select_cursor_parent<F: Fn(&Self) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) -> bool + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "select-cursor-parent",
                transmute(select_cursor_parent_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn emit_select_cursor_parent(&self) -> bool {
        let res = self.emit("select-cursor-parent", &[]).unwrap();
        res.unwrap().get().unwrap()
    }

    fn connect_select_cursor_row<F: Fn(&Self, bool) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, bool) -> bool + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "select-cursor-row",
                transmute(select_cursor_row_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn emit_select_cursor_row(&self, object: bool) -> bool {
        let res = self.emit("select-cursor-row", &[&object]).unwrap();
        res.unwrap().get().unwrap()
    }

    fn connect_start_interactive_search<F: Fn(&Self) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) -> bool + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "start-interactive-search",
                transmute(start_interactive_search_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn emit_start_interactive_search(&self) -> bool {
        let res = self.emit("start-interactive-search", &[]).unwrap();
        res.unwrap().get().unwrap()
    }

    fn connect_test_collapse_row<F: Fn(&Self, &TreeIter, &TreePath) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &TreeIter, &TreePath) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "test-collapse-row",
                transmute(test_collapse_row_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_test_expand_row<F: Fn(&Self, &TreeIter, &TreePath) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &TreeIter, &TreePath) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "test-expand-row",
                transmute(test_expand_row_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_toggle_cursor_row<F: Fn(&Self) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) -> bool + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "toggle-cursor-row",
                transmute(toggle_cursor_row_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn emit_toggle_cursor_row(&self) -> bool {
        let res = self.emit("toggle-cursor-row", &[]).unwrap();
        res.unwrap().get().unwrap()
    }

    fn connect_unselect_all<F: Fn(&Self) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) -> bool + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "unselect-all",
                transmute(unselect_all_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn emit_unselect_all(&self) -> bool {
        let res = self.emit("unselect-all", &[]).unwrap();
        res.unwrap().get().unwrap()
    }

    #[cfg(any(feature = "v3_8", feature = "dox"))]
    fn connect_property_activate_on_single_click_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::activate-on-single-click",
                transmute(notify_activate_on_single_click_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_enable_grid_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::enable-grid-lines",
                transmute(notify_enable_grid_lines_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_enable_search_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::enable-search",
                transmute(notify_enable_search_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_enable_tree_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::enable-tree-lines",
                transmute(notify_enable_tree_lines_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_expander_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::expander-column",
                transmute(notify_expander_column_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_fixed_height_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::fixed-height-mode",
                transmute(notify_fixed_height_mode_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_headers_clickable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::headers-clickable",
                transmute(notify_headers_clickable_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_headers_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::headers-visible",
                transmute(notify_headers_visible_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_hover_expand_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::hover-expand",
                transmute(notify_hover_expand_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_hover_selection_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::hover-selection",
                transmute(notify_hover_selection_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_level_indentation_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::level-indentation",
                transmute(notify_level_indentation_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_model_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::model",
                transmute(notify_model_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_reorderable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::reorderable",
                transmute(notify_reorderable_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_rubber_banding_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::rubber-banding",
                transmute(notify_rubber_banding_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_rules_hint_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::rules-hint",
                transmute(notify_rules_hint_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_search_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::search-column",
                transmute(notify_search_column_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_show_expanders_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::show-expanders",
                transmute(notify_show_expanders_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_tooltip_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::tooltip-column",
                transmute(notify_tooltip_column_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_ubuntu_almost_fixed_height_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::ubuntu-almost-fixed-height-mode",
                transmute(notify_ubuntu_almost_fixed_height_mode_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }
}

unsafe extern "C" fn columns_changed_trampoline<P>(this: *mut ffi::GtkTreeView, f: glib_ffi::gpointer)
where P: IsA<TreeView> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn cursor_changed_trampoline<P>(this: *mut ffi::GtkTreeView, f: glib_ffi::gpointer)
where P: IsA<TreeView> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn expand_collapse_cursor_row_trampoline<P>(this: *mut ffi::GtkTreeView, object: glib_ffi::gboolean, p0: glib_ffi::gboolean, p1: glib_ffi::gboolean, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<TreeView> {
    let f: &&(Fn(&P, bool, bool, bool) -> bool + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked(), from_glib(object), from_glib(p0), from_glib(p1)).to_glib()
}

unsafe extern "C" fn move_cursor_trampoline<P>(this: *mut ffi::GtkTreeView, step: ffi::GtkMovementStep, direction: libc::c_int, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<TreeView> {
    let f: &&(Fn(&P, MovementStep, i32) -> bool + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked(), from_glib(step), direction).to_glib()
}

unsafe extern "C" fn row_activated_trampoline<P>(this: *mut ffi::GtkTreeView, path: *mut ffi::GtkTreePath, column: *mut ffi::GtkTreeViewColumn, f: glib_ffi::gpointer)
where P: IsA<TreeView> {
    let f: &&(Fn(&P, &TreePath, &TreeViewColumn) + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(path), &from_glib_borrow(column))
}

unsafe extern "C" fn row_collapsed_trampoline<P>(this: *mut ffi::GtkTreeView, iter: *mut ffi::GtkTreeIter, path: *mut ffi::GtkTreePath, f: glib_ffi::gpointer)
where P: IsA<TreeView> {
    let f: &&(Fn(&P, &TreeIter, &TreePath) + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(iter), &from_glib_borrow(path))
}

unsafe extern "C" fn row_expanded_trampoline<P>(this: *mut ffi::GtkTreeView, iter: *mut ffi::GtkTreeIter, path: *mut ffi::GtkTreePath, f: glib_ffi::gpointer)
where P: IsA<TreeView> {
    let f: &&(Fn(&P, &TreeIter, &TreePath) + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(iter), &from_glib_borrow(path))
}

unsafe extern "C" fn select_all_trampoline<P>(this: *mut ffi::GtkTreeView, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<TreeView> {
    let f: &&(Fn(&P) -> bool + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked()).to_glib()
}

unsafe extern "C" fn select_cursor_parent_trampoline<P>(this: *mut ffi::GtkTreeView, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<TreeView> {
    let f: &&(Fn(&P) -> bool + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked()).to_glib()
}

unsafe extern "C" fn select_cursor_row_trampoline<P>(this: *mut ffi::GtkTreeView, object: glib_ffi::gboolean, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<TreeView> {
    let f: &&(Fn(&P, bool) -> bool + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked(), from_glib(object)).to_glib()
}

unsafe extern "C" fn start_interactive_search_trampoline<P>(this: *mut ffi::GtkTreeView, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<TreeView> {
    let f: &&(Fn(&P) -> bool + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked()).to_glib()
}

unsafe extern "C" fn test_collapse_row_trampoline<P>(this: *mut ffi::GtkTreeView, iter: *mut ffi::GtkTreeIter, path: *mut ffi::GtkTreePath, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<TreeView> {
    let f: &&(Fn(&P, &TreeIter, &TreePath) -> Inhibit + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(iter), &from_glib_borrow(path)).to_glib()
}

unsafe extern "C" fn test_expand_row_trampoline<P>(this: *mut ffi::GtkTreeView, iter: *mut ffi::GtkTreeIter, path: *mut ffi::GtkTreePath, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<TreeView> {
    let f: &&(Fn(&P, &TreeIter, &TreePath) -> Inhibit + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(iter), &from_glib_borrow(path)).to_glib()
}

unsafe extern "C" fn toggle_cursor_row_trampoline<P>(this: *mut ffi::GtkTreeView, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<TreeView> {
    let f: &&(Fn(&P) -> bool + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked()).to_glib()
}

unsafe extern "C" fn unselect_all_trampoline<P>(this: *mut ffi::GtkTreeView, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<TreeView> {
    let f: &&(Fn(&P) -> bool + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked()).to_glib()
}

#[cfg(any(feature = "v3_8", feature = "dox"))]
unsafe extern "C" fn notify_activate_on_single_click_trampoline<P>(this: *mut ffi::GtkTreeView, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TreeView> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_enable_grid_lines_trampoline<P>(this: *mut ffi::GtkTreeView, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TreeView> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_enable_search_trampoline<P>(this: *mut ffi::GtkTreeView, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TreeView> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_enable_tree_lines_trampoline<P>(this: *mut ffi::GtkTreeView, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TreeView> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_expander_column_trampoline<P>(this: *mut ffi::GtkTreeView, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TreeView> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_fixed_height_mode_trampoline<P>(this: *mut ffi::GtkTreeView, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TreeView> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_headers_clickable_trampoline<P>(this: *mut ffi::GtkTreeView, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TreeView> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_headers_visible_trampoline<P>(this: *mut ffi::GtkTreeView, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TreeView> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_hover_expand_trampoline<P>(this: *mut ffi::GtkTreeView, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TreeView> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_hover_selection_trampoline<P>(this: *mut ffi::GtkTreeView, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TreeView> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_level_indentation_trampoline<P>(this: *mut ffi::GtkTreeView, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TreeView> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_model_trampoline<P>(this: *mut ffi::GtkTreeView, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TreeView> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_reorderable_trampoline<P>(this: *mut ffi::GtkTreeView, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TreeView> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_rubber_banding_trampoline<P>(this: *mut ffi::GtkTreeView, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TreeView> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_rules_hint_trampoline<P>(this: *mut ffi::GtkTreeView, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TreeView> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_search_column_trampoline<P>(this: *mut ffi::GtkTreeView, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TreeView> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_show_expanders_trampoline<P>(this: *mut ffi::GtkTreeView, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TreeView> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_tooltip_column_trampoline<P>(this: *mut ffi::GtkTreeView, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TreeView> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_ubuntu_almost_fixed_height_mode_trampoline<P>(this: *mut ffi::GtkTreeView, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TreeView> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TreeView::from_glib_borrow(this).downcast_unchecked())
}
