#!/usr/bin/env ruby -wW1

$: << '.'
$: << '../lib'
$: << '../ext'

if __FILE__ == $0
  if (i = ARGV.index('-I'))
    x,path = ARGV.slice!(i, 2)
    $: << path
  end
end

require 'optparse'
require 'oj'
require 'perf'

$indent = 0
$iter = 1

opts = OptionParser.new

opts.on("-c", "--count [Int]", Integer, "iterations")       { |i| $iter = i }
opts.on("-i", "--indent [Int]", Integer, "indent")          { |i| $indent = i }

opts.on("-h", "--help", "Show this display")                { puts opts; Process.exit!(0) }
files = opts.parse(ARGV)

$levels = [ "ERROR", "WARN", "INFO", "DEBUG", "TRACE" ]
$entry = {
  "bar" => "0",
  "level" => "INFO",
  "message" => "A message",
  "msgType" => 1,
  "source" => "Test",
  "thread" => "main",
  "version" => 1,
  "when" => 1400000000000000000,
}

Oj.default_options = { :mode => :strict, :indent => $indent }

filename = 'log.json'
File.open(filename, "w") { |f|
  $iter.times do |i|
    $entry["bar"] = (1_400_000_000_000 + i * 200) / 1000
    $entry["when"] = 1_400_000_000_000_000_000 + i * 100_000_000
    $entry["message"] = "This is log message number #{i} out of #{$iter} entries."
    $entry["level"] = $levels[i % $levels.size]
    Oj.to_stream(f, $entry, :indent => $indent)
    if 0 == $indent
      f.flush()
      f.write("\n")
    end
  end
}

$cnt = 0
perf = Perf.new()
perf.add('Oj.load_file', '') { Oj.load_file(filename) { |o| $cnt += 1 } }
perf.run(1)

puts "*** read #{$cnt} entries"
