module MethodNameMapping
  @@method_map = {
    'bang'         => '!',
    'percent'      => '%',
    'and'          => '&',
    'times'        => '*',
    'times2'       => '**',
    'plus'         => '+',
    'minus'        => '-',
    'div'          => '/',
    'lt'           => '<',
    'lte'          => '<=',
    'spaceship'    => '<=>',
    'lt2'          => '<<',
    'equals2'      => '==',
    'equals3'      => '===',
    'equalstilde'  => '=~',
    'gt'           => '>',
    'ge'           => '>=',
    'gt2'          => '>>',
    'unary_plus'   => '+@',
    'unary_minus'  => '-@',
    'index'        => '[]',
    'index_equals' => '[]=',
    'carat'        => '^',
    'or'           => '|',
    'tilde'        => '~',
  }

  @@mapped_re = @@method_map.values.map {|s| Regexp.escape(s)}.join("|")

  def to_ruby(name)
    name = name.to_s.dup
    is_class_method = name.sub!(/^class_/, '')

    if @@method_map.has_key?(name)
      name=@@method_map[name]
    elsif name.sub!(/_equals(_.*)?$/, '=')
    elsif name.sub!(/_bang(_.*)?$/, '!')
    elsif name.sub!(/_eh(_.*)?$/, '?')
    elsif name =~ /(.*?)_/ and @@method_map.has_key? $1
      name = @@method_map[$1]
    end
    name = 'self.' + name if is_class_method

    return name
  end
end
